/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) state.h: version 25.1 created on 11/27/91 at 14:50:31	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)state.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ifndef SYS_STATE_H
#define SYS_STATE_H

/* state.h */

	/* flags and macros for special status word */


#define	SSW_FC		0x8000
#define	SSW_FB		0x4000
#define	SSW_RC		0x2000
#define	SSW_RB		0x1000
#define	SSW_DF		0x0100
#define SSW_RMW		0x0080
#define SSW_READ	0x0040		/* this bit off means a write */
#define SSW_FC2		0x0004		/* function code 2 kernel/user */

#define	DF(ssw)		((ssw) & SSW_DF)
#define	stageB(ssw)	((ssw) & SSW_FB)
#define	stageC(ssw)	((ssw) & SSW_FC)
#define	kernel_ref(ssw)	((ssw) & SSW_FC2)

/* special status word for A and B stack frame formats (same offset in both) */
#define s_ABssw		s_proc.formatA.fA_ssw


/* 
 * stack frame for all types of exceptions
 */


typedef struct	state	{
	ulong	s_sp;		/* usp */
	ulong	s_d0, s_d1, s_d2, s_d3, s_d4, s_d5, s_d6, s_d7;
	ulong	s_a0, s_a1, s_a2, s_a3, s_a4, s_a5, s_a6;
	ushort	s_ps;		/* psw */
	ulong	s_pc;		/* instruction counter */

	uint	s_format : 4;	/* describes format of any additional info */
	uint	s_crunch : 1;	/* reduce this stack frame to format 0 */
	uint	s_expand : 1;	/* expand this stack frame */
	uint	s_vector : 8;	/* vector number */
	uint	s_unused : 2;	/* unused bits */

	/* additional processor state information (see s_format above) */
	union	{
		/* normal stack frame */
		uint	format0;

		/* throwaway four word stack frame */
		struct {
			ushort	f1_ps;
			ulong	f1_pc;
			ushort	f1_vecoff;
		} format1;

		/* six word stack frame */
		struct {
			ulong	f2_instaddr;
		} format2;

		/* coprocessor mid-instruction stack frame */
		struct {
			ulong	f9_instaddr;
			ushort	f9_INTERNAL[4];
		} format9;

		/* short bus cycle fault stack frame */
		struct {
			ushort	fA_INTER0[1];	/* internal register(s) */
			ushort	fA_ssw;		/* special status word */
			ushort	fA_pipeC;	/* instruction pipe stage C */
			ushort	fA_pipeB;	/* instruction pipe stage B */
			ulong	fA_faultaddr;	/* data cycle fault address */
			ushort	fA_INTER1[2];	/* internal register(s) */
			ulong	fA_outbuff;	/* data output buffer */
			ushort	fA_INTER2[2];	/* internal register(s) */
		} formatA;

		/* long bus cycle fault stack frame */	
		struct {
			ushort	fB_INTER0[1];	/* internal register(s) */
			ushort	fB_ssw;		/* special status word */
			ushort	fB_pipeC;	/* instruction pipe stage C */
			ushort	fB_pipeB;	/* instruction pipe stage B */
			ulong	fB_faultaddr;	/* data cycle fault address */
			ushort	fB_INTER1[2];	/* internal register(s) */
			ulong	fB_outbuff;	/* data output buffer */
			ushort	fB_INTER2[4];	/* internal register(s) */
			ulong	fB_stBaddr;	/* stage B address */
			ushort	fB_INTER3[2];	/* internal register(s) */
			ulong	fB_inbuff;	/* data input buffer */
			ushort	fB_INTER4[3];	/* internal register(s) */
			ushort	fB_cpu_type : 4;/* mask version */
			uint	fB_INTER5 : 12;	/* internal register(s) */
			ushort	fB_INTER6[18];	/* internal register(s) */
		} formatB;
	} s_proc;
} state_t;

#endif /* SYS_STATE_H */
