/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) userio.c: version 25.1 created on 11/27/91 at 14:49:50	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)userio.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/iopmbuf.h"
#include "sys/errno.h"
#include "sys/param.h"
#include "sys/types.h"
#include "sys/iopmdebug.h"
#include "user.h"
#include "buf.h"

/******************************************************************************/
suser()
{
	if ( iu.u_uid == 0 )
		return 1;

	iu.u_error = EPERM;
	return 0;
}

/******************************************************************************/
/* Copy from iop driver to kernel buf and interrupt the kernel.
/* The kernel will copyout from kernel buf to user memory.
*/
copyout(src, dest, count)
caddr_t  src;
caddr_t  dest;
uint     count;
{
	register struct buf  *kbp = iu.u_kbp;
	uint                 xfer;
	int                  savpri;
	extern struct buf    **itokbp;

	while ( count )
	{
		xfer = count > kbp->b_bcount ? kbp->b_bcount : count;
		bcopy(src, kbp->b_un.b_addr, xfer);

		kbp->b_resid = xfer;
		kbp->av_back = (buf_t *)dest;
		kbp->b_driver_flags = I_DATA | B_READ;

		PRINT3(ROUT|DATA, "copyout: src = %x, dest = %x, count = %x\n",
		  src, dest, count);

		savpri = spl1();

		if ( !add_chain((caddr_t)itokbp, (caddr_t)kbp,
		                (caddr_t)&kbp->av_forw) )
		{
			blkintrpm(kbp);
		}

		while ( !(kbp->b_driver_flags & B_DONE) )
			sleep((caddr_t)kbp, PRIBIO);

		splx(savpri);

		if ( kbp->b_driver_flags & I_ERROR )
		{
			kbp->b_driver_flags = 0;
			return -1;	/* tell ioctl_proc copyout error */
		}
		src += xfer;
		dest += xfer;
		count -= xfer;
	}
	kbp->b_driver_flags = 0;
	return 0;
}

/******************************************************************************/
copyin(src, dest, count)
caddr_t  src;
caddr_t  dest;
uint     count;
{
	register struct buf  *kbp = iu.u_kbp;
	uint                 xfer;
	int                  savpri;
	extern struct buf    **itokbp;

	while ( count )
	{
		xfer = count > kbp->b_bcount ? kbp->b_bcount : count;
		kbp->b_resid = xfer;
		kbp->av_back = (buf_t *)src;
		kbp->b_driver_flags = I_DATA;	/* ~B_READ == WRITE */

		PRINT3(ROUT|DATA, "copyin: src = %x, dest = %x, count = %x\n",
		  src, dest, count);

		savpri = spl1();

		if ( !add_chain((caddr_t)itokbp, (caddr_t)kbp,
		                (caddr_t)&kbp->av_forw) )
		{
			blkintrpm(kbp);
		}

		while ( !(kbp->b_driver_flags & B_DONE) )
			sleep((caddr_t)kbp, PRIBIO);

		splx(savpri);

		if ( kbp->b_driver_flags & I_ERROR )
		{
			kbp->b_driver_flags = 0;
			return -1;	/* tell ioctl_proc copyin error */
		}
		bcopy(kbp->b_un.b_addr, dest, xfer);
		src += xfer;
		dest += xfer;
		count -= xfer;
	}
	kbp->b_driver_flags = 0;
	return 0;
}
