/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) trap.c: version 25.1 created on 11/27/91 at 14:49:45	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)trap.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/psl.h"
#include "sys/param.h"
#include "state.h"
#include "sys/sbus_iopm.h"
#include "sys/immu.h"
#include "iopm.h"
#include "tcb.h"

caddr_t  faultaddr = 0;

unsigned char stkfmtsz[16] = {		/* (# bytes-8) on stack frame */
	0, 0, 4, 0, 0, 0, 0, 0,		/* for the exceptions */
	0, 12, 24, 84, 0, 0, 0, 0};	/* index is the format code */

static	char	bad_trap_name[] = "Unknown exception";

char *nametrap[] = {
	bad_trap_name,
	bad_trap_name,
	"Bus Error",
	"Address Error",
	"Illegal Instruction",
	"Zero Divide",
	"CHK Instruction",
	"TRAPV Instruction",
	"Privileged Instruction",
	"Trace Trap",
	"Unimplemented instrucion",
	"Unimplemented instrucion",
	bad_trap_name,
	"Coprocessor protocol violation",
	"Format error",
	"Unitialized interrupt",
	bad_trap_name,
	bad_trap_name,
	bad_trap_name,
	bad_trap_name,
	bad_trap_name,
	bad_trap_name,
	bad_trap_name,
	bad_trap_name,
	"Spurious Interrupt",
	"Auto 1",
	"Auto 2",
	"Auto 3",
	"Auto 4",
	"Auto 5",
	"Auto 6",
	"Auto 7",
	"TRAP 0 Instruction",
	"TRAP 1 Instruction",
	"TRAP 2 Instruction",
	"TRAP 3 Instruction",
	"TRAP 4 Instruction",
	"TRAP 5 Instruction",
	"TRAP 6 Instruction",
	"TRAP 7 Instruction",
	"TRAP 8 Instruction",
	"TRAP 9 Instruction",
	"TRAP 10 Instruction",
	"TRAP 11 Instruction",
	"TRAP 12 Instruction",
	"TRAP 13 Instruction",
	"TRAP 14 Instruction",
	"TRAP 15 Instruction",
	"Floating Point Exception",
	"Floating Point Exception",
	"Floating Point Exception",
	"Floating Point Exception",
	"Floating Point Exception",
	"Floating Point Exception",
	"Floating Point Exception",
};

/******************************************************************************/
static char *
get_except_name(vector_number)
uint  vector_number;
{
	if ( vector_number >= (sizeof(nametrap) / sizeof(nametrap[0])) )
		return bad_trap_name;

	return nametrap[vector_number];
}

/******************************************************************************/
u_trap(stk_frame)
struct state  stk_frame;
{
	extern unsigned char  stkfmtsz[];

	printf("%s  (vector 0x%x, format %d)\n",
	  get_except_name(stk_frame.s_vector), stk_frame.s_vector,
	  stk_frame.s_format);

	disp_reg(&stk_frame);

	backtrace();
}

/******************************************************************************/
showtrap(stk_frame)
struct state  *stk_frame;
{
	extern unsigned char  stkfmtsz[];

	printf("%s  (vector 0x%x, format %d)\n",
	  get_except_name(stk_frame->s_vector), stk_frame->s_vector,
	  stk_frame->s_format);

	disp_reg(stk_frame);
}

/******************************************************************************/
u_buserr()
{
	printf("buserr\n");
}

/******************************************************************************/
k_buserr(stk_frame)
struct state  stk_frame;		/* stk_frame is value/result */
{
	register uchar   faultreg = *ERROR_STAT_REG;
	register ushort  config_reg = *CONFIG_REG;

	/* clear the errors */
	config_reg &= ~CLR_ERR;
	*CONFIG_REG = config_reg;
	config_reg |= CLR_ERR;
	*CONFIG_REG = config_reg;

	if ( faultaddr )		/* check for expected fault */
	{
		stk_frame.s_pc = (ulong)faultaddr;
		return;
	}

	showbuserr(&stk_frame, faultreg);
}

/******************************************************************************/
busviol(stk_ptr)
register struct state  *stk_ptr;
{
	ushort  ssw;

	switch ( stk_ptr->s_format )
	{

	    case 0xA:	/* format A */
		/* get special status word */
		ssw = stk_ptr->s_proc.formatA.fA_ssw;

		if ( DF(ssw) )
			/* data cycle fault address */
			return stk_ptr->s_proc.formatA.fA_faultaddr;

		if ( stageC(ssw) )
			return (ulong)stk_ptr->s_pc + 2;

		if ( stageB(ssw) )
			return (ulong)stk_ptr->s_pc + 4;

		break;

	    case 0xB:	/* format B */
		/* get special status word */
		ssw = stk_ptr->s_proc.formatB.fB_ssw;

		if ( DF(ssw) )
			/* data cycle fault address */
			return stk_ptr->s_proc.formatB.fB_faultaddr;

		if ( stageC(ssw) )
			return stk_ptr->s_proc.formatB.fB_stBaddr-2;

		if ( stageB(ssw) )
			return stk_ptr->s_proc.formatB.fB_stBaddr;

		break;
	}

	printf("unknown cause of bus error");
	stop_processor();
}

/******************************************************************************/
showbuserr(stk_ptr, faultreg)
register struct state  *stk_ptr;
register uchar         faultreg;
{
	ulong                 vaddr;
	extern unsigned char  stkfmtsz[];

	vaddr = busviol(stk_ptr);

	backtrace();

	printf("Bus Error\n");

	disp_reg(stk_ptr);

	printf("logical address that generated fault %x\n", vaddr);
	printf("fault register = 0x%x\n", faultreg);
	printf("special status word = 0x%x, ", stk_ptr->s_proc.formatA.fA_ssw);

	break_out_ssw(stk_ptr->s_proc.formatA.fA_ssw);
}

/******************************************************************************/
break_out_ssw(ssw)
register unsigned  ssw;
{

	if ( DF(ssw) ) {

		if ( ssw & SSW_RMW )
			printf("modify ");

		if ( ssw & SSW_READ )
			printf("read");
		else
			printf("write");
	}
	else
		printf("instruction fetch");

	printf("\n");
}

/******************************************************************************/
boarderr(stk_ptr)
struct state  stk_ptr;
{
	register ushort  config_reg = *CONFIG_REG;
	uchar            err_reg = *ERROR_STAT_REG;
	ushort           stat_reg = *STATUS_CTRL_REG;

	if ( stat_reg & CS_TIMEOUT )
	{
		config_reg |= (FLUSH_PIPE_IN | FLUSH_PIPE_OUT);
		*CONFIG_REG = config_reg;
		config_reg &= ~(FLUSH_PIPE_IN | FLUSH_PIPE_OUT);
		*CONFIG_REG = config_reg;
	}

	/* clear the errors */
	config_reg &= ~CLR_ERR;
	*CONFIG_REG = config_reg;
	config_reg |= CLR_ERR;
	*CONFIG_REG = config_reg;

	if ( stat_reg & (CMD1_OUT | DEV_SUSP) && err_reg & UP_TIMEOUT )
	{
		config_reg &= ~DEV_RST_OUT;
		*CONFIG_REG = config_reg;
		config_reg |= DEV_RST_OUT;
		*CONFIG_REG = config_reg;
	}

	printf("Board error\n");
	printf("err reg = 0x%x", err_reg);
	break_out_err(err_reg);
	printf("stat reg = 0x%x", stat_reg);
	break_out_stat(stat_reg);

	disp_reg(&stk_ptr);

	printf("maps = %.2x %.2x %.2x %.2x  %.2x %.2x %.2x %.2x  %.2x %.2x %.2x %.2x  %.2x %.2x %.2x\n",
	       *(uchar*)0xfc000000, *(uchar*)0xfc000004, *(uchar*)0xfc000008,
	       *(uchar*)0xfc00000c, *(uchar*)0xfc000010, *(uchar*)0xfc000014,
	       *(uchar*)0xfc000018, *(uchar*)0xfc00001c, *(uchar*)0xfc000020,
	       *(uchar*)0xfc000024, *(uchar*)0xfc000028, *(uchar*)0xfc00002c,
	       *(uchar*)0xfc000030, *(uchar*)0xfc000034, *(uchar*)0xfc000038);

	return;
}

/******************************************************************************/
break_out_err(reg)
register uchar  reg;
{
	if ( !(reg & UP_TIMEOUT) )
		printf(", UP.TIMEOUT");
	if ( !(reg & CS_TIMEOUT) )
		printf(", CS_TIMEOUT");
	if ( !(reg & NACK_SENT) )
		printf(", NACK.SENT");
	if ( !(reg & NO_ACK) )
		printf(", NO.ACK");
	if ( !(reg & NACK_RCVED) )
		printf(", NACK.RCVED");
	if ( !(reg & MEM_PERROR) )
		printf(", MEM.PERROR");
	if ( !(reg & DEV_BERROR) )
		printf(", DEV.BERROR");
	if ( !(reg & MEM_PRO_ERR) )
		printf(", MEM.PRO.ERR");
	printf("\n");
}

/******************************************************************************/
break_out_stat(reg)
register ushort  reg;
{
	if ( reg & DEV_SUSP )
		printf(", DEV.SUSP");
	if ( !(reg & NOT_DEV_NMI) )
		printf(", DEV.NMI");
	if ( !(reg & NOT_SYS_FRZ) )
		printf(", RX.FREEZE");
	if ( reg & SOFT_INTR_7 )
		printf(", INT.7");
	if ( !(reg & NO_DIAG_BAG) )
		printf(", DIAG.BAG");
	if ( reg & RX_CMD )
		printf(", RX.CMD");
	if ( reg & CMD1_OUT )
		printf(", CMD.1.OUT");
	if ( reg & CMD2_OUT )
		printf(", CMD.2.OUT");
	printf(", slot %d", (~reg & SLOT_MASK) >> 4);
	if ( !(reg & IN_CSS) )
		printf(", EXPANSION");
	if ( reg & INTERFACE_EN )
		printf(", INTERFACE.ENA");
	if ( reg & CONSOLE_MODE )
		printf(", CONSOLE");
	printf("\n");
}

/******************************************************************************/
#define OP_ADDA_A7	0xdefc		/* 68020 opcode for adda.w #xx, a7 */
#define OP_ADDQ_A7	0x504f		/* 68020 opcode for addq.l #xx, a7 */
#define ADDQ_MASK	0x0e00		/* mask to remove data from addq */
#define ADDQ_SHIFT	9		/* shift to extract data from addq */

backtrace(arg)
uint  arg;
{
	register uint      n;
	register uint      retpc;
	register int       args;
	register uint      *fp;
	register ushort    *addr;
	register uint      *stklo, *stkhi;
	extern struct tcb  *curtcbp;
	extern struct tcb  tcbpool[];
	extern int         own_stack[];

	fp = &arg - 2;	/* stack frame is fp, pc, arg, .... */
	printf("Stack Backtrace:\n");
	if ( curtcbp )
	{
		printf("on a task stack (%x).\n",fp);
		stklo = (uint *)(TCBSTACKS + 2 * (curtcbp-tcbpool) * NBPP);
		stkhi = (uint *)(TCBSTACKS + 2 * (curtcbp-tcbpool) * NBPP + NBPP);
	}
	else
	{
		printf("on the idle stack (%x).\n",fp);
		stklo = (uint *)own_stack;
		stkhi = (uint *)((caddr_t)own_stack + STKSZ);
	}
	retpc = fp[1];
	fp = (uint *) *fp;

	for ( ; fp >= stklo && fp < stkhi && *fp; fp = (uint *)*fp )
	{
		addr = (ushort *) fp[1];
		printf("pc=%x (", retpc);		/* print return pc */
		retpc = (uint) addr;

		/*
		 * Guess at the number arguments by looking at the opcode
		 * pointed at by the return pc and checking how much is added
		 * to the stack.  Divide by 4 and add 1 to get the number of
		 * arguments, except that there is no way to tell 0 args and 1
		 * arg apart (the sp doesn't move).  So, assume 1 argument if
		 * not followed by an add.
		 */
		n = *addr;
		if ( (n & ~ADDQ_MASK) == OP_ADDQ_A7 )
		{
			switch ( n = (n & ADDQ_MASK) >> ADDQ_SHIFT )
			{
			    case 0:		/* addq 8 */
				args = 2;
				break;
			    case 4:		/* addq 4 */
				args = 1;
				break;
			    default:
				printf("[addq %d]", n);
				args = 0;
			}
		}
		else if ( n == OP_ADDA_A7 )
			args = ((short *)addr)[1] / 4;
		else
			args = 0;

		if ( args > 0 )
		{
			if ( args > 8 )
			{
				printf("{%d} ", args);
				args = 8;
			}
			for ( n = 2; --args >= 0; n++ )
				printf("%x%s", fp[n], (args ? ", " : ")\n"));
		}
		else
			printf(")\n");
	}
	printf("pc=%x\n", retpc);			/* print return pc */
}

/******************************************************************************/
disp_reg(stk_ptr)
struct state  *stk_ptr;
{
	register uint  *r = (uint *)&stk_ptr->s_d0;
	register uint  sp = (uint)&stk_ptr->s_proc + stkfmtsz[stk_ptr->s_format];

	printf("d0 %.8x  d1 %.8x  d2 %.8x  d3 %.8x\n", r[0], r[1], r[2], r[3]);
	printf("d4 %.8x  d5 %.8x  d6 %.8x  d7 %.8x\n", r[4], r[5], r[6], r[7]);
	printf("a0 %.8x  a1 %.8x  a2 %.8x  a3 %.8x  sr = %.4x\n",
	  r[8], r[9], r[10], r[11], stk_ptr->s_ps);
	printf("a4 %.8x  a5 %.8x  a6 %.8x  sp %.8x  pc = %.8x\n",
	  r[12], r[13], r[14], sp, stk_ptr->s_pc);
}
