/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) tdb.c: version 25.1 created on 11/27/91 at 14:49:40	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)tdb.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/state.h"
#include "sys/own.h"
#include "sys/trap.h"
#include "sys/psl.h"
#include "sys/debug.h"
#include "sys/errno.h"
#include "sys/iopmcomm.h"

extern	uchar	stkfmtsz[];

/******************************************************************************/
tdb(debug_state)
state_t	debug_state;
{
	register struct iopm_comm  *iopmcommp = (struct iopm_comm *)IOPM_COMM;
	extern	void	TDB_vector();

	iopmcommp->o_tdb.state = &debug_state;

	if ( iopmcommp->o_tdb.state->s_vector == TRCTRAP )
		/* prevent reentry for exceptions that use nullvect (=TDB_vector) */
		if ( iopmcommp->o_tdb.state->s_pc == (ulong)TDB_vector ||
		     iopmcommp->o_tdb.cmd == TDB_CMD_GO)
		{
			iopmcommp->o_tdb.state->s_ps &= ~PS_T;
			return;
		}

	while (1)
	{
		iopmcommp->o_tdb.done = 1;
		while ( iopmcommp->o_tdb.done )	/* wait for next cmd from spm */
			;
		if ( iopmcommp->o_tdb.cmd == TDB_CMD_GO )
			return;
		if ( iopmcommp->o_tdb.cmd == TDB_CMD_STEP )
		{
			iopmcommp->o_tdb.state->s_ps |= PS_T;
			return;
		}
		tdb_low_level();
	}
}

/******************************************************************************/
void
TDB_errvect()
{
	longjmp( iopmcomm.o_tdb.jbuf, 1 );
}

/******************************************************************************/
tdb_low_level()
{
	ulong		saved_vbr;
	extern ulong	TDBvec[];

	saved_vbr = get_vbr();
	if ( setjmp(iopmcomm.o_tdb.jbuf) )
		iopmcomm.o_tdb.error = EFAULT;
	else {
		set_vbr(TDBvec);
		iopmcomm.o_tdb.error = 0;	/* no error */
		tdb_execute_low();
	}
	set_vbr(saved_vbr);
}

/******************************************************************************/
tdb_execute_low()
{
	extern prtwhere;

	switch ( iopmcomm.o_tdb.cmd )
	{
	    case TDB_CMD_GET_CHAR:
		iopmcomm.o_tdb.value = *(uchar *)iopmcomm.o_tdb.arg;
		break;

	    case TDB_CMD_PUT_CHAR:
		*(uchar *) iopmcomm.o_tdb.arg = iopmcomm.o_tdb.value;
		break;

	    case TDB_CMD_GET_SHORT:
		iopmcomm.o_tdb.value = *(ushort *)iopmcomm.o_tdb.arg;
		break;

	    case TDB_CMD_PUT_SHORT:
		*(ushort *)iopmcomm.o_tdb.arg = iopmcomm.o_tdb.value;
		break;

	    case TDB_CMD_GET_LONG:
		iopmcomm.o_tdb.value = *(ulong *)iopmcomm.o_tdb.arg;
		break;

	    case TDB_CMD_PUT_LONG:
		*(ulong *)iopmcomm.o_tdb.arg = iopmcomm.o_tdb.value;
		break;

	    case TDB_CMD_GET_REG:
		tdb_getreg();
		break;

	    case TDB_CMD_PUT_REG:
		tdb_putreg();
		break;

	    case TDB_CMD_SHOW_TRAP:
		prtwhere = 1;
		showtrap( iopmcomm.o_tdb.state );
		prtwhere = 2;
		break;

	    case TDB_CMD_BACKTRACE:
		prtwhere = 1;
		backtrace();
		prtwhere = 2;
		break;

	    default:
		iopmcomm.o_tdb.error = EINVAL;
		break;
	}
}

/******************************************************************************/
tdb_getreg()
{
	state_t	*stp = iopmcomm.o_tdb.state;

	switch (iopmcomm.o_tdb.arg)
	{
	    case TDB_REG_D0:
		iopmcomm.o_tdb.value = stp->s_d0;
		break;

	    case TDB_REG_D1:
		iopmcomm.o_tdb.value = stp->s_d1;
		break;

	    case TDB_REG_D2:
		iopmcomm.o_tdb.value = stp->s_d2;
		break;

	    case TDB_REG_D3:
		iopmcomm.o_tdb.value = stp->s_d3;
		break;

	    case TDB_REG_D4:
		iopmcomm.o_tdb.value = stp->s_d4;
		break;

	    case TDB_REG_D5:
		iopmcomm.o_tdb.value = stp->s_d5;
		break;

	    case TDB_REG_D6:
		iopmcomm.o_tdb.value = stp->s_d6;
		break;

	    case TDB_REG_D7:
		iopmcomm.o_tdb.value = stp->s_d7;
		break;

	    case TDB_REG_A0:
		iopmcomm.o_tdb.value = stp->s_a0;
		break;

	    case TDB_REG_A1:
		iopmcomm.o_tdb.value = stp->s_a1;
		break;

	    case TDB_REG_A2:
		iopmcomm.o_tdb.value = stp->s_a2;
		break;

	    case TDB_REG_A3:
		iopmcomm.o_tdb.value = stp->s_a3;
		break;

	    case TDB_REG_A4:
		iopmcomm.o_tdb.value = stp->s_a4;
		break;

	    case TDB_REG_A5:
		iopmcomm.o_tdb.value = stp->s_a5;
		break;

	    case TDB_REG_A6:
		iopmcomm.o_tdb.value = stp->s_a6;
		break;

	    case TDB_REG_A7:
		iopmcomm.o_tdb.value =
			(ulong) &stp->s_proc + stkfmtsz[stp->s_format];
		break;

	    case TDB_REG_PC:
		iopmcomm.o_tdb.value = (ulong) stp->s_pc;
		break;

	    case TDB_REG_SR:
		iopmcomm.o_tdb.value = stp->s_ps;
		break;

	    case TDB_REG_VECTOR:
		iopmcomm.o_tdb.value = stp->s_vector;
		break;

	    case TDB_REG_FORMAT:
		iopmcomm.o_tdb.value = stp->s_format;
		break;

	    default:
		iopmcomm.o_tdb.error = EINVAL;
		break;
	}
}

/******************************************************************************/
tdb_putreg()
{
	state_t	*stp = iopmcomm.o_tdb.state;

	switch ( iopmcomm.o_tdb.arg )
	{
	    case TDB_REG_D0:
		stp->s_d0 = iopmcomm.o_tdb.value;
		break;

	    case TDB_REG_D1:
		stp->s_d1 = iopmcomm.o_tdb.value;
		break;

	    case TDB_REG_D2:
		stp->s_d2 = iopmcomm.o_tdb.value;
		break;

	    case TDB_REG_D3:
		stp->s_d3 = iopmcomm.o_tdb.value;
		break;

	    case TDB_REG_D4:
		stp->s_d4 = iopmcomm.o_tdb.value;
		break;

	    case TDB_REG_D5:
		stp->s_d5 = iopmcomm.o_tdb.value;
		break;

	    case TDB_REG_D6:
		stp->s_d6 = iopmcomm.o_tdb.value;
		break;

	    case TDB_REG_D7:
		stp->s_d7 = iopmcomm.o_tdb.value;
		break;

	    case TDB_REG_A0:
		stp->s_a0 = iopmcomm.o_tdb.value;
		break;

	    case TDB_REG_A1:
		stp->s_a1 = iopmcomm.o_tdb.value;
		break;

	    case TDB_REG_A2:
		stp->s_a2 = iopmcomm.o_tdb.value;
		break;

	    case TDB_REG_A3:
		stp->s_a3 = iopmcomm.o_tdb.value;
		break;

	    case TDB_REG_A4:
		stp->s_a4 = iopmcomm.o_tdb.value;
		break;

	    case TDB_REG_A5:
		stp->s_a5 = iopmcomm.o_tdb.value;
		break;

	    case TDB_REG_A6:
		stp->s_a6 = iopmcomm.o_tdb.value;
		break;

	    case TDB_REG_A7:
		stp->s_sp = iopmcomm.o_tdb.value;
		break;

	    case TDB_REG_PC:
		stp->s_pc = iopmcomm.o_tdb.value;
		break;

	    case TDB_REG_SR:
		stp->s_ps = iopmcomm.o_tdb.value;
		break;

	    case TDB_REG_VECTOR:
		stp->s_vector = iopmcomm.o_tdb.value;
		break;

	    case TDB_REG_FORMAT:
		stp->s_format = iopmcomm.o_tdb.value;
		break;

	    default:
		iopmcomm.o_tdb.error = EINVAL;
		break;
	}
}
