/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) tcb.c: version 25.1 created on 11/27/91 at 14:49:36	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)tcb.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/cmn_err.h"
#include "sys/debug.h"
#include "sys/immu.h"
#include "sys/map.h"
#include "iopm.h"
#include "sys/iopmcomm.h"
#include "stream.h"		/* after iopmcomm */
#include "user.h"
#include "tcb.h"
#include "sys/iopmdebug.h"
#include "sys/bufstat.h"

struct tcb            *freetcbp;
extern struct tcb     tcbpool[];
extern struct i_proc  iproc;
extern uint           numtcb;
extern uint           numtcb_struct;
extern uint           memalloc();

/******************************************************************************/
/*
** get tcb and stack from pools, mfg tcb, put on runq
*/
create(start, arg, pri)
{
	register struct tcb  *tcbp;
	int                  tcbnum;
	register int         *stackp;
	int                  savpri;
	extern               catch_no_exit();

	savpri = splhi();
	if ( !(tcbp = freetcbp) )
	{
		iopmcomm.itcbst.fail++;
		splx(savpri);
		return -1;
	}

	ASSERT(valid_tcb(tcbp));
	ASSERT(tcbp->tcb_flags == T_FREE);

	/* remove tcb from free list */
	freetcbp = tcbp->tcb_link;
	BUMPUSE(iopmcomm.itcbst);
	ASSERT(iopmcomm.itcbst.use <= numtcb);
	splx(savpri);

	tcbnum = tcbp - tcbpool;
	ASSERT(tcbnum < numtcb);
	/* stacks are associated 1 to 1 with tcb's. */
	/* stacks are 1 page long. */
	/* stacks are every other page starting at virtual address TCBSTACKS */
	/* Leave room for var arg funcs like printf at top of stack */
	stackp = (int *)(TCBSTACKS + 2 * tcbnum * NBPP + NBPP - 0x100);

	/* set up u area in tcb */
	tcbp->u_uid = 0;
	tcbp->u_gid = 0;
	tcbp->u_ruid = 0;
	tcbp->u_rgid = 0;
	tcbp->u_ttyp = 0;
	tcbp->p_pid = 0;
	tcbp->p_pgrp = 0;
	tcbp->p_session_id = 0;
	/* u_procp is initialized in the data section in slp.c */

	tcbp->u_error = 0;
	tcbp->u_rval = 0;

	*--stackp = arg;	/* proc argument */
	*--stackp = (int)catch_no_exit;		/* safety net return pc */

	bzero((caddr_t)tcbp->tcb_rsav, sizeof tcbp->tcb_rsav);
	tcbp->tcb_rsav[PC] = start;
	tcbp->tcb_rsav[SP] = (int)stackp;

	tcbp->tcb_pri = pri;
	tcbp->tcb_wchan = 0;
	tcbp->tcb_sig = 0;
	setrq(tcbp);

	return 0;
}

/******************************************************************************/
catch_no_exit()
{
	cmn_err(CE_WARN, "Missing exit at the end of task!\n");
	exit();
}
/******************************************************************************/
exit()
{
	int                savpri;
	extern struct tcb  *curtcbp;
	extern struct buf  *tcb_head;
	extern mblk_t      *stcb_head;
	extern             own_stack[];
	extern             swtch_continue();

	ASSERT(valid_tcb(curtcbp));
	ASSERT(curtcbp->tcb_flags == T_CURRENT);

	curtcbp->p_pid = 0;		/* for M_KILL streams message */

	/* Put the curent tcb on the free list, the stacks int the stack pool */
	/* are associated one to one with the tcbs in the tcb pool */
	savpri = splhi();
	curtcbp->tcb_link = freetcbp;
	freetcbp = curtcbp;
	curtcbp->tcb_flags = T_FREE;
	iopmcomm.itcbst.use--;
	ASSERT(iopmcomm.itcbst.use < numtcb);
	splx(savpri);
	curtcbp = 0;

	if ( tcb_head || stcb_head )
		softintr();

	set_pc_sp(swtch_continue, (caddr_t)own_stack + STKSZ - 0x100);
}

/******************************************************************************/
tcbinit()
{
	register struct tcb  *tcbp;

	iu.u_procp = &iproc;

	for ( tcbp = &tcbpool[numtcb - 1]; tcbp >= tcbpool; tcbp-- )
	{
		tcbp->tcb_link = freetcbp;
		freetcbp = tcbp;
	}
	iopmcomm.tcbarray = tcbpool;
	iopmcomm.numtcb = numtcb;
}

/******************************************************************************/
/* returns 1 for ok, 0 for fail
*/
setnumtcb(desired_tcb)
uint desired_tcb;	/* number of tcbs */
{
	uint               extra_stacks;
	extern struct map  memmap[];
	int		   saved_pri;

	static uint	   routine_called = 0;

	if (desired_tcb > numtcb_struct)
		return 0;	/* number is too large */

	if ( routine_called )
		return 0;	/* already called */
	routine_called++;

	if ( desired_tcb <= numtcb )
		return 1;	/* already have enough */

	extra_stacks = memalloc(desired_tcb - numtcb);
	if ( extra_stacks == 0 )
		return 0;	/* not enough memory */
	/* FIX MSS, counts on 1 page per stack */
	bzero((caddr_t)(extra_stacks * NBPP), NBPP * (desired_tcb - numtcb));

	add_stk_pool(extra_stacks, numtcb, desired_tcb);

	/* add the new tasks to the list of free tasks
	 * as a side effect, increments the global variable numtcb
	 */
	saved_pri = splhi();
	for (; numtcb != desired_tcb; numtcb++) {
		tcbpool[numtcb].tcb_link = freetcbp;
		freetcbp = &tcbpool[numtcb];
	}
	splx(saved_pri);
	iopmcomm.numtcb = numtcb;

	PRINT1(CONFIG, "setnumtcb: num tasks %d\n", numtcb);
	return 1;
}

/******************************************************************************/
valid_tcb(tcbp)
register struct tcb  *tcbp;
{
	if ( (uint)tcbp < (uint)tcbpool ||
	     (uint)tcbp >= (uint)&tcbpool[numtcb] ||
	     ((uint)tcbp - (uint)tcbpool) % sizeof(struct tcb) )
		return 0;

	return 1;
}
