/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) strmgr.c: version 25.1.1.3 created on 2/2/93 at 11:06:58	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)strmgr.c	25.1.1.3	2/2/93 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/errno.h"
#include "sys/types.h"
#include "sys/param.h"
#include "sysmacros.h"
#include "sys/stream.h"
#include "stream.h"	/* after sys/stream */
#include "sys/iopmstream.h"
#include "sys/iopmdebug.h"
#include "sys/stropts.h"
#include "sys/iopmcomm.h"
#include "sys/debug.h"
#include "sys/iopmstat.h"
#include "devsw.h"
#include "sys/cmn_err.h"

struct strifstat  strifstat;

static mblk_t  *ktoicpmsg(), *itokcpmsg();
static void    cmd_rput_hipri(), send_flow_msg(), send_copy_msg();
static void    cmd_wput(), mux_rput();
void           cmd_rput(), mux_wput(), sendmptokernel(), set_list_avail();

/* The code on the IOPM is structured as a series of layers. Two of these
/* layers correspond to real streams modules, the other two layers don't
/* have queues, they just have "put" routines. The layers from the kernel/IOPM
/* interface down are:
/*	cmd layer - no queues; deal with stream head stuff eg open, link
/*	mux layer - no queues; match mp to stream using b_prev
/*	copy layer - real streams module; copy messages to/from kernel
/*	flow layer - real streams module; flow control across kernel/IOPM
*/
/******************************************************************************/
/* FLOW LAYER */
#define RFLOW_STATE  ((struct iopm_ctl *)rqp->q_ptr)->ic_rflow_state
/******************************************************************************/
flow_wput(wqp, imp)
iqueue_t  *wqp;
mblk_t    *imp;
{
	ASSERT(valid_wq(wqp));
	ASSERT(valid_wq(wqp->q_next));	/* protocol driver or mod */
	ASSERT(valid_iopm_mblk(imp));

	putnext(wqp, imp);		/* put to protocol */
}

/******************************************************************************/
flow_rput(rqp, imp)
iqueue_t         *rqp;
register mblk_t  *imp;
{
	ASSERT(valid_rq(rqp));
	ASSERT(valid_rq(rqp->q_next));	/* the copy queue */
	ASSERT(valid_iopm_mblk(imp));

	if ( imp->b_datap->db_type >= QPCTL ||
	     RFLOW_STATE == EMPTY && kcanput(rqp) )
	{
		if ( imp->b_datap->db_type == M_FLUSH && *imp->b_rptr & FLUSHR )
			flushq(rqp, FLUSHDATA);

		putnext(rqp, imp);	/* copy_rput(rqp->q_next,imp) */
	}
	else
	{
		send_flow_msg(rqp);
		RFLOW_STATE = CLOGGED;
		putq(rqp, imp);
	}
}

/******************************************************************************/
flow_rsrv(rqp)
register iqueue_t  *rqp;
{
	register mblk_t  *imp;
	int              savpri;

	ASSERT(valid_rq(rqp));

	RFLOW_STATE = DRAINING;

	ASSERT(valid_rq(rqp->q_next));	/* copy rq */

	while ( (imp = getq(rqp)) && kcanput(rqp) )
		putnext(rqp, imp);	/* copy_rput(rqp->q_next,imp) */

	if ( imp )
	{
		send_flow_msg(rqp);
		RFLOW_STATE = CLOGGED;
		ASSERT(imp->b_datap->db_type < QPCTL);
		putbq(rqp, imp);
	}
	else
	{
		savpri = splstr();
		if ( RFLOW_STATE == DRAINING );
			RFLOW_STATE = EMPTY;
		splx(savpri);
	}
}

/******************************************************************************/
void
set_list_avail(wqp)
iqueue_t  *wqp;			/* wqp is copy wq */
{
	register iqueue_t  *q;
	register uint      avail;
	register uint      count;

	ASSERT(valid_wq(wqp));
	q = wqp->q_next;	/* q is flow wq */
	ASSERT(valid_wq(q));
	q = q->q_next;		/* q is protocol driver/mod wq */
	ASSERT(valid_wq(q));
	
	while ( q->q_next && !q->q_qinfo->qi_srvp )
		q = q->q_next;

	if ( q->q_qinfo->qi_srvp )
		avail = q->q_hiwat + 1;
	else
		avail = DEFAULT_HIWAT;

	count = q->q_count + wqp->q_count;
	if ( avail < count )
		avail = 0;
	else
		avail -= count;

	ASSERT(valid_iopmctl((struct iopm_ctl *)RD(wqp)->q_ptr));

	((struct iopm_ctl *)RD(wqp)->q_ptr)->ic_wavail = avail;
}

/******************************************************************************/
static
kcanput(rqp)
iqueue_t  *rqp;				/* flow rq */
{
	register struct iopm_ctl  *iopmctl;

	ASSERT(valid_rq(rqp));
	iopmctl = (struct iopm_ctl *)rqp->q_ptr;
	ASSERT(valid_iopmctl(iopmctl));

	return iopmctl->ic_ravail > iopmctl->ic_rproduced -
	       iopmctl->ic_rconsumed + rqp->q_next->q_count;
}

/******************************************************************************/
/* COPY LAYER */
/******************************************************************************/
copy_wput(wqp, kmp)
register iqueue_t  *wqp;
register mblk_t    *kmp;
{
	ASSERT(valid_wq(wqp));
	ASSERT(valid_pm_mblk(kmp));

	if ( (kmp->b_datap->db_type == M_FLUSH) && (*kmp->b_rptr & FLUSHW) )
		kflushq(wqp, FLUSHDATA);

	putq(wqp, kmp);

	set_list_avail(wqp);
}

/******************************************************************************/
copy_wsrv(wqp)
register iqueue_t  *wqp;
{
	register mblk_t           *kmp;
	register mblk_t           *imp;
	register struct iopm_ctl  *iopmctl;

	ASSERT(valid_wq(wqp));
	iopmctl = (struct iopm_ctl *)RD(wqp)->q_ptr;
	ASSERT(valid_iopmctl(iopmctl));

	/* canput tests beyond flow layer since flow layer has no wsrv */
	while ( (kmp = getq(wqp)) &&
	        (kmp->b_datap->db_type >= QPCTL || canput(wqp->q_next)) )
	{
		/* M_WFLOW is kernel requests back enable message. */
		/* Since it is lo pri and canput succeeded, tell K to flow */
		if ( kmp->b_datap->db_type == M_WFLOW )
		{
			set_list_avail(wqp);
			kmp->b_prev = (mblk_t *)iopmctl;
			sendmptokernel(kmp);
		}
		else if ( imp = ktoicpmsg(kmp, wqp) )
		{
			/* return kernel msg to kernel */
			kfreemsg(kmp);

			putnext(wqp, imp);	/* flow_wput(wqp->q_next,imp) */
		}
		else
		{
			break;
		}
	}

	if ( kmp )
		noenable_putbq(wqp, kmp);
	else if ( iopmctl->ic_iflags & QSLPCLS )
	{
		/* is close waiting for q to empty? */
		iopmctl->ic_iflags &= ~QSLPCLS;
		wakeup((caddr_t)wqp);
	}

	set_list_avail(wqp);
}

/******************************************************************************/
/* This routine uses FLUSHDATA vs FLUSHALL since we don't want to flush hi pri
/* messages waiting to be copied (eg FLUSHW msg).
*/
copy_rput(rqp, imp)
iqueue_t         *rqp;
register mblk_t  *imp;
{
	ASSERT(valid_rq(rqp));
	ASSERT(valid_iopm_mblk(imp));

	if ( imp->b_datap->db_type == M_FLUSH && *imp->b_rptr & FLUSHR )
		flushq(rqp, FLUSHDATA);

	putq(rqp, imp);
}

/******************************************************************************/
copy_rsrv(rqp)
register iqueue_t  *rqp;
{
	register mblk_t  *kmp;
	register mblk_t  *imp;

	ASSERT(valid_rq(rqp));

	while ( (imp = getq(rqp)) && (kmp = itokcpmsg(imp, rqp)) )
	{
		freemsg(imp);
		mux_rput(rqp, kmp);
	}

	if ( imp )
		noenable_putbq(rqp, imp);
}

/******************************************************************************/
/* Copies kernel message (including all b_cont) to IOPM message.
/* Returns pointer to IOPM message or 0 if not enuf IOPM mblks
*/
static mblk_t *
ktoicpmsg(kmp, wqp)
register mblk_t  *kmp;
iqueue_t         *wqp;
{
	register mblk_t  *imp;
	register mblk_t  *firstimp = 0;
	register mblk_t  *lastimp = 0;
	register uint    msglen;
	extern           qenable();
	extern ushort    rbsize[];
	uint             timeout();

	do		/* process entire msg (all b_cont) */
	{
		ASSERT(valid_pm_mblk(kmp));

		ASSERT(kmp->b_datap->db_class < NCLASS);
		msglen = rbsize[kmp->b_datap->db_class];

		if ( (imp = allocb((int)msglen, BPRI_MED)) == 0 )
		{
			freemsg(firstimp);

			ASSERT(valid_wq(wqp));
			/* BPRI_LO here vs BPRI_MED for allocb is hysteresis */
			/* to minimize trashing. */
			if ( !bufcall(msglen, BPRI_LO, qenable, (long)wqp) )
				timeout((void(*)())qenable, (caddr_t)wqp, HZ);

			return 0;
		}

		if ( !firstimp )
			firstimp = imp;

		/* copy kernel msg to iop msg (imp->b_wptr == db_base)*/
		bcopy((caddr_t)kmp->b_datap->db_base, (caddr_t)imp->b_wptr,
		  msglen);

		ASSERT(kmp->b_wptr >= kmp->b_datap->db_base);
		ASSERT(kmp->b_wptr <= kmp->b_datap->db_base + msglen);
		imp->b_wptr += kmp->b_wptr - kmp->b_datap->db_base;
		ASSERT(kmp->b_rptr >= kmp->b_datap->db_base);
		ASSERT(kmp->b_rptr <= kmp->b_datap->db_base + msglen);
		imp->b_rptr += kmp->b_rptr - kmp->b_datap->db_base;
		imp->b_datap->db_type = kmp->b_datap->db_type;

		if ( lastimp )
			lastimp->b_cont = imp;
		lastimp = imp;

	} while ( kmp = kmp->b_cont );

	return firstimp;
}

/******************************************************************************/
/* Copies IOPM message (including all b_cont) to kernel message.
/* Returns pointer to kernel message or 0 if not enuf kernel mblks
*/
static mblk_t *
itokcpmsg(imp, rqp)
register mblk_t  *imp;
iqueue_t         *rqp;
{
	register mblk_t  *kmp;
	register mblk_t  *firstkmp = 0;
	register mblk_t  *lastkmp = 0;
	register uint    msglen;
	uint             hipri;
	extern mblk_t    *kallocb();
	extern ushort    rbsize[];

	do
	{
		ASSERT(valid_iopm_mblk(imp));

		ASSERT(imp->b_datap->db_class < NCLASS);
		msglen = rbsize[imp->b_datap->db_class];

		if ( (kmp = kallocb(msglen, BPRI_MED)) == 0 )
		{
			if ( firstkmp )
				hipri = firstkmp->b_datap->db_type >= QPCTL;
			else
				hipri = imp->b_datap->db_type >= QPCTL;

			kfreemsg(firstkmp);

			send_copy_msg(rqp, hipri, msglen);
			return 0;
		}

		ASSERT(valid_pm_mblk(kmp));

		if ( !firstkmp )
			firstkmp = kmp;

		/* copy iopm msg to kernel msg (kmp->b_wptr == db_base)*/
		bcopy((caddr_t)imp->b_datap->db_base, (caddr_t)kmp->b_wptr,
		  msglen);

		ASSERT(imp->b_wptr >= imp->b_datap->db_base);
		ASSERT(imp->b_wptr <= imp->b_datap->db_base + msglen);
		kmp->b_wptr += imp->b_wptr - imp->b_datap->db_base;
		ASSERT(imp->b_rptr >= imp->b_datap->db_base);
		ASSERT(imp->b_rptr <= imp->b_datap->db_base + msglen);
		kmp->b_rptr += imp->b_rptr - imp->b_datap->db_base;
		kmp->b_datap->db_type = imp->b_datap->db_type;

		if ( lastkmp )
			lastkmp->b_cont = kmp;
		lastkmp = kmp;

	} while ( imp = imp->b_cont );

	return firstkmp;
}

/******************************************************************************/
/* MUX LAYER */
/******************************************************************************/
void
mux_wput(kmp)
register mblk_t  *kmp;
{
	register iqueue_t  *wqp;

	ASSERT(valid_pm_mblk(kmp));
	ASSERT(valid_iopmctl((struct iopm_ctl *)kmp->b_prev));

	if ( ((struct iopm_ctl *)kmp->b_prev)->ic_iflags & CLOSING )
	{
		kfreemsg(kmp);
		return;
	}

	wqp = (iqueue_t *)((struct iopm_ctl *)kmp->b_prev)->ic_iwq;
	ASSERT(valid_wq(wqp));
	kmp->b_prev = NULL;
	copy_wput(wqp, kmp);
}

/******************************************************************************/
static void
mux_rput(rqp, kmp)
iqueue_t         *rqp;
register mblk_t  *kmp;
{
	ASSERT(valid_rq(rqp));
	ASSERT(valid_pm_mblk(kmp));
	ASSERT(valid_iopmctl((struct iopm_ctl *)rqp->q_ptr));

	kmp->b_prev = (mblk_t *)rqp->q_ptr; /* attach control struct to mblk */
	cmd_rput(kmp);
}

/******************************************************************************/
/* CMD LAYER */
/******************************************************************************/
static void
cmd_wput(kmp)
register mblk_t  *kmp;
{
	register struct iopm_ctl  *iopmctl;

	ASSERT(valid_pm_mblk(kmp));
	iopmctl = (struct iopm_ctl *)kmp->b_prev;
	ASSERT(valid_iopmctl(iopmctl));

	if ( !(kmp->b_datap->db_type & QREMCMD) )
	{
		mux_wput(kmp);
		return;
	}

	switch ( kmp->b_datap->db_type )
	{
	    case M_WFLOW:		/* kernel says write flow stopped */
		ASSERT(kmp->b_datap->db_type < QPCTL);
		mux_wput(kmp);
		return;

	    case M_RFLOW:		/* kernel says restart read flow */
		ASSERT(iopmctl->ic_rflow_mp == NULL);
		iopmctl->ic_rflow_mp = kmp;
		ASSERT(valid_wq(iopmctl->ic_iwq));		/* copy wq */
		ASSERT(valid_wq(iopmctl->ic_iwq->q_next));	/* flow wq */

		qenable(RD(iopmctl->ic_iwq->q_next));	/* enable flow rq */
		return;

	    case M_HICOPY:		/* kernel says try again to copy */
		((struct copy_msg *)kmp->b_wptr)->cm_use = 0;
		ASSERT(valid_wq(iopmctl->ic_iwq));	/* copy q */

		qenable(RD(iopmctl->ic_iwq));		/* enable copy rq */
		return;

	    case M_LOCOPY:		/* kernel says try again to copy */
		((struct copy_msg *)kmp->b_wptr)->cm_use = 0;
		ASSERT(valid_wq(iopmctl->ic_iwq));	/* copy q */

		qenable(RD(iopmctl->ic_iwq));		/* enable copy rq */
		return;

	    case M_OPEN:
	    case M_CLOSE:
	    case M_CLOSES:
	    {
		extern void    strproc();
		extern mblk_t  *stcb_head;
		extern mblk_t  *proc_head;

		if ( create((int)strproc, 0, STRPRI + 2) )
		{
			kmp->b_next = stcb_head;
			stcb_head = kmp;
		}
		else
		{
			kmp->b_next = proc_head;
			proc_head = kmp;
		}
		return;
	    }

	    case M_KILL:
	    case M_KILLS:
	    {
		extern void  process_kill();

		process_kill(kmp);
		return;
	    }

	    case M_IOCTL | QREMCMD:
	    {
		extern void  process_ioctl();

		kmp->b_datap->db_type &= ~ QREMCMD;
		process_ioctl(kmp);
		return;
	    }

	    default:
		ASSERT(0);
	}
}

/******************************************************************************/
void
cmd_rput(kmp)
register mblk_t  *kmp;
{
	ASSERT(valid_pm_mblk(kmp));
	ASSERT(!(kmp->b_datap->db_type & QREMCMD));

	if ( kmp->b_datap->db_type >= QPCTL )
		cmd_rput_hipri(kmp);

	sendmptokernel(kmp);
}

/******************************************************************************/
static void
cmd_rput_hipri(kmp)
register mblk_t  *kmp;
{
	register struct iocblk  *iocblk;
	struct iopm_ctl         *iopmctl;
	void                    clear_idownq();

	ASSERT(valid_pm_mblk(kmp));
	iopmctl = (struct iopm_ctl *)kmp->b_prev;
	ASSERT(valid_iopmctl(iopmctl));

	switch ( kmp->b_datap->db_type )
	{
	    case M_IOCACK:
		iocblk = (struct iocblk *)kmp->b_rptr;
		switch ( iocblk->ioc_cmd )
		{
		    case I_LINK:
		    {
			kmp->b_datap->db_type |= QREMCMD;

			clear_idownq(iopmctl);

			/* driver should have set count to 0? */
			iocblk->ioc_count = 0;
			break;
		    }

		    case I_UNLINK:
		    {
			register struct iopm_ctl  *ctl_down;
			register iqueue_t         *irqdown;
			extern struct qinit       rflowdata;
			extern struct qinit       wflowdata;

			ctl_down = iopmctl->ic_savctl;
			ASSERT(valid_iopmctl(ctl_down));
			irqdown = RD(ctl_down->ic_iwq->q_next);
			ASSERT(valid_rq(irqdown));

			setq(irqdown, &rflowdata, &wflowdata);
			irqdown->q_ptr = (caddr_t)ctl_down;

			/* reconnect rflow to rcopy */
			irqdown->q_next = RD(ctl_down->ic_iwq);

			/* driver should have set count to 0? */
			iocblk->ioc_count = 0;
			qenable(irqdown);
			break;
		    }
		}
		break;

	    case M_IOCNAK:
		iocblk = (struct iocblk *)kmp->b_rptr;
		switch ( iocblk->ioc_cmd )
		{
		    case I_LINK:
		    {
			register dev_t  dev;
			register struct iopm_ctl  *ctl_down;
			register iqueue_t         *irqdown;
			extern struct qinit       rflowdata;
			extern struct qinit       wflowdata;

			ctl_down = iopmctl->ic_savctl;
			ASSERT(valid_iopmctl(ctl_down));
			irqdown = RD(ctl_down->ic_iwq->q_next);
			ASSERT(valid_rq(irqdown));

			setq(irqdown, &rflowdata, &wflowdata);
			irqdown->q_ptr = (caddr_t)ctl_down;

			/* reconnect rflow to rcopy */
			irqdown->q_next = RD(ctl_down->ic_iwq);

			iocblk->ioc_error = EINVAL;
			iocblk->ioc_count = 0;
			qenable(irqdown);
			break;
		    }

		    case I_UNLINK:
			iocblk->ioc_error = EINVAL;
			iocblk->ioc_count = 0;
			break;
		}
		break;
	}
}

/******************************************************************************/
/* This is at best a half hearted attempt to make LINK bullet proof.
/* A program that writes to a stream head that is being linked under another
/* stream will cause problems. This should catch messages that are flowing
/* upstream on a stream that is being linked under another stream.
*/
static void
clear_idownq(iopmctl)
struct iopm_ctl  *iopmctl;
{
	struct iopm_ctl  *lower_ctl;
	iqueue_t         *lower_wq;
	mblk_t           *mp;

	/* clear any messages in the copy layer */
	lower_ctl = iopmctl->ic_savctl;
	ASSERT(valid_iopmctl(lower_ctl));
	lower_wq = lower_ctl->ic_iwq;
	ASSERT(valid_wq(lower_wq));
	if ( RD(lower_wq)->q_first )
	{
		cmn_err(CE_WARN, "mesages discarded from irh");
		while ( mp = getq(RD(lower_wq)) )
			if ( mp->b_datap->db_type != M_WFLOW )
				freemsg(mp);
	}

	if ( lower_wq->q_first )
	{
		cmn_err(CE_WARN, "mesages discarded from iwh");
		while ( mp = getq(RD(lower_wq)) )
			if ( mp->b_datap->db_type == M_WFLOW )
				sendmptokernel(mp);
			else
				kfreemsg(mp);
	}

	/* remove q's from queuerun, bufcall and timeout list */
	chk_runlist(RD(lower_wq));
	chk_bufcall((long)RD(lower_wq));
	chktimeout(RD(lower_wq), lower_wq);
}

/******************************************************************************/
static void
send_flow_msg(rqp)
iqueue_t  *rqp;				/* flow rq */
{
	register struct iopm_ctl  *iopmctl;
	register mblk_t           *kmp = 0;
	int                       savpri;

	ASSERT(valid_rq(rqp));
	iopmctl = (struct iopm_ctl *)rqp->q_ptr;
	ASSERT(valid_iopmctl(iopmctl));

	savpri = splstr();
	if ( kmp = iopmctl->ic_rflow_mp )
		iopmctl->ic_rflow_mp = NULL;
	splx(savpri);

	if ( kmp )
	{
		ASSERT(kmp->b_datap->db_type == M_RFLOW);
		kmp->b_prev = (mblk_t *)iopmctl;
		sendmptokernel(kmp);
	}
}

/******************************************************************************/
/* The uint at b_wptr (b_rptr) is an in-use flag. 0 is not in use.
/* Non 0 is a requested length. The msg is in use until it returns to the IOPM.
*/
static void
send_copy_msg(rqp, hipri, len)
iqueue_t  *rqp;				/* copy rq */
uint      hipri;
uint      len;
{
	register struct iopm_ctl  *iopmctl;
	register mblk_t           *kmp;
	uint                      gotit = 0;
	int                       savpri;

	ASSERT(valid_rq(rqp));
	iopmctl = (struct iopm_ctl *)rqp->q_ptr;
	ASSERT(valid_iopmctl(iopmctl));

	savpri = splstr();
	if ( hipri )
	{
		kmp = iopmctl->ic_hicopy_mp;
		if ( ((struct copy_msg *)kmp->b_wptr)->cm_use == 0 &&
		     ((struct copy_msg *)kmp->b_wptr)->cm_close == 0 )
		{
			gotit = 1;
			ASSERT(valid_pm_mblk(kmp));
			ASSERT(kmp->b_datap->db_type == M_HICOPY);
			((struct copy_msg *)kmp->b_wptr)->cm_use = 1;
		}
	}
	else
	{
		kmp = iopmctl->ic_locopy_mp;
		if ( ((struct copy_msg *)kmp->b_wptr)->cm_use == 0 &&
		     ((struct copy_msg *)kmp->b_wptr)->cm_close == 0 )
		{
			gotit = 1;
			ASSERT(valid_pm_mblk(kmp));
			ASSERT(kmp->b_datap->db_type == M_LOCOPY);
			((struct copy_msg *)kmp->b_wptr)->cm_use = 1;
		}
	}
	splx(savpri);

	if ( gotit )
	{
		((struct copy_msg *)kmp->b_wptr)->cm_count = len;
		kmp->b_prev = (mblk_t *)iopmctl;
		sendmptokernel(kmp);
	}
}

/******************************************************************************/
/* SEND/RECEIVE LAYER */
/******************************************************************************/
void
sendmptokernel(kmp)
register mblk_t  *kmp;
{
	register struct iopm_ctl  *iopmctl;
	register mblk_t           *tmp;
	extern struct queue       **itoksp;
	extern disp_int_t         pm_str_intr;
	extern ushort             bsize[];
	extern ushort             upkern_inc();

	strifstat.msg_out++;

	ASSERT(valid_pm_mblk(kmp));

	iopmctl = (struct iopm_ctl *)kmp->b_prev;
	ASSERT(valid_iopmctl(iopmctl));

	for (tmp = kmp; tmp; tmp = tmp->b_cont)
		iopmctl->ic_rproduced += bsize[tmp->b_datap->db_class];

	/* add_chain returns previous first element */
	if ( !add_chain((caddr_t)itoksp, (caddr_t)kmp, (caddr_t)&kmp->b_next) )
		strintrpm(upkern_inc(), &pm_str_intr);
}

/******************************************************************************/
receivekmp()
{
	register mblk_t           *kmp;
	register struct iopm_ctl  *iopmctl;
	register mblk_t           *tmp;
	extern ushort             bsize[];
	extern mblk_t             *rev_kmp_chain();

	strifstat.new_req++;

	kmp = (mblk_t *)remove_chain(thrucss((uint)&ktois));

	ASSERT(valid_pm_mblk(kmp) || kmp == 0);

	if ( kmp && kmp->b_next )
		kmp = rev_kmp_chain(kmp);

	while ( kmp )
	{
		strifstat.msg_in++;

		ASSERT(valid_pm_mblk(kmp));
		iopmctl = (struct iopm_ctl *)kmp->b_prev;
		ASSERT(valid_iopmctl(iopmctl));

		for (tmp = kmp; tmp; tmp = tmp->b_cont)
			iopmctl->ic_wconsumed += bsize[tmp->b_datap->db_class];

		tmp = kmp->b_next;
		kmp->b_next = 0;

		cmd_wput(kmp);

		kmp = tmp;
	}
}

/******************************************************************************/
/* misc routines */
/******************************************************************************/
valid_pm_mblk(kmp)
mblk_t  *kmp;
{
	if ( !valid_pm_addr((uint)kmp) )
		return 0;

	if ( !valid_pm_addr((uint)kmp->b_datap) )
		return 0;

	if ( !valid_pm_addr((uint)kmp->b_datap->db_base) )
		return 0;

	return 1;
}

valid_iopmctl(iopmctl)
register struct iopm_ctl  *iopmctl;
{
	if ( !valid_pm_addr((uint)iopmctl) )
		return 0;

	return iopmctl->ic_version == CTL_VERSION;
}
