/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) strhd.c: version 25.1 created on 11/27/91 at 14:49:17	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)strhd.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/errno.h"
#include "sys/types.h"
#include "sys/param.h"
#include "sysmacros.h"
#include "sys/file.h"
#include "user.h"
#include "proc.h"
#include "sys/stream.h"
#include "stream.h"	/* after sys/stream */
#include "sys/iopmstream.h"
#include "sys/iopmdebug.h"
#include "sys/stropts.h"
#include "sys/iopmcomm.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "tcb.h"
#include "iopm.h"
#include "devsw.h"

int            flow_rput(), flow_wput(), flow_rsrv();
void           process_kill(), process_ioctl(), strproc();
static void    remove_mp(), set_savsig(), stask_init(), closetime();
static void    process_FIND(), process_LOOK(), process_PUSH(), process_POP();
static void    process_LINK(), process_UNLINK(), process_FDINSERT();
static mblk_t  *get_last_mblk();
static void    sopenproc(), first_open(), second_open(), scloseproc();
static void    PUSHproc(), POPproc();

/* accepts one message then goes full */
struct module_info  rflowinfo = { 0, "rflow", 0, INFPSZ, 1, 0 };
struct module_info  wflowinfo = { 0, "wflow", 0, INFPSZ, 1, 0 };
struct qinit        rflowdata =
	{ flow_rput, flow_rsrv, NULL, NULL, NULL, &rflowinfo, NULL };
struct qinit        wflowdata =
	{ flow_wput, NULL, NULL, NULL, NULL, &wflowinfo, NULL };
struct streamtab    flowinfo = { &rflowdata, &wflowdata, NULL, NULL };

int      copy_rput(), copy_wput(), copy_rsrv(), copy_wsrv();

struct module_info  rcopyinfo = { 0, "rcopy", 0, INFPSZ, DEFAULT_HIWAT, 0 };
struct module_info  wcopyinfo = { 0, "wcopy", 0, INFPSZ, DEFAULT_HIWAT, 0 };
struct qinit        rcopydata =
	{ copy_rput, copy_rsrv, NULL, NULL, NULL, &rcopyinfo, NULL };
struct qinit        wcopydata =
	{ copy_wput, copy_wsrv, NULL, NULL, NULL, &wcopyinfo, NULL };
struct streamtab    copyinfo = { &rcopydata, &wcopydata, NULL, NULL };

mblk_t   *stcb_head;		/* head of list of mblk's waiting for tcbs */
mblk_t   *proc_head;		/* head of list of mblk's waiting to start */

extern struct i_proc  iproc;
extern struct tcb     *curtcbp;

void  cmd_rput(), mux_wput(), sendmptokernel(), set_list_avail();

#define	kWR(q)		((queue_t *)((char *)(q) + sizeof(queue_t)))
/******************************************************************************/
strmgr()
{
	extern struct tcb  *freetcbp;

	if ( stcb_head && freetcbp )
		process_tcb_list();
	if ( ktois )
		receivekmp();
}

/******************************************************************************/
process_tcb_list()
{
	mblk_t             *stcb_mp;
	mblk_t             *nextkmp;
	extern struct tcb  *freetcbp;
	mblk_t             *rev_kmp_chain();

	ASSERT(stcb_head);
	/* if a tcb is free, process request waiting for tcb */
	stcb_mp = stcb_head;
	stcb_head = 0;

	if ( stcb_mp->b_next )
		stcb_mp = rev_kmp_chain(stcb_mp);

	while ( stcb_mp )
	{
		ASSERT(valid_pm_mblk(stcb_mp));

		nextkmp = stcb_mp->b_next;
		stcb_mp->b_next = 0;

		if ( create((int)strproc, 0, STRPRI + 2) )
		{
			stcb_mp->b_next = stcb_head;
			stcb_head = stcb_mp;
		}
		else
		{
			stcb_mp->b_next = proc_head;
			proc_head = stcb_mp;
		}

		stcb_mp = nextkmp;
	}
}

/******************************************************************************/
void
process_kill(kmp)
mblk_t   *kmp;
{
	mblk_t             *tmp;
	mblk_t             *lmp;
	short              pid;
	struct tcb         *tcbp;
	extern uint        numtcb;
	extern struct tcb  tcbpool[];
	extern struct tcb  *sleepq;

	ASSERT(valid_pm_mblk(kmp));
	pid = *(short *)kmp->b_rptr;
	sendmptokernel(kmp);

	/* search for open request in waiting_for_tcb list */
	/* if found, don't do open, return OPENFAIL */
	for ( lmp = 0, tmp = stcb_head; tmp; lmp = tmp, tmp = tmp->b_next )
		if ( pid == ((struct iopmscb *)tmp->b_rptr)->iopms_pid )
			if ( tmp->b_datap->db_type == M_OPEN )
			{
				remove_mp(tmp, lmp, &stcb_head);
				return;
			}
			else
				set_savsig(tmp);

	for ( lmp = 0, tmp = proc_head; tmp; lmp = tmp, tmp = tmp->b_next )
		if ( pid == ((struct iopmscb *)tmp->b_rptr)->iopms_pid )
			if ( tmp->b_datap->db_type == M_OPEN )
			{
				remove_mp(tmp, lmp, &proc_head);
				return;
			}
			else
				set_savsig(tmp);

	/* find tcb corresponding to open, close or ioctl to be killed */
	for ( tcbp = tcbpool; tcbp < &tcbpool[numtcb]; tcbp++ )
		if ( pid == tcbp->p_pid )
			break;

	if ( tcbp == &tcbpool[numtcb] )
		return;

	/* set tcb_sig so call to sleep will return (or exit) */
	tcbp->tcb_sig = 1;

	unsleep(tcbp);
}

/******************************************************************************/
static void
remove_mp(kmp, lmp, headp)
mblk_t  *kmp;
mblk_t  *lmp;
mblk_t  **headp;
{
	if ( lmp )
		lmp->b_next = kmp->b_next;
	else
		*headp = kmp->b_next;

	((struct iopmscb *)kmp->b_rptr)->iopms_dev = (dev_t)OPENFAIL;
	((struct iopmscb *)kmp->b_rptr)->iopms_err = EINTR;
	sendmptokernel(kmp);
}

/******************************************************************************/
static void
set_savsig(kmp)
mblk_t  *kmp;
{
	ASSERT(valid_pm_mblk(kmp));

	switch ( kmp->b_datap->db_type )
	{
	    case M_CLOSE:
		((struct iopmscb *)kmp->b_rptr)->iopms_savsig = 1;
		break;

	    case M_IOCTL:
		ASSERT(kmp->b_cont);
		switch ( ((struct iocblk *)kmp->b_rptr)->ioc_cmd )
		{
		    case I_PUSH:
		    case I_POP:
			((struct iopmscb *)kmp->b_cont->b_rptr)->iopms_savsig =
			  1;
			break;

		    default:
			ASSERT(0);
			break;
		}
		break;

	    default:
		ASSERT(0);
		break;
	}
}

/******************************************************************************/
void
process_ioctl(kmp)
register mblk_t  *kmp;
{
	register struct iocblk  *iocblk;

	ASSERT(valid_pm_mblk(kmp));
	iocblk = (struct iocblk *)kmp->b_rptr;

	iocblk->ioc_rval = 0;

	switch ( iocblk->ioc_cmd )
	{
	    case I_FIND:	/* see if named mod is pushed on this stream */
		process_FIND(kmp);
		break;

	    case I_LOOK:	/* get name of first mod down stream */
		process_LOOK(kmp);
		break;

	    case I_PUSH:
		process_PUSH(kmp);
		break;

	    case I_POP:
		process_POP(kmp);
		break;

	    case I_LINK:
		process_LINK(kmp);
		break;

	    case I_UNLINK:
		process_UNLINK(kmp);
		break;

	    case I_FDINSERT:
		process_FDINSERT(kmp);
		break;
	}
}

/******************************************************************************/
static void
process_FIND(kmp)
register mblk_t  *kmp;
{
	register struct iocblk    *iocblk;
	register struct iopm_ctl  *iopmctl;
	register int              index;
	register iqueue_t         *wqp;

	ASSERT(valid_pm_mblk(kmp));
	iocblk = (struct iocblk *)kmp->b_rptr;
	ASSERT(kmp->b_cont);

	/* look in local fmodsw for mod name */
	if ( (index = findmod((char *)kmp->b_cont->b_rptr)) < 0 )
	{
		kmp->b_datap->db_type = M_IOCACK;
		iocblk->ioc_rval = -1; /* no such module on this IOPM */
		iocblk->ioc_count = 0;
		sendmptokernel(kmp);
		return;
	}

	/* start with module under IOPM psuedo head */
	/* while module exists and is not the one we are looking for */
	iopmctl = (struct iopm_ctl *)kmp->b_prev;
	ASSERT(valid_iopmctl(iopmctl));
	ASSERT(valid_wq(iopmctl->ic_iwq)); /* copy wq */
	ASSERT(valid_wq(iopmctl->ic_iwq->q_next)); /* flow wq */
	ASSERT(valid_wq(iopmctl->ic_iwq->q_next->q_next)); /* user wq */

	for ( wqp = iopmctl->ic_iwq->q_next->q_next;
	      wqp && fmodsw[index].f_str->st_wrinit != wqp->q_qinfo;
	      wqp = wqp->q_next )
	{
		ASSERT(valid_wq(wqp));
	}

	kmp->b_datap->db_type = M_IOCACK;
	iocblk->ioc_rval = wqp ? 1 : 0;	/* returned answer */
	iocblk->ioc_count = 0;		/* no data structure to return */
	/* strdoioctl (in kernel) will set u.u_rval */
	sendmptokernel(kmp);
}

/******************************************************************************/
static void
process_LOOK(kmp)
register mblk_t  *kmp;
{
	register struct iocblk    *iocblk;
	register struct iopm_ctl  *iopmctl;
	register int              index;

	ASSERT(valid_pm_mblk(kmp));
	iocblk = (struct iocblk *)kmp->b_rptr;
	ASSERT(kmp->b_cont);

	if ( iocblk->ioc_count != FMNAMESZ + 1 )
	{
		kmp->b_datap->db_type = M_IOCNAK;
		iocblk->ioc_error = EINVAL;
		sendmptokernel(kmp);
		return;
	}

	iopmctl = (struct iopm_ctl *)kmp->b_prev;
	ASSERT(valid_iopmctl(iopmctl));

	for ( index = 0; index < fmodcnt; index++ )
		if ( fmodsw[index].f_str->st_wrinit ==
		     iopmctl->ic_iwq->q_next->q_next->q_qinfo )
		{
			bcopy(fmodsw[index].f_name,
			  (caddr_t)kmp->b_cont->b_rptr, FMNAMESZ + 1);
			kmp->b_datap->db_type = M_IOCACK;
			/* strdoioctl in kernel will copy from msg to user */
			sendmptokernel(kmp);
			return;
		}

	kmp->b_datap->db_type = M_IOCACK;
	iocblk->ioc_error = EINVAL;
	iocblk->ioc_count = 0;
	sendmptokernel(kmp);
}

/******************************************************************************/
static void
process_PUSH(kmp)
register mblk_t  *kmp;
{
	register struct iocblk    *iocblk;
	int                       index;

	ASSERT(valid_pm_mblk(kmp));
	iocblk = (struct iocblk *)kmp->b_rptr;
	ASSERT(kmp->b_cont);

	if ( (index =
	  findmod(((struct iopmscb *)kmp->b_cont->b_rptr)->iopms_mname)) < 0 )
	{
		kmp->b_datap->db_type = M_IOCNAK;
		iocblk->ioc_error = EINVAL;
		sendmptokernel(kmp);
		return;
	}

	iocblk->ioc_count = (uint)index;	/* use count to pass index */

	if ( create((int)strproc, 0, STRPRI + 2) )
	{
		kmp->b_next = stcb_head;
		stcb_head = kmp;
	}
	else
	{
		kmp->b_next = proc_head;
		proc_head = kmp;
	}
}

/******************************************************************************/
static void
process_POP(kmp)
register mblk_t  *kmp;
{
	register struct iocblk    *iocblk;
	register struct iopm_ctl  *iopmctl;

	ASSERT(valid_pm_mblk(kmp));
	iocblk = (struct iocblk *)kmp->b_rptr;
	iopmctl = (struct iopm_ctl *)kmp->b_prev;
	ASSERT(valid_iopmctl(iopmctl));
	ASSERT(iopmctl->ic_iwq->q_next);		/* flow wq */
	ASSERT(iopmctl->ic_iwq->q_next->q_next);	/* user mod wq */

	if ( iopmctl->ic_iwq->q_next->q_next->q_next &&	/* user driver wq */
	     !(iopmctl->ic_iwq->q_next->q_next->q_next->q_flag & QREADR) )
	{
		if ( create((int)strproc, 0, STRPRI + 2) )
		{
			kmp->b_next = stcb_head;
			stcb_head = kmp;
		}
		else
		{
			kmp->b_next = proc_head;
			proc_head = kmp;
		}
	}
	else
	{
		kmp->b_datap->db_type = M_IOCNAK;
		iocblk->ioc_error = EINVAL;
		sendmptokernel(kmp);
	}
}

/******************************************************************************/
/* The LINK ioctl breaks the stream between the copy and flow layer and tells
/* the mux driver that the flow queues are the new lower mux queues. The copy
/* layer queues stay behind to be reconected during the unlink command.
*/
static void
process_LINK(kmp)
register mblk_t  *kmp;
{
	register struct iocblk    *iocblk;
	register struct iopm_ctl  *iopmctl;
	struct linkblk            *linkp;
	iqueue_t                  *iwqdown;
	dev_t                     dev;
	mblk_t                    *mp;
	int                       savpri;

	ASSERT(valid_pm_mblk(kmp));
	iocblk = (struct iocblk *)kmp->b_rptr;
	iopmctl = (struct iopm_ctl *)kmp->b_prev;
	ASSERT(valid_iopmctl(iopmctl));
	ASSERT(kmp->b_cont);

	/* b_cont->b_rptr contains room for a linkblk */
	linkp = (struct linkblk *)kmp->b_cont->b_rptr;

	/* l_bot -> kernel str hd.
	/* q_next -> kernel IOPM driver.
	/* q_ptr->ic_iwq -> first IOPM wr q */
	ASSERT(valid_pm_addr(linkp->l_qbot));
	ASSERT(valid_pm_addr(linkp->l_qbot->q_next));
	ASSERT(linkp->l_qbot->q_next->q_flag & QREMOTE);
	ASSERT(valid_iopmctl((struct iopm_ctl *)linkp->l_qbot->q_next->q_ptr));
	ASSERT(valid_wq(
	  ((struct iopm_ctl *)linkp->l_qbot->q_next->q_ptr)->ic_iwq));
	ASSERT(valid_wq(
	  ((struct iopm_ctl *)linkp->l_qbot->q_next->q_ptr)->ic_iwq->q_next));

	iwqdown =
	  ((struct iopm_ctl *)linkp->l_qbot->q_next->q_ptr)->ic_iwq->q_next;

	dev = iopmctl->ic_iopmdev;
	ASSERT(dev & UNMINOR_BIT);
	ASSERT(cdevsw[major(dev)].d_str);
	/* test that upper stream has mux capibilities */
	if ( !cdevsw[major(dev)].d_str->st_muxwinit )
	{
		kmp->b_datap->db_type = M_IOCNAK;
		iocblk->ioc_error = EINVAL;
		sendmptokernel(kmp);
		return;
	}

	savpri = splstr();
	/* cut q_next link from rflow to rcopy */
	RD(iwqdown)->q_next = 0;

	setq(RD(iwqdown),
	     cdevsw[major(dev)].d_str->st_muxrinit,
	     cdevsw[major(dev)].d_str->st_muxwinit);
	splx(savpri);

	iopmctl->ic_savctl = (struct iopm_ctl *)RD(iwqdown)->q_ptr;

	/* don't change IOPM q_ptr or kernel IOPM driver q_ptr, so the */
	/* UNLINK can restore the lower stream */
	iwqdown->q_flag |= QWANTR;
	RD(iwqdown)->q_flag |= QWANTR;

	/* mfg phony linkblk entry with IOPM addresses for drivers */
	linkp->l_qtop = (queue_t *)getendq(iopmctl->ic_iwq);
	linkp->l_qbot = (queue_t *)iwqdown;

	copy_wput(iopmctl->ic_iwq, kmp);
}

/******************************************************************************/
static void
process_UNLINK(kmp)
register mblk_t  *kmp;
{
	register struct iopm_ctl  *iopmctl;
	register iqueue_t         *wqp;
	register struct linkblk   *linkp;
	register queue_t          *kwqdown;
	register iqueue_t         *iwqdown;

	ASSERT(valid_pm_mblk(kmp));
	iopmctl = (struct iopm_ctl *)kmp->b_prev;
	ASSERT(valid_iopmctl(iopmctl));
	wqp = iopmctl->ic_iwq;
	ASSERT(valid_wq(wqp));
	ASSERT(kmp->b_cont);
	linkp = (struct linkblk *)kmp->b_cont->b_rptr;
	ASSERT(valid_pm_addr(linkp->l_qbot));
	kwqdown = linkp->l_qbot->q_next;
	ASSERT(valid_pm_addr(kwqdown));
	ASSERT(kwqdown->q_flag & QREMOTE);
	ASSERT(valid_iopmctl((struct iopm_ctl *)kwqdown->q_ptr));
	iwqdown = ((struct iopm_ctl *)kwqdown->q_ptr)->ic_iwq;
	ASSERT(valid_wq(iwqdown));
	/* save the lower q ctl until the ACK */
	iopmctl->ic_savctl = (struct iopm_ctl *)RD(iwqdown)->q_ptr;

	linkp->l_qbot = (queue_t*)iwqdown;
	linkp->l_qtop = (queue_t*)getendq(wqp);

	copy_wput(wqp, kmp);
}

/******************************************************************************/
static void
process_FDINSERT(kmp)
register mblk_t  *kmp;
{
	register struct iocblk    *iocblk;
	register struct iopm_ctl  *iopmctl;
	register queue_t          *otherkwq;
	register iqueue_t         *otheriwq;
	register mblk_t           *insertmp;
	register uint             offset;

	ASSERT(valid_pm_mblk(kmp));
	iocblk = (struct iocblk *)kmp->b_rptr;
	iopmctl = (struct iopm_ctl *)kmp->b_prev;
	ASSERT(valid_iopmctl(iopmctl));
	ASSERT(kmp->b_cont);

	insertmp = ((struct remoteinsert *)kmp->b_cont->b_rptr)->insertmp;
	ASSERT(valid_pm_mblk(insertmp));
	insertmp->b_prev = (mblk_t *)iopmctl;
	offset = ((struct remoteinsert *)kmp->b_cont->b_rptr)->offset;
	ASSERT(offset < 0x1000);	/*CMW sizeof largest msg block */
	otherkwq = kWR(*(queue_t **)(insertmp->b_rptr + offset));
	ASSERT(valid_pm_addr(otherkwq));

	if ( !(otherkwq->q_flag & QREMOTE) )
	{
		kfreemsg(insertmp);
		kmp->b_datap->db_type = M_IOCNAK;
		iocblk->ioc_error = EINVAL;
		sendmptokernel(kmp);
		return;
	}

	ASSERT(valid_iopmctl((struct iopm_ctl *)otherkwq->q_ptr));
	if ( ((struct iopm_ctl *)otherkwq->q_ptr)->ic_iopmslot !=
	  iopmcomm.slot )
	{
		kfreemsg(insertmp);
		kmp->b_datap->db_type = M_IOCNAK;
		iocblk->ioc_error = EINVAL;
		sendmptokernel(kmp);
		return;
	}

	/* ic_iwq is a pointer to the IOPM "head" write queue */
	otheriwq = ((struct iopm_ctl *)otherkwq->q_ptr)->ic_iwq;

	ASSERT(valid_wq(otheriwq));

	/* find the end of the other IOPM stream */
	for ( otheriwq = otheriwq->q_next; otheriwq->q_next;
	      otheriwq = otheriwq->q_next )
	{
		ASSERT(valid_wq(otheriwq));
	}

	*((iqueue_t **)(insertmp->b_rptr + offset)) = otheriwq;

	mux_wput(insertmp);
	kmp->b_datap->db_type = M_IOCACK;
	iocblk->ioc_count = 0;
	sendmptokernel(kmp);
	return;
}

/******************************************************************************/
void
strproc()
{
	mblk_t  *kmp;
	int     savpri;

	savpri = spl1();
	kmp = get_last_mblk(&proc_head);
	if ( !kmp )
	{
		splx(savpri);
		exit();
	}

	ASSERT(valid_pm_mblk(kmp));
	switch ( kmp->b_datap->db_type )
	{
	    case M_OPEN:
		stask_init((struct iopmscb *)kmp->b_rptr);
		splx(savpri);
		sopenproc(kmp);
		exit();
		break;

	    case M_CLOSE:
		stask_init((struct iopmscb *)kmp->b_rptr);
		splx(savpri);
		scloseproc(kmp);
		exit();
		break;

	    case M_IOCTL:
		ASSERT(kmp->b_cont);
		switch ( ((struct iocblk *)kmp->b_rptr)->ioc_cmd )
		{
		    case I_PUSH:
			stask_init((struct iopmscb *)kmp->b_cont->b_rptr);
			splx(savpri);
			PUSHproc(kmp);
			exit();
			break;

		    case I_POP:
			stask_init((struct iopmscb *)kmp->b_cont->b_rptr);
			splx(savpri);
			POPproc(kmp);
			exit();
			break;

		    default:
			ASSERT(0);
			break;
		}

	    default:
		ASSERT(0);
		break;
	}
}

/******************************************************************************/
static mblk_t *
get_last_mblk(head)
mblk_t  **head;
{
	register mblk_t  *tmp;
	register mblk_t  *lmp = 0;

	if ( !*head )
		return NULL;

	for ( tmp = *head; tmp->b_next; tmp = tmp->b_next )
		lmp = tmp;

	if ( lmp )
		lmp->b_next = 0;
	else
		*head = 0;

	return tmp;
}

/******************************************************************************/
static void
stask_init(iopmscbp)
register struct iopmscb  *iopmscbp;
{
	iproc.p_pid = iopmscbp->iopms_pid;
	iproc.p_pgrp = iopmscbp->iopms_pgrp;
	iproc.p_session_id = iopmscbp->iopms_session_id;
	iu.u_uid = iopmscbp->iopms_uid;
	iu.u_gid = iopmscbp->iopms_gid;
	iu.u_ruid = iopmscbp->iopms_ruid;
	iu.u_rgid = iopmscbp->iopms_rgid;
	iu.u_ttyp = iopmscbp->iopms_ttyp;
	curtcbp->tcb_sig = iopmscbp->iopms_savsig;
}

/******************************************************************************/
#define FLAG    iopcbp->iopms_oflag
#define SFLAG   iopcbp->iopms_sflag

extern struct cdevsw cdevsw[];

static void
sopenproc(kmp)
mblk_t  *kmp;
{
	register struct iopm_ctl  *iopmctl;
	register iqueue_t         *qp;

	ASSERT(valid_pm_mblk(kmp));
	iopmctl = (struct iopm_ctl *)kmp->b_prev;
	ASSERT(valid_iopmctl(iopmctl));

	PRINT1(SROUT | SOPEN, "sopenproc: iwq %x\n", iopmctl->ic_iwq);

	if ( qp = iopmctl->ic_iwq )	/* the copy wq */
		second_open(qp, kmp);
	else
		first_open(kmp);

	sendmptokernel(kmp);
}

/******************************************************************************/
static void
first_open(kmp)
mblk_t  *kmp;
{
	register struct iopm_ctl  *iopmctl;
	register struct iopmscb   *iopcbp;
	register iqueue_t         *crqp;	/* copy rq */
	register iqueue_t         *frqp;	/* flow rq */
	ushort                    idev;
	int                       imin;

	ASSERT(valid_pm_mblk(kmp));
	iopcbp = (struct iopmscb *)kmp->b_rptr;
	iopmctl = (struct iopm_ctl *)kmp->b_prev;
	ASSERT(valid_iopmctl(iopmctl));

	if ( !(crqp = allocq()) )	/* alloc q for IOPM copy layer */
	{
		PRINT(SOPEN, "sopenproc: failed to alloc copy q.\n");
		iopcbp->iopms_dev = OPENFAIL;
		return;
	}

	if ( !(frqp = allocq()) )	/* alloc q for IOPM flow layer */
	{
		PRINT(SOPEN, "sopenproc: failed to alloc flow q.\n");
		freeq(crqp);
		iopcbp->iopms_dev = OPENFAIL;
		return;
	}

	setq(crqp, &rcopydata, &wcopydata);
	crqp->q_ptr = (caddr_t)iopmctl;
	iopmctl->ic_iwq = WR(crqp);

	setq(frqp, &rflowdata, &wflowdata);
	frqp->q_ptr = (caddr_t)iopmctl;
	WR(crqp)->q_next = WR(frqp);
	frqp->q_next = crqp;

	idev = iopmctl->ic_iopmdev;

	PRINT2(SOPEN, "sopenproc: about to call qattach, idev %x, irq = %x\n",
	  idev, frqp);

	/* pass clone open flag to qattach. qattach now returns dev from open */
	if ( cdevsw[major(idev)].d_str &&
	     ((imin =
	     qattach(cdevsw[major(idev)].d_str, frqp, idev, (int)FLAG, SFLAG))
	     != OPENFAIL) )
	{	/* success. pass rq back to kernel so driver has link to IOPM */
		/* prime pump so srv routines called on first putq */
		frqp->q_flag |= QWANTR;
		noenable(WR(frqp));
		crqp->q_flag |= QWANTR;
		WR(crqp)->q_flag |= QWANTR;
		set_list_avail(WR(crqp));

		if ( iopcbp->iopms_ttyp != iu.u_ttyp )
		{
			iopcbp->iopms_ttyp = iu.u_ttyp;
			ASSERT(valid_iopm_vaddr(iu.u_ttyp));
			iopcbp->iopms_pgrp = *iu.u_ttyp;
		}

		if ( SFLAG )
			iopcbp->iopms_dev += imin;
		else
		{
			ASSERT(imin == minor(idev));
		}

		ASSERT(major(idev) == major((major(idev) << 8) + imin));

	}
	else	/* failure. */
	{
		freeq(crqp);
		freeq(frqp);
		iopcbp->iopms_dev = (dev_t)OPENFAIL;
		iopcbp->iopms_err = iu.u_error;
	}
}

/******************************************************************************/
static void
second_open(wqp, kmp)
iqueue_t  *wqp;			/* the copy layer wq */
mblk_t    *kmp;
{
	register struct iopmscb   *iopcbp;
	register struct iopm_ctl  *iopmctl;

	ASSERT(valid_wq(wqp));
	wqp = wqp->q_next;	/* the flow wq */
	ASSERT(valid_wq(wqp));
	ASSERT(valid_pm_mblk(kmp));
	iopcbp = (struct iopmscb *)kmp->b_rptr;
	iopmctl = (struct iopm_ctl *)kmp->b_prev;
	ASSERT(valid_iopmctl(iopmctl));

	/* copy kernel's *ttyp to driver private pgrp */
	if ( valid_iopm_vaddr(iopmctl->ic_iopmttyp) )
		*iopmctl->ic_iopmttyp = iopmctl->ic_pgrp;

	/*
	 * Open all modules and devices down stream to notify
	 * that another user is streaming.
	 * For modules, set the last argument to MODOPEN and
	 * do not pass any open flags.
	 */

	while ( wqp = wqp->q_next )
	{
		ASSERT(valid_wq(wqp));
		if ( wqp->q_flag & QREADR )
			break;

		PRINT1(SOPEN, "sopenproc: about to call qi_qopen (%x)\n",
		  RD(wqp)->q_qinfo->qi_qopen );

		*LED_CTRL_REG = LED1_OFF;
		*LED_CTRL_REG = LED2_ON;

		/* The streams book says the head will pass 0 for dev */
		/* however the ATT code passes a dev. */
		if ( (*RD(wqp)->q_qinfo->qi_qopen)(
		       RD(wqp), iopmctl->ic_iopmdev,
		       (wqp->q_next ? 0 : FLAG),
		       (wqp->q_next ? MODOPEN : 0)) == OPENFAIL )
		{
			*LED_CTRL_REG = LED1_ON;
			*LED_CTRL_REG = LED2_OFF;

			iopcbp->iopms_dev = (dev_t)OPENFAIL;
			if ( iu.u_error )
				iopcbp->iopms_err = iu.u_error;
			else
				iopcbp->iopms_err = ENXIO;

			return;
		}

		*LED_CTRL_REG = LED1_ON;
		*LED_CTRL_REG = LED2_OFF;
	}

	if ( iopcbp->iopms_ttyp != iu.u_ttyp )
	{
		iopcbp->iopms_ttyp = iu.u_ttyp;
		ASSERT(valid_iopm_vaddr(iu.u_ttyp));
		iopcbp->iopms_pgrp = *iu.u_ttyp;
	}
}

/******************************************************************************/
static void
scloseproc(kmp)
mblk_t  *kmp;
{
	register struct iopm_ctl  *iopmctl;
	register struct iopmscb   *iopcbp;
	register                  savpri;
	register iqueue_t         *cwqp;
	register iqueue_t         *fwqp;
	register iqueue_t         *q;
	register iqueue_t         *prev = NULL;
	uint                      id;
	int                       flag;
	uint                      timeout();

	ASSERT(valid_pm_mblk(kmp));
	iopcbp = (struct iopmscb *)kmp->b_rptr;
	iopmctl = (struct iopm_ctl *)kmp->b_prev;
	ASSERT(valid_iopmctl(iopmctl));
	ASSERT(valid_wq(iopmctl->ic_iwq));
	cwqp = iopmctl->ic_iwq;
	flag = FLAG;

	PRINT2(SROUT | SCLOSE, "scloseproc: irq = %x, iwq = %x\n",
	  RD(cwqp), cwqp);

	if ( !(flag & FNDELAY) && cwqp->q_count )
	{
		/* wait for copy wq to clear */
		savpri = splstr();
		iopmctl->ic_iflags |= QSLPCLS;
		id = timeout(closetime, (caddr_t)cwqp, STRTIMOUT * HZ);
		while ( iopmctl->ic_iflags & QSLPCLS && cwqp->q_count )
			if ( sleep((caddr_t)cwqp, PZERO + 2 | PCATCH) )
				break;

		untimeout((int)id);
		iopmctl->ic_iflags &= ~QSLPCLS;
		splx(savpri);
	}

	fwqp = cwqp->q_next;

	while ( fwqp->q_next )	/* first mod after flow layer */
	{
		if ( !(flag & FNDELAY) )
		{
			savpri = splstr();
			/* The resource that this code waits for when sleeping
			** is the QSLPCLS flag
			*/
			iopmctl->ic_iflags |= QSLPCLS;
			id = timeout(closetime, (caddr_t)cwqp, STRTIMOUT * HZ);
			/*
			 * sleep until awakened by copy_wsrv() or closetime() 
			 */
			while ( iopmctl->ic_iflags & QSLPCLS &&
			  fwqp->q_next->q_count )
			{
				fwqp->q_next->q_flag |= QWANTW;
				if ( sleep((caddr_t)cwqp, STIPRI | PCATCH) )
					break;
			}

			untimeout((int)id);
			iopmctl->ic_iflags &= ~QSLPCLS;
			splx(savpri);
		}
		iopmctl->ic_iflags |= CLOSING;
		qdetach(RD(fwqp->q_next), 1, flag);
	}

	kflushq(cwqp, FLUSHALL);	/* flush copy write q */
	flushq(fwqp, FLUSHALL);		/* flush flow wq, may HAVE BEEN mux */
	flushq(RD(fwqp), FLUSHALL);	/* flush flow read q */
	flushq(RD(cwqp), FLUSHALL);	/* flush copy read q */

	chk_runlist(RD(cwqp));		/* remove copy q's from queuerun list */
	chk_runlist(RD(fwqp));		/* remove flow q's from queuerun list */
	chk_bufcall(RD(cwqp));		/* remove copy q's from bufcall list */
	chk_bufcall(RD(fwqp));		/* remove flow q's from bufcall list */

	freeq(RD(fwqp));		/* free flow layer queue pair */
	freeq(RD(cwqp));		/* free copy layer queue pair */

	sendmptokernel(kmp);
}

/******************************************************************************/
/*
 * This function is placed in the callout table to wake up a process
 * waiting to close a stream that has not completely drained.
 */
static void
closetime(iwq)
iqueue_t  *iwq;
{
	register struct iopm_ctl  *iopmctl;

	ASSERT(valid_wq(iwq));
	iopmctl = (struct iopm_ctl *)RD(iwq)->q_ptr;
	ASSERT(valid_iopmctl(iopmctl));

	if ( iopmctl->ic_iflags & QSLPCLS )
	{
		wakeup((caddr_t)iwq);
		iopmctl->ic_iflags &= ~QSLPCLS;
	}
}

/******************************************************************************/
/* ioc_count is used to pass in the index into fmodsw */
static void
PUSHproc(kmp)
register mblk_t  *kmp;
{
	register struct iocblk      *iocblk;
	register struct iopm_ctl    *iopmctl;
	register struct iopmscb     *iopmscb;
	uint                        index;
	iqueue_t                    *fwqp;

	ASSERT(valid_pm_mblk(kmp));
	iocblk = (struct iocblk *)kmp->b_rptr;
	iopmctl = (struct iopm_ctl *)kmp->b_prev;
	ASSERT(valid_iopmctl(iopmctl));
	ASSERT(kmp->b_cont);

	index = iocblk->ioc_count;
	iocblk->ioc_count = 0;
	iopmscb = (struct iopmscb *)kmp->b_cont->b_rptr;

	ASSERT(fmodsw[index].f_str);
	if ( qattach(fmodsw[index].f_str, RD(iopmctl->ic_iwq->q_next),
	             iopmctl->ic_iopmdev, 0, 0) == OPENFAIL )
	{
		kmp->b_datap->db_type = M_IOCNAK;
		if ( iu.u_error )
			iocblk->ioc_error = iu.u_error;
		else
			iocblk->ioc_error = ENXIO;

		sendmptokernel(kmp);
		return;
	}

	set_list_avail(iopmctl->ic_iwq);

	kmp->b_datap->db_type = M_IOCACK | QREMCMD;

	if ( iopmscb->iopms_ttyp != iu.u_ttyp )
	{
		ASSERT(valid_iopm_vaddr(iu.u_ttyp));
		iopmscb->iopms_pgrp = *iu.u_ttyp;
	}
	iocblk->ioc_rval = (int)iu.u_ttyp;

	sendmptokernel(kmp);

	/* if the IOPM "head" was full and the next mod was waiting to
	** write to it, now there is an empty mod to write to, so
	** enable the waiting mod.
	*/
	ASSERT(valid_wq(iopmctl->ic_iwq));
	fwqp = iopmctl->ic_iwq->q_next;
	ASSERT(valid_wq(fwqp));
	if ( RD(fwqp)->q_flag & QWANTW )
	{
		register iqueue_t  *q;

		for ( q = backq(RD(fwqp)->q_next);
		      q && !q->q_qinfo->qi_srvp;
		      q = backq(q) );
			if ( q )
				qenable(q);
	}

	/* if the mod formerly below the IOPM "head" was full and the
	** IOPM "head" was waiting to write, then enable the IOPM "head"
	*/
	if ( fwqp->q_next->q_flag & QWANTW )
		qenable(fwqp);
}

/******************************************************************************/
static void
POPproc(kmp)
register mblk_t  *kmp;
{
	register struct iocblk    *iocblk;
	register struct iopm_ctl  *iopmctl;

	ASSERT(valid_pm_mblk(kmp));
	iocblk = (struct iocblk *)kmp->b_rptr;
	iopmctl = (struct iopm_ctl *)kmp->b_prev;
	ASSERT(valid_iopmctl(iopmctl));

	ASSERT(valid_wq(iopmctl->ic_iwq));			/* copy wq */
	ASSERT(valid_wq(iopmctl->ic_iwq->q_next));		/* flow wq */
	ASSERT(valid_wq(iopmctl->ic_iwq->q_next->q_next));	/* user mod */
	ASSERT(valid_wq(iopmctl->ic_iwq->q_next->q_next->q_next)); /* usr drv */

	qdetach(RD(iopmctl->ic_iwq->q_next->q_next), 1, 0);

	set_list_avail(iopmctl->ic_iwq);

	kmp->b_datap->db_type = M_IOCACK;

	iocblk->ioc_count = 0;
	sendmptokernel(kmp);
}
