/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) startup.c: version 25.1 created on 11/27/91 at 14:49:04	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)startup.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/kmem.h"
#include "sys/iopmcomm.h"
#include "sys/spm_mem.h"
#include "sys/sbus_iopm.h"
#include "sys/iopmstat.h"
#include "iopm.h"
#include "tcb.h"

extern own_stack[];

/******************************************************************************/
startc()
{
	register ushort  config_reg = *CONFIG_REG;
	int              nextfree;
	extern char      edata;
	extern void      iopm_mgr();
	extern           swtch_continue();

	config_reg &= ~DEV_RST_OUT;	/* set lo active reset to device brd */
	*CONFIG_REG = config_reg;
	config_reg |= DEV_RST_OUT;	/* clear reset */
	*CONFIG_REG = config_reg;

	*LED_CTRL_REG = LED1_OFF;

	iopmcomm.iopm_version = IOPM_VERSION;

	/* tell spm we are done */
	iopmcomm.o_boot_response = 1;

	nextfree = mmuinit();		/* init mmu */

	if ( spm_mem.spm_version != SPM_MEM_VERSION )
		panic("spm version mismatch: spm_version %x, iopm spm_mem version %x",
		  spm_mem.spm_version, SPM_MEM_VERSION);

#ifdef M68020
	if ( spm_mem.cpu_type != 68020 )
		panic("IOPM compiled to work in 68020 system. System is %d.\n",
		  spm_mem.cpu_type);
#endif

#ifdef M68040
	if ( spm_mem.cpu_type != 68040 )
		panic("IOPM compiled to work in 68040 system. System is %d.\n",
		  spm_mem.cpu_type);
#endif

	if ( !(*STATUS_CTRL_REG & NO_DIAG_BAG) )
		coninit();		/* init diag bag console */

	meminit( nextfree );
	binit();			/* init local buf pool */
	tcbinit();			/* init tcb pool */
	strinit();
	timeout_init();
	init_intr_info();
	dizzy_llock_init();
	kcacheb_init();
	infoinit();

	if ( create(iopm_mgr, 0, 0) )	/** arg = 0, pri = 0 */
		panic("startup: no tcb's to create task 0");

	spl0();
	/* tell spm ok to send next clock */
	iopmcomm.o_reprime_clock = 1;
	*LED_CTRL_REG = LED2_OFF;

	set_pc_sp( swtch_continue, (caddr_t)own_stack + STKSZ-4 );
	panic("startup: return from set_pc_sp");
}

/******************************************************************************/
infoinit()
{
	extern struct iopminfo   iopminfo;
	extern struct kbstat     kbstat;
	extern struct intrstat   intrstat;
	extern struct strifstat  strifstat;
	extern struct bufifstat  bufifstat;

	iopminfo.kbstatp = &kbstat;
	iopminfo.intrstatp = &intrstat;
	iopminfo.strifstatp = &strifstat;
	iopminfo.bufifstatp = &bufifstat;

	iopmcomm.iopminfop = &iopminfo;
}
