/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) slp.c: version 25.1 created on 11/27/91 at 14:48:56	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)slp.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/param.h"
#include "sys/types.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/sbus_iopm.h"
#include "user.h"
#include "proc.h"
#include "tcb.h"

struct tcb     *runq = 0;
struct tcb     *sleepq = 0;
struct tcb     *curtcbp = 0;
int            curpri = 0;
int            idleflg;
struct i_user  iu;
struct i_proc  iproc;
int            spin_lock_count = 0;
uint           runflag = 0;
uint           ticks_since_setrq = 0;
uint           intr_ignored = 0;

/******************************************************************************/
sleep(chan, disp)
caddr_t  chan;
{
	int  savpri = splhi();

	ASSERT(valid_tcb(curtcbp));
	ASSERT(curtcbp->tcb_flags == T_CURRENT);

	if ( curtcbp->tcb_sig && (disp & PMASK) > PZERO )
		if ( disp & PCATCH )
		{
			splx(savpri);
			return 1;
		}
		else
		{
			splx(savpri);
			*LED_CTRL_REG = LED1_ON;
			*LED_CTRL_REG = LED2_OFF;
			cmn_err(CE_WARN, "signal rcvd w/o PCATCH. task exit");
			exit();		/* task exit = system call longjump */
		}

	curtcbp->tcb_link = sleepq;	/* put tcb on the sleep queue */
	curtcbp->tcb_wchan = chan;
	curtcbp->tcb_pri = disp & PMASK;
	sleepq = curtcbp;
	curtcbp->tcb_flags = T_SLEEPQ;
	*LED_CTRL_REG = LED1_ON;
	*LED_CTRL_REG = LED2_OFF;

	swtch();
	splx(savpri);
	*LED_CTRL_REG = LED1_OFF;
	*LED_CTRL_REG = LED2_ON;
	return 0;
}

/******************************************************************************/
wakeup(chan)
caddr_t  chan;
{
	struct tcb  *tcbp;
	struct tcb  *last_tcbp = NULL;
	struct tcb  *tmp_tcbp = NULL;
	int         savpri = splhi();

	for ( tcbp = sleepq; tcbp; )
	{
		ASSERT(valid_tcb(tcbp));
		if ( tcbp->tcb_wchan == chan )
		{
			if ( !last_tcbp )	/* remove from sleepq */
				tmp_tcbp = sleepq = tcbp->tcb_link;
			else
				tmp_tcbp = last_tcbp->tcb_link = tcbp->tcb_link;

			ASSERT(tcbp->tcb_flags == T_SLEEPQ);
			tcbp->tcb_wchan = 0;
			setrq(tcbp);
			tcbp = tmp_tcbp;
		}
		else
		{
			last_tcbp = tcbp;
			tcbp = tcbp->tcb_link;
		}
	}
	splx(savpri);
}

/******************************************************************************/
unsleep(tcbp)
struct tcb  *tcbp;
{
	int                  savpri;
	register struct tcb  *tmptcbp;
	register struct tcb  *last_tcbp;

	ASSERT(valid_tcb(tcbp));
	savpri = splhi();
	for ( tmptcbp = sleepq; tmptcbp; tmptcbp = tmptcbp->tcb_link )
	{
		ASSERT(valid_tcb(tmptcbp));
		if ( tmptcbp != tcbp )
		{
			last_tcbp = tmptcbp;
			continue;
		}
		if ( sleepq == tcbp )	/* remove from sleepq */
			sleepq = tcbp->tcb_link;
		else
			last_tcbp->tcb_link = tcbp->tcb_link;

		ASSERT(tcbp->tcb_flags == T_SLEEPQ);
		tcbp->tcb_wchan = 0;
		setrq(tcbp);
		break;
	}
	splx(savpri);
}

/******************************************************************************/
swtch()
{
	extern int  own_stack[];
	extern      swtch_continue();

	/* save u area and proc (u_procp not saved since it always = &i_proc) */
	curtcbp->u_uid = iu.u_uid;
	curtcbp->u_gid = iu.u_gid;
	curtcbp->u_ruid = iu.u_uid;
	curtcbp->u_rgid = iu.u_gid;
	curtcbp->u_error = iu.u_error;
	curtcbp->u_rval = iu.u_rval;
	curtcbp->u_ttyp = iu.u_ttyp;
	curtcbp->u_kbp = iu.u_kbp;
	curtcbp->p_pid = iproc.p_pid;
	curtcbp->p_pgrp = iproc.p_pgrp;
	curtcbp->p_session_id = iproc.p_session_id;

	if ( save(curtcbp->tcb_rsav) )
		return;		/* resume in swtch_continue returns here */
	
	ASSERT(spin_lock_count == 0);
	set_pc_sp(swtch_continue, (caddr_t)own_stack + STKSZ-4);
}

/******************************************************************************/
swtch_continue()
{
	struct tcb   *disp();
	extern char  qrunflag;

	spl0();				/* created tasks get this ipl */

	/* anti-starvation. intr_ignored is set (in cssintr) if task not run */
	/* in about 1/10 sec */
	if ( intr_ignored )
	{
		intr_ignored = 0;
		softintr();
	}

	/*
	 * Search for highest-priority runnable process
	 * If no process is runnable, wait for one.
	 */
	while ( 1 )
	{
		if ( qrunflag )
			runqueues();

		if ( curtcbp = disp() )
			break;
		idle();
	}

	/* restore u area */
	iu.u_uid = curtcbp->u_uid;
	iu.u_gid = curtcbp->u_gid;
	iu.u_ruid = curtcbp->u_ruid;
	iu.u_rgid = curtcbp->u_rgid;
	iu.u_error = curtcbp->u_error;
	iu.u_rval = curtcbp->u_rval;
	iu.u_ttyp = curtcbp->u_ttyp;
	iu.u_kbp = curtcbp->u_kbp;
	iproc.p_pid = curtcbp->p_pid;
	iproc.p_pgrp = curtcbp->p_pgrp;
	iproc.p_session_id = curtcbp->p_session_id;

	resume(curtcbp->tcb_rsav);	/* resume returns to new task */
	/* never gets here */
}

/******************************************************************************/
struct tcb*
disp()
{
	register             n;
	register struct tcb  *tcbp;
	register struct tcb  *last_tcbp;
	register struct tcb  *best_tcbp;
	register struct tcb  *sav_last;
	int                  savpri;

	savpri = splhi();

	ticks_since_setrq = 0;
	best_tcbp = NULL;
	last_tcbp = NULL;
	n = 128;

	/*
	 * Search for oldest highest-priority task
	 */
	for ( tcbp = runq; tcbp; last_tcbp = tcbp, tcbp = tcbp->tcb_link )
	{
		ASSERT(valid_tcb(tcbp));
		if ( tcbp->tcb_pri > n )/* tcbp has worst pri than best */
			continue;
		best_tcbp = tcbp;
		sav_last = last_tcbp;
		n = tcbp->tcb_pri;	/* save the best that slept first */
	}

	/*
	 * If no process is runnable, idle.
	 */
	if ( !(tcbp = best_tcbp) )
	{
		runflag = 0;
		splx(savpri);
		return 0;
	}

	last_tcbp = sav_last;

	/* Take tcbp off the runq */

	if ( last_tcbp == NULL )
		runq = tcbp->tcb_link;
	else
		last_tcbp->tcb_link = tcbp->tcb_link;

	ASSERT(tcbp->tcb_flags == T_RUNQ);
	tcbp->tcb_flags = T_CURRENT;
	curpri = n;
	splx(savpri);
	return(tcbp);
}

/******************************************************************************/
setrq(tcbp)
register struct tcb *tcbp;
{
	int  savpri = splhi();

	ASSERT(valid_tcb(tcbp));
	tcbp->tcb_link = runq;
	runq = tcbp;
	tcbp->tcb_flags = T_RUNQ;
	runflag = 1;
	splx(savpri);
}
