/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) prf.c: version 25.1 created on 11/27/91 at 14:48:50	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)prf.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/iopmcomm.h"
#include "sys/cmn_err.h"

#define PRTSPM   1
#define PRTLOCAL 2
#define ARGS	a0,a1,a2,a3,a4,a5

int  prtwhere = PRTLOCAL;

#define output(c) \
{ \
	if ( prtwhere & PRTLOCAL ) \
		lputchar(c); \
	if ( prtwhere & PRTSPM ) \
		sputchar(c); \
}

/******************************************************************************/
/*
 * Scaled down version of C Library printf.
 * Only %s %u %d %o %x %D are recognized.
 * Used to print diagnostic information
 * directly on console tty.
 * Since it is not interrupt driven,
 * all system activities are pretty much suspended.
 * Printf should not be used for chit-chat.
 */

printf(fmt, x1)
register char *fmt;
unsigned x1;
{
	register int	c;
	register uint	*adx;
	register char	*s;
	register struct iopm_comm  *iopmcommp = (struct iopm_comm *)IOPM_COMM;
	uint l;			/* minimum lenght number to print */

	adx = &x1;

	if ( *(short *)STATUS_CTRL_REG & NO_DIAG_BAG )
		prtwhere = PRTSPM;

loop:
	while ( (c = *fmt++) != '%' )
	{
		if ( c == '\0' )
		{
			if ( prtwhere & PRTSPM )
			{
				iopmcommp->o_spm_printf_count = iopmcommp->o_printf_count;
				iopmcommp->o_printf_count = 0;

				/* wait for SPM to drain output */
				while ( iopmcommp->o_spm_printf_count );
			}

			return;
		}
		output(c);
	}

	if ( (c = *fmt++) == '%' )
	{
		output(c);
		goto loop;
	}

	l = 0;
	if ( c == 'l' )
		c = *fmt++;

	if ( c == '.' )
		if ( (c = *fmt++) >= '0' || c <= '9' ) {
			l = c - '0'; c = *fmt++; }
		else
			goto loop;

	if ( c <= 'Z' && c >= 'A')
		c += 'a' - 'A';

	if (c == 'd' || c == 'u' || c == 'o' || c == 'x')
		printn( c == 'd' && (long)*adx < 0 ? -(long)*adx : (long)*adx,
		        c == 'o' ? 8 : (c == 'x' ? 16 : 10),
		        c == 'd' && (long)*adx < 0, l );
	else
		if (c == 's')
		{
			s = (char *)*adx;
			while ( c = *s++ )
				output(c);
		}

	adx++;
	goto loop;
}

/******************************************************************************/
printn(n, b, s, l)
ulong n;
register b;
{
	register i, nd;
	int	plmax;
	char d[12];

	if ( b == 8 )
		plmax = 11;
	else if ( b == 10 )
		plmax = 10;
	else if ( b == 16 )
		plmax = 8;

	if ( s )
		output('-');

	for ( i = 0; i < plmax; i++ )
	{
		nd = n%b;
		d[i] = nd;
		n = n/b;
		if ( n==0 )
			break;
	}

	if (i==plmax)
		i--;

	while ( --l > i )
		output('0');

	for ( ; i >= 0; i-- )
		output("0123456789ABCDEF"[d[i]]);
}

/******************************************************************************/
int	panic_level = 0;

panic(fmt, ARGS)
caddr_t  fmt;
{
	prtwhere = PRTSPM;
	panic_level = 1;
	printf("\nPANIC: ");
	printf(fmt, ARGS);
	printf("\n");

	backtrace();

	stop_processor();
}

/******************************************************************************/
/*	Called by the ASSERT macro in debug.h when an
**	assertion fails.
*/

assfail(a, f, l)
register char *a, *f;
{
	/*	Save all registers for the dump since crash isn't
	 *	very smart at the moment.
	 */
	
	register int	r6, r5, r4, r3;

	panic("assertion failed: %s, file: %s, line: %d", a, f, l);
}

/******************************************************************************/
cmn_err(level, fmt, ARGS)
int	level ;
char	*fmt;
int	ARGS ;
{
	int  savpri;

	/*	set up to print to putbuf, console, or both
	**	as indicated by the first character of the
	**	format.
	*/

	switch ( level )
	{
	    case CE_CONT :
		printf(fmt, ARGS) ;
		break ;

	    case CE_NOTE :
		printf("\nNOTICE: ") ;
		printf(fmt, ARGS) ;
		printf("\n") ;
		break ;

	    case CE_WARN :
		printf("\nWARNING: ") ;
		printf(fmt, ARGS) ;
		printf("\n") ;
		break ;

	    case CE_PANIC :
		switch ( panic_level )
		{
		    case 0 :
			savpri = splhi() ;
			panic_level = 1 ;
			printf("\nPANIC: ") ;
			printf(fmt, ARGS) ;
			printf("\n") ;

			backtrace();
			stop_processor();
			splx(savpri) ;
			break;

		    case 1 :
			panic_level = 2 ;
			printf("\nDOUBLE PANIC: ") ;
			printf(fmt, ARGS) ;
			printf("\n") ;

			stop_processor();
			break;

		    default :
			panic_level = 3 ;
			break;
		}
		break;

	    default :
		printf("unknown level in cmn_err (level=%d, msg=\"%s\")",
		  level, fmt) ;
	}
}

/******************************************************************************/
sputchar(c)
register c;
{
	register struct iopm_comm  *iopmcommp = (struct iopm_comm *)IOPM_COMM;

	if ( iopmcommp->o_printf_count == PRINTFBUFFLEN )
	{
		iopmcommp->o_spm_printf_count = iopmcommp->o_printf_count;
		iopmcommp->o_printf_count = 0;
		while ( iopmcommp->o_spm_printf_count )
			;
	}
	iopmcommp->o_char_buff[iopmcommp->o_printf_count++] = c;
}
