/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) malloc.c: version 25.1 created on 11/27/91 at 14:48:47	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)malloc.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/cmn_err.h"
#include "sys/debug.h"
#include "sys/map.h"
#include "sys/param.h"
#include "sys/immu.h"
#include "sys/iopmcomm.h"

/******************************************************************************/
/*
 * Allocate 'size' units from the given map. Return the base of the allocated
 * space. In a map, the addresses are increasing and the list is terminated by
 * a 0 size. Algorithm is first-fit.
 */
unsigned int
malloc(mp, size)
register struct map *mp;
register int size;
{
	register unsigned int a;
	register struct map *bp;

	if (size == 0)
		return(NULL);
	ASSERT(size > 0);
	for (bp = mapstart(mp); bp->m_size; bp++) {
		if (bp->m_size >= size) {
			a = bp->m_addr;
			bp->m_addr += size;
			if ((bp->m_size -= size) == 0) {
				do {
					bp++;
					(bp-1)->m_addr = bp->m_addr;
				} while ((bp-1)->m_size = bp->m_size);
				mapsize(mp)++;
			}
			ASSERT(bp->m_size < 0x80000000);
			return(a);
		}
	}
	return(0);
}

/******************************************************************************/
/*
 * Free the previously allocated space a of size units into the specified map.
 * Sort a into map and combine on one or both ends if possible.
 */
mfree(mp, size, a)
register struct map *mp;
register int	size;
register unsigned int a;
{
	register struct map *bp;
	register unsigned int t;

	if (size == 0)
		return;
	ASSERT(size > 0);
	bp = mapstart(mp);
	for (; bp->m_addr<=a && bp->m_size!=0; bp++);
	if (bp>mapstart(mp) && (bp-1)->m_addr+(bp-1)->m_size == a) {
		(bp-1)->m_size += size;
		if(bp->m_addr){		/* m_addr==0 end of map table */
			ASSERT(a+size <= bp->m_addr);
			if (a+size == bp->m_addr) { 

				/* compress adjacent map addr entries */
				(bp-1)->m_size += bp->m_size;
				while (bp->m_size) {
					bp++;
					(bp-1)->m_addr = bp->m_addr;
					(bp-1)->m_size = bp->m_size;
				}
				mapsize(mp)++;
			}
		}
	} else {
		if (a+size == bp->m_addr && bp->m_size) {
			bp->m_addr -= size;
			bp->m_size += size;
			ASSERT(bp == mapstart(mp)  ||
				((bp - 1)->m_addr + (bp - 1)->m_size) <
				 bp->m_addr);
		} else {
			ASSERT(size);
			if (mapsize(mp) == 0) {
				cmn_err(CE_WARN,"mfree map overflow %x.\
	Lost %d items at %d\n",mp,size,a) ;
				return;
			}
			do {
				t = bp->m_addr;
				bp->m_addr = a;
				a = t;
				t = bp->m_size;
				bp->m_size = size;
				bp++;
			} while (size = t);
			mapsize(mp)--;
		}
	}
	if (mapwant(mp)) {
		mapwant(mp) = 0;
		wakeup((caddr_t)mp);
	}
}

/******************************************************************************/
uint
memalloc(numpg)
{
	uint  addr;
	extern struct map  memmap[];

	addr = malloc(memmap, numpg);
	if ( addr )
		iopmcomm.freemem -= numpg << PNUMSHFT;

	return addr;
}

/******************************************************************************/
memfree(addr, size)
{
	extern struct map  memmap[];

	mfree(memmap, size, addr);
	iopmcomm.freemem += size << PNUMSHFT;
}

/******************************************************************************/
/* allocate reqsize items from the end of the pool
*/
unsigned int
malloclast(mp, reqsize, limit)
register struct map  *mp;
unsigned int         limit;
{
	register unsigned int a;
	register struct map *bp;

	if (reqsize == 0)
		return 0;

	ASSERT(reqsize > 0);
	for ( bp = mapstart(mp); bp->m_size; bp++ );
	for ( ; bp >= mapstart(mp); bp-- )
	{
		if ( bp->m_size >= reqsize )
		{
			a = bp->m_addr + (bp->m_size - reqsize);
			if ( a < limit )
				return 0;
			if ((bp->m_size -= reqsize) == 0) {
				do {
					bp++;
					(bp-1)->m_addr = bp->m_addr;
				} while ((bp-1)->m_size = bp->m_size);
				mapsize(mp)++;
			}
			ASSERT(bp->m_size < 0x80000000);
			return a;
		}
	}
	return 0;
}
