/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) machdep.c: version 25.1 created on 11/27/91 at 14:48:40	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)machdep.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sysmacros.h"
#include "sys/immu.h"
#include "sys/spm_mem.h"
#include "sys/kmem.h"
#include "sys/debug.h"
#include "iopm.h"
#include "sys/iopm_mmu.h"
#include "sys/param.h"
#include "sys/systm.h"
#include "sys/map.h"
#include "sys/cmn_err.h"
#include "sys/iopmbuf.h"
#include "sys/iopmcomm.h"
#include "sys/iopmdebug.h"

struct map  memmap[10];

/* CPU root pointer */
uint crpinit[2];

static uint  *add_stack_ptp;		/* page tables used to add stacks */

void         iomap_program();

/* interrupts
**  1 soft
**  2 reqsrv
**  3 not used
**  4 if lo
**  5 if hi
**  6 clk
**  7 nmi
*/
/******************************************************************************/
valid_iopm_addr(addr)
uint  addr;
{
	return addr >= IOPM_RAM_START &&
	       addr < IOPM_RAM_START + iopmcomm.memsize;
}

valid_iopm_vaddr(addr)
register uint  addr;
{
	if ( addr >= IOPM_RAM_START )
		return valid_iopm_addr(addr);

	if ( addr >= MAINSTORE )
		return 0;

	if ( ((struct mmutbl *)crpinit[1] + (addr >> SEG_SHFT))->limit ==
	     INVALIDTD )
		return 0;

	/* vaddr is in driver space which uses upper limits */
	return
	  (((struct mmutbl *)crpinit[1] + (addr >> SEG_SHFT))->limit & LMASK) >=
	  btoc(addr & SEG_SIZE - 1) << 16;
}

valid_pm_addr(addr)
uint  addr;
{
	return addr >= MAINSTORE &&
		addr < MAINSTORE + (spm_mem.num_pages << PNUMSHFT);
}

/******************************************************************************/
/*
** driver request for service. cause level two interrupt.
*/
request_service()
{
	int_ctrl_reg = INTR2 | INTR_ON;
}

/******************************************************************************/
/*
** iop activity scheduling. cause level one interrupt.
*/
softintr()
{
	int_ctrl_reg = INTR1 | INTR_ON;
}

/******************************************************************************/
/* There is a 16 bit ripple counter with period 12.8 uSec at IOPM_COUNTER.
/* Since this counter is not syncronized with the read request it could change
/* during a read. To make sure the value is valid the counter must be read until
/* two consectutive reads return the same value.
/* To provide the upper 16 bits of a 32 bit counter upper16 is incremented
/* whenever the counter rolls over (increments past 64K).
/* For this to work readcount must be call at least once every 64K * 12.8 uSec.
/* It is called in the clock interrupt routine (every 20 mSec).
*/
get_time_stamp()
{
	static ushort    upper16;
	static ushort    savcount;
	register ushort  count;
	int              savpri;

	savpri = splhi();

	do
	{
		count = *IOPM_COUNTER;
	} while ( count != *IOPM_COUNTER );

	if ( count < savcount )
		upper16++;

	savcount = count;

	splx(savpri);

	return upper16 << 16 | count;
}

/******************************************************************************/
meminit(start)
{
	int endram = IOPM_RAM_START + iopmcomm.memsize - 1;

	mapinit(memmap, 8);
	mfree(memmap, (int)(btoc(endram)-btoc(start)), btoc(start));
}

/******************************************************************************/
thrucss(addr)
register uint  addr;
{
	ASSERT( valid_iopm_addr(addr) );
	return addr + 0x800000;
}

/******************************************************************************/
cache_flush()
{
	cache_enable();
}

/******************************************************************************/
/******************************************************************************/
ipde_t  *ptbase;

/* transparent tranlation register 0 maps f0000000-f7ffffff (the device board),
/* cache disabled, read and write, ignore function codes */
uint tt0init = 0xf0078507;

/* transparent tranlation register 1 maps fc000000-ffffffff (hardware regs),
/* cache disabled, read and write, ignore function codes */
uint tt1init = 0xfc038507;

/* translation control register, CPU root pointer only, no function code enable,
/* use all 32 bits (no initial shift), 12 bits "segment" #, 8 bits page # */
uint tcinit = 0x80c0c800;

/*
** 4K (12 bits) segments, 1M each.  Use 8 byte desciptors -> 32K (8 pg) seg tbl.
** 256 (8 bits) pages per seg, 4K each. Use 4 byte descriptors -> 1K pg tbl.
**
** physical addr map
** 00000000-f0000000	css maps, 15 maps X 256 Meg
** f0000000-f8000000	device boards
** f8000000-fa000000	IOP ram 1 or 4 Meg, multiple images
**	~50K	IOP common
**	8 pg	segment table
**	1 pg	page table for first 4 Meg of MAINSTORE
**	1/4 pg	page table for IOP mem (1 pg for 4 M)
**	3/4 pg	page tables for misc (ptalloc) (1 pg for 4 M)
**	1 pg	own_stack
**	n pg	n stacks
**	m*x	m drivers
** fc000000-ffffffff	hardware registers
**
** virtual addr map
** 00000000-00100000	first 1 Meg driver space not used
** 00100000-a0000000	2559 1 Meg driver spaces, not mapped here
** a0000000-e0000000	mapped thru css maps to MAINSTORE
** e0000000-f0000000	IOP general purpose iomap
** f0000000-f8000000	device boards, mapped with transparent translation reg 0
** f8000000-f8400000	IOP memory mapped 1 to 1 (1 or 4 Meg)
** f8400000-f8800000	invalid, not used
** f8800000-f8c00000	IOP memory thru css map 13 (1 or 4 Meg)
** f9000000-f9001000	own_stack
** f9001000-fa000000	invalid, not used
** fa000000-fa0n0000	~10 4 K stacks alternated with invalid pages
** fa0n0000-fb000000	invalid, not used
** fb000000-fb100000	1M window into (user) css memory
** fb100000-fc000000	invalid, not used
** fc000000-ffffffff	hardware regs, mapped with transparent translation reg 1
** note: dma addresses to css bus are in the 0 to e0000000 range.
*/
uint iopend;		/* global end of used memory */

static int slot_to_map[16] = {-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1};

#define SPMMEM0      (*(struct spm_mem *)0)

mmuinit()
{
	struct mmutbl  *stblp;
	extern         end;
	uint           firstmem;

	iopend = (uint)&end;

	firstmem = setmaps();

	iopend = iopend + NBPP-1 & ~(NBPP-1);	/* round up to page boundary */
	stblp = (struct mmutbl *)iopend;

	/* "segment" table is 8 bytes * 4K entries. Page tables after seg tbl */

	crpinit[0] = 0x80000003;	/* lower limit=0, 8 byte tables */
	crpinit[1] = (uint)stblp;
	iopmcomm.stblp = (uint *)stblp;
	iopm_stbl(stblp, (uint *)(iopend + 0x8000));
	iomap_program(0, firstmem << U32TOADDR);
	mmuasm();			/* set tt0, tt1, crp, tc */

	iopmcomm.freemem = iopmcomm.memsize - (iopend - IOPM_RAM_START);

	return iopend;
}

/******************************************************************************/
setmaps()
{
	register uint  mapnum = 0;
	register uint  slot;
	uint           firstmem;
	void           iomap_init();

	iomap_init();
	for ( slot = 0; slot < SBUS_NUM_SLOT; slot++ )
		if ( SPMMEM0.sbus_slot_id[slot] == SBUS_MM )
		{
			if ( mapnum == 0 )
				firstmem = slot;
			else
				iomap_program(mapnum, slot << U32TOADDR);

			slot_to_map[slot] = mapnum++ << U32TOSLOT;
		}
		else
			slot_to_map[slot] = -1;

	if ( mapnum >= 13 )
		cmn_err(CE_PANIC,"Too many memory boards for IOPM to map.");

	/* set map 13 to point to this IOPM. This will be used for thrucss() */
	iomap_program(13, iopmcomm.slot);

	return firstmem;
}

/******************************************************************************/
#define SPMMEM0STBL  (uint)((struct spm_mem *)0)->iopm_stbl

ipde_t  *winptblp;

static
iopm_stbl(stblp, ptblp)
register struct mmutbl  *stblp;
uint                    *ptblp;
{
	register uint  va = 0;
	uint           *tblp;
	uint           sav_map;
	extern uint    numtcb_struct;
	extern uint    maxsysmem;
	ipde_t         *ptalloc();
	caddr_t        iomap();
	uint           iomap_save();

	iopend = (uint)ptblp;

	/* driver's space. 1M each (0-a0000000) */
	for ( ; va < MAINSTORE; va += SEG_SIZE )
	{
		stblp->limit = INVALIDTD;
		stblp++;
	}

	/* for the first "maxsysmem" bytes of main memory,
	/* copy the page tables into local memory */
	maxsysmem = min(maxsysmem, SPMMEM0.num_pages << PNUMSHFT);

	for ( va = MAINSTORE; va < MAINSTORE + maxsysmem; va += SEG_SIZE )
	{
		mk_css_ptbl(va, (uint *)iopend);
		stblp->limit = PTDESC;
		stblp->tblp = iopend;
		stblp++;
		iopend += NPDPPT*4;
	}

	/* for all the rest of main memory, use the page tables the SPM */
	/* set up in main memory */
	sav_map = iomap_save();
	tblp = (uint *)iomap(SPMMEM0STBL >> U32TOSLOT, SPMMEM0STBL << U32TOADDR)
	       + btoc(va - MAINSTORE) / NPDPPT;
	for ( ; va < MAINSTORE + (SPMMEM0.num_pages << PNUMSHFT);
	  va += SEG_SIZE )
	{
		stblp->limit = PTDESC;
		stblp->tblp = slot_to_map[*tblp >> U32TOSLOT] |
		              (*tblp << U32TOADDR);
		tblp++;
		stblp++;
	}
	iomap_restore(sav_map);

	for ( ; va < (uint)0xe0000000; va += SEG_SIZE )
	{
		stblp->limit = INVALIDTD;
		stblp++;
	}

	/* iomap uses map 14 (0xe0000000-0xf0000000) */
	for ( ; va < IOPM_DB_BASE; va += SEG_SIZE )
	{
		stblp->limit = EARLYTERM;	/* lower limit=0, early term */
		stblp->tblp = va;
		stblp++;
	}

	for ( ; va < IOPM_RAM_START; va += SEG_SIZE )
	{
		stblp->limit = INVALIDTD;
		stblp++;
	}

	/* iop memory mapping, early termination (f8000000-f8400000) */
	mk_iopm_ptbl((uint *)iopend);
	for ( ; va < IOPM_RAM_START + iopmcomm.memsize; va += SEG_SIZE )
	{
		stblp->limit = PTDESC;
		stblp->tblp = iopend;
		stblp++;
		iopend += NPDPPT*4;
	}

	ptbase = (ipde_t *)iopend;
	ASSERT( !((uint)ptbase & 0xf) );/* ptbase must be on 16 byte boundary */
	iopend = (uint)ptbase + NBPP & ~(NBPP - 1);

	for ( ; va < (uint)0xf8800000; va += SEG_SIZE )
	{
		stblp->limit = INVALIDTD;
		stblp++;
	}

	for ( ; va < (uint)0xf8800000 + iopmcomm.memsize; va += SEG_SIZE )
	{
		stblp->limit = EARLYTERM;
		stblp->tblp = va - 0x20800000;	/* set up map 13 -> slot|0f */
		stblp++;
	}

	for ( ; va < OWN_STACK; va += SEG_SIZE )
	{
		stblp->limit = INVALIDTD;
		stblp++;
	}

	stblp->limit = 0x0001fc01;
	stblp->tblp = iopend;
	stblp++;
	iopend += NBPP;
	va += SEG_SIZE;

	for ( ; va < TCBSTACKS; va += SEG_SIZE )
	{
		stblp->limit = INVALIDTD;
		stblp++;
	}

	stblp->limit = 0x0 | 2 * numtcb_struct << 16 | 0xfc02;
	stblp->tblp = (uint)ptalloc(2*numtcb_struct);
	if ( !stblp->tblp )
		cmn_err(CE_PANIC,"no page tables for stacks");
	mk_stk_pool((uint *)stblp->tblp);
	stblp++;
	va += SEG_SIZE;

	for ( ; va < PHYSIO_WINDOW; va += SEG_SIZE )
	{
		stblp->limit = INVALIDTD;
		stblp++;
	}

	winptblp = (ipde_t *)ptalloc(PWINSZ/NBPP);
	if ( !winptblp )
		cmn_err(CE_PANIC,"no page tables for window");
	stblp->limit = 0x0 | 0xfc01;
	stblp->tblp = (uint)winptblp;
	mk_win_ptbl((uint *)stblp->tblp);
	stblp++;
	va += SEG_SIZE;

	for ( ; va != 0x0; va += SEG_SIZE )
	{
		stblp->limit = INVALIDTD;
		stblp++;
	}
}

/******************************************************************************/
mk_css_ptbl(km, ptp)
uint  km;
uint  *ptp;
{
	extern uint     iomap_save();
	extern caddr_t  iomap();
	register        va = km;
	register sde_t  *st;
	register uint   *pt;
	uint            kptp;
	uint            savmap = iomap_save();

	st = (sde_t *)iomap(SPMMEM0STBL >> U32TOSLOT, SPMMEM0STBL << U32TOADDR);
	st += (btoc(km-MAINSTORE)/NPDPPT);
	kptp = *(uint *)st;
	pt = (uint *)iomap((uint)kptp >> U32TOSLOT, (uint)kptp << U32TOADDR);
	for ( ; va < km + SEG_SIZE; va += NBPP )
		*ptp++ = *pt++;
		
	iomap_restore(savmap);
}

/******************************************************************************/
/* Make alternating stack page, invalid page, stack page ...
/* Stacks that grow too large will crash the board, but it won't be a subtle
/* error!
*/
static
mk_stk_pool(ptp)
register uint  *ptp;
{
	register     va;
	extern uint  numtcb;
	extern uint  numtcb_struct;
	uint         tcb;

	/* first page tables for the standard stacks */

	for ( va = TCBSTACKS; va < TCBSTACKS + 2 * numtcb * NBPP;
	      va += 2 * NBPP )
	{
		*ptp++ = iopend | 0x1;		/* pde for stack */
		iopend += NBPP;
		*ptp++ = INVALIDTD;		/* pde for invalid page */
	}

	/* now, leave room for additional configured stacks */
	add_stack_ptp = ptp;		/* save for later */

	for ( tcb = numtcb; tcb != numtcb_struct; tcb++ )
	{
		*ptp++ = INVALIDTD;	/* invalid that may be changed later */
		*ptp++ = INVALIDTD;		/* pde for invalid page */
	}
}

/******************************************************************************/
/* Add additional stack page, invalid page, stack page ...
*/
add_stk_pool(pagenum, start_tcb, end_tcb)
uint  pagenum;
uint  start_tcb;
uint  end_tcb;
{
	register uint  *ptp = add_stack_ptp;
	extern uint    numtcb;
	extern uint    numtcb_struct;

	/* It is important that add_stack_ptp be used only be valid.
	 * Once used, it becomes invalid.
	 */
	add_stack_ptp = 0;
	ASSERT(ptp);

	ASSERT(start_tcb == numtcb);
	ASSERT(end_tcb <= numtcb_struct);
	for ( ; start_tcb != end_tcb; start_tcb++)
	{
		*ptp++ = pagenum++ * NBPP | 0x1;	/* pde for stack */
		*ptp++ = INVALIDTD;		/* pde for invalid page */
	}
	mflush();
}

/******************************************************************************/
static
mk_win_ptbl(ptp)
register uint  *ptp;
{
	register  va;

	for ( va = PHYSIO_WINDOW; va < PHYSIO_WINDOW + PWINSZ; va += NBPP )
		*ptp++ = INVALIDTD;		/* pde for invalid page */
}

/******************************************************************************/
static
mk_iopm_ptbl(ptblp)
uint  *ptblp;
{
	register va;

	for ( va = IOPM_RAM_START; va < iopend; va += NBPP )
		*ptblp++ = va | 1;	/* pg descipt */

	for ( ; va < IOPM_RAM_START + iopmcomm.memsize; va += NBPP )
#ifdef NOT_YET
		*ptblp++ = 0;	/* invalid */
#else
		*ptblp++ = va | 1;	/* tmp */
#endif
}

/******************************************************************************/

#if defined M68040

/* 
 * lpfn_to_spfn
 *
 * Convert from a linear page frame addr to an sbus (system) page frame addr.
 * Calculate which linear megabyte the lpfn points to.
 * This indexes into the kv_iomap, from which the spfn megabyte pointer is
 * extracted.
 * The spfn is the combination of the its megabyte pointer and the page
 * offset into that megabyte (from the lpfn).
 * Note : This works because lpfns over a megabyte range are guaranteed to
 * be contiguous on a slot (ie the spfn for each megabyte is contiguous).
 */
uint
lpfn_to_spfn(lpfn)
uint	lpfn;
{
	int	index = index_fm_lpfn(lpfn);
	uint	spfn = spfn_fm_kv_iomap(spm_mem.kv_iomap[index]);

	return(spfn | pg_fm_lpfn(lpfn));
}

static uint
lpfn_to_pfn(lpfn)
uint	lpfn;
{
	return spm_mem.lpfn_tbl[pg_fm_lpfn(lpfn) + (index_fm_lpfn(lpfn)*0x100)];
}

#else
/**
#define spfn_to_lpfn(spfn)  ((spfn)-spm_mem.pfn_adjust[(spfn)>>SpfnToSlotShft])
**/

static uint
spfn_to_lpfn(spfn)
register uint	spfn;
{
	register uint	sbus_slot;

	sbus_slot = spfn >> SpfnToSlotShft;
	ASSERT(spm_mem.sbus_slot_id[sbus_slot] == SBUS_MM);
	ASSERT(spfn << PNUMSHFT < spm_mem.slot_size[sbus_slot]);
	return spfn - spm_mem.pfn_adjust[sbus_slot];
}

/**
#define lpfn_to_pfn(lpfn)  (spm_mem.lpfn_tbl[lpfn])
**/
static uint
lpfn_to_pfn(lpfn)
uint	lpfn;
{
	ASSERT(lpfn < spm_mem.num_pages);
	return spm_mem.lpfn_tbl[lpfn];
}

/**
#define spfn_to_pfn(spfn)  (lpfn_to_pfn(spfn_to_lpfn(spfn)))
**/
static uint
spfn_to_pfn(spfn)
register uint	spfn;
{
	return lpfn_to_pfn(spfn_to_lpfn(spfn));
}
#endif

/******************************************************************************/
/* returns IOPM physical address.
** returns 0 if vaddr is not mapped.
** NOTE: the physical address of spm_mem.IOPM_sp (0xa0000000) is 0.
*/
caddr_t
vtop(vaddr, procp)
register caddr_t  vaddr;
proc_t            *procp;
{
	struct mmutbl  *stblp;
	uint           *ptblp;
	uint		spfn;
	uint		uv_to_spfn();
	uint		kv_to_spfn();
	caddr_t		spfn_map();

	if ( procp )
	{
		ASSERT(valid_pm_addr(procp));

		spfn = uv_to_spfn((uint)vaddr, procp);
		return spfn_map(spfn, poff(vaddr));
	}

	/* device board mapped using transparent tranlation register 0 */
	if ( vaddr >= (caddr_t)IOPM_DB_BASE && vaddr < (caddr_t)IOPM_RAM_START )
		return vaddr;

	/* hardware registers mapped using transparent tranlation register 0 */
	if ( vaddr >= (caddr_t)0xfc000000  && vaddr <= (caddr_t)0xffffffff )
		return vaddr;

	if ( vaddr >= (caddr_t) ADDR_SYS_SEGS &&
	  vaddr < (caddr_t) ADDR_MEM_SEGS ) {
		spfn = kv_to_spfn((uint)vaddr);
		return spfn_map(spfn, poff(vaddr));
	}

	stblp = (struct mmutbl *)crpinit[1] + ((uint)vaddr >> SEG_SHFT);

	if ( (stblp->limit & DTMASK) == PGDESC )
		return (caddr_t)((stblp->tblp & PAMASK) +
		                 ((uint)vaddr & SEG_SIZE-1));

	if ( (stblp->limit & DTMASK) == PTDESC4 )
	{
		ptblp = (uint *)(stblp->tblp & 0xfffffff0) +
		        (((uint)vaddr >> PNUMSHFT) & (NPDPPT - 1));
		if ( valid_iopm_addr((uint)ptblp) )
			return (caddr_t)((*ptblp & ~POFFMASK) + poff(vaddr));
		else
		{
			uint     savmap = iomap_save();
			caddr_t  physaddr;
			uint     memslot;

			memslot = (*(uchar *)(MAP_BASE_REG +
			                  4 * ((uint)ptblp >> U32TOSLOT)) >> 4);
			ASSERT(spm_mem.sbus_slot_id[memslot] == SBUS_MM);
			ptblp = (uint *)iomap(memslot, (uint)ptblp&0x0fffffff);
			physaddr = (caddr_t)((*ptblp&~POFFMASK) + poff(vaddr));
			iomap_restore(savmap);
			return physaddr;
		}
	}

	return 0;
}

/******************************************************************************/
#if defined M68040
static uint
rde_to_km(rde)
rde_t	rde;
{
	register uint km;

	/* compute virtual addr of page of the table */
	km = pfn_to_km(lpfn_to_pfn(rde.rde_all >> LPFN_XDE_SHFT));

	    /* add in the table offset */
	return km +
	       ((rde.rde.fn & ((1 << (PNUMSHFT - BQTSHFT)) - 1)) << BQTSHFT);

}

static uint
sde_to_km(sde)
sde_t	sde;
{
	register uint km;

	/* compute virtual addr of page of the table */
	km = pfn_to_km(lpfn_to_pfn(sde.sde_all >> LPFN_XDE_SHFT));

	    /* add in the table offset */
	return km +
	       ((sde.sde.fn & ((1 << (PNUMSHFT - BPTSHFT)) - 1)) << BPTSHFT);

}

static uint
qde_to_km(qde)
qde_t	qde;
{
	register uint km;

	/* compute virtual addr of page of the table */
	km = pfn_to_km(lpfn_to_pfn(qde.qde_all >> LPFN_XDE_SHFT));

	    /* add in the table offset */
	return km +
	       ((qde.qde.fn & ((1 << (PNUMSHFT - BSTSHFT)) - 1)) << BSTSHFT);

}

#else
static uint
rde_to_km(rde)
rde_t	rde;
{
	/* WARNING: This code assumes that rfn and pfn are the same thing */
	return spfn_to_pfn(rde.rdm.rde_rfn) << PNUMSHFT;
}

static uint
sde_to_km(sde)
sde_t  sde;
{
	uint  ssfn;
	uint  vsfn;

	ssfn = sde.sgm.sg_sfn;

	vsfn = spfn_to_pfn(ssfn >> NPTPPSHFT) << NPTPPSHFT;
	vsfn += ssfn & ((1 << NPTPPSHFT) - 1);
	return vsfn << BPTSHFT;
}
#endif

#if defined M68040

static uint
uv_to_spfn(vaddr, p)
register uint  vaddr;
proc_t         *p;
{
	union {
		rde_t  *rde_p;
		qde_t  *qde_p;
		sde_t  *sde_p;
		pde_t  *pde_p;
	} xptr;

	xde_t  xde;

	ASSERT(UMEM_START == KUMEM_START);
	ASSERT(UMEM_SIZE == KUMEM_SIZE);
	ASSERT(UMEM_START == 0);
	ASSERT(vaddr < (UMEM_START + (ulong)UMEM_SIZE));
	ASSERT(valid_pm_addr(p));

	/*
	** assumes that pagetable pointers are at the lowest level (pde).
	** so does not support indirect mappings.
	*/
	/* compute Ssegment table address from root pointer */
	xptr.qde_p = (qde_t *)rde_to_km(p->p_urde);
	ASSERT(valid_pm_addr(xptr.qde_p));
	xde.qde.qde_all = xptr.qde_p[qnum(vaddr)].qde_all;
	ASSERT(xde.qde.qde.udt != UDT_INVALID);

	/* compute segment table address from Ssegment pointer */
	xptr.sde_p = (sde_t *)qde_to_km(xde.qde);
	ASSERT(valid_pm_addr(xptr.sde_p));
	xde.sde.sde_all = xptr.sde_p[snum(qoff(vaddr))].sde_all;
	ASSERT(xde.sde.sde.udt != UDT_INVALID);

	/* compute page table address from segment pointer */
	xptr.pde_p = (pde_t *)sde_to_km(xde.sde);
	ASSERT(valid_pm_addr(xptr.pde_p));

	/* Return the address of the pagetable entry */
	return lpfn_to_spfn(xptr.pde_p[pnum(soff(vaddr))].pde.fn);
}

static uint
kv_to_spfn(vaddr)
register uint  vaddr;
{
	ASSERT(vaddr >= ADDR_SYS_SEGS);
	ASSERT(pnum(vaddr - ADDR_SYS_SEGS) < spm_mem.kv_size);
	ASSERT(valid_pm_addr(spm_mem.kptbl));

	return lpfn_to_spfn(spm_mem.kptbl[pnum(vaddr - ADDR_SYS_SEGS)].pde.fn);
}
#else

static uint
uv_to_spfn(vaddr, p)
register uint  vaddr;
proc_t         *p;
{
	register sde_t  *sde_ptr;
	register pde_t  *pde_ptr;
	sde_t           ppt;

	ASSERT(vaddr < (UMEM_START + (ulong)UMEM_SIZE));
	ASSERT(valid_pm_addr(p));
	sde_ptr= (sde_t *)rde_to_km(p->p_urde);
	ASSERT(valid_pm_addr(sde_ptr));
	ppt = sde_ptr[snum(vaddr)];
	ASSERT(ppt.sg_sge != spm_mem.invalid_sde.sg_sge);

	pde_ptr = (pde_t *) sde_to_km(ppt);
	ASSERT(valid_pm_addr(pde_ptr));
	return pde_ptr[pnum(soff(vaddr))].pgm.pg_pfn;
}

static uint
kv_to_spfn(vaddr)
register uint  vaddr;
{
	ASSERT(vaddr >= ADDR_SYS_SEGS);
	ASSERT(pnum(vaddr - ADDR_SYS_SEGS) < spm_mem.kv_size);
	ASSERT(valid_pm_addr(spm_mem.kptbl));

	return spm_mem.kptbl[pnum(vaddr - ADDR_SYS_SEGS)].pgm.pg_pfn;
}
#endif	/* M68040 */

/******************************************************************************/
/*
 * vmap
 *
 *	return a virtual address through which p's vaddr
 *	can be accessed.
 *
 *	a NULL p indicates IOPM physical address
 *
 *	the map is valid up to the next page boundary.
 *
 *	this map is NOT VALID across a context switch
 *
 */

caddr_t
vmap(vaddr, p)
caddr_t  vaddr;
proc_t   *p;
{
	register uint  *pde_p;

	/* get address of IOPM seg table for PHYSIO_WINDOW */
	pde_p = &((struct mmutbl *)crpinit[1])[PHYSIO_WINDOW >> SEG_SHFT].tblp;

	/* Fill in IOPM seg table. This desc is an 'early termination' so */
	/* it is really a page desc. */
	*pde_p = (uint)vtop(vaddr, p) & ~POFFMASK;

	mflush();

	return (caddr_t)(PHYSIO_WINDOW | poff(vaddr));
}


uint
vmap_save()
{
	return ((struct mmutbl *)crpinit[1])[PHYSIO_WINDOW >> SEG_SHFT].tblp;
}

vmap_restore(savpde)
uint  savpde;
{
	((struct mmutbl *)crpinit[1])[PHYSIO_WINDOW >> SEG_SHFT].tblp = savpde;
	mflush();
}

/******************************************************************************/
setmmu(physaddr, vaddr, size)
uint  physaddr;
uint  vaddr;
uint  size;				/* in pages */
{
	uint           *tbl;
	uint           i;
	struct mmutbl  *stblp;
	extern uint    malloc();
	ipde_t         *ptalloc();

	if ( !vaddr )
		cmn_err(CE_PANIC,
		  "Driver loading at virtual address 0 not allowed.");

	stblp = (struct mmutbl *)crpinit[1] + (vaddr >> SEG_SHFT);

	PRINT3(CONFIG, "setmmu: paddr %x, vaddr %x, size %x\n",
	  physaddr, vaddr, size << PNUMSHFT);

#if !defined OVERLAY
	if ( (stblp->limit & DTMASK) != INVALID )
		return 0;
#endif
	physaddr &= ~(NBPP-1);
	if ( !(tbl = (uint *)ptalloc(size)) )
		cmn_err(CE_PANIC, "No page tables for driver.");

	for ( i = 0; i < size; i++ )
	{
		*(tbl+i) = physaddr | 1;
		physaddr += NBPP;
	}

	stblp->limit = SHORTPT | (i<<16);
	stblp->tblp = (uint)tbl;
	mflush();

	return 1;
}

/******************************************************************************/
/* NOTE that lastpdp assumes that the page table region is thru the end of the
/* page it starts on.
*/
ipde_t *
ptalloc(numpgs)
uint  numpgs;
{
	ipde_t  *pdp;		/* page descriptor pointer */
	ipde_t  *pdstart;
	ipde_t  *lastpdp = (ipde_t *)((uint)ptbase + NBPP & ~(NBPP -1));

	/* page table must start on 16 byte boundaries */
	for ( pdp = ptbase; pdp < lastpdp - numpgs; pdp += 4 )
	{
		if ( pdp->pgi.pg_pde == 0 )
		{
			pdstart = pdp;
			for ( ; pdp < pdstart + numpgs; pdp++ )
				if ( pdp->pgi.pg_pde != 0 )
					break;

			if ( pdp == pdstart + numpgs )
				return pdstart;
		}
	}

	return 0;
}
