/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) kstream.c: version 25.1 created on 11/27/91 at 14:48:35	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)kstream.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/param.h"
#include "sys/debug.h"
#include "sys/stream.h"
#include "sys/stropts.h"
#include "sys/strstat.h"
#include "sys/spm_mem.h"
#include "stream.h"		/* before iopmstream */
#include "sys/iopmstream.h"
#include "sys/sbus_iopm.h"
#include "sys/iopmdebug.h"
#include "sys/iopmstat.h"

/* NO zeros */
static uint    kdblk_want_init[NCLASS] = {5, 5, 5, 5, 5, 5, 4, 3, 2};

struct k_blk_cache {
	dblk_t  *kdblk_head[NCLASS];	/* head of local dblk cache */
	uint    kdblk_want[NCLASS];	/* # dblks in each class to keep */
	uint    kdblk_cnt[NCLASS];	/* number of dblk's in local cache */
	uint    kdblk_time[NCLASS];	/* time of last req for this sz dblk */
	mblk_t  *kmblk_head;		/* head of local mblk cache */
	uint    kmblk_cnt;		/* diag only */
	uint    kmblk_extra;		/* # of cached mblks > # cached dblks */
} kblk;

#define AGETIME 10		/* 10 secs between flush old dblks */

/* statistics */
struct kbstat  kbstat;

/* these structures are in spm_mem and defined in ml/build.c */
extern char             kqrunflag;
extern char             kstrbcflag;/* kernel bufcall functions ready to go */
extern dizzy_lock_t     kallocb_lock;
extern struct msgb      *kmbfreelist;
extern dblk_t           *kdbfreelist[];
extern struct dbalcst   kdballoc[];
extern struct strstat   kstrst;
extern uint             local_lbolt;

/******************************************************************************/
kcacheb_init()
{
	register struct k_blk_cache  *kblkp = &kblk;
	register int                 class;
	extern                       flush_old_kb();

	for ( class = 0; class < NCLASS; class++ )
		kblkp->kdblk_want[class] = kdblk_want_init[class];

	timeout(flush_old_kb, 0, AGETIME * HZ);
}

/******************************************************************************/
/* This routine can get away with no spl since it is only run from copy_rsrv,
/* a service routine which cannot preempt itself. kfreeb is also run from a
/* service routine and flush_old_kb is a timeout routine, intr level 1, the
/* same intr level as service routines.
*/
mblk_t *
kallocb(size, pri)
uint  size;
uint  pri;
{
	register struct k_blk_cache  *kblkp = &kblk;
	register dblk_t  *dblkp = 0;
	register mblk_t  *mblkp;
	register uint    trys;
	register         class;
	int              orig_class;
	extern dblk_t    *kfillb();

	if ( (orig_class = class = getclass(size)) >= NCLASS )
		return NULL;

	kbstat.kab[class].called++;

	/* try to get a dblk & mblk from the local cache. */
	/* if we fail to get a dblk, try the next size dblk. */
	for ( trys = 0; trys < ALLOCB_TRIES; trys++, class++ )
	{
		kblkp->kdblk_time[class] = local_lbolt;

		/* try to get dblk from local cache */
		if ( dblkp = kblkp->kdblk_head[class] )
		{
			kbstat.kab[orig_class].cachit[trys]++;
			break;			/* got it */
		}

		if ( class == NCLASS - 1 )
			break;
	}

	if ( !dblkp && !(dblkp = kfillb(orig_class, pri)) )
		return NULL;

	ASSERT(valid_pm_addr((uint)dblkp));
	ASSERT(dblkp->db_ref == 0);
	class = dblkp->db_class;
	ASSERT(dblkp == kblkp->kdblk_head[class]);

	/* remove dblk from local cache */
	kblkp->kdblk_head[class] = dblkp->db_freep;
	dblkp->db_freep = NULL;
	kblkp->kdblk_cnt[class]--;

	/* remove mblk from local cache */
	ASSERT(valid_pm_addr((uint)kblkp->kmblk_head));
	mblkp = kblkp->kmblk_head;
	kblkp->kmblk_head = mblkp->b_next;
	kblkp->kmblk_cnt--;
	ASSERT(mblk_cnt_ok());

	/* initialize dblk and mblk */
	mblkp->b_next = NULL;
	mblkp->b_prev = NULL;
	mblkp->b_cont = NULL;
	mblkp->b_datap = dblkp;
	mblkp->b_rptr = dblkp->db_base;
	mblkp->b_wptr = dblkp->db_base;
	dblkp->db_ref = 1;
	dblkp->db_type = M_DATA;

	return mblkp;
}

/******************************************************************************/
dblk_t *
kfillb(class, pri)
register uint  class;
uint           pri;
{
	register struct k_blk_cache  *kblkp = &kblk;
	register uint  want = kblkp->kdblk_want[class];
	dblk_t         *dblkp = 0;
	extern uint    kfill_mblks();
	extern dblk_t  *kfill_dblks();

	/* protect kdbfreelist & kmbfreelist & dba_cnt test vs dba_cnt++ */
	/* also protect kstrst.dblock, .dblk & .mblk */
	dizzy_lock(&kallocb_lock);

	ASSERT(want);
	if ( want = kfill_mblks(want) )
		dblkp = kfill_dblks(class, pri, want);

	dizzy_unlock(&kallocb_lock);

	return dblkp;
}

/******************************************************************************/
#define NBUMPUP(X, N)	{X.use += (N);  X.total += (N);\
			 X.max = (X.use > X.max ? X.use : X.max); }

uint
kfill_mblks(want)
register uint  want;
{
	register struct k_blk_cache  *kblkp = &kblk;
	register uint    cnt;
	register mblk_t  *mblkp;
	register mblk_t  *lastmp;

	ASSERT(want);
	ASSERT(mblk_cnt_ok());
	if ( want <= kblkp->kmblk_extra )
		return want;	/* if we already have enuf, don't get more */

	want -= kblkp->kmblk_extra;

	if ( !(mblkp = kmbfreelist) )
	{
		PRINT(SRESRC, "kfill_mblks: no kernel mblks\n");
		return kblkp->kmblk_extra;
	}

	cnt = want - 1;			/* # to get (for loop assumes 1 got) */
	ASSERT(valid_pm_addr((uint)mblkp));
	for ( lastmp = mblkp; cnt && lastmp->b_next; cnt-- )
	{
		lastmp = lastmp->b_next;
		ASSERT(valid_pm_addr((uint)lastmp));
	}

	if ( cnt )			/* didn't get all we wanted */
	{
		kstrst.mblock.fail++;
		want -= cnt;
	}

	/* take mblks off kernel freelist (mblkp aready set to kmbfreelist) */
	kmbfreelist = lastmp->b_next;
	NBUMPUP(kstrst.mblock, want);

	/* add mblks to local mblk cache */
	lastmp->b_next = kblkp->kmblk_head;
	kblkp->kmblk_head = mblkp;
	kblkp->kmblk_cnt += want;
	kblkp->kmblk_extra += want;
	ASSERT(mblk_cnt_ok());

	return want;
}

/******************************************************************************/
#define kbcmax(class, pri) ((pri) == BPRI_LO ? dbp->dba_lo : \
                           ((pri) == BPRI_HI ? spm_mem.nmblock : dbp->dba_med))

dblk_t *
kfill_dblks(class, pri, want)
register uint  class;
register uint  want;
{
	register struct k_blk_cache  *kblkp = &kblk;
	register uint            trys;
	register uint            cnt;
	register dblk_t          *dblkp;
	register dblk_t          *lastdp;
	register struct dbalcst  *dbp;

	ASSERT(want);
	ASSERT(kblkp->kmblk_extra >= want);
	for ( trys = 0; ; class++ )
	{
		ASSERT(kblkp->kdblk_cnt[class] == 0);

		dbp = &kdballoc[class];

		if ( kbcmax(class, pri) > dbp->dba_cnt &&
		     (dblkp = kdbfreelist[class]) )
			break;		/* there's some dblk's here */

		kstrst.dblk[class].fail++;
		kstrst.dblock.fail++;
		if ( class == NCLASS - 1 || ++trys == ALLOCB_TRIES )
		{
			PRINT(SRESRC, "kfill_dblks: no kernel dblks\n");
			return NULL;
		}
	}

	kbstat.kab[class - trys].fill[trys]++;

	/* We know there's 1 at 'pri'. Are there more at BPRI_LO? */
	if ( kbcmax(class, BPRI_LO) < dbp->dba_cnt + want )
		if ( kbcmax(class, BPRI_LO) <= dbp->dba_cnt )
			want = 1;
		else
			want = kbcmax(class, BPRI_LO) - dbp->dba_cnt;

	cnt = want - 1;			/* for loop assumes we got 1 */
	ASSERT(valid_pm_addr((uint)dblkp));
	for ( lastdp = dblkp; cnt; cnt-- )
	{
		lastdp = lastdp->db_freep;
		ASSERT(valid_pm_addr((uint)lastdp));
	}

	/* take dblks off kernel free list (dblkp already set to kdbfreelist) */
	kdbfreelist[class] = lastdp->db_freep;
	dbp->dba_cnt += want;
	NBUMPUP(kstrst.dblock, want);
	NBUMPUP(kstrst.dblk[class], want);

	/* add dblks to local cache */
	lastdp->db_freep = kblkp->kdblk_head[class];
	kblkp->kdblk_head[class] = dblkp;
	kblkp->kdblk_cnt[class] += want;
	kblkp->kmblk_extra -= want;
	ASSERT(mblk_cnt_ok());

	return dblkp;
}

/******************************************************************************/
kfreeb(mblkp)
register mblk_t *mblkp;
{
	register struct k_blk_cache  *kblkp = &kblk;
	register dblk_t          *dblkp;
	register                 class;
	register struct dbalcst  *dbp;
	register int             want = -1;

	ASSERT(valid_pm_addr((uint)mblkp));
	dblkp = mblkp->b_datap;
	ASSERT(dblkp->db_ref > 0);

	class = dblkp->db_class;
	kbstat.kfb[class].called++;
	mblkp->b_datap = NULL;

	/* return mblk to local cache */
	mblkp->b_next = kblkp->kmblk_head;
	kblkp->kmblk_head = mblkp;
	kblkp->kmblk_cnt++;

	if ( dblkp->db_ref == 1 )
	{
		/* return dblk to local cache */
		dblkp->db_ref = 0;
		dblkp->db_freep = kblkp->kdblk_head[class];
		kblkp->kdblk_head[class] = dblkp;
		dblkp = 0;
		kblkp->kdblk_cnt[class]++;
	}
	else
		kblkp->kmblk_extra++;

	ASSERT(mblk_cnt_ok());
	/* calc min dblk to free. note assending order. note kdblk_want >= 1 */
	/* dblk not already freed to local dblk cache */
	if ( dblkp )
		want = 0;

	/* kernel is running lo */
	dbp = &kdballoc[class];
	if ( dbp->dba_cnt >= dbp->dba_lo )
		want = 1;

	/* too many dblks in local dblk cache */
	if ( kblkp->kdblk_cnt[class] >= 2 * kblkp->kdblk_want[class] )
		want = kblkp->kdblk_cnt[class] - kblkp->kdblk_want[class];

	if ( want >= 0 )
		kflushb(dblkp, class, (uint)want);
}

/******************************************************************************/
#define K_STR_SCHED(X) (!kstrbcflag && ( X->dba_hip || \
                        (X->dba_medp && (X->dba_cnt < X->dba_med)) || \
                        (X->dba_lop && (X->dba_cnt < X->dba_lo))))

kflushb(dblkp, class, want)
register dblk_t  *dblkp;
register         class;
uint             want;
{
	register struct k_blk_cache  *kblkp = &kblk;
	register struct dbalcst  *dbp = &kdballoc[class];

	kbstat.kfb[class].flush++;

	/* protect kdbfreelist & kmbfreelist */
	dizzy_lock(&kallocb_lock);

	if ( dblkp && --dblkp->db_ref == 0 )
	{
		/* return dblk to local cache */
		ASSERT(valid_pm_addr((uint)dblkp));
		ASSERT(dblkp->db_class == class);
		dblkp->db_freep = kblkp->kdblk_head[class];
		kblkp->kdblk_head[class] = dblkp;
		dblkp = 0;
		kblkp->kdblk_cnt[class]++;
		kblkp->kmblk_extra--;
	}

	if ( want == 0 || kblkp->kdblk_cnt[class] == 0 )
	{
		dizzy_unlock(&kallocb_lock);
		return;
	}

	kflush_dblk(class, want);

	kflush_mblk();

	dizzy_unlock(&kallocb_lock);

	if ( K_STR_SCHED(dbp) )
	{
		kqrunflag = 1;
		kstrbcflag = 1;
	}			
}

/******************************************************************************/
kfreemsg(bp)
register mblk_t *bp;
{
	register mblk_t  *tp;

	while ( bp )
	{
		tp = bp->b_cont;
		kfreeb(bp);
		bp = tp;
	}
}

/******************************************************************************/
flush_old_kb()
{
	register struct k_blk_cache  *kblkp = &kblk;
	register uint  class;
	extern         flush_old_kb();

	for ( class = 0; class < NCLASS; class++ )
	{
		if ( kblkp->kdblk_head[class] &&
		     local_lbolt - kblkp->kdblk_time[class] > AGETIME * HZ )
		{
			kbstat.flush_old_kdb[class]++;

			/* reset time for this class. msg dribble off slowly */
			kblkp->kdblk_time[class] = local_lbolt;

			dizzy_lock(&kallocb_lock);
			kflush_dblk(class, 1);
			kflush_mblk();
			dizzy_unlock(&kallocb_lock);
		}
	}

	timeout(flush_old_kb, 0, AGETIME * HZ);
}

/******************************************************************************/
kflush_dblk(class, want)
register uint  want;
{
	register struct k_blk_cache  *kblkp = &kblk;
	register uint    cnt;
	register dblk_t  *dblkp;
	register dblk_t  *lastdp;

	ASSERT(class < NCLASS);
	ASSERT(want);
	ASSERT(kblkp->kdblk_cnt[class] >= want);
	cnt = want - 1;
	ASSERT(valid_pm_addr((uint)kblkp->kdblk_head[class]));
	for ( lastdp = kblkp->kdblk_head[class]; cnt; cnt-- )
	{
		lastdp = lastdp->db_freep;
		ASSERT(valid_pm_addr((uint)lastdp));
	}

	/* take dblk off local cache */
	dblkp = kblkp->kdblk_head[class];
	kblkp->kdblk_head[class] = lastdp->db_freep;
	kblkp->kdblk_cnt[class] -= want;
	kblkp->kmblk_extra += want;
	ASSERT(mblk_cnt_ok());

	/* return dblks to kernel freelist */
	lastdp->db_freep = kdbfreelist[class];
	kdbfreelist[class] = dblkp;
	kdballoc[class].dba_cnt -= want;
	kstrst.dblock.use -= want;
	kstrst.dblk[class].use -= want;
}

/******************************************************************************/
kflush_mblk()
{
	register struct k_blk_cache  *kblkp = &kblk;
	register uint    cnt;
	register mblk_t  *mblkp;
	register mblk_t  *lastmp;

	ASSERT(kblkp->kmblk_extra);
	ASSERT(mblk_cnt_ok());
	cnt = kblkp->kmblk_extra - 1;
	ASSERT(valid_pm_addr((uint)kblkp->kmblk_head));
	ASSERT(kblkp->kmblk_head->b_datap == NULL);
	for ( lastmp = kblkp->kmblk_head; cnt; cnt-- )
	{
		lastmp = lastmp->b_next;
		ASSERT(valid_pm_addr((uint)lastmp));
		ASSERT(lastmp->b_datap == NULL);
	}

	/* take mblk off local cache */
	mblkp = kblkp->kmblk_head;
	kblkp->kmblk_head = lastmp->b_next;
	kblkp->kmblk_cnt -= kblkp->kmblk_extra;

	/* return mblk to kernel freelist */
	lastmp->b_next = kmbfreelist;
	kmbfreelist = mblkp;
	kstrst.mblock.use -= kblkp->kmblk_extra;

	kblkp->kmblk_extra = 0;
	ASSERT(mblk_cnt_ok());
}

/******************************************************************************/
/*
 * Empty a queue.  
 * If flag is set, remove all messages.  Otherwise, remove
 * only non-control messages.  If queue falls below its low
 * water mark, and QWANTW was set before the flush, enable
 * the nearest upstream service procedure.
 */
kflushq(q, flag)
register iqueue_t *q;
{
	register mblk_t *bp, *nbp;
	register s;
	int wantw;

	ASSERT(valid_queue(q));

	s = splstr();

	wantw = q->q_flag & QWANTW;

	bp = q->q_first;
	q->q_first = NULL;
	q->q_last = NULL;
	q->q_count = 0;
	q->q_flag &= ~(QFULL|QWANTW);
	splx(s);
	while ( bp )
	{
		nbp = bp->b_next;
		bp->b_next = 0;
		if ( !flag && bp->b_datap->db_type == M_WFLOW )
		{
			ASSERT(valid_iopmctl((struct iopm_ctl *)RD(q)->q_ptr));
			set_list_avail(q);
			bp->b_prev = (mblk_t *)RD(q)->q_ptr;
			sendmptokernel(bp);
		}
		else
			kfreemsg(bp);

		bp = nbp;
	}

	s = splstr();
	if ( wantw )
	{
		/* find nearest back queue with service proc */
		for ( q = backq(q); q && !q->q_qinfo->qi_srvp; q = backq(q) );
		if ( q )
			qenable(q);
	}
	splx(s);
}

/******************************************************************************/
mblk_t *
rev_kmp_chain(headp)
mblk_t  *headp;
{
	register mblk_t  *mp = headp;
	register mblk_t  *lastp = 0;
	register mblk_t  *savforw;

	ASSERT(valid_pm_mblk(mp));
	ASSERT(valid_pm_mblk(mp->b_next));

	do
	{
		ASSERT(valid_pm_mblk(mp));
		savforw = mp->b_next;
		mp->b_next = lastp;
		lastp = mp;
		mp = savforw;
	} while ( mp );

	return lastp;
}

/******************************************************************************/
mblk_cnt_ok()
{
	register struct k_blk_cache  *kblkp = &kblk;
	register uint  class;
	register uint  sum = 0;

	for ( class = 0; class < NCLASS; class++ )
		sum += kblkp->kdblk_cnt[class];

	return kblkp->kmblk_cnt - kblkp->kmblk_extra == sum;
}
