/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iomap.c: version 25.1 created on 11/27/91 at 14:48:30	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iomap.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/param.h"
#include "sys/types.h"
#include "sys/sbus_iopm.h"
#include "sys/debug.h"
#include "sys/sbus.h"
#include "sys/spm_mem.h"

#define	UintBits	32	/* number of bits in a uint */

/* How mapper works on addresses */ 
#define	UnmappedBits	28	/* lower 28 bits don't get mapped */
#define	MapInBits	 4	/* next 4 bits get mapped */
#define	MapOutBits	 8	/* to 8 bits */
/* a iopm system slot is a byte, the upper nibble is the css slot, the */
/* lower nibble is an expansion slot. If the lower nibble is 'f' */
/* the upper nibble is the css slot of the card in question. If the lower */
/* nibble is not 'f', it is the slot in an expansion chassis. The upper */
/* nibble is then the slot of the IOM tied to that expansion chassis. */ 
#define CssShft		 4	/* bits to shft system_slot to css slot */
#define ExpMask		0xf	/* mask for expansion slot in system_slot */

#define IO_MAPPER(mapnum)  *(char *)((uint *)MAP_BASE_REG + (mapnum))
#define	IO_SPACE	((unsigned char *)0)	/* mapped region */

#define	REG_MAPS	13	/* number of regular maps */
#define	LoopMap		13	/* map that loops back to this IOPM */
#define	MyMap		14	/* map that iomap uses */
#define	BAD_MAP		15	/* invalid map number */

#define	LowBits(nbits, value)	((value) & ((1 << (nbits)) - 1))
#define	HighBits(nbits, value)	((value) >> (nbits))

static uchar	unmap_tbl[1 << MapOutBits]; /* convert map value to mapnum */

/******************************************************************************/
/*
 * iomap -- temporary map of system bus area
 *
 * WARNING: iomap programs a single mapping register.
 *	iomap_save and iomap_restore must be used.
 *
 *	Typical use:
 *
 *	uint xxx = iomap_save();
 *
 *	abc_reg = iomap(slot, offset);
 *	printf("abc_reg contains\n", *abc_reg);
 *
 *	iomap_restore(xxx);
 */


caddr_t
iomap(sbus_slot, addr)
uint	sbus_slot;
uint	addr;
{
	register uint	low_part, high_part;

	low_part = LowBits(UnmappedBits, addr);
	high_part = HighBits(UnmappedBits, addr);
	high_part |= (sbus_slot << (UintBits - UnmappedBits));

	/*
	 * high_part now contains the upper part of the combined address
	 * low_part now contains the lower part of the combined address
	 */

	IO_MAPPER(MyMap) = high_part;
	return (caddr_t)(IO_SPACE + (MyMap << UnmappedBits) + low_part);
}

/******************************************************************************/
/*
 * iomap_save -- return current map value
 */

uint
iomap_save()
{
	return IO_MAPPER(MyMap);
}

/******************************************************************************/
/*
 * iomap_restore -- restore value returned from earlier call to iomap_save 
 */

iomap_restore(value)
uint	value;
{
	IO_MAPPER(MyMap) = value;
}





/******************************************************************************/
/*
 * spfn_map -- given sbus page num and offset, return IOPM physical address
 * This only works if the required map has already been programmed
 */

caddr_t
spfn_map(spfn, offset)
uint	spfn;
uint	offset;
{
	uint	mapnum;

	mapnum = unmap_tbl[HighBits(UnmappedBits - BPCSHIFT, spfn)];
	ASSERT(mapnum != BAD_MAP);

	offset += LowBits(UnmappedBits - BPCSHIFT, spfn) << BPCSHIFT;
	return((caddr_t)(IO_SPACE + (mapnum << UnmappedBits) + offset));
}

/******************************************************************************/
/*
 * iomap_program -- change value of map register
 * FIX MSS, this function should be replaced by higher level functions
 */

void
iomap_program(mapnum, value)
uint	mapnum;
uint	value;
{
	ASSERT(unmap_tbl[value] == BAD_MAP);	/* no aliasing */
	unmap_tbl[value] = mapnum;

	IO_MAPPER(mapnum) = value;
}

/******************************************************************************/
/*
 * iomap_init -- establish initial map conditions
 * FIX MSS, this routine should be expanded
 */

void
iomap_init()
{
	uint	mapval;
	uint	mapnum;

	for (mapval = 0; mapval != (1 << MapOutBits); mapval++)
		unmap_tbl[mapval] = BAD_MAP;
	for (mapnum = 1; mapnum != REG_MAPS; mapnum++)
		IO_MAPPER(mapnum) = 0xf8;
		/* The hope is that 0xf8 will point to something invalid */
		/* FIX MSS, we can do better at finding something invalid */
}

/******************************************************************************/
/*
 * Temporarily map CSS expansion chassis address space.
 *
 * same usage, same warnings as iomap
 */
caddr_t
iosba_map(system_slot, offset)
uint  system_slot;
uint  offset;
{
uint sbus_slot = system_slot >> CssShft;
uint expansion_slot = system_slot & ExpMask;

	ASSERT(system_slot_ok(system_slot));

	return iomap(sbus_slot,
	  expansion_slot << UnmappedBits | LowBits(UnmappedBits, offset));
}

/******************************************************************************/
system_slot_ok(system_slot)
uint  system_slot;
{
	if ( system_slot >> CssShft >= SBUS_NUM_SLOT )
		return 0;

	if ( (system_slot & ExpMask) != SBUS_NUM_SLOT - 1 &&
	     spm_mem.sbus_slot_id[system_slot >> CssShft] != SBUS_NIOM )
		return 0;

	if ( (system_slot & ExpMask) >= SBUS_NUM_SLOT )
		return 0;

	return 1;
}

map_to_slot(map)
uint  map;
{
	return IO_MAPPER(map);
}
