/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) css.c: version 25.1 created on 11/27/91 at 14:48:26	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)css.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/iopmbuf.h"
#include "sys/kmem.h"
#include "sys/iopmcomm.h"
#include "tcb.h"
#include "buf.h"
#include "sys/sbus_pm.h"
#include "sys/spm_mem.h"
#include "sys/iopmdebug.h"
#include "sys/ints.h"
#include "sys/debug.h"
#include "sys/buf.h"
#include "sys/iopmstat.h"

disp_int_t  pm_buf_intr;	/* interrupt vector, etc */
disp_int_t  pm_str_intr;

struct intrstat  intrstat;

/******************************************************************************/
init_intr_info()
{
	pm_buf_intr.fields.vector = IOPM_BUF_INTR;
	pm_buf_intr.fields.level = MOT_LEVEL_TWO;
	pm_buf_intr.fields.directed = NON_DIRECTED;
	pm_buf_intr.fields.src_slot = iopmcomm.slot >> 4;
	pm_buf_intr.fields.io_slot = iopmcomm.slot & 0xf;

	pm_str_intr.fields.vector = IOPM_STR_INTR;
	pm_str_intr.fields.level = MOT_LEVEL_ONE;
	pm_str_intr.fields.directed = NON_DIRECTED;
	pm_str_intr.fields.src_slot = iopmcomm.slot >> 4;
	pm_str_intr.fields.io_slot = iopmcomm.slot & 0xf;
}

/******************************************************************************/
blkintrpm(kbp)
struct buf  *kbp;
{
	uint            savmap;
	extern uint     spm_slot;	/* defined in ml/build_addr.c */
	extern caddr_t  iomap();
	extern uint     iomap_save();

	intrstat.buf_intr_out++;

	savmap = iomap_save();

	*(disp_int_t *)iomap(spm_slot, SPM_INT_DISPATCHER) = pm_buf_intr;

	iomap_restore(savmap);
}

/******************************************************************************/
strintrpm(pm_id, info)
ushort      pm_id;
disp_int_t  *info;
{
	extern uint     	iomap_save();
	extern caddr_t  	iomap();
	uint            	savmap = iomap_save();
	register own_t		*o;
	register disp_int_t	*old_prdcr, *new_prdcr;

	ASSERT(pm_id < SBUS_MAX_NUM_PM);
	o = spm_mem.pm_own[pm_id];
	info->fields.dest_slot = o->o_slot;

	do {
		old_prdcr = o->o_queue_1.producer;

		new_prdcr = old_prdcr + 1;
		/* handle wrap around */
		if (new_prdcr == o->o_queue_1.end)
			new_prdcr = o->o_queue_1.data;

		/* handle queue full */
		while (*(uint *)new_prdcr)
			;

	} while (! cas_long(&o->o_queue_1.producer, old_prdcr, new_prdcr));

	*old_prdcr = *info;

	intrstat.str_intr_out++;

#ifdef M68040
	*(long *)iomap(o->o_slot, PM_INT_REQ_REG) =
	  PM_LEVEL_ONE_INT_REQ | (o->o_base_pm_id == pm_id ? INT_ID : 0);
#else
	*(long *)iomap(o->o_slot, PM_INT_REQ_REG) = PM_LEVEL_ONE_INT_REQ;
#endif /* M68040 */

	iomap_restore(savmap);
}

/******************************************************************************/
cssintr()
{
	extern uint  ticks_since_setrq;
	extern uint  intr_ignored;

	intrstat.intr_in++;		/* counts all intr 1 for now */

	/* if task hasn't run for a while, return to task */
	if ( ticks_since_setrq > HZ / 10 + 1 )
	{
		intr_ignored = 1;
		return;
	}

	strmgr();
	bufmgr();
}
