/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) config.c: version 25.1 created on 11/27/91 at 14:48:20	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)config.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "devsw.h"
#include "sys/iopmcomm.h"
#include "sys/kmem.h"
#include "sys/types.h"
#include "tcb.h"
#include "sys/errno.h"
#include "sys/sbus_pm.h"
#include "sys/spm_mem.h"
#include "stream.h"
#include "sys/immu.h"
#include "sysmacros.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/sbus_iopm.h"
#include "sys/ints.h"
#include "sys/iopmioctl.h"
#include "sys/iopmbuf.h"
#include "sys/iopmdebug.h"
#include "sys/iopmsltbl.h"
#include "buf_conf.h"
#include "str_conf.h"
#include "user.h"
#include "sysinfo.h"

struct bdevsw  bdevsw[256];
struct cdevsw  cdevsw[256];
uint devcnt;

extern struct fmodsw fmodsw[];
extern int           fmodcnt;

#define UM(maj)	notminored((maj) << 8)

void (*devsrvp)();

static disp_int_t	spm_cmd_intr;	/* interrupt vector, etc. */
static disp_int_t	pm_cmd_intr;	/* interrupt vector, etc. */

#define PREFIXSIZE 16
struct mod_info {
	uchar  prefix[PREFIXSIZE];
	uchar  used;
	uchar  maj;		/* IOPM major number */
	ushort num;		/* number of groups of 256 minors */
	int    port;		/* passed from user to driver */
	dev_t  idev;
} mi[NUM_CONFIG];

caddr_t  mod_addr;
uint     mod_tlen;
uint     mod_dlen;

#ifdef IOPMDEBUG
int iopm_dbg = IOPMDEBUG;
#else
int iopm_dbg;
#endif

/******************************************************************************/
/*
** this will be task 0 that loads the drivers and maintains the local bdevsw
*/
void
iopm_mgr()
{
	uint               savmap;
	int                i;
	struct mod_info    *mip;
	uint               nextmip = 0;
	int                index;
	dev_t              imaj;
	extern uint        iopmcmd;
	extern uint        spm_slot;
	extern struct tcb  *curtcbp;
	extern struct tcb  *runq;
	extern             prtwhere;
	extern uint        iopend;
	extern void        writepm();
	extern uint        iomap_save();
	extern caddr_t     iomap();
	extern uint        memalloc();

	*LED_CTRL_REG = READY_LED_ON;

	for ( i = 0; i < 128; i++ )
	{
		MAJOR[i] = i;
		MINOR[i] = UM(i);
	}

	for ( i = 0; i < 256; i++ )
	{
		bdevsw[i].d_open = NULL;
		bdevsw[i].d_close = NULL;
		bdevsw[i].d_strategy = NULL;
		cdevsw[i].d_open = NULL;
		cdevsw[i].d_close = NULL;
		cdevsw[i].d_ioctl = NULL;

		cdevsw[i].d_str = NULL;
	}
	spm_cmd_intr.fields.vector = IOPM_IOCTL_INTR;
	spm_cmd_intr.fields.level = MOT_LEVEL_FIVE;
	spm_cmd_intr.fields.directed = DIRECTED;
	spm_cmd_intr.fields.dest_slot = spm_slot;
	spm_cmd_intr.fields.src_slot = iopmcomm.slot >> 4;
	spm_cmd_intr.fields.io_slot = iopmcomm.slot & 0xf;

	pm_cmd_intr.fields.vector = IOPM_IOCTL_INTR;
	pm_cmd_intr.fields.level = MOT_LEVEL_TWO;
	pm_cmd_intr.fields.directed = NON_DIRECTED;
	pm_cmd_intr.fields.dest_slot = spm_slot;
	pm_cmd_intr.fields.src_slot = iopmcomm.slot >> 4;
	pm_cmd_intr.fields.io_slot = iopmcomm.slot & 0xf;

	devsrvp = NULL;
	user_config();

	prtwhere = 1;		/* remote */
	printf("0x%x available memory\n", iopmcomm.freemem);
	prtwhere = 2;		/* local */

	while(1)
	{
		uint  savecmd;
		int saved_pri;

		saved_pri = splhi();
		while ( !(savecmd = iopmcmd) )
			sleep((caddr_t)&iopmcmd, 2);/*CMW arbitrary (high) pri*/
		splx(saved_pri);

		savmap = iomap_save();
		switch ( savecmd & ~SPM_CMD )
		{
		    /*
		    ** Given the virtual (ie linked) address and the length
		    ** of the text and data + bss, reserve some memory and
		    ** pass back the IOPM physical address of the memory.
		    **
		    ** iopm_arg[0] is the virtual address of the text
		    ** iopm_arg[0] returns the physical address of the text
		    ** iopm_arg[1] is the length of the text
		    ** iopm_arg[2] returns the physical addr of the data + bss
		    ** iopm_arg[3] is the length of the data + bss
		    */
		    case LOAD_WHERE:	/* load where cmd (for spm) */
		    {
			uint               physaddr;
			extern struct map  memmap[];

			physaddr = memalloc((int)btoc(iopmcomm.iopm_arg[1])) <<
			  PNUMSHFT;
			if ( physaddr )
			{
				bzero((caddr_t)physaddr, iopmcomm.iopm_arg[1]);
				/* NOTE: data starts on next page after text */
				if ( !setmmu(physaddr, iopmcomm.iopm_arg[0],
				            btoc(iopmcomm.iopm_arg[1]) +
				            btoc(iopmcomm.iopm_arg[3])) )
				{
					iopmcomm.iopm_response = -1;
					break;
				}
				mod_addr = (caddr_t)iopmcomm.iopm_arg[0];
				iopmcomm.iopm_arg[0] = physaddr;
				iopmcomm.iopm_response = 0;
			}
			else
			{
				cmn_err(CE_WARN,
				  "iopm_mgr: Insuffient memory to load driver/module\n");
				iopmcomm.iopm_response = -1;
				break;
			}

			physaddr = memalloc((int)btoc(iopmcomm.iopm_arg[3])) <<
			  PNUMSHFT;
			if ( physaddr )
			{
				bzero((caddr_t)physaddr, iopmcomm.iopm_arg[3]);
				iopmcomm.iopm_arg[2] = physaddr;
				iopmcomm.iopm_response = 0;
				mod_tlen = iopmcomm.iopm_arg[1];
				mod_dlen = iopmcomm.iopm_arg[3];
			}
			else
			{
				mod_addr = 0;
				cmn_err(CE_WARN,
				  "iopm_mgr: Insuffient memory to load driver/module\n");
				memfree((int)btoc(iopmcomm.iopm_arg[1]),
				  iopmcomm.iopm_arg[0] >> PNUMSHFT);

				iopmcomm.iopm_response = -1;
			}

			break;
		    }

		    case START_MOD:	/* start cmd */
			ASSERT(iopmcomm.iopm_arg[0]);
			ASSERT(iopmcomm.iopm_arg[0] >= (uint)mod_addr);
			ASSERT(iopmcomm.iopm_arg[0] < (uint)mod_addr+mod_tlen);

			*LED_CTRL_REG = LED1_OFF;
			*LED_CTRL_REG = LED2_ON;
			(*(void(*)())iopmcomm.iopm_arg[0])();
			*LED_CTRL_REG = LED1_ON;
			*LED_CTRL_REG = LED2_OFF;
			iopmcomm.iopm_response = 0;

			for ( i = 0, mip = mi; i < NUM_CONFIG; mip++, i++ )
				if ( mip->used )
				{
					cmn_err(CE_WARN,
					  "Loaded module %s not attached",
					  mip->prefix);
					mip->used = 0;
				}

			nextmip = 0;
			mod_addr = 0;
			mod_tlen = 0;
			mod_dlen = 0;
			break;

#define IOPMTBL  ((struct iopmsltbl *)iopmcomm.iopm_arg[0])
#define KMIN     iopmcomm.iopm_arg[1]
#define NUMDEV   iopmcomm.iopm_arg[2]
#define PORT     iopmcomm.iopm_arg[3]
#define IMIN     iopmcomm.iopm_arg[4]
		    case BUF_DEVSW:	/* devsw cmd */
			if ( nextmip == NUM_CONFIG )
				cmn_err(CE_PANIC,
				 "Too many drivers in downloaded object code.");
			ASSERT(iopmcomm.iopm_arg_str[0]);/* driver name */
			ASSERT(NUMDEV);			/* at least one minor */
			ASSERT(NUMDEV < 0x8000);	/* range */
			ASSERT(KMIN < 0x8000);		/* range */
			ASSERT(IMIN < 0x8000);

			mip = &mi[nextmip];
			mip->used = 1;

			for ( i = 0; iopmcomm.iopm_arg_str[i] &&
			             i < PREFIXSIZE - 1; i++ )
			{
				mip->prefix[i] = iopmcomm.iopm_arg_str[i];
			}
			mip->prefix[i] = '\0';

			mip->num = (NUMDEV + 0xff) >> 8;

			if ( IMIN )
			{
				for ( index = nextmip - 1; index >= 0; index-- )
					if ( !strcmp(mip->prefix, mi[index].prefix) &&
					     minor(mi[index].idev) == 0 )
						break;

				if ( index < 0 )
					cmn_err(CE_PANIC,
	"Attempt to configure driver with IOPM minor %d before\n  configuring driver with IOPM minor 0."
, IMIN);
				ASSERT(0x8000 & mi[index].idev);
				mip->idev = major(mi[index].idev) + IMIN;
				imaj = major(mi[index].idev);
			}
			else
			{
				index = nextmip;
				mip->idev = UM(devcnt);
				imaj = devcnt;
			}

			for ( i = ((mip->idev >> 8) & 0x7f);
			      i < (((mip->idev + NUMDEV + 0xff) >> 8) & 0x7f);
			      i++ )
			{
				MAJOR[i] = imaj;
				MINOR[i] = mi[index].idev & 0xff00;
			}
			devcnt = i;

			mip->port = PORT;

			PRINT4(CONFIG,
			  "iopm_mgr: BUF: name '%s', k min 0x%x, IOPM maj %d, num of devs %d\n",
			  mip->prefix, KMIN, imaj, NUMDEV);

			for ( i = KMIN >> MNPGSHFT; i < (KMIN >> MNPGSHFT) +
			      ((NUMDEV + (MNPG - 1)) >> MNPGSHFT);
			      i++ )
			{
				IOPMTBL[i].iopmdev =
				    notminored(mip->idev + (i << MNPGSHFT) -
				       (KMIN & ~(MNPG - 1)) + IMIN);
			}
			nextmip++;
			iopmcomm.iopm_response = 0;
			break;

		    case STR_DEVSW:	/* devsw cmd */
			if ( nextmip == NUM_CONFIG )
				cmn_err(CE_PANIC,
				 "Too many drivers in downloaded object code.");
			ASSERT(iopmcomm.iopm_arg_str[0]);/* driver name */
			ASSERT(NUMDEV);			/* at least one minor */
			ASSERT(NUMDEV < 0x8000);	/* range */
			ASSERT(KMIN < 0x8000);		/* range */
			ASSERT(IMIN < 0x8000);

			mip = &mi[nextmip];
			mip->used = 1;

			for ( i = 0; iopmcomm.iopm_arg_str[i] &&
			      i < PREFIXSIZE - 1; i++ )
			{
				mip->prefix[i] = iopmcomm.iopm_arg_str[i];
			}
			mip->prefix[i] = '\0';

			mip->num = (NUMDEV + 0xff) >> 8;

			if ( IMIN )
			{
				for ( index = nextmip - 1; index >= 0; index-- )
					if ( !strcmp(mip->prefix,
					     mi[index].prefix) &&
					     minor(mi[index].idev) == 0 )
						break;

				if ( index < 0 )
					cmn_err(CE_PANIC,
	"Attempt to configure driver with IOPM minor %d before\n  configuring driver with IOPM minor 0."
, IMIN);
				ASSERT(0x8000 & mi[index].idev);
				mip->idev = major(mi[index].idev) + IMIN;
				mip->maj = major(mi[index].idev);
			}
			else
			{
				index = nextmip;
				mip->idev = UM(devcnt);
				imaj = devcnt;
			}

			for ( i = ((mip->idev >> 8) & 0x7f);
			      i < (((mip->idev + NUMDEV + 0xff) >> 8) & 0x7f);
			      i++ )
			{
				MAJOR[i] = imaj;
				MINOR[i] = mi[index].idev & 0xff00;
			}

			devcnt = i;

			mip->port = PORT;

			PRINT4(CONFIG,
			  "iopm_mgr: STR: name '%s', k min 0x%x, IOPM maj %d, num of devs %d\n",
			  mip->prefix, KMIN, imaj, NUMDEV);
			for ( i = KMIN >> MNPGSHFT;
			      i < (KMIN >> MNPGSHFT) +
			      ((NUMDEV + (MNPG - 1))>> MNPGSHFT);
			      i++ )
			{
				IOPMTBL[i].iopmdev =
				    notminored(mip->idev + (i << MNPGSHFT) -
				       (KMIN & ~(MNPG - 1)) + IMIN);
			}

			nextmip++;
			iopmcomm.iopm_response = 0;
			break;

		    case SET_QUEUES:
			iopmcomm.iopm_response = !setnumq(iopmcomm.iopm_arg[0]);

			break;

		    case SET_NMSG:
			iopmcomm.iopm_response =
			  !setnummsg(iopmcomm.iopm_arg[0], iopmcomm.iopm_arg[1],
			             iopmcomm.iopm_arg[2], iopmcomm.iopm_arg[3],
			             iopmcomm.iopm_arg[4], iopmcomm.iopm_arg[5],
			             iopmcomm.iopm_arg[6], iopmcomm.iopm_arg[7],
			             iopmcomm.iopm_arg[8]);

			break;

		    case SET_BP:
			iopmcomm.iopm_response =
			  !setnumbp(iopmcomm.iopm_arg[0]);

			break;

		    case SET_BUF:
			iopmcomm.iopm_response = 
			  !setnumbuf(iopmcomm.iopm_arg[0]);

			break;

		    case SET_NUMTCB:
			iopmcomm.iopm_response=!setnumtcb(iopmcomm.iopm_arg[0]);
			break;

		    /* Returns an CSS board offset that can be used to access */
		    /* memory (and regs and device boards) from the CSS .*/
		    /* Returns a 0 for invalid addresses ie not mapped. */
		    /* NOTE: one mapped address (0xa0000000) also returns 0. */
		    case VTOP:
		    {
			caddr_t  vtop();

			iopmcomm.iopm_response =
		(uint)vtop((caddr_t)iopmcomm.iopm_arg[0], (struct proc *)0);
			break;
		    }

		    default:
			cmn_err(CE_WARN, "Unknown command %x\n", savecmd);
			iopmcomm.iopm_response = 0;
			break;
		}

		iopmcmd = (uint)0x0;
		if ( savecmd & SPM_CMD )
			*(disp_int_t *)iomap(spm_slot, SPM_INT_DISPATCHER) =
		  	  spm_cmd_intr;
		else
			*(disp_int_t *)iomap(spm_slot, SPM_INT_DISPATCHER) =
		  	  pm_cmd_intr;

		iomap_restore(savmap);
	}
}

/******************************************************************************/
attach_bufs_driver( buf_conf )
struct buf_config  *buf_conf;
{
	uint i, j;
	uint  attached = 0;
	extern void nodev();
	extern void nulldev();

	PRINT4(CONFIG,
	  "attach_bufs_driver: name '%s', open %x, strat %x, dma %x\n",
	  buf_conf->bc_prefix, buf_conf->bc_open, buf_conf->bc_strat,
	  buf_conf->bc_dma);

	if ( buf_conf->bc_version != BC_VERSION )
		panic("attach_bufs_driver: version mismatch. %s driver.\nIOPM os version %x, driver version %x",
		  buf_conf->bc_prefix, BC_VERSION, buf_conf->bc_version);

	ASSERT((uint)buf_conf->bc_open >= (uint)mod_addr);
	ASSERT((uint)buf_conf->bc_open < (uint)mod_addr + mod_tlen);
	ASSERT((uint)buf_conf->bc_close >= (uint)mod_addr);
	ASSERT((uint)buf_conf->bc_close < (uint)mod_addr + mod_tlen);
	ASSERT((uint)buf_conf->bc_strat >= (uint)mod_addr);
	ASSERT((uint)buf_conf->bc_strat < (uint)mod_addr + mod_tlen);
	ASSERT((uint)buf_conf->bc_print >= (uint)mod_addr);
	ASSERT((uint)buf_conf->bc_print < (uint)mod_addr + mod_tlen);
	ASSERT((uint)buf_conf->bc_ioctl >= (uint)mod_addr);
	ASSERT((uint)buf_conf->bc_ioctl < (uint)mod_addr + mod_tlen);

	/*
	** if a driver tries to pass nodev as a strat routine,
	** bc_strat will point to jmp [(nodev)].
	** "jmp" is 4 bytes, then double de reference [(nodev)] to cmp to nodev
	*/
	if ( invalid_routine(buf_conf->bc_open, nulldev) )
		cmn_err(CE_PANIC, "attach_bufs_driver: invalid open routine");
	if ( invalid_routine(buf_conf->bc_close, nulldev) )
		cmn_err(CE_PANIC, "attach_bufs_driver: invalid close routine");
	if ( invalid_routine(buf_conf->bc_strat, nodev) )
		cmn_err(CE_PANIC, "attach_bufs_driver: invalid strat routine");
	if ( invalid_routine(buf_conf->bc_ioctl, nodev) )
		cmn_err(CE_PANIC, "attach_bufs_driver: invalid ioctl routine");
	if ( invalid_routine(buf_conf->bc_print, nulldev) )
		cmn_err(CE_PANIC, "attach_bufs_driver: invalid print routine");

	if ( !one_bit_set(buf_conf->bc_dma) )
		panic("attach_bufs_driver: more than one bit set in dma flag.");

	for ( j = 0; j < NUM_CONFIG; j++ )
	{
		for ( i = 0; i < PREFIXSIZE - 1; i++ )
		{
			if ( mi[j].prefix[i] == '\0' ||
			     *(buf_conf->bc_prefix + i) == '\0' ||
			     mi[j].prefix[i] != *(buf_conf->bc_prefix + i) )
				break;
		}

		if ( *(buf_conf->bc_prefix + i) != '\0' ||
		     mi[j].prefix[i] != '\0' )
			continue;

		attached = 1;
		mi[j].used = 0;

		for ( i = major(mi[j].idev); i < major(mi[j].idev) + mi[j].num;
		      i++ )
		{
			bdevsw[i].d_open = buf_conf->bc_open;
			bdevsw[i].d_close = buf_conf->bc_close;
			bdevsw[i].d_strategy = buf_conf->bc_strat;
			bdevsw[i].d_print = buf_conf->bc_print;
			bdevsw[i].dma = buf_conf->bc_dma;
			cdevsw[i].d_open = buf_conf->bc_open;
			cdevsw[i].d_close = buf_conf->bc_close;
			cdevsw[i].d_ioctl = buf_conf->bc_ioctl;
		}

		if ( buf_conf->bc_start )
		{
			ASSERT((uint)buf_conf->bc_start >= (uint)mod_addr);
			ASSERT((uint)buf_conf->bc_start <
			  (uint)mod_addr + mod_tlen);
			/* call driver start routine with IOPM dev and port */
			(*buf_conf->bc_start)(mi[j].idev, mi[j].port);
		}
	}

	if ( !attached )
		cmn_err(CE_PANIC,
		  "driver name (%s) doesn't match any expected driver.",
		  buf_conf->bc_prefix);
}

/******************************************************************************/
#define drv_name  str_conf->sc_strtab->st_rdinit->qi_minfo->mi_idname
attach_streams_driver( str_conf )
struct str_config  *str_conf;
{
	uint i, j;
	uint  attached = 0;

	ASSERT(str_conf->sc_strtab);
	ASSERT((uint)str_conf->sc_strtab >= (uint)mod_addr);
	ASSERT((uint)str_conf->sc_strtab <
	  (uint)mod_addr + (btoc(mod_tlen) << BPCSHIFT) + mod_dlen);
	ASSERT(str_conf->sc_strtab->st_rdinit);
	ASSERT(str_conf->sc_strtab->st_rdinit->qi_minfo);
	ASSERT(drv_name);

	PRINT3(CONFIG,
	  "attach_streams_driver: name '%s', strtab %x, start %x\n",
	  drv_name, str_conf->sc_strtab, str_conf->sc_start);

	if ( str_conf->sc_version != SC_VERSION )
		cmn_err(CE_PANIC,
		  "attach_streams_driver: version mismatch. %s driver.\nIOPM os version %x, driver version %x",
		  drv_name, SC_VERSION, str_conf->sc_version);

	for ( j = 0; j < NUM_CONFIG; j++ )
	{
		for ( i = 0; i < PREFIXSIZE - 1; i++ )
		{
			if ( mi[j].prefix[i] != *(drv_name + i) ||
			     mi[j].prefix[i] == '\0' ||
			     *(drv_name + i) == '\0' )
				break;
		}

		if ( mi[j].prefix[i] != '\0' || *(drv_name + i) != '\0' )
			continue;

		attached = 1;
		mi[j].used = 0;

		for ( i = major(mi[j].idev); i < major(mi[j].idev) + mi[j].num;
		      i++ )
			cdevsw[i].d_str = str_conf->sc_strtab;

		PRINT3(CONFIG,
		  "attach_streams_driver: name '%s', IOPM maj num %d, major groups %d\n",
		  drv_name, major(mi[j].idev), mi[j].num);

		if ( str_conf->sc_start )
		{
			ASSERT((uint)str_conf->sc_start >= (uint)mod_addr);
			ASSERT((uint)str_conf->sc_start <
			  (uint)mod_addr + mod_tlen);
			/* call driver start routine with IOPM dev and port */
			(*str_conf->sc_start)(mi[j].idev, mi[j].port);
		}
	}

	if ( !attached )
		cmn_err(CE_PANIC,
		  "driver name (%s) doesn't match any expected driver.",
		  drv_name);
}
#undef drv_name

/******************************************************************************/
#define mod_name  mod_conf->smc_strtab->st_rdinit->qi_minfo->mi_idname
attach_streams_module(mod_conf)
struct str_mod_config  *mod_conf;
{
	uint  i;

	PRINT2(CONFIG,"attach_streams_module: strtab %x, fmodcnt %d\n",
	  mod_conf->smc_strtab,fmodcnt);

	ASSERT(mod_conf->smc_strtab);
	ASSERT(mod_conf->smc_strtab->st_rdinit);
	ASSERT(mod_conf->smc_strtab->st_rdinit->qi_minfo);
	ASSERT(mod_name);
	if ( mod_conf->smc_version != SMC_VERSION )
		cmn_err(CE_PANIC,
		  "attach_stream_module: version mismatch. %s driver.\nIOPM os version %x, driver version %x",
		  mod_name, SMC_VERSION, mod_conf->smc_version);

	fmodsw[fmodcnt].f_str = mod_conf->smc_strtab;
	for ( i = 0; *(mod_name + i) && i <= FMNAMESZ; i++ )
		fmodsw[fmodcnt].f_name[i] = *(mod_name + i);

	fmodsw[fmodcnt].f_name[i+1] = '\0';
	fmodcnt++;

	PRINT2(CONFIG, "stream_module_attach: name '%s', module number %d\n",
	  fmodsw[fmodcnt-1].f_name, fmodcnt-1);
}
#undef mod_name

/******************************************************************************/
strcmp(str1, str2)
register uchar  *str1;
register uchar  *str2;
{
	register uint  i;

	for ( i = 0; i < PREFIXSIZE - 1; i++ )
	{
		if ( *(str1 + i) != *(str2 + i) ||
		     *(str1 + i) == '\0' || *(str2 + i) == '\0' )
			break;
	}

	if ( *(str1 + i) == '\0' && *(str2 + i) == '\0' )
		return 0;
	else
		return 1;
}

/******************************************************************************/
/*
** if a driver tries to pass 'okref' as a xxx routine,
** bc_xxx will point to jmp [(okref)].
** "jmp" is 4 bytes, then double de reference [(okref)] to cmp to okref
*/
invalid_routine(routine, okref)
void  (*routine)();
void  (*okref)();
{
	if ( !valid_iopm_addr(*(uint *)((caddr_t)routine + 4)) )
		return 0;

	return **(void(***)())((caddr_t)routine + 4) != okref;
}

/******************************************************************************/
catch()
{
	extern void  (*devsrvp)();

	if ( devsrvp )
		(*devsrvp)();
}

/******************************************************************************/
set_serv_handler( func )
void  (*func)();
{
	devsrvp = func;
}

/******************************************************************************/
set_lo_db_vector( func )
void  (*func)();
{
	extern void  (*M68Kvec[])();
	extern void  nullvect();

	if ( func )
		M68Kvec[28] = func;
	else
		M68Kvec[28] = nullvect;
}

/******************************************************************************/
set_hi_db_vector( func )
void  (*func)();
{
	extern void  (*M68Kvec[])();
	extern void  nullvect();

	if ( func )
		M68Kvec[29] = func;
	else
		M68Kvec[29] = nullvect;
}

/******************************************************************************/
no_routine()
{
	cmn_err(CE_PANIC, "No such function or routine");
}

/******************************************************************************/
/*
** Routine which sets a user error; placed in
** illegal entries in the bdevsw and cdevsw tables.
*/
void
nodev()
{
	iu.u_error = ENXIO;
}

/*
** Null routine; placed in insignificant entries
** in the bdevsw and cdevsw tables.
*/
void
nulldev()
{
}

/******************************************************************************/
get_lbolt()
{
	extern lbolt;

	return lbolt;
}

get_time()
{
	extern time;

	return time;
}

struct i_user *
get_u()
{
	return &iu;
}

struct i_sysinfo *
get_sysinfo()
{
	extern struct i_sysinfo  isysinfo;

	return &isysinfo;
}

/******************************************************************************/
dmajor(dev)
dev_t  dev;
{
	extern uchar  MAJOR[];

	return (int)MAJOR[dev >> 8 & 0x7f];
}

dminor(dev)
dev_t  dev;
{
	return (int)(dev & UNMINOR_BIT ? dev - MINOR[major(dev)] : dev);
}

/******************************************************************************/
one_bit_set(bit_flag)
uint  bit_flag;
{
	uint i;
	uint sum = 0;

	for ( i = 0; i < 32; bit_flag >>= 1, i++ )
		if ( bit_flag & 1 )
			sum++;

	return sum <= 1;
}

strlog()
{
	cmn_err(CE_WARN, "strlog not loaded\n");
}

void
set_profiler(func)
void  (*func)();
{
	extern void  (*profiler)();	/* optional profiler routine */

	profiler = func;
}
