/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) clock.c: version 25.1 created on 11/27/91 at 14:48:15	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)clock.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/iopmcomm.h"
#include "sys/param.h"
#include "tcb.h"
#include "sys/sbus_iopm.h"
#include "callo.h"

#define PDELAY (PZERO-1)
int   timeflg = 0;
uint  local_lbolt;

extern struct icallo  callout[];
extern struct icallo  *callo_head;	/* in iopmcomm.h */
struct icallo         *callo_free;
void          (*profiler)();	/* optional profiler routine */

/******************************************************************************/
clock(pc)
uint	pc;
{
	register struct icallo *cp;
	static int             sec = 0;
	extern                 lbolt;
	extern                 runflag;
	extern                 ticks_since_setrq;

	/* tell spm ok to send next clock */
	iopmcomm.o_reprime_clock = 1;

	local_lbolt = lbolt;

	if ( runflag )
		ticks_since_setrq++;

#ifdef ASDEBUG
	if ( sec > HZ/2 )
		*LED_CTRL_REG = READY_LED_OFF;
#endif

	if ( callo_head )
	{
		cp = callo_head;
		while( cp && cp->c_time <= 0 )
			cp = cp->c_next;

		if ( cp )
			cp->c_time--;

		if ( callo_head->c_time <= 0 )
		{
			timeflg = 1;
			softintr();
		}
	}

	get_time_stamp();

	if ( profiler )
		(*profiler)(pc);

	if ( sec++ < HZ )
		return;

	set_sysinfo();

#ifdef ASDEBUG
	*LED_CTRL_REG = READY_LED_ON;
	sec -= HZ;
#endif
}

/******************************************************************************/
/*
 * timeout is called to arrange that fun(arg) is called in tim/HZ seconds.
 * An entry is sorted into the callout structure.
 * The time in each structure entry is the number of HZ's more
 * than the previous entry. In this way, decrementing the
 * first entry has the effect of updating all entries.
 *
 * The panic is there because there is nothing
 * intelligent to be done if an entry won't fit.
 */

uint
timeout(func, arg, ticks)
void           (*func)();
caddr_t        arg;
register uint  ticks;
{
	register struct icallo	*p1, *p2, *p3;
	int   			savpri;
	static uint             timeid;
	extern uint             ncallout;

	savpri = spl6();

	if ( !callo_free )
		panic("Timeout table overflow");

	p1 = callo_head;
	p2 = 0;
	while ( p1 && p1->c_time <= ticks )
	{
		ticks -= p1->c_time;
		p2 = p1;
		p1 = p1->c_next;
	}

	if ( p1 )
		p1->c_time -= ticks;

	p3 = callo_free;
	callo_free = callo_free->c_next;

	p3->c_time = ticks;
	p3->c_func = func;
	p3->c_arg = arg;
	p3->c_id = ++timeid;

	if ( p1 )
		p3->c_next = p1;
	else
		p3->c_next = 0;

	if ( p2 )
		p2->c_next = p3;
	else
		callo_head = p3;

	splx(savpri);
	return(timeid);
}

/******************************************************************************/
untimeout(id)
register  id;
{
	register struct icallo  *p1;
	register struct icallo  *p2 = 0;
	int                     savpri;

	savpri = spl6();
	for ( p1 = callo_head; p1; p1 = p1->c_next )
	{
		if ( p1->c_id == id )
		{
			if ( p2 )
				p2->c_next = p1->c_next;
			else
				callo_head = p1->c_next;

			if ( p1->c_next )
				p1->c_next->c_time += p1->c_time;

			p1->c_next = callo_free;
			callo_free = p1;
			break;
		}
		p2 = p1;
	}

	splx(savpri);
}

/******************************************************************************/
/* chktimeout is called by qdetach to remove any timeouts that have not been
/* "untimeout'ed" that referenace the read queue or the write queue.
*/
chktimeout(arg1, arg2)
register caddr_t  arg1;
register caddr_t  arg2;
{
	register struct icallo  *p1;
	register struct icallo  *p2 = 0;
	int                     savpri;

	savpri = spl6();
	for ( p1 = callo_head; p1; p1 = p1->c_next )
	{
		if ( p1->c_arg == arg1 || p1->c_arg == arg2 )
		{
			if ( p2 )
				p2->c_next = p1->c_next;
			else
				callo_head = p1->c_next;

			if ( p1->c_next )
				p1->c_next->c_time += p1->c_time;

			p1->c_next = callo_free;
			callo_free = p1;
			break;
		}
		p2 = p1;
	}

	splx(savpri);
}

/******************************************************************************/
/*
 * timein() is called via a low priority interrupt set in clock()
 */
timein()
{
	register struct icallo *p1;
	register void          (*func)();
	register caddr_t       arg;
	int                    savpri;

	if ( !callo_head )
		return;

	savpri = spl6();
	while ( (p1 = callo_head) && p1->c_time <= 0 )
	{
		func = p1->c_func;
		arg = p1->c_arg;
		/* move up entries first so untimeout won't find us */
		callo_head = p1->c_next;
		p1->c_next = callo_free;
		callo_free = p1;

		spl1();
		(*func)(arg);
		spl6();
	}
	splx(savpri);
}

/******************************************************************************/
delay(ticks)
uint  ticks;
{
	int                savpri;
	extern struct tcb  *curtcbp;
	extern             wakeup();

	if ( ticks == 0 )
		return;

	savpri = splhi();
	timeout((void(*)())wakeup, (caddr_t)curtcbp + 1, ticks);
	sleep((caddr_t)curtcbp+1, PDELAY);
	splx(savpri);
}

/******************************************************************************/
timeout_init()
{
	register struct icallo  *cp;
	uint                    i;
	extern uint             ncallout;

	cp = callout;
	callo_free = cp;

	for ( i = 0; i < ncallout - 1; cp++, i++ )
		cp->c_next = cp + 1;

	cp->c_next = 0;
}

/******************************************************************************/
#include "sys/sysinfo.h"
#include "sysinfo.h"
struct i_sysinfo  isysinfo;
struct i_sysinfo  sysinfo_mirror;
set_sysinfo()
{
	register ulong  delta;

	if ( delta = isysinfo.rcvint - sysinfo_mirror.rcvint )
	{
		sysinfo_mirror.rcvint = isysinfo.rcvint;
		atom_add(&iopmcomm.ksysinfop->rcvint, delta);
	}

	if ( delta = isysinfo.xmtint - sysinfo_mirror.xmtint )
	{
		sysinfo_mirror.xmtint = isysinfo.xmtint;
		atom_add(&iopmcomm.ksysinfop->xmtint, delta);
	}

	if ( delta = isysinfo.mdmint - sysinfo_mirror.mdmint )
	{
		sysinfo_mirror.mdmint = isysinfo.mdmint;
		atom_add(&iopmcomm.ksysinfop->mdmint, delta);
	}

	if ( delta = isysinfo.rawch - sysinfo_mirror.rawch )
	{
		sysinfo_mirror.rawch = isysinfo.rawch;
		atom_add(&iopmcomm.ksysinfop->rawch, delta);
	}

	if ( delta = isysinfo.canch - sysinfo_mirror.canch )
	{
		sysinfo_mirror.canch = isysinfo.canch;
		atom_add(&iopmcomm.ksysinfop->canch, delta);
	}

	if ( delta = isysinfo.outch - sysinfo_mirror.outch )
	{
		sysinfo_mirror.outch = isysinfo.outch;
		atom_add(&iopmcomm.ksysinfop->outch, delta);
	}
}
