/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) bufmgr.c: version 25.1 created on 11/27/91 at 14:48:08	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)bufmgr.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/open.h"
#include "sys/errno.h"
#include "sys/debug.h"
#include "sysmacros.h"
#include "sys/types.h"
#include "sys/cmn_err.h"
#include "tcb.h"
#include "user.h"
#include "proc.h"
#include "sys/mfs.h"
#include "sys/buf.h"
#include "sys/iopmcomm.h"
#include "sys/iopmbuf.h"
#include "buf.h"
#include "devsw.h"
#include "dma.h"
#include "sys/spm_mem.h"
#include "sys/sbus_spm.h"
#include "sys/iopmsltbl.h"
#include "sys/iopmdebug.h"
#include "sys/iopmstat.h"
#include "iopm.h"

struct bufifstat  bufifstat;

buf_t       *bufhead;		/* head of q for reqs waiting for a buffer */
buf_t       *bphead;		/* head of q for reqs waiting for a buf hdr */
buf_t       *tcb_head;		/* head of q for reqs waiting for tcb's */
disp_int_t  pm_buf_intr;	/* interrupt vector, etc */

extern caddr_t  getbuf();

#define IOPMBCB  ((struct iopmbcb *)kbp->b_un.b_addr)

/******************************************************************************/
bufmgr()
{
	extern uint          *freebuf;
	extern struct i_buf  *freebph;
	extern struct tcb    *freetcbp;

	if ( tcb_head && freetcbp )
		process_buf_tcb_list();
	if ( bufhead && freebuf )
		process_buf_list();
	if ( bphead && freebph )
		process_bp_list();
	if ( ktoib )
		process_new_req();
}

/******************************************************************************/
process_buf_tcb_list()
{
	register struct buf  *kbp;
	struct buf           *next_req;
	uint                 fail = 0;
	extern struct buf    *reverse_chain();
	extern               bproc();

	kbp = tcb_head;
	tcb_head = 0;
	ASSERT(valid_pm_addr(kbp));
	if ( kbp->av_forw )
		kbp = reverse_chain(kbp);

	do
	{
		ASSERT(valid_pm_addr(kbp));
		next_req = kbp->av_forw;

		switch ( kbp->b_driver_flags & IOPM_DRIVER_FLAGS )
		{
		    case I_OPEN:
		    case I_CLOSE:
		    case I_IOCTL:
			if ( fail || create((int)bproc, (int)kbp, 0) )
			{
				fail = 1;
				kbp->av_forw = tcb_head;
				tcb_head = kbp;
			}
			break;

		    default:
			cmn_err(CE_PANIC,
			  "process_buf_tcb_list: unexpected b_driver_flags %x\n"
			  ,kbp->b_driver_flags);
		}
		kbp = next_req;
	} while ( kbp );
}

/******************************************************************************/
process_buf_list()
{
	register struct buf  *kbp;
	struct buf           *next_req;
	int                  savpri;
	extern struct buf    *reverse_chain();

	kbp = bufhead;
	bufhead = 0;
	ASSERT(valid_pm_addr(kbp));
	if ( kbp->av_forw )
		kbp = reverse_chain(kbp);

	do
	{
		ASSERT(valid_pm_addr(kbp));
		next_req = kbp->av_forw;

		switch ( kbp->b_driver_flags & IOPM_DRIVER_FLAGS )
		{
		    case I_STRAT:
			if ( bufhead )
			{
				savpri = spldb();
				kbp->av_forw = bufhead;
				bufhead = kbp;
				splx(savpri);
				break;
			}
			bstrategy(kbp);
			break;

		    default:
			cmn_err(CE_PANIC,
			  "process_buf_list: unexpected b_driver_flags %x\n"
			  ,kbp->b_driver_flags);
		}
		kbp = next_req;
	} while ( kbp );
}

/******************************************************************************/
process_bp_list()
{
	register struct buf  *kbp;
	struct buf           *next_req;
	int                  savpri;
	extern struct buf    *reverse_chain();

	kbp = bphead;
	bphead = 0;
	ASSERT(valid_pm_addr(kbp));
	if ( kbp->av_forw )
		kbp = reverse_chain(kbp);

	do
	{
		ASSERT(valid_pm_addr(kbp));
		next_req = kbp->av_forw;

		switch ( kbp->b_driver_flags & IOPM_DRIVER_FLAGS )
		{
		    case I_STRAT:
			if ( bphead )
			{
				savpri = spldb();
				kbp->av_forw = bphead;
				bphead = kbp;
				splx(savpri);
				break;
			}
			bstrategy(kbp);
			break;

		    default:
			cmn_err(CE_PANIC,
			  "process_bp_list: unexpected b_driver_flags %x\n"
			  ,kbp->b_driver_flags);
		}
		kbp = next_req;
	} while ( kbp );
}

/******************************************************************************/
process_new_req()
{
	register struct buf  *kbp;
	struct buf           *next_req;
	int                  savpri;
	extern struct buf    *reverse_chain();
	extern               bproc();
	extern void          nulldev();

	bufifstat.new_req++;

	kbp = (buf_t *)remove_chain(thrucss((uint)&ktoib));
	ASSERT(valid_pm_addr(kbp));
	if ( kbp->av_forw )
		kbp = reverse_chain(kbp);

	do
	{
		bufifstat.buf_in++;

		ASSERT(valid_pm_addr(kbp));
		next_req = kbp->av_forw;
		PRINT1(INTR, "BUF INTR bp=%x ", kbp);
		BPRINT_TYPE(INTR, kbp);
		PRINT(INTR, "\n");

		switch ( kbp->b_driver_flags & IOPM_DRIVER_FLAGS )
		{
		    case I_STRAT:
			if ( bufhead )
			{
				savpri = spldb();
				kbp->av_forw = bufhead;
				bphead = kbp;
				splx(savpri);
				break;
			}
			bstrategy(kbp);
			break;

		    case I_OPEN:
		    case I_CLOSE:
		    case I_IOCTL:
			if ( create((int)bproc, (int)kbp, 0) )
			{
				kbp->av_forw = tcb_head;
				tcb_head = kbp;
			}
			break;

		    case I_DATA:
		    case I_ERROR:
			kbp->b_driver_flags |= B_DONE;
			wakeup((caddr_t)kbp);
			break;

		    case I_PRINT:
		    {
			register     idev;
			extern uint  devcnt;

			idev = kbp->b_resid;

			if ( major(idev) >= devcnt )
			{
				cmn_err(CE_WARN,
				  "bufmgr: I_PRINT: Bad dev %x, msg = '%s'",
				  idev, *(char **)kbp->b_un.b_addr);
				sendbuftokernel(kbp);	/* return to kernel */
				break;
			}

			ASSERT(bdevsw[major(idev)].d_print);
			if ( bdevsw[major(idev)].d_print != nulldev )
				(*bdevsw[major(idev)].d_print)(idev,
				  *(char **)kbp->b_un.b_addr);
			else
				cmn_err(CE_WARN,
				  "bufmgr: No d_print routine for dev %x, msg = '%s'\n",
				  idev, *(char **)kbp->b_un.b_addr);

			sendbuftokernel(kbp);	/* return to kernel */
			break;
		    }

		    default:
			printf("iopbmgr: unexpected b_driver_flags %x\n"
			    ,kbp->b_driver_flags);
			sendbuftokernel(kbp);	/* return to kernel */
		}
		kbp = next_req;
	} while ( kbp );
}

/******************************************************************************/
#define FLAG ((struct iopmbcb *)kbp->b_un.b_addr)->ib_arg1.flag
#define OTYP ((struct iopmbcb *)kbp->b_un.b_addr)->ib_arg2.otyp

#define CMD ((struct iopmbcb *)kbp->b_un.b_addr)->ib_arg1.cmd
#define ARG ((struct iopmbcb *)kbp->b_un.b_addr)->ib_arg2.arg
#define MODE ((struct iopmbcb *)kbp->b_un.b_addr)->ib_arg3.mode

bproc(kbp)
register struct buf  *kbp;
{
	int                   savpri = spl1();
	register dev_t        imajdev = major(kbp->b_resid);
	register void         (*func)();
	extern struct tcb     *curtcbp;
	extern struct i_proc  iproc;
	extern void           nodev();

	iproc.p_pid = IOPMBCB->ib_pid;
	iproc.p_pgrp = IOPMBCB->ib_pgrp;
	iproc.p_session_id = IOPMBCB->ib_session_id;
	iu.u_uid = IOPMBCB->ib_uid;
	iu.u_gid = IOPMBCB->ib_gid;
	iu.u_ruid = IOPMBCB->ib_ruid;
	iu.u_rgid = IOPMBCB->ib_rgid;

	switch ( kbp->b_driver_flags & IOPM_DRIVER_FLAGS )
	{
	    case I_OPEN:
		func = bdevsw[imajdev].d_open;
		if ( !func )
		{
			nodev();
			break;
		}
		*LED_CTRL_REG = LED1_OFF;
		*LED_CTRL_REG = LED2_ON;

		ASSERT(valid_iopm_vaddr(func));
		(*func)(minor(kbp->b_resid), FLAG, OTYP);

		*LED_CTRL_REG = LED1_ON;
		*LED_CTRL_REG = LED2_OFF;
		break;

	    case I_CLOSE:
		while ( wait_for_bufs(kbp->b_resid) );

		ASSERT(bdevsw[imajdev].d_close);
		func = bdevsw[imajdev].d_close;
		*LED_CTRL_REG = LED1_OFF;
		*LED_CTRL_REG = LED2_ON;

		ASSERT(valid_iopm_vaddr(func));
		(*func)(minor(kbp->b_resid), FLAG, OTYP);

		*LED_CTRL_REG = LED1_ON;
		*LED_CTRL_REG = LED2_OFF;
		break;

	    case I_IOCTL:
		iu.u_kbp = kbp;
		ASSERT(cdevsw[imajdev].d_ioctl);
		func = cdevsw[imajdev].d_ioctl;
		if ( func != nodev )
		{
			*LED_CTRL_REG = LED1_OFF;
			*LED_CTRL_REG = LED2_ON;

			ASSERT(valid_iopm_vaddr(func));
			(*func)(minor(kbp->b_resid), CMD, ARG, MODE);

			*LED_CTRL_REG = LED1_ON;
			*LED_CTRL_REG = LED2_OFF;
		}
		else
			iu.u_error = ENXIO;
		break;

	    default:
		ASSERT(0);
	}

	if ( iu.u_error )
	{
		kbp->b_driver_flags = B_ERROR;
		kbp->b_error = (char)iu.u_error;
	}

	/* only used for ioctl */
	((struct iopmbcb *)kbp->b_un.b_addr)->ib_rval = iu.u_rval;

	sendbuftokernel(kbp);

	splx(savpri);
	exit();
}

/******************************************************************************/
bstrategy(kbp)
register struct buf  *kbp;	/* kernel buf header pointer */
{
	register struct i_buf  *bp;
	void                   (*strategy)();
	extern struct i_buf    *bstrat();
	extern void            nodev();

	PRINT4(DATA,"bstrategy: kbp %x, imajdev %x, b_flags %x, dmaflag %x\n",
	        kbp, major(kbp->b_resid), kbp->b_flags,
	        bdevsw[major(kbp->b_resid)].dma);

	if ( !(bp = bstrat(kbp)) )
		return;

	if ( kbp->b_flags & B_PHYS )
		/* kernel passes full IOPM dev in b_resid */
		bp->b_dev = kbp->b_resid;
	else	/* not B_PHYS, kernel buffer pool */
		bp->b_dev = minor(kbp->b_resid);

	/* copy k buf to iop buf */
	bp->b_flags = kbp->b_flags;
	bp->b_blkno = kbp->b_blkno;
	bp->b_kbp = (void *)kbp;	/* save pointer to kbp in IOPM bp */

	PRINT1(ROUT,"call strat. count = %d\n",bp->b_bcount);

	ASSERT(bdevsw[major(kbp->b_resid)].d_strategy);
	strategy = bdevsw[major(kbp->b_resid)].d_strategy;
	*LED_CTRL_REG = LED1_OFF;
	*LED_CTRL_REG = LED2_ON;

	ASSERT(valid_iopm_vaddr(strategy));
	/* call driver strat routine at spl1 */
	(*strategy)(bp);

	*LED_CTRL_REG = LED1_ON;
	*LED_CTRL_REG = LED2_OFF;

	/*
	** av_back is used as a flag to tell if the IOPM OS is waiting for the
	** close for this bp. That is if this kbp is on a waiting-for-resource
	** list when a close request comes along, this kbp will be marked.
	*/
	if ( kbp->av_back )
		wakeup((caddr_t)kbp);

}

/******************************************************************************/
struct i_buf *
bstrat(kbp)
register struct buf  *kbp;
{
	register struct i_buf  *bp;
	int                    savpri;
	int                    dmaflag = bdevsw[major(kbp->b_resid)].dma;
	struct i_buf           *getbp();
	uint                   vmap_save();
	caddr_t                vmap();
	caddr_t                buf;

	savpri = spldb();

	if ( !(dmaflag & SGDMA) && bufhead )
	{
		kbp->av_forw = bufhead;
		bufhead = kbp;
		splx(savpri);
		return 0;
	}

	if ( !(bp = getbp()) )	/* get a bp */
	{			/* no bp available */
		kbp->av_forw  = bphead;
		bphead = kbp;
		splx(savpri);
		return 0;
	}

	bp->b_kbp = (void *)kbp;
	splx(savpri);

	bp->b_bcount = kbp->b_bcount;
	if ( dmaflag & SGDMA )
	{
		bp->b_un.b_addr = kbp->b_un.b_addr;
		bp->b_proc = (void *)kbp->b_proc;

		PRINT3(DATA,"    bp %x, b_addr %x, count %x\n",
		        bp,bp->b_un.b_addr, bp->b_bcount);
	}
	else
	{
		extern caddr_t  eblklimit;
		extern caddr_t  bufferp;

		if ( bp->b_bcount > eblklimit - bufferp )
		{
			cmn_err(CE_WARN,
			  "b_bcount (%d) > size of PHYSIO buffer (%d)",
			  bp->b_bcount, eblklimit - bufferp);
			bp->b_flags |= B_ERROR;
			bp->b_error = EINVAL;
			bp->b_kbp = (void *)kbp;	/* for iodone */
			iodone(bp);
			return 0;
		}

		savpri = spldb();
		if ( (buf = getbuf((bp->b_bcount + BSIZE - 1) / BSIZE)) == 0 )
		{
			freebp(bp);
			kbp->av_forw = bufhead;
			bufhead = kbp;
			splx(savpri);
			return 0;
		}
		splx(savpri);

		bp->b_iflags |= BI_BUF;
		bp->b_un.b_addr = buf;
		bp->b_proc = 0;

		PRINT3(DATA,"    bp %x, buf %x, count %x\n",
		   bp, buf, bp->b_bcount);

		if ( !(kbp->b_flags & B_READ) )
		{
			uint     savmap = vmap_save();
			caddr_t  src;
			caddr_t  dest = buf;
			uint     cnt;
			uint     xfer = 0;

			while ( xfer < bp->b_bcount )
			{
				src = vmap(kbp->b_un.b_addr + xfer,kbp->b_proc);
				cnt = min(bp->b_bcount - xfer, 
				  NBPP - ((uint)src & (NBPP - 1)));

				PRINT3(DATA,"bcopy(%x %x %x)\n",
				  src, dest + xfer, cnt);

				bcopy(src, dest + xfer, cnt);

				PRINT1(DATA,"data %x\n",*(uint *)buf);

				xfer += cnt;
			}

			vmap_restore(savmap);
		}
	}

	return bp;
}

/******************************************************************************/
struct buf *
reverse_chain( headp )
struct buf  *headp;
{
	register struct buf  *kbp = headp;
	register struct buf  *lastbp = 0;
	register struct buf  *savforw;

	do {
		ASSERT(valid_pm_addr(kbp));
		savforw = kbp->av_forw;
		kbp->av_forw = lastbp;
		lastbp = kbp;
		kbp = savforw;
	} while ( kbp );

	return lastbp;
}

/******************************************************************************/
/* Scan the 3 waiting-for-resouces lists looking for bp requests for the device
/* 'dev'. If found, mark the kernel bp by setting 'av_back' non zero (this
/* was set to zero by the kernel when the bp was pasted to the IOPM).
/* Then sleep on that kbp. When the resource is free and the request is
/* serviced, 'iodone' will call wakeup.
*/
wait_for_bufs(dev)
register dev_t  dev;
{
	register struct buf  *kbp;

	for ( kbp = bufhead; kbp; kbp = kbp->av_forw )
	{
		ASSERT(valid_pm_addr(kbp));
		if ( kbp->b_resid == dev )
		{
			kbp->av_back = kbp;
			sleep((caddr_t)kbp, PRIBIO);
			return 1;
		}
	}

	for ( kbp = bphead; kbp; kbp = kbp->av_forw )
	{
		ASSERT(valid_pm_addr(kbp));
		if ( kbp->b_resid == dev )
		{
			kbp->av_back = kbp;
			sleep((caddr_t)kbp, PRIBIO);
			return 1;
		}
	}

	return 0;
}

/******************************************************************************/
sendbuftokernel(kbp)
struct buf  *kbp;
{
	extern struct buf  **itokbp;

	PRINT1(SEND, "sendbuftokernel: bp=%x ", kbp);
	BPRINT_TYPE(SEND, kbp);
	PRINT(SEND, "\n");

	bufifstat.buf_out++;

	if ( !add_chain((caddr_t)itokbp, (caddr_t)kbp, (caddr_t)&kbp->av_forw) )
		blkintrpm();
}
