/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) bio.c: version 25.1 created on 11/27/91 at 14:48:02	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)bio.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/debug.h"
#include "sys/buf.h"
#include "iopm.h"
#include "sys/iopmcomm.h"
#include "sysmacros.h"
#include "sys/iopmsltbl.h"
#include "sys/iopmbuf.h"
#include "sys/immu.h"
#include "sys/map.h"
#include "sys/iopmdebug.h"
#include "sys/bufstat.h"
#include "buf.h"
#include "devsw.h"
#include "dma.h"
#include "sys/errno.h"
#include "user.h"
#include "sys/param.h"

extern struct bufstat  bufstat;		/* in iopmcomm */

struct i_buf    *freebph;		/* head of buffer headers */
int             wantbuf;		/* flag for geteblk/brlse */
int             wantbp;			/* flag for geteblk/brlse */
uint            freebuf;
caddr_t         eblklimit;
uint            eblkuse;

extern uint        nbuffermap;
extern struct map  buffermap[];
extern struct buf  *bufhead;		/* bufmgr waiting for buffer */
extern struct buf  *bphead;		/* bufmgr waiting for buffer head */
extern i_buf_t     *bppoolp;		/* buffer headers */
extern uint        numbp;		/* number of buffer headers */
extern caddr_t     bufferp;		/* buffers for buffer headers */
extern uint        numbuf;		/* number of BSIZE buffers */

extern uint  vmap_save();
extern uint  memalloc();
#define  MAXPHYS  256			/* num BSIZE bufs kept from geteblk */
/******************************************************************************/
struct i_buf *
geteblk()
{
	register struct i_buf  *bp;
	int                    savpri;
	caddr_t                buf;

	savpri = spldb();

	while ( (bp = freebph) == NULL )
	{
		bufstat.bp.fail++;
		bufstat.eblk.fail++;
		wantbp = 1;
		sleep((caddr_t)&wantbp, PRIBIO + 1);
	}
	ASSERT(bp >= bppoolp);
	ASSERT(bp < bppoolp + numbp);

	/* take bp off the freelist */
	freebph = bp->av_forw;
	BUMPUSE(bufstat.bp);
	ASSERT(freebph == NULL || freebph >= bppoolp);
	ASSERT(freebph < bppoolp + numbp);
	ASSERT(bufstat.bp.use <= numbp);

	while ( (buf = (caddr_t)malloclast(buffermap, BSIZE, eblklimit)) == 0 )
	{
		freebuf = 0;
		bufstat.buf.fail++;
		bufstat.eblk.fail++;
		wantbuf = 1;
		sleep((caddr_t)&wantbuf, PRIBIO + 1);
	}

	BUMPUSE(bufstat.buf);
	ASSERT(bufstat.buf.use <= numbuf);
	BUMPUSE(bufstat.eblk);
	bp->b_un.b_addr = buf;
	eblkuse++;

	splx(savpri);
	bp->b_flags = B_BUSY;
	bp->b_error = 0;
	bp->b_dev = (dev_t)NODEV;
	bp->b_kbp = (void *)bp;		/* flag. bp is now in use */
	bp->b_bcount = BSIZE;
	bp->b_iflags = BI_BUF;

	return(bp);
}

/******************************************************************************/
brelse(bp)
register struct i_buf  *bp;
{
	int          savpri;

	savpri = spldb();

	ASSERT(bp >= bppoolp);
	ASSERT(bp < bppoolp + numbp);
	ASSERT(bp->b_kbp);
	ASSERT(bp->b_un.b_addr >= eblklimit);
	ASSERT(bp->b_un.b_addr < bufferp + numbuf * BSIZE);

	eblkuse--;

	ASSERT(!((uint)bp->b_un.b_addr & BSIZE - 1));
	mfree(buffermap, BSIZE, (uint)bp->b_un.b_addr);
	freebuf = 1;
	bufstat.buf.use--;
	ASSERT(bufstat.buf.use < numbuf);

	bp->b_kbp = 0;			/* flag. bp is now free */
	bp->av_forw = freebph;
	freebph = bp;
	bufstat.bp.use--;
	bufstat.eblk.use--;
	ASSERT(bufstat.bp.use < numbp);

	/* Now that we have freed a bp we can wakeup geteblk OR sched bufmgr */
	/* Give preference to geteblk */
	if ( wantbp )			/* geteblk waiting for bp ? */
	{
		wantbp = 0;
		wakeup((caddr_t)&wantbp);
	}
	else if ( bphead )		/* bufmgr waiting for bp ? */
		softintr();

	/* Now that we have freed a buf we can wakeup geteblk OR sched bufmgr */
	/* Give preference to geteblk */
	if ( wantbuf )			/* geteblk waiting for buf ? */
	{
		wantbuf = 0;
		wakeup((caddr_t)&wantbuf);
	}
	else if ( bufhead )	/* bufmgr waiting for buf ? */
		softintr();

	splx(savpri);
}

/******************************************************************************/
/* This is the routine the IOPM os uses to get a local buf header for the buf
/* request recieved from the kernel.
*/
struct i_buf *
getbp()
{
	register struct i_buf  *bp;
	int                    savpri;
	caddr_t                buf;

	savpri = spldb();

	if ( (bp = freebph) == NULL )
	{
		bufstat.bp.fail++;
		splx(savpri);
		PRINT(RESOURCE,"out of buf headers");
		return(0);
	}
	ASSERT(bp >= bppoolp);
	ASSERT(bp < bppoolp + numbp);

	/* take bp off the freelist */
	freebph = bp->av_forw;
	BUMPUSE(bufstat.bp);
	ASSERT(freebph == NULL || freebph >= bppoolp);
	ASSERT(freebph < bppoolp + numbp);
	ASSERT(bufstat.bp.use <= numbp);
	bp->b_iflags = 0;
	splx(savpri);

	return(bp);
}

/******************************************************************************/
/* Free a buf header allocated by the IOPM os.  Depending on the capibilities
/* of the device board, the buf header may be assosiated with a buffer in the
/* IOPM memory or it may be associated with a buffer in main memory.
*/
freebp(bp)
register struct i_buf  *bp;
{
	int  savpri;

	savpri = spldb();

	ASSERT(bp->b_kbp);
	bp->b_kbp = 0;			/* flag. bp is now free */

	if ( bp->b_iflags & BI_BUF )
	{
		ASSERT(bp >= bppoolp);
		ASSERT(bp < bppoolp + numbp);
		ASSERT(bp->b_un.b_addr >= bufferp);
		ASSERT(bp->b_un.b_addr < bufferp + numbuf * BSIZE);
		ASSERT(!((uint)bp->b_un.b_addr & BSIZE - 1));

		mfree(buffermap, (bp->b_bcount + BSIZE - 1) & ~(BSIZE - 1),
		   bp->b_un.b_addr);
		freebuf = 1;
		bufstat.buf.use -= (bp->b_bcount + BSIZE - 1) / BSIZE;
		ASSERT(bufstat.buf.use < numbuf);

		if ( wantbuf && bp->b_un.b_addr > eblklimit )
			wakeup((caddr_t)&wantbuf);
		else if ( bufhead )
			softintr();
	}
	bp->av_forw = freebph;
	freebph = bp;
	bufstat.bp.use--;
	ASSERT(bufstat.bp.use < numbp);

	if ( wantbp )
		wakeup((caddr_t)&wantbp);
	else if ( bufhead )
		softintr();

	splx(savpri);
}

/******************************************************************************/
caddr_t
getbuf(size)
uint  size;		/* in BSIZE chunks */
{
	int      savpri;
	caddr_t  buf;

	savpri = spldb();

	if ( (buf = (caddr_t)malloc(buffermap, size * BSIZE)) == 0 )
	{
		freebuf = 0;
		bufstat.buf.fail++;
		splx(savpri);
		return 0;
	}

	bufstat.buf.use += size;
	bufstat.buf.total += size;
	bufstat.buf.max = (bufstat.buf.use > bufstat.buf.max ?
	  bufstat.buf.use : bufstat.buf.max);

	ASSERT(bufstat.buf.use <= numbuf);
	ASSERT(buf >= bufferp);
	ASSERT(buf < bufferp + numbuf * BSIZE);
	splx(savpri);

	return buf;
}

/******************************************************************************/
clrbuf(bp)
register struct i_buf  *bp;
{
	uint     savmap;
	caddr_t  dest;
	uint     cnt;
	uint     xfer = 0;
	caddr_t  vmap();

	savmap = vmap_save();
	while ( xfer < bp->b_bcount )
	{
		dest = vmap(bp->b_un.b_addr + xfer, (struct proc *)bp->b_proc);
		cnt = min(bp->b_bcount - xfer, NBPP - ((uint)dest & (NBPP-1)));

		bzero(dest + xfer, cnt);

		xfer += cnt;
	}
	vmap_restore(savmap);

	bp->b_resid = 0;
}

/******************************************************************************/
iowait(bp)
struct i_buf  *bp;
{
	int  savpri = spldb();

	while ( (bp->b_flags & B_DONE) == 0 )
		sleep((caddr_t)bp, PRIBIO);

	if ( bp->b_flags & B_ERROR && (iu.u_error = bp->b_error) == 0 )
		iu.u_error = EIO;

	splx(savpri);
}

/******************************************************************************/
iodone(bp)
struct i_buf  *bp;
{
	register struct buf  *kbp = (struct buf *)bp->b_kbp;
	extern struct buf    *phys_head;
	extern uint          vmap_save();
	extern caddr_t       vmap();

	PRINT3(DATA, "iodone: bp = %x, kbp=%x, dev=%x\n", bp, kbp, bp->b_dev);

	if ( kbp == (struct buf *)bp )	/* bp obtained by geteblk */
	{
		bp->b_flags |= B_DONE;
		wakeup((caddr_t)bp);
		return;
	}

	ASSERT(valid_pm_addr(kbp));	/* bp obtained by IOPM OS */

	kbp->b_resid = bp->b_resid;

	if ( bp->b_flags & B_ERROR )
	{
		kbp->b_driver_flags |= B_ERROR;
		kbp->b_error = bp->b_error;
	}
	else
	{
		/* if there is an IOPM buffer associated with this bp, copy */
		if ( bp->b_flags & B_READ && bp->b_iflags & BI_BUF )
		{
			uint     savmap = vmap_save();
			caddr_t  src = bp->b_un.b_addr;
			caddr_t  dest;
			uint     cnt;
			uint     xfer = 0;

			while ( xfer < bp->b_bcount )
			{
				dest = vmap(kbp->b_un.b_addr+xfer, kbp->b_proc);
				cnt = min(bp->b_bcount - xfer,
				  NBPP - ((uint)dest & (NBPP - 1)));

				PRINT3(DATA,"bcopy(%x %x %x)\n",
				   src + xfer, dest, cnt);

				bcopy(src + xfer, dest, cnt);

				PRINT1(DATA,"data %x\n",*(uint *)dest);

				xfer += cnt;
			}

			vmap_restore(savmap);
		}
	}

	sendbuftokernel(kbp);

	freebp(bp);
}

/******************************************************************************/
/* Initializes pools of buffer headers w/ & w/o buffers and the pool of
/* PHYSIO buffers for compiled in drivers.
*/
binit()
{
	register i_buf_t  *bp;
	register caddr_t  pbufp;
	register uint     n;

	mapinit(buffermap, nbuffermap);

	/* for compiled in drivers, space.c will set bppoolp and numbp */
	if ( bppoolp && numbp )
	{
		freebph = bppoolp;
		for ( bp = bppoolp, n = 0; n < numbp - 1; bp++, n++ )
		{
			bp->b_un.b_addr = 0;
			bp->av_forw = bp + 1;
		}
		bp->av_forw = NULL;
		iopmcomm.bparray = bppoolp;
		iopmcomm.numbp = numbp;
	}

	if ( bufferp && numbuf )
	{
		bufferp = (caddr_t)((uint)bufferp + BSIZE - 1 & ~(BSIZE - 1));
		mfree(buffermap, numbuf * BSIZE, bufferp);
		iopmcomm.bufarray = bufferp;
		iopmcomm.numbuf = numbuf;

		if ( numbuf > MAXPHYS )
			eblklimit = bufferp + MAXPHYS * BSIZE;
		else
			/* reserve 70% for geteblk */
			eblklimit = bufferp + (7 * numbuf / 10) * BSIZE;
	}
}

/******************************************************************************/
/* Used to dynamically configure number of buffer headers w/o buffers.
/* Return 1 for ok, 0 for fail
*/
setnumbp(reqnbp)
uint reqnbp;
{
	int                savpri;
	register int       numpg;
	register i_buf_t   *bp;

	PRINT1(CONFIG,"setnumbp: reqnbp %x, ",reqnbp);

	if ( numbp )
		return 0;

	savpri = spldb();
	numpg = btoc(reqnbp * sizeof(i_buf_t));
	bppoolp = (i_buf_t *)(memalloc(numpg) << PNUMSHFT);
	if ( bppoolp == 0 )
	{
		splx(savpri);
		return 0;
	}

	PRINT2(CONFIG, "%d pages of bp's at %x\n", numpg, bppoolp);

	bzero((caddr_t)bppoolp, numpg * NBPP);

	numbp = (numpg * NBPP) / sizeof(i_buf_t);
	freebph = bppoolp;
	for ( bp = bppoolp; bp < bppoolp + numbp; bp++ )
	{
		bp->b_un.b_addr = 0;
		bp->av_forw = bp + 1;
	}
	bp->av_forw = NULL;

	iopmcomm.bparray = bppoolp;
	iopmcomm.numbp = numbp;

	splx(savpri);
	return 1;
}

/******************************************************************************/
/* Used to dynamically configure number of buffers
/* Return 1 for ok, 0 for fail
*/
setnumbuf(reqnbuf)
uint reqnbuf;
{
	int  savpri;

	PRINT1(CONFIG,"setnumbuf: reqnbuf %x, ",reqnbuf);

	if ( numbuf )
		return 0;

	savpri = spldb();
	bufferp = (caddr_t)(memalloc((int)btoc(reqnbuf * BSIZE)) << PNUMSHFT);
	if ( bufferp == 0 )
	{
		splx(savpri);
		return 0;
	}

	PRINT1(CONFIG, "buffers at %x\n", bufferp);

	numbuf = reqnbuf;

	ASSERT(!((uint)bufferp & BSIZE - 1));
	mfree(buffermap, numbuf * BSIZE, bufferp);

	iopmcomm.bufarray = bufferp;
	iopmcomm.numbuf = numbuf;

	if ( numbuf > MAXPHYS )
		eblklimit = bufferp + MAXPHYS * BSIZE;
	else
		/* reserve 70% for geteblk */
		eblklimit = bufferp + (7 * numbuf / 10) * BSIZE;

	splx(savpri);
	return 1;
}

/******************************************************************************/
/* No strat routine for buf drivers w/o strat routines
*/
void
nostrat(bp)
register struct i_buf  *bp;
{
	bp->b_flags |= B_ERROR;
	bp->b_error = ENODEV;
	iodone(bp);
}

