#	START NEW ARIX SCCS HEADER
#
#	@(#) ttrap.s: version 25.1 created on 11/27/91 at 14:47:53
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)ttrap.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#
	ident	"@(#)ttrap.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"

	global	nullvect
	global	buserr			#vector address 8
	global	auto1
	global	auto2
	global	auto3
	global	auto4
	global	auto6
	global	auto7
	global	TDB_vector
	global	autoend

	text

#-------------------------------------------------------------------------------
buserr:
	movm.l	&0xfffe,-(%sp)		# save all registers

	mov.w	%sr,%d0
	or.w	&0x0700,%d0
	mov.w	%d0,%sr			# spl7

	mov.l	%sp,%a0
	mov.l	%a0,-(%sp)		# pass stack frame pointer to k_buserr

	jsr	k_buserr		# handle user mode bus error

	addq.l	&4,%sp
	movm.l	(%sp)+,&0x7fff		# restore registers

	tst.l	faultaddr		# test for expected fault
	beq	stop_processor		# not expected
	clr.l	faultaddr
	rte

#-------------------------------------------------------------------------------
auto1:
	mov.b	&0x07,(0xfd800000)	# led 1 on
	mov.b	&INTR1_OFF,int_ctrl_reg
	movm.l	&0xc0c0,-(%sp)		# save d0,d1,a0,a1

	jsr	cssintr			# service kernel requests

	tst.l	timeflg			# timeout servicing?
	beq.b	auto1_1
	clr.l	timeflg
	jsr	timein
auto1_1:
	tst.l	iopmcmd			# new configuration commands?
	beq.b	auto1_2
	pea	iopmcmd			# push argument to wakeup
	jsr	wakeup
	addq.l	&4,%sp
auto1_2:
	movm.l	(%sp)+,&0x0303		# restore a1,a0,d1,d0
	rte

#-------------------------------------------------------------------------------
auto2:
	mov.b	&0x07,(0xfd800000)	# led 1 on
	mov.b	&INTR2_OFF,int_ctrl_reg
	movm.l	&0xc0c0,-(%sp)		# save d0,d1,a0,a1
	jsr	catch
	movm.l	(%sp)+,&0x0303		# restore a1,a0,d1,d0
	rte

#-------------------------------------------------------------------------------
auto3:
mov.b	&0x07,(0xfd800000)	# led 1 on
	mov.b	&INTR3_OFF,int_ctrl_reg
	rte

#-------------------------------------------------------------------------------
auto4:
mov.b	&0x07,(0xfd800000)	# led 1 on
	movm.l	&0xc0c0,-(%sp)		# save d0,d1,a0,a1

#	jsr	board intr serv

	tst.l	qrunflag
	beq.b	auto4_1
	jsr	runqueues
auto4_1:
	movm.l	(%sp)+,&0x0303		# restore a1,a0,d1,d0
	rte

#-------------------------------------------------------------------------------
auto5:
mov.b	&0x07,(0xfd800000)	# led 1 on
	movm.l	&0xc0c0,-(%sp)		# save d0,d1,a0,a1

# jsr intr service

	tst.l	qrunflag
	beq.b	auto5_1
	jsr	runqueues
auto5_1:
	movm.l	(%sp)+,&0x0303		# restore a1,a0,d1,d0
	rte

#-------------------------------------------------------------------------------
auto6:
	mov.b	&0x07,(0xfd800000)	# led 1 on
	mov.b	&INTR6_OFF,int_ctrl_reg
	movm.l	&0xc0c0,-(%sp)		# save d0,d1,a0,a1
	mov.l	18(%sp), -(%sp)		# pass pc
	jsr	clock
	addq	&4, %sp
	movm.l	(%sp)+,&0x0303		# restore a1,a0,d1,d0
	rte

#-------------------------------------------------------------------------------
auto7:
	mov.b	&0x07,(0xfd800000)	# led 1 on
	mov.b	&INTR7_OFF,int_ctrl_reg
	cmp.b	(error_stat_reg),&0xff
	beq.b	TDB_vector

	movm.l	&0xfffe,-(%sp)		# save registers
	mov.l	%sp,%a0
	mov.l	%a0,-(%sp)		# pass stack frame pointer
	jsr	boarderr

	mov.l	(%sp)+,%a0
	mov.l	%a0,%sp
	movm.l	(%sp)+,&0x7fff
					# fall thru to tdb

#-------------------------------------------------------------------------------
nullvect:
TDB_vector:
	mov.w	&0x2700,%sr		# spl7
	tst.l	in_tdb
	beq.b	enter_tdb
	rte

enter_tdb:
	add.l	&1, in_tdb		# prevent re-entrance
	movm.l	&0xfffe,-(%sp)		# save registers
	mov.l	%sp,%a0
	mov.l	%a0,-(%sp)		# pass stack frame pointer

	jsr	cache_disable		# disable and freeze cache
	mov.l	%d0, sav_cacr

	jsr	tdb

	mov.l	sav_cacr, -(%sp)
	jsr	cache_restore		# restore cache control
	addq.l	&4, %sp

	mov.l	(%sp)+,%a0
	mov.l	%a0,%sp
	movm.l	(%sp)+,&0x7fff
	sub.l	&1, in_tdb
	rte
autoend:

	data

sav_cacr:
	long	0
