#	START NEW ARIX SCCS HEADER
#
#	@(#) misc.s: version 25.1 created on 11/27/91 at 14:47:40
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)misc.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#

	global	mmuasm
	global	mflush
	global	cache_enable
	global	cache_disable
	global	cache_restore
	global	set_pc_sp
	global	setjmp		# set up environment for non_local goto
	global	longjmp		# non-local goto
	global	save		# saves register sets
	global	resume		# restores registers, then longjmps
	global	bcopy
	global	bzero
	global	min,max
	global	spl0, spl1, spl2, spl3, spl4, spl5, spl6, spl7
	global	splstr, splserv, spldb, spllo
	global	splhi, splx
	global	stop_processor
	global	idle
	global	spinlock
	global	spinunlock
	global	upkern_inc
	global	set_vbr, get_vbr
	global	add_chain
	global	remove_chain
	global	atom_or, atom_and
	global	atom_or_short, atom_and_short
	global	atom_add, atom_sub
	global	cas_long
	global	dizzy_lock, dizzy_unlock

	text

#------------------------------------------------------------------
mmuasm:
	pmove	tt0init,%tt0
	pmove	tt1init,%tt1
	pmove	crpinit,%crp
	pmove	tcinit,%tc
	rts

mflush:
	pflusha
	rts

#------------------------------------------------------------------
	set	CD, 0x800		# clear data cache
	set	IBE, 0x10		# instruction burst enable
	set	CI, 0x8			# clear instruction cache
	set	FI, 0x2			# freeze instruction cache
	set	EI, 0x1			# enable instruction cache

cache_enable:
	mov.l	%cacr, %d0		# return old value
	mov.l	&IBE+EI+CI+CD, %a0	# enable instruction cache & burst
	mov.l	%a0, %cacr
	rts

cache_disable:
	mov.l	%cacr, %d0		# return old value
	mov.l	&FI, %a0		# freeze instruction cache
	mov.l	%a0, %cacr
	rts

cache_restore:
	mov.l	%cacr, %d0		# return old value
	mov.l	4(%sp), %d1
	or.l	&CI+CD, %d1
	mov.l	%d1, %cacr
	rts

#------------------------------------------------------------------
#
#	B C O P Y
#
#	bcopy(source, destination, count)
#
#------------------------------------------------------------------

bcopy:
	mov.l	4(%sp),%a0		# source
	mov.l	8(%sp),%a1		# destination
	mov.l	12(%sp),%d0
	beq.b	bc090%			# zero count
	mov.l	%a0,%d1
	or.l	8(%sp),%d1
	and.l	&1,%d1			# word aligned
	beq.b	bc030%

bc005%:
	subq.l	&1,%d0

bc010%:
	mov.b	(%a0)+,(%a1)+
	dbvs	%d0,bc010%		# NOTE: 16 bit decrement only
	sub.l	&0x10000,%d0
	bcc.b	bc010%
bc090%:
	rts
bc030%:
	mov.l	%d0,%d1
	lsr.l	&5,%d1
	beq.b	bc005%			# less than 32 bytes left
	subq.l	&1,%d1			# don't do last 32 bytes in a page
	beq.b	bc005%
bc050%:					# do move multiple for 3x
	movm.l	&0x3f3c,-(%sp)		# save registers
	mov.l	&32,%d2
	mov.l	%a1,%d3			# d3 tracks a1
	subq.l	&1,%d1			# adjust for -1 termination
bc060%:
	movm.l	(%a0)+,&0x3cf0
	movm.l	&0x3cf0,(%a1)
	add.l	%d2,%d3
	mov.l	%d3,%a1
	dbvs	%d1,bc060%
	movm.l	(%sp)+,&0x3cfc		# restore registers
	mov.l	%d0,%d1
	lsr.l	&5,%d1
	subq.l	&1,%d1			# last 32 bytes of a page
	lsl.l	&5,%d1
	sub.l	%d1,%d0
	bne.b	bc005%			# some less than 32 left
	rts	
	
#------------------------------------------------------------------
#
#	B Z E R O
#
#	bzero(address, count)
#
#------------------------------------------------------------------

bzero:
	mov.l	4(%sp),%d1		# address
	mov.l	8(%sp),%d0		# count
	add.l	%d0,%d1
	mov.l	%d1,%a0
	mov.l	&0,%a1
bz010%:
	mov.l	%a0,%d1
	and.l	&1,%d1
	beq.b	bz020%			# word boundary
	clr.b	-(%a0)
	subq.l	&1,%d0
	bne.w	bz020%
	rts
bz020%:
	mov.l	%d0,%d1
	lsr.l	&5,%d1			# see if 32 bytes left
	beq.b	bz023%			# no
	subq.l	&1,%d1			# don't do last 32 bytes of a page
	beq.b	bz023%
	lsl.l	&5,%d1
	sub.l	%d1,%d0			# adjust # of bytes left
	lsr.l	&5,%d1
	subq.l	&1,%d1
	movm.l	&0xbf00,-(%sp)		# save d0,d2-d7 registers
	clr.l	%d0
	clr.l	%d2
	clr.l	%d3
	clr.l	%d4
	clr.l	%d5
	clr.l	%d6
	clr.l	%d7
bz022%:
	movm.l	&0xbf40,-(%a0)		# use a1,d0,d2-d7
	dbvs	%d1,bz022%
	movm.l	(%sp)+,&0x00fd		# restore regs
bz023%:
	mov.l	%d0,%d1			# check if any long words 
	lsr.l	&2,%d1
	beq.b	bz025%
	subq.l	&1,%d1
bz024%:
	mov.l	%a1,-(%a0)		# clear long words
	dbvs	%d1,bz024%
bz025%:
	and.l	&3,%d0
	beq.b	bz090%			# check if 1 to 3 bytes left
bz030%:
	clr.b	-(%a0)
	subq.l	&1,%d0
	bra.b	bz025%
bz090%:
	rts


#--------------------------------------------------------------------
#
#	M I N
#
#	returns the minimum of 2 unsigned int
#
#	i = min((uint)a, (uint)b);
#
#--------------------------------------------------------------------

min:
	mov.l	4(%sp),%d0
	cmp.l	%d0,8(%sp)
	bls.w	min010
	mov.l	8(%sp),%d0
min010:
	rts

#--------------------------------------------------------------------
#
#	M A X
#
#	returns the maximum of 2 unsigned int
#
#	i = max((uint)a, (uint)b);
#
#--------------------------------------------------------------------

max:
	mov.l	4(%sp),%d0
	cmp.l	%d0,8(%sp)
	bcc.w	max010
	mov.l	8(%sp),%d0
max010:
	rts


#-----------------------------------------------------------------------------
#
#	S Y S T E M    P R I V I L E G E    L E V E L S
#
#-----------------------------------------------------------------------------

spllo:
spl0:
	mov.w	%sr,%d0		# previous level
	and.w	&0xf8ff,%sr
	rts

spl1:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0100,%d1
	mov.w    %d1,%sr
	rts

splserv:
spl2:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0200,%d1
	mov.w    %d1,%sr
	rts

spl3:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0300,%d1
	mov.w    %d1,%sr
	rts

spl4:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0400,%d1
	mov.w    %d1,%sr
	rts

splstr:
spldb:
spl5:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0500,%d1
	mov.w    %d1,%sr
	rts

spl6:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0600,%d1
	mov.w    %d1,%sr
	rts

splhi:
spl7:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	or.w	&0x0700,%d1
	mov.w    %d1,%sr
	rts

splx:
	# coming in
	#
	#
	#sp-->	pc high word
	#	pc low word
	#	junk
	#	sr
	#
	#
	mov.l	(%sp)+, %a0		# save pc in %a0
	clr.w	-(%sp)			# clear format/vector info
	mov.l	%a0, -(%sp)		# push pc back on stack
	mov.w	8(%sp), %d0		# grab sr
	mov.w	%d0, -(%sp)		# copy sr into position
	#sp->	sr
	#	pc high word
	#	pc low word
	#	0
	#	junk
	#	sr
	rte

#-------------------------------------------------------------------------------
#
#	S E T _ P C _ S P
#
#	change pc and sp to new values.
#	no return
#
#-------------------------------------------------------------------------------

set_pc_sp:
	mov.l	(%sp)+,%a0	# toss return PC, it won't we needed
	mov.l	(%sp)+,%a0	# new pc will be needed
	mov.l	(%sp),%sp	# set new sp value
	mov.l	&0,%a6		# set frame pointer to 0, helps backtrace
	jmp	(%a0)		# jmp to new pc

#-------------------------------------------------------------------------------
#
#	S E T J M P , L O N G J M P
#
#	S A V E , R E S U M E
#
#-------------------------------------------------------------------------------

# setjmp (save_area)
# save (save_area)
#	saves registers and return location in save_area


setjmp:
save:
	mov.l	(%sp)+,%a1	# pop return address of calling routine into %a1
	mov.l	(%sp),%a0	# address of save area
	movm.l	&0xfefc,(%a0)	# save a7-a1,d7-d2
	mov.l	&0,%d0		# return(0)
	jmp	(%a1)


# longjmp (save_area, [value])
#	resets registers from save_area and returns to the location
#	from WHERE setjmp() WAS CALLED.
#	** Never returns 0 - this lets the returned-to environment know that the
#	return was the result of a long jump.

longjmp:
	mov.l	4(%sp),%a0	# get address of save_area
	mov.l	8(%sp),%d0	# value returned
	bne.b	long1%		# branch if not zero
	mov.l	&1,%d0		# set to one
long1%:
	movm.l	(%a0),&0xfefc	# restore a7-a1,d7-d2
	jmp	(%a1)


# resume ( save_area )
#	Retores another task's registers. Returns non-zero.

resume:
	mov.l	4(%sp),%a0	# address of save_area
	movm.l	(%a0),&0xfefc	# restore previous a7-a1,d7-d2
	mov.l	&1,%d0		# return (1)
	jmp	(%a1)		# return to save caller

#-------------------------------------------------------------------------------
#	stop_processor

stop_processor:
	stop	&0x2700
	bra.b	stop_processor

#-------------------------------------------------------------------------------
#	idle with interrupts enabled
#	always leaves with interrupts enabled

idle:
	mov.w	&0x2700,%sr	# splhi()
	tst.l	runq		# task ready to run?
	bne.b	idle1		# yes

	tst.l	qrunflag	# queues ready to run?
	bne.b	idle1		# yes

	mov.b	&0x0f,(0xfd800000)	# led 1 off
	stop	&0x2000		# spl0() and wait for intr

	bra.b	idle		# nothing ready to run. wait for next intr
idle1:
	mov.w	&0x2000,%sr
	rts

#-------------------------------------------------------------------------------
#	spinlock(&lock),  spinunlock(&lock)

spinlock:
	mov.l	4(%sp),%a0	# addr of spin lock
ifdef(`ASDEBUG',
`	jsr	cas_check')
	mov.w	%sr,%d0		# save sr
	mov.l	&0,%d1
	or	&0x0700,%sr	# spl7()
	cas.w	%d1,%d0,(%a0)
	bne	spinlockfail

	mov.b	own_slot,2(%a0)	# slot num
	mov.l	(%sp),4(%a0)	# diag. save pc of caller
	add.l	&1,8(%a0)	# inc lock didn't have to wait count
	add.l	&1,spin_lock_count
	rts

spinlockfail:
	mov.l	&0,%a1		# init wait count
spin_fail_again:
	mov.w	%d0,%sr		# restore sr

	mov.l	&100,%d1	# wait with out touching main system memory
spinlockloop:
	dbne	%d1,spinlockloop

	add.l	&100,%a1	# inc wait count
	tst.w	(%a0)		# spin lock free?
	beq.b	spin_try_again	# yes
	bra.b	spin_fail_again

spin_try_again:
	mov.l	&0,%d1
	or	&0x0700,%sr	# spl7()
	cas.w	%d1,%d0,(%a0)
	bne	spin_fail_again

	mov.b	own_slot,2(%a0)	# slot num
	mov.l	(%sp),4(%a0)	# diag. save pc of caller
	add.l	&1,12(%a0)	# inc collision count
	add.l	&1,spin_lock_count
	mov.l	%a1,%d1
	add.l	%d1,16(%a0)	# inc wait count
	rts

spinunlock:
	# coming in
	#
	#
	#sp-->	pc high word
	#	pc low word
	#	addr high of spinlock
	#	addr low of spinlock
	#
	#
	sub.l	&1,spin_lock_count
	mov.l	4(%sp), %a0		# grab spinlock addr
	mov.l	(%sp)+, %a1		# pop pc in %a1
	clr.w	-(%sp)			# clear format/vector info
	mov.l	%a1, -(%sp)		# push pc back on stack
	mov.w	(%a0), -(%sp)		# copy old sr into position
	beq.b	spinerror
ifdef(`M68040',
`	mov.w	&0,%d1			# the 040 *always* writes on a cas
	mov.w	(%a0),%d0		# this clear must be atomic wrt spinlock
	cas.w	%d0,%d1,(%a0)		# clear the lock',
`	clr.w	(%a0)')			# clear lock
	#sp->	old sr
	#	pc high word
	#	pc low word
	#	0
	#	addr high of spinlock
	#	addr low of spinlock
	rte

spinerror:
	trap	&0
	rts

#-------------------------------------------------------------------------------
# UPKERN support
#
#	typedef struct {
#		ushort	up_cnt;		/* reference count of lock */
#		ushort	up_id;		/* id of processor that has lock */
#	} upkern_t;
# 
# up_id is up_slot for PM20 boards.
# Note that the upkern is dealt with as a single 32 bit quantity by these
# routines, as well as two 16 bit quantities.
#
# upkern_inc()	atomically increment upkern.up_cnt, making it stick to a slot.
#
#		up_cnt is upkern.up_cnt
#		up_id is upkern.up_id
#		old_up_cnt is %d0
#		new_up_cnt is %d1

upkern_inc:
	mov.l	&upkern, %a0	# address of upkern data struct
ifdef(`ASDEBUG',
`	jsr	cas_check')
	mov.w	(%a0), %d0	# old_up_cnt = up_cnt
upkern_inc_loop:
	mov.w	%d0, %d1	# new_up_cnt = old_up_cnt
	add.w	&1, %d1		# increment copy of up_cnt
	cas.w	%d0, %d1, (%a0) # up_cnt == old_up_cnt ? up_cnt = new_up_cnt :
				#			 old_up_cnt = up_cnt
	bne.b	upkern_inc_loop	# if we failed %d0 was updated to current value
	clr.l	%d0		# we succeded
	mov.w	2(%a0), %d0	# return up_id
	rts

#-------------------------------------------------------------------------------
# int get_vbr()
# int set_vbr( &vector_base_pointer )
get_vbr:
	mov.l	%vbr, %d0
	rts

set_vbr:
	mov.l	4(%sp), %d0
	mov.l	%d0, %vbr
	rts

#-------------------------------------------------------------------------------
# add_chain( &headptr, &newelement, &newelementptr )

add_chain:
	mov.l	4(%sp),%a0	# address of head pointer
ifdef(`ASDEBUG',
`	jsr	cas_check')
	mov.l	8(%sp),%d1	# address of new element
	mov.l	12(%sp),%a1	# address of new element forward pointer
	mov.l	(%a0),%d0	# head for comparison
add_loop:
	mov.l	%d0,(%a1)	# setup new element forward pointer
	cas.l	%d0,%d1,(%a0)	# change head pointer to new element
	bne.b	add_loop	# failed to add new element
	rts

#-------------------------------------------------------------------------------
# int remove_chain( &head_pointer )
#
#	returns (int)pointer to first element in %d0 not pointer in %a0

remove_chain:
	mov.l	4(%sp),%a0
ifdef(`ASDEBUG',
`	jsr	cas_check')
remove_loop:
	mov.l	(%a0),%d0	# is first element on chain null?
	beq.b	remove_done	# yes. (return null)
	mov.l	&0,%d1		# new head_pointer will be 0. ie remove chain
	cas.l	%d0,%d1,(%a0)
	bne.b	remove_loop	# cas not done. try again
remove_done:
	rts			# return first element on chain

#-------------------------------------------------------------------------------
# ulong
# atom_and(&ulong, and_val)	and-s and_val into ulong using a cas, returns d0
#

atom_and:
	mov.l	4(%sp), %a0		# load address of ulong into a0
ifdef(`ASDEBUG',
`	jsr	cas_check')
	mov.l	8(%sp), %a1		# load and_val into a1
	mov.l	(%a0), %d0		# pre-load ulong's value into d0
atom_and_loop:
	mov.l	%a1, %d1
	and.l	%d0, %d1		# d1 = d0 & a1
	cas.l	%d0, %d1, (%a0)
	bne.b	atom_and_loop
	rts

#-------------------------------------------------------------------------------
# ulong
# atom_or(&ulong, or_val)	or-s or_val into ulong using a cas, returns prev
#
atom_or:
	mov.l	4(%sp), %a0		# load address of ulong into a0
ifdef(`ASDEBUG',
`	jsr	cas_check')
	mov.l	8(%sp), %a1		# load or_val into a1
	mov.l	(%a0), %d0		# pre-load ulong's value into d0
atom_or_loop:
	mov.l	%a1, %d1
	or.l	%d0, %d1		# d1 = d0 | a1
	cas.l	%d0, %d1, (%a0)
	bne.b	atom_or_loop
	rts

#-------------------------------------------------------------------------------
# ushort
# atom_or_short(addr, or_val)
# unshort *addr;
# unshort or_val;
# {
#	unshort retval = *addr;
#	*addr |= or_val;
#	return(retval);
# }
#
# atom_or_short -- or in bits and return prev value
# atom_and_short -- same as atom_or_byte except and in bits

atom_or_short:
	mov.l	4(%sp), %a0		# get address of byte
ifdef(`ASDEBUG',
`	jsr	cas_check')
	mov.l	&0, %d0			# retval = 0
atom_or_short_loop:
	mov.l	8(%sp), %d1		# get bit mask to or in
	mov.w	(%a0), %d0		# get current value of byte
	or.w	%d0, %d1		# or current value with mask
	cas.w	%d0, %d1, (%a0)		# try to make a change
	bne.b	atom_or_short_loop	# if it changed on us, try again
	rts				# d0 contains prev value

atom_and_short:
	mov.l	4(%sp), %a0		# get address of byte
ifdef(`ASDEBUG',
`	jsr	cas_check')
	mov.l	&0, %d0			# retval = 0
atom_and_short_loop:
	mov.l	8(%sp), %d1		# get bit mask to or in
	mov.w	(%a0), %d0		# get current value of byte
	and.w	%d0, %d1		# and current value with mask
	cas.w	%d0, %d1, (%a0)		# try to make a change
	bne.b	atom_and_short_loop	# if it changed on us, try again
	rts				# d0 contains prev value

#-------------------------------------------------------------------------------
# ulong
# atom_add(&ulong, add_val)	adds add_val to ulong using a cas, returns prev
#

atom_add:
	mov.l	4(%sp), %a0		# load address of ulong into a0
ifdef(`ASDEBUG',
`	jsr	cas_check')
	mov.l	8(%sp), %a1		# load add_val into a1
	mov.l	(%a0), %d0		# pre-load ulong's value into d0
atom_add_loop:
	mov.l	%a1, %d1
	add.l	%d0, %d1		# d1 = d0 + a1
	cas.l	%d0, %d1, (%a0)
	bne.b	atom_add_loop
	rts

#-------------------------------------------------------------------------------
# ulong
# atom_sub(&ulong, sub_val)	subtracts sub_val from ulong, returns prev value
#

atom_sub:
	mov.l	4(%sp), %a0		# load address of ulong into a0
ifdef(`ASDEBUG',
`	jsr	cas_check')
	mov.l	8(%sp), %a1		# load and_val into a1
	mov.l	(%a0), %d0		# pre-load ulong's value into d0
atom_sub_loop:
	mov.l	%d0, %d1
	sub.l	%a1, %d1		# d1 = d0 - a1
	cas.l	%d0, %d1, (%a0)
	bne.b	atom_sub_loop
	rts

#-------------------------------------------------------------------------------
# cas_long
# cas_long(address, old_val, new_val)
#
#	/* Start atomic sequence */
#	if (*address != old_val)
#		return(0);
#
#	*address = new_val
#	/* End atomic sequence */
#	return(1);

cas_long:
	mov.l	4(%sp), %a0
	mov.l	8(%sp), %d0
	mov.l	12(%sp), %d1
	cas.l	%d0, %d1, (%a0)
	bne.b	L%cas_long_fail
	mov.l	&1, %d0
	bra.b	L%cas_long_out
L%cas_long_fail:
	mov.l	&0, %d0
L%cas_long_out:
	rts

#-------------------------------------------------------------------------------
cas_check:
	cmp.l	%a0,&0xf8000000
	blt.b	cas_check_ok
	cmp.l	%a0,&0xf8800000
	bge.b	cas_check_ok
	trap	&0
cas_check_ok:
	rts

#------------------------------------------------------------------------------
#	dizzy_lock( &lock )
#
dizzy_lock:
	mov.l	4(%sp), %a0		# addr of lock
ifdef(`ASDEBUG',
`	jsr	cas_check		# check lock has CSS addr')
	clr.l	%d0
	mov.w	%sr, %d0
	mov.l	%d0, %a1		# save sr in %a1
	or.w	&0x0700, %sr		# spl7

	# add lock req to list of requesters
	mov.l	(%a0), %d0		# previous head of list. compare value
	mov.l	lock_req_ptr, %d1	# addr of our lock array element.

	mov.l	&1, dizzy		# set spin element to 1
dizzy_lock_cas_again:
	mov.l	%d0, (%d1.l)		# update our lock req next_lock_req.
	cas.l	%d0, %d1, (%a0)		# try to grab lock
	bne.b	dizzy_lock_cas_again

	tst.l	%d0			# was the lock previously free?
	bne.b	dizzy_lock_wait		# if no, branch

	clr.l	dizzy			# clear dizzy element
	mov.l	iopm_lock_id, 8(%a0)	# save our id in lock
	addq.l	&1, 16(%a0)		# inc non-collision count in lock
dizzy_lock_got_it:
	mov.l	%a1, 4(%a0)		# save psw in lock
	mov.l	(%sp), 12(%a0)		# save our PC in lock for diagnostics
	addq.l	&1, spin_lock_count
	rts

dizzy_lock_wait:
	clr.l	%d0			# wait counter
dizzy_lock_spin:
	addq.l	&1, %d0
	tst.l	dizzy			# test dizzy element
	bne.b	dizzy_lock_spin

ifdef(`ASDEBUG',
`	tst.l	(%a0)			# ASSERT lock is still locked
	beq	spin_error')
ifdef(`ASDEBUG',
`	mov.l	iopm_lock_id, %d1
	cmp.l	%d1, 8(%a0)		# ASSERT lock_owner == iopm_lock_id
	bne	spin_error')

	addq.l	&1, 20(%a0)		# inc fail count in lock
	add.l	%d0, 24(%a0)		# add to wait count in lock
	bra.b	dizzy_lock_got_it

#------------------------------------------------------------------------------
#	dizzy_unlock( &lock )
#
# Try the case where no one is waiting for the lock first. If we transition
# from locked with no one waiting to free we are done. Else call dizzy_unlock_c
#
# The stack has been modified to do an rte, instead of an rts. This is to force
# a pending interrupt to be taken after the rte (thus in the calling routine),
# instead of in the middle of dizzy_unlock.  This allows the kernel profiler
# somewhat clearer view.

dizzy_unlock:
	mov.l	4(%sp), %a0		# addr of lock

ifdef(`ASDEBUG',
`	mov.l	iopm_lock_id, %d0
	cmp.l	%d0, 8(%a0)		# ASSERT lock_owner == iopm_lock_id
	bne	spin_error')

ifdef(`ASDEBUG',
`	jsr	cas_check		# check lock has CSS addr')

	sub.l	&1, spin_lock_count
ifdef(`ASDEBUG',
`	bcs	spin_error		# ASSERT spin_lock_count was > 0 ')

	mov.l	4(%a0), %a1		# save psw stored in lock
	mov.l	(%a0), %d0		# compare value.
ifdef(`ASDEBUG',
`	beq	spin_error		# ASSERT is lock locked ')

	# coming in				going out
	#					sp-->	old psw
	#						pc high word
	#sp-->	pc high word				pc low word	
	#	pc low word				0
	#	addr high of lock			addr high of lock
	#	addr low of lock			addr low of lock
	#
	mov.l	(%sp)+, %d1		# pop pc into %d1
	clr.w	-(%sp)			# clear format/vector info
	mov.l	%d1, -(%sp)		# push pc back on stack
	mov.w	%a1, -(%sp)		# push psw on stack

	cmp.l	%d0, lock_req_ptr	# anyone (besides us) on list, waiting?
	bne.b	dizzy_unlock_the_hard_way	# if yes, branch
	clr.l	%d1			# update value
	cas.l	%d0, %d1, (%a0)		# try to free lock w/ no waiters
	bne.b	dizzy_unlock_the_hard_way	# if failure, branch
	rte

dizzy_unlock_the_hard_way:
	mov.l	%a0, -(%sp)		# push addr of lock arg
	jsr	dizzy_unlock_c
	addq.l	&4, %sp
	rte

spin_error:
	trap	&0
