/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) build_addr.c: version 25.1 created on 11/27/91 at 14:47:36	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)build_addr.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "sys/types.h"
#include "sys/iopmcomm.h"
#include "sys/spm_mem.h"
#include "sys/sbus_iopm.h"
#include "iopm.h"


struct	kvtab {
	char	*name;
	uint	value;
} kvtab[] = {
	/* variables in iopm_comm */
	{"iopmcomm",	IOPM_COMM},
	{"iopmcmd",	(uint)&((struct iopm_comm *)IOPM_COMM)->iopm_cmd},
	{"ktoib",	(uint)&((struct iopm_comm *)IOPM_COMM)->ktoib},
	{"itokbp",	(uint)&((struct iopm_comm *)IOPM_COMM)->itokbp},
	{"ktois",	(uint)&((struct iopm_comm *)IOPM_COMM)->ktois},
	{"itoksp",	(uint)&((struct iopm_comm *)IOPM_COMM)->itoksp},
	{"qhead",	(uint)&((struct iopm_comm *)IOPM_COMM)->qihead},
	{"qtail",	(uint)&((struct iopm_comm *)IOPM_COMM)->qitail},
	{"bufstat",	(uint)&((struct iopm_comm *)IOPM_COMM)->ibufstat},
	{"strst",	(uint)&((struct iopm_comm *)IOPM_COMM)->istrst},
	{"mbfreelist",	(uint)&((struct iopm_comm *)IOPM_COMM)->imbfreelist},
	{"dbfreelist",	(uint)((struct iopm_comm *)IOPM_COMM)->idbfreelist},
	{"dballoc",	(uint)((struct iopm_comm *)IOPM_COMM)->idballoc},
	{"nqueue",	(uint)&((struct iopm_comm *)IOPM_COMM)->nqueue},
	{"queuep",	(uint)&((struct iopm_comm *)IOPM_COMM)->queuep},
	{"dblkp",	(uint)&((struct iopm_comm *)IOPM_COMM)->dblkp},
	{"mblkp",	(uint)&((struct iopm_comm *)IOPM_COMM)->mblkp},
	{"nblk",	(uint)((struct iopm_comm *)IOPM_COMM)->nblk},
	{"in_tdb",	(uint)&((struct iopm_comm *)IOPM_COMM)->o_tdb.in_tdb},
	{"own_slot",	(uint)&((struct iopm_comm *)IOPM_COMM)->slot},
	{"callo_head",	(uint)&((struct iopm_comm *)IOPM_COMM)->callo_head},
	{"dizzy",	(uint)&((struct iopm_comm *)IOPM_COMM)->dizzy},
	{"iopm_lock_id",(uint)&((struct iopm_comm *)IOPM_COMM)->lock_id},
	{"lock_req_ptr",(uint)&((struct iopm_comm *)IOPM_COMM)->lock_req_ptr},

	/* local variables needed by modules and drivers */
	{"MAJOR",	(uint)MAJOR_TBL},
	{"MINOR",	(uint)MINOR_TBL},

	/* MEMORY segs */
	{"spm_mem",	ADDR_SPM_MEM},
	{"lbolt",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->lbolt},
	{"time",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->spm_time},
	{"upkern",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->upkern},
	{"spm_slot",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->spm_slot},

	/* kernel streams variables in spm_mem */
	{"kqrunflag",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->qrunflag},
	{"kstrbcflag",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->strbcflag},
	{"kallocb_lock",(uint)&((struct spm_mem *)ADDR_SPM_MEM)->allocb_lock},
	{"kdballoc",	(uint)((struct spm_mem *)ADDR_SPM_MEM)->dballoc},
	{"kmbfreelist",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->mbfreelist},
	{"kdbfreelist",	(uint)((struct spm_mem *)ADDR_SPM_MEM)->dbfreelist},
	{"kstrst",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->strst},

	/* virtual iopm memory addresses */
	{"own_stack", OWN_STACK},

	/* HARDWARE REGISTERS */
	{"int_ctrl_reg", (uint)INT_CTRL_REG},
	{"led_ctrl_reg", (uint)LED_CTRL_REG},
	{"error_stat_reg", (uint)ERROR_STAT_REG},

	/* VALUES FOR INTERRUPT REQUEST REGISTER */
	{"INTR1_OFF", INTR1|INTR_OFF},
	{"INTR2_OFF", INTR2|INTR_OFF},
	{"INTR3_OFF", INTR3|INTR_OFF},
	{"INTR6_OFF", INTR6|INTR_OFF},
	{"INTR7_OFF", INTR7|INTR_OFF},
};

main()
{
	struct	kvtab	*kvptr;

	/* Generate warning as part of output file */
	printf("%s%s%s%s",
		"\t# WARNING WARNING WARNING:\n",
		"\t# This file is generated by running build_addr\n",
		"\t# Do not change this file by hand.\n",
		"\t# Changes will be lost next time build_addr is run.\n");

	for (kvptr = kvtab;
		kvptr != kvtab + (sizeof(kvtab) / sizeof(kvtab[0]));
		kvptr++) {

		printf("\tset\t%s, 0x%x\n", kvptr->name, kvptr->value);
		printf("\tglobal\t%s\n", kvptr->name);
	}
	exit(0);
}
