/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) bag.c: version 25.1 created on 11/27/91 at 14:47:06	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)bag.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 *	diag bag SCC interface
 *	Support for printf and other kernel diagnostic messages
 */
#include "sys/param.h"
#include "sys/types.h"
#include "ascc.h"
#include "con20.h"

#define	CON_ASCC	ASCC0A

#define	CTRL_S	'\023'
#define	CTRL_Q	'\021'

#define	CB_QSIZE	0x100
#define	CB_HIWATER	0x10
#define	CB_LOWATER	0x4

char cbbuf[CB_QSIZE];
struct cb {
	char *st;
	char *end;
	char *head;
	char *tail;
	short ct;
} cb = {
	cbbuf,
	&cbbuf[CB_QSIZE],
	cbbuf,
	cbbuf,
	0
};
char	xmit_next;
char	xoff;
#define	XOFF_BUFF_FULL	1	/* we sent ^S because the buff was filling */
#define	XOFF_CHAR	2	/* we sent ^S because we were asked to */

/******************************************************************************/
coninit()
{
	register struct ascc *sp = CON_ASCC;

	while ( !(sp->reg[1].reg & RR1_ALL_SENT) );

	sp->reg[9].reg = WR9_HRST;
	sp->reg[4].reg = WR4_16CLOCK | WR4_2STOP;
	sp->reg[3].reg = WR3_RX8 | WR3_RXEN;
	sp->reg[5].reg = WR5_TX8 | WR5_DTR | WR5_TXEN | WR5_RTS;
	sp->reg[14].reg = WR14_PCLK;
	sp->reg[12].reg = BDRT9600 & 0xff;
	sp->reg[13].reg = BDRT9600 >> 8;
	sp->reg[11].reg = WR11_TBRG | WR11_RBRG;
	sp->reg[14].reg = WR14_BRGEN | WR14_PCLK;

	sp->reg[0].reg = WR0_EXINT;
	sp->reg[0].reg = WR0_EXINT;
	sp->reg[1].reg = WR1_EXTEN;

	sp = ASCC0B;

	sp->reg[4].reg = WR4_16CLOCK | WR4_2STOP;
	sp->reg[3].reg = WR3_RX8 | WR3_RXEN;
	sp->reg[5].reg = WR5_TX8 | WR5_DTR | WR5_TXEN | WR5_RTS;
	sp->reg[14].reg = WR14_PCLK;
	sp->reg[12].reg = BDRT19K & 0xff;
	sp->reg[13].reg = BDRT19K >> 8;
	sp->reg[11].reg = WR11_TBRG | WR11_RBRG;
	sp->reg[14].reg = WR14_BRGEN | WR14_PCLK;

	sp->reg[9].reg = WR9_MIE  |	/* master int enable */
			 WR9_NV   |	/* no vector */
			 WR9_VIS;	/* vector include status */
}

/******************************************************************************/
lputchar(c)
register c;
{
	int i;
	register struct ascc *ap = CON_ASCC;

	if (c == '\n')
		lputchar('\r');

	while ( pollout(c) == -1 );
}

/******************************************************************************/
poll_general()
{
	register struct ascc *sp = ASCC0B;

	static	polling;

	if (polling)
		return;
	polling++;

	if ( sp->reg[0].reg & RR0_RX ) {
		if ( sp->reg[1].reg & (RR1_ROR | RR1_PAR | RR1_FER) )
		{
			printf("rx err\n");
			sp->reg[0].reg = WR0_ERROR;
		}
		if ( cb.ct < 0x100 )
		{
			*cb.head++ = sp->reg[8].reg & 0x7f;
			if ( cb.head == cb.end )
				cb.head = cb.st;
			if ( (cb.ct++ > CB_HIWATER) && !(xoff & XOFF_BUFF_FULL) )
			{
				if (!xoff)
					if (xmit_next == CTRL_Q)
						xmit_next = 0;
					else
						xmit_next = CTRL_S;
				xoff |= XOFF_BUFF_FULL;
			}
		}
	}
	if (xmit_next)
		if ( sp->reg[0].reg & RR0_TX ) {
			sp->reg[8].reg = xmit_next;
			xmit_next = '\0';
		}
	polling = 0;
}

/******************************************************************************/
int
pollin()
{
	register struct ascc *sp = CON_ASCC;
	int	c;

	poll_general();

	if (!( sp->reg[0].reg & RR0_RX ) )
		return(-1);
	c = sp->reg[8].reg & 0x7f;
	return(c);
}

/******************************************************************************/
int
pollin2()
{
	register struct ascc *sp = ASCC0B;
	int c;

	poll_general();

	/* POSSIBLE KLUDGE TO FIX READY BUG. FIX MSS */
	if ( (CON_ASCC)->reg[0].reg & RR0_RX )
		return(-1);

	if ( cb.ct == 0 )
		return(-1);
	c = (int)*cb.tail;
	if ( ++cb.tail == cb.end )
		cb.tail = cb.st;
	cb.ct--;
	if ( (cb.ct < CB_LOWATER) && (xoff & XOFF_BUFF_FULL))
	{
		xoff &= ~XOFF_BUFF_FULL;
		if (!xoff)
			if (xmit_next == CTRL_S)
				xmit_next = 0;
			else
				xmit_next = CTRL_Q;
	}
	return(c);
}

/******************************************************************************/
int
pollout(c)
{
	register struct ascc *sp = CON_ASCC;

	poll_general();
	if ( sp->reg[0].reg & RR0_TX )
	{
		sp->reg[8].reg = c;
		return(0);
	}
	return(-1);
}

/******************************************************************************/
int
pollout2(c)
{
	register struct ascc *sp = ASCC0B;

	poll_general();
	if (c == CTRL_S) {
		if (!xoff)
			if (xmit_next == CTRL_Q)
				xmit_next = 0;
			else
				xmit_next = CTRL_S;
		xoff |= XOFF_CHAR;
		return(0);
	}
	if (c == CTRL_Q) {
		xoff &= ~XOFF_CHAR;
		if (!xoff)
			if (xmit_next == CTRL_S)
				xmit_next = 0;
			else
				xmit_next = CTRL_Q;
		return(0);
	}
	if (xmit_next)
		return(-1);
	if ( sp->reg[0].reg & RR0_TX )
	{
		sp->reg[8].reg = c;
		return(0);
	}
	else
		return(-1);
}

/******************************************************************************/
/*
**	exint for CON_ASSC only. break -> rtscope.
*/
coninterrupt()
{
	register struct ascc *sp = CON_ASCC;
	static int xbreak = 0;

	if ( xbreak && !(sp->reg[0].reg & RR0_BREAK) )
	{
		xbreak = sp->reg[8].reg;	/* discard null char */
		xbreak = 0;
/*		RTscope();	/* move as close to rte as possible */
	}
	if ( sp->reg[0].reg & RR0_BREAK )
	{
		xbreak = 1;
	}
	sp->reg[0].reg = WR0_EXINT;
	sp->reg[0].reg = WR0_HIUS;
}
