#ifndef SYS_ASCC_H
#define SYS_ASCC_H

/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) ascc.h: version 25.1 created on 11/27/91 at 14:47:03	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)ascc.h	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*******************************************************************
 *
 *			A  S  C  C
 *
 *******************************************************************/

struct scc_reg {
	unsigned char reg;
	unsigned char filler;
};

struct ascc {
	struct scc_reg reg[16];		/* 16 read/write registers */
};

/*******************************************************************
 *
 *	R E A D    R E G I S T E R S
 *
 *******************************************************************/

#define RR0_RX		0x01	/* rx ready */
#define RR0_ZERO	0x02	/* zero count */
#define RR0_TX		0x04	/* tx ready */
#define RR0_DCD		0x08	/* data carrier detect */
#define RR0_SYNC	0x10	/* sync */
#define RR0_HUNT	0x10	/* hunt */
#define RR0_RING	0x10	/* ring */
#define RR0_CTS		0x20	/* clear to send */
#define RR0_TUR		0x40	/* tx underrun */
#define RR0_EOM		0x40	/* end of message */
#define RR0_BREAK	0x80	/* break */
#define RR0_ABORT	0x80	/* abort */
#define RR0_CARR_ON(x)	((x&(RR0_DCD|RR0_RING)) == (RR0_DCD|RR0_RING))

#define RR1_ALL_SENT	0x01	/* all sent */
#define RR1_PAR		0x10	/* parity error */
#define RR1_ROR		0x20	/* rx overrun error */
#define RR1_FER		0x40	/* framming error */
#define RR1_CRC		0x40	/* crc error */
#define RR1_EOF		0x80	/* end of frame */

/*******************************************************************
 *
 *	W R I T E    R E G I S T E R S
 *
 *******************************************************************/

#define WR0_EXINT	0x10	/* reset external status interrupts */
#define WR0_ABORT	0x18	/* send abort */
#define WR0_TXINT	0x28	/* reset tx int pending */
#define WR0_ERROR	0x30	/* reset error */
#define WR0_HIUS	0x38	/* reset highest ius */
#define WR0_RXCRC	0x40	/* reset rx crc checker */
#define WR0_TXCRC	0x80	/* reset tx crc generator */
#define WR0_TXEOM	0xc0	/* reset tx underrun/eom */

#define WR1_EXTEN	0x01	/* external ints enable */
#define WR1_TXEN	0x02	/* transmitter ints enable */
#define WR1_PARSP	0x04	/* parity is special condition */
#define WR1_RX1ST	0x08	/* rx int on first or special */
#define WR1_RXALL	0x10	/* rx int on all or special */
#define WR1_RXSP	0x18	/* rx int on special only */

#define WR3_RXEN	0x01	/* receiver enable */
#define WR3_SYNC	0x02	/* sync char load inhibit */
#define WR3_ADDR	0x04	/* address search mode */
#define WR3_CRC		0x08	/* receiver crc enable */
#define WR3_HUNT	0x10	/* enter hunt mode */
#define WR3_AUTO	0x20	/* auto enables */
#define WR3_RX5		0x00	/* 5 or less rx bits */
#define WR3_RX7		0x40	/* 7 rx bits */
#define WR3_RX6		0x80	/* 6 rx bits */
#define WR3_RX8		0xc0	/* 8 rx bits */

#define WR4_PARITY	0x01
#define WR4_EVEN	0x02
#define WR4_ODD		0x00
#define WR4_SYNC	0x00
#define WR4_1STOP	0x04
#define WR4_1_5STOP	0x08
#define WR4_2STOP	0x0c
#define WR4_8SYNC	0x00
#define WR4_16SYNC	0x10
#define WR4_SDLC	0x20
#define WR4_EXSYNC	0x30
#define WR4_1CLOCK	0x00
#define WR4_16CLOCK	0x40
#define WR4_32CLOCK	0x80
#define WR4_64CLOCK	0xc0

#define WR5_TXCRCEN	0x01	/* transmitter crc enable */
#define WR5_RTS		0x02	/* request to send */
#define WR5_CRC16	0x04	/* crc-16 */
#define WR5_TXEN	0x08	/* transmitter enable */
#define WR5_BREAK	0x10	/* send break */
#define WR5_TX5		0x00	/* 5 or less tx bits */
#define WR5_TX7		0x20	/* 7 tx bits */
#define WR5_TX6		0x40	/* 6 tx bits */
#define WR5_TX8		0x60	/* 8 tx bits */
#define WR5_DTR		0x80	/* data terminal ready */

#define WR9_VIS		0x01
#define WR9_NV		0x02
#define WR9_DLC		0x04
#define WR9_MIE		0x08
#define WR9_STHI	0x10
#define WR9_BRST	0x40	/* channel B reset */
#define WR9_ARST	0x80	/* channel A reset */
#define WR9_HRST	0xc0	/* hardware reset */

#define	WR10_PRE1	0x80	/* Preset 1/0 (crc) */
#define WR10_NRZI	0x20	/* NRZI/NRZ mode */
#define	WR10_ABTTXU	0x04	/* Abort on Tx Underrun */

#define WR11_OXTAL	0x00	/* TRxC out is xtal output */
#define WR11_OTCLK	0x01	/* TRxC out is xtal output */
#define WR11_OBRG	0x02	/* TRxC out is xtal output */
#define WR11_BRGO	0x02	/* baud rate generator output */
#define WR11_ODPLL	0x03	/* TRxC out is xtal output */
#define WR11_TRXC	0x04	/* direction of the TRxC pin on the chip o/i* */
#define WR11_TRTxC	0x00	/* transmit clock from rtxc */
#define WR11_TTRxC	0x08	/* transmit clock from trxc */
#define WR11_TBRG	0x10	/* transmit clock from brg */
#define WR11_TDPLL	0x18	/* transmit clock from dpll */
#define WR11_RRTxC	0x00	/* receive clock from rtxc */
#define WR11_TCGO	0x10	/* use baud rate generator for transmit clock */
#define WR11_RTRxC	0x20	/* receive clock from trxc */
#define WR11_RBRG	0x40	/* receive clock from brg */
#define WR11_RCGO	0x40	/* use baud rate generator for receive clock */
#define WR11_RDPLL	0x60	/* receive clock from dpll */

#define WR14_BRGEN	0x01	/* enable baud rate generator */
#define WR14_ENABD	0x01    /* enable baud rate generator */
#define WR14_PCLK	0x02	/* brg source is scc's pclk */
#define WR14_SRCH	0x20	/* enter search mode */
#define WR14_DIS_DPLL	0x60	/* disable DPLL */
#define	WR14_SRC_BRG	0x80	/* set DPLL clk src as BRG */

#define WR15_DCD_IE	0x08	/* enable carrier ints */
#define WR15_RI_IE	0x10	/* ring indicator ints */
#define WR15_CTS_IE	0x20	/* enable cts ints */
#define WR15_EOM_IE	0x40	/* enable tx underrun ints */
#define WR15_ABORT_IE	0x80	/* enable abort ints */
#define WR15_BREAK_IE	0x80	/* enable break ints */

/*******************************************************************
 *
 *	V E C T O R   I N C L U D E   S T A T U S
 *
 *******************************************************************/

#define SCCVIS_MASK	0x0e
#define SCCVIS_TXB	0x00
#define SCCVIS_EXB	0x02
#define SCCVIS_RXB	0x04
#define SCCVIS_SPB	0x06
#define SCCVIS_TXA	0x08
#define SCCVIS_EXA	0x0a
#define SCCVIS_RXA	0x0c
#define SCCVIS_SPA	0x0e

#endif /* SYS_ASCC_H */
