/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) stp_strat.c: version 25.1 created on 11/27/91 at 14:46:19	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)stp_strat.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/debug.h"
#include "sys/file.h"
#include "sys/errno.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/elog.h"

#include "sys/buf.h"

#include "hlvl_macro.h"
#include "scsi_cmdbx.h"
#include "stp_cdb.h"

#ifdef EXABYTE
#include "xbyte.h"
#include "xbyte_cdb.h"
#else
#include "stp.h"
#endif /* EXABYTE */

#include "scsi_log.h"
#include "stioctl.h"

#define	GET_SPACE_CODE(x)	(((x)>>16)&0x03)
#define	GET_SPACE_COUNT(x)	((x)>>8)
#define b_cmd	b_blkno	 /* scsi command field */

extern long	lbolt;

extern struct DEVICE_TABLE TAPE_TAB[];
extern CMD_BOX *scsi_get_cmd();

extern void TAPE_INTR();

/*
 * TAPE_COMMAND()
 *
 * Parameters:
 *
 *	Unit ID
 *	Command
 *	Number of byte for parameter list
 *
 * Return Codes:
 *
 *	0 - success
 *	1 - failure
 *
 *
 */

#define BP_REL_ATTN	0x80000000

TAPE_COMMAND(unit_id, cmd, buf_len, attn_flag)
unchar	unit_id;
uint cmd;
uint buf_len;
uint attn_flag;
{
	struct buf *bp;
	uint	x;
	struct DEVICE_TABLE *dp;

	dp = GETDP(unit_id);
	bp = dp->own_bp;
	
	LOG_LONG_WORD(LOG_TAPE|LOG_XCMD, unit_id, cmd, RBEGIN);
	bp->b_flags = B_BUSY;
	bp->b_error = 0;
	bp->b_cmd = cmd;
	bp->b_bcount =  buf_len;
	if(attn_flag == CMD_RELEASE_ATTN)
		bp->b_cmd |= BP_REL_ATTN;
/* do the oper	*/
	TAPE_STRATEGY(bp);
/* wendy */
	while((bp->b_flags & B_DONE) == 0)

		iowait(bp);
	bp->b_flags &= ~B_BUSY;	/* release local buf structure */	
	if(bp->b_flags & B_WANTED)
		wakeup(bp);
	LOG_LONG_WORD(LOG_TAPE|LOG_XCMD, unit_id, bp->b_flags, REND);
/*  if error, release buffer and return with -1,otherwise, return with 1 */
	if(bp->b_flags & B_ERROR)
		return(0);
	else 
		return(1);
	
} /* end of stpcommand */

/*
 * TAPE_STRATEGY()
 *
 *		Accept a bp, try to send it out, return
 *
 * Parameter:
 *
 *		Buffer header pointer.
 *
 * No Return Value.
 *
 * Assumptions:
 *
 *		This code can run both on the slaves and the master.
 *
 */

TAPE_STRATEGY(bp)
register struct buf *bp;
{

	unchar	unit_id;
	struct DEVICE_TABLE *dp;
	uint	iplsave;
	
	unit_id =UNIT(bp->b_dev);
	dp = GETDP(unit_id);
	
	LOG_LONG_WORD(LOG_TAPE|LOG_STRA, 0, bp, RBEGIN);
		
	iplsave = splhlv();

	if (bp != dp->own_bp) {
		dp->sar->io_cnt++;	/* total number of requests */
		bp->b_start = get_time_stamp(); 
	}
	/* link buffer header to drive worklist */
	bp->av_forw = NULL;
	if (dp->b_actf == NULL) 
		dp->b_actf = bp;
	else 
 		dp->b_actl->av_forw = bp;

	dp->b_actl = bp;
	dp->qcnt++;	/* number of requests in the queue */
	TAPE_START(dp);

	splx(iplsave);
	
	LOG_LONG_WORD(LOG_TAPE|LOG_STRA, 0, bp, REND);
}

TAPE_START(dp)
struct DEVICE_TABLE *dp;
{

	LOG_LONG_WORD(LOG_TAPE|LOG_START, 0, dp, RBEGIN);
	
	if((dp->b_actf) && (!dp->outstanding)) {
	/* dequeue i/o request */
		dp->outstanding = dp->b_actf;

		if((dp->b_actf = dp->outstanding->av_forw) == NULL)
			dp->b_actl = NULL;
		dp->qcnt--;

		tapexstart(dp);
	}
	LOG_LONG_WORD(LOG_TAPE|LOG_START, 0, dp, REND);
} /* end of stpstart */

static tapexstart(dp)
struct DEVICE_TABLE *dp;
{
	register buf_t *bp = dp->outstanding;
	register CMD_BOX *cm = dp->cm;	
	struct g0_cdb	*cdb;

	/* format command mailbox	*/
	LOG_LONG_WORD(LOG_TAPE|LOG_XSTART, 0, bp->b_flags, RBEGIN);
	LOG_LONG_WORD(LOG_PR, 0, bp, 0);

	bzero(cm, sizeof( CMD_BOX)); 

	cm->unit_id = UNIT(bp->b_dev);
	cm->retry_cnt = 10;	/* set retry count */
	cdb = (struct g0_cdb *)(cm->cmd_dsc_blk);

	if(bp == dp->own_bp){ /* request is set by stpcommand */
		cdb->opcode = bp->b_cmd;
		if(bp->b_cmd & BP_REL_ATTN)
			cm->cmd_type = CMD_RELEASE_ATTN; 
		else 
			cm->cmd_type = 0;
	}
	else{ /* reqeust is set by iopm os directly */

	    cm->cmd_type = 0;
	    if(bp->b_flags & B_READ)
		cdb->opcode =  CDB_READ;
	    else
		cdb->opcode = CDB_WRITE;
	}
	cdb->lun_flags = DRV_LUN;
	cdb->ctl = 0;

	switch(cdb->opcode){
			

		case CDB_READ:
			/* no tape mark detected */
			if (!(dp->tapemark & TM_DETECTED)) {
				if (!setcdbrw (dp, cdb))
					return ;
			} 
			else { /* tape mark detected, not reported */
				if (!(dp->tapemark & TM_REPORTED)) {
					bp->b_resid = bp->b_bcount ;
					iodone(bp) ;
					dp->tapemark |= TM_REPORTED ;
					dp->outstanding = 0 ;
					return ;
				} 
				else  /* tape mark detected and reported */ {
					dp->tapemark &= ~TM_REPORTED ;
					dp->tapemark &= ~TM_DETECTED ;
					if (!setcdbrw (dp, cdb))
						return ;
				}
			}

			cm->dma_flags = DMA_READ;	
			cm->timer =  RDWR_TIME_SLICE*(bp->b_bcount/BLOCKSIZE+1);
			break;

		case CDB_WRITE:

			if (!(dp->tapemark & TM_EOM) || 
			      dp->tapemark & TM_REPORTED) {
				if (!setcdbrw(dp,cdb))
					return;
			} else {
				bp->b_error = ENOSPC;
				bp->b_flags |= B_ERROR;
				iodone(bp);
				dp->tapemark |= TM_REPORTED;
				dp->outstanding = 0;
				return;
			}

			cm->timer =  RDWR_TIME_SLICE*(bp->b_bcount/BLOCKSIZE+1);
			break;

		case CDB_MODE_SENSE:

			cdb->alloc_len = bp->b_bcount;
			cm->dma_flags |= DMA_READ;
			cm->timer = (uint)BASIC_TIME_SLICE;
			break;

		case CDB_MODE_SELECT:
			mode_select_data(dp,bp->b_un.b_addr);
			cdb->alloc_len = bp->b_bcount;
			cm->timer = (uint )BASIC_TIME_SLICE;
			break;

		case CDB_REQUEST_SENSE:
		case CDB_INQUIRY:

			cdb->alloc_len = bp->b_bcount;
			cm->dma_flags |= DMA_READ;
			cm->timer = (uint )BASIC_TIME_SLICE;
			break;

 		case CDB_SPACE: 	
		{
			unchar	count;

			cdb->lun_flags = GET_SPACE_CODE(bp->b_cmd);	
			count = GET_SPACE_COUNT(bp->b_cmd);
			cdb->count_lsb = count;
			if(cdb->count_lsb & 0x80)
			/* sign bit propergatation */
				cdb->count_msb = cdb->count = 0xFF;
			cm->timer = (uint)SKIP_TIME_SLICE;
			break;
		}

		case CDB_LOAD:
			cdb->reten_load = bp->b_cmd >> 8; /* get load/unload mark */
		case CDB_ERASE:
		case CDB_REWIND:
			cm->timer = (uint)REWIND_TIME_SLICE;
			break;
 		case CDB_WRITE_FILEMARKS:
			cdb->xfer_len_lsb = bp->b_cmd>>8; /* get number of filemarks to write */
#ifdef EXABYTE
#ifndef LONG_FILEMARK
			cdb->ctl |= XB_SHORT;
#endif /* LONG_FILEMARK */
#endif  /* EXABYTE */
			
			cm->timer = (uint)UNIT_TIME_SLICE;
			break;
		case CDB_MEDIUM_REMOVAL:
			cdb->prvnt = (bp->b_cmd & 0x01);

		case CDB_READ_BLKLI:
		case CDB_TEST_UNIT_READY:
			cm->timer = (uint)BASIC_TIME_SLICE;
			break;
		default:
			/* unknown command */
			panic("\nstpxstart: unknown scsi command :%x",
				cdb->opcode);
	}
	/* setup common infomation in command box */

	cm->cmd_dsc_len = sizeof(struct g0_cdb);
	cm->service = TAPE_INTR; /* setup server routine */
	cm->tag = (uint )bp;

	/* setup dma information */
	if((cm->dma_buf_len = bp->b_bcount) != 0){
		cm->dma_buffer = (unchar *)bp->b_un.b_addr;
		cm->dma_proc = bp->b_proc;	
	}
	scsi_send_cmd(cm); /* send command box to low level driver */
	
	LOG_LONG_WORD(LOG_TAPE|LOG_XSTART, 0, bp, REND);
} /* end of stpxstart */

static setcdbrw(dp,rwcdb)
struct DEVICE_TABLE *dp;
struct g0_cdb	*rwcdb;
{

	register buf_t *bp = dp->outstanding;
	uint	blklen;	

	/* setup xfer length */	
#ifdef EXABYTE
	if(rwcdb->opcode == CDB_READ)
		rwcdb->lun_flags |= SILI;
	if((dp->minblklen > bp->b_bcount) ||
	   (dp->maxblklen < bp->b_bcount)){
		bp->b_error = EINVAL;
		bp->b_flags |= B_ERROR;
		sxb_display_err( UNIT(bp->b_dev), "illegal record size");
		iodone(bp);
		dp->outstanding = 0;
		return(0);
	}
	ITOC3(rwcdb->xfer_len_msb, rwcdb->xfer_len, rwcdb->xfer_len_lsb,
		bp->b_bcount);
	return(1);
#else

	if(dp->subtype == ARCHIVE){
	/* setup xfer length */	
		rwcdb->lun_flags = FIXED; /* fixed block length */
		ASSERT(dp->blk_size);
		blklen = bp->b_bcount/dp->blk_size;
		if(bp->b_bcount != (blklen*dp->blk_size)){
			bp->b_error = EINVAL;
			bp->b_flags |= B_ERROR;
			stp_display_err(dp->subtype, UNIT(bp->b_dev),
					 "illegal record size");
			iodone(bp);
			dp->outstanding = 0;
			return(0);
		}
		ITOC3(rwcdb->xfer_len_msb, rwcdb->xfer_len, rwcdb->xfer_len_lsb,
		blklen);
	} 
	else { /* nine track drive */
	/* setup xfer length */	
		if(rwcdb->opcode == CDB_READ)
			rwcdb->lun_flags |= SILI;
		if((dp->minblklen > bp->b_bcount) ||
		   (dp->maxblklen < bp->b_bcount)){
			bp->b_error = EINVAL;
			bp->b_flags |= B_ERROR;
			stp_display_err(dp->subtype, UNIT(bp->b_dev),
				 "illegal record size");
			iodone(bp);
			dp->outstanding = 0;
			return(0);
		}
		ITOC3(rwcdb->xfer_len_msb, rwcdb->xfer_len, rwcdb->xfer_len_lsb,
		bp->b_bcount);
	}
	return(1);
#endif /* EXABYTE */
}

static mode_select_data(dp,mdp)
register struct DEVICE_TABLE *dp;
#ifdef EXABYTE
register XBYTE_MODE_DATA	*mdp;
{
	mdp->mh.sd_len = mdp->mh.med_type = 0;
	mdp->mh.wp_bm_speed =  dp->has_cache<<4; 
	mdp->mh.dscptr_len = DSCPTR_LEN;

	mdp->bdsp.density = 0;
	mdp->bdsp.numblk_msb = mdp->bdsp.numblk = mdp->bdsp.numblk_lsb = 
	mdp->bdsp.blk_len_msb = mdp->bdsp.blk_len_lsb = mdp->bdsp.pad = 0;
	mdp->bdsp.blk_len = 0;

	mdp->vdr.flags = dp->mode_flags;
	mdp->vdr.motion_thres = dp->motion_thres;
	mdp->vdr.recon_thres = dp->recon_thres;
	mdp->vdr.gap_thres = dp->gap_thres ;
#else

register struct mode_head *mdp;
{

	struct blk_dscptr *dsp;

	mdp = (struct mode_head *)dp->outstanding->b_un.b_addr;
	mdp->sd_len =mdp->med_type = 0;
	if(dp->subtype == TRACK9)
		mdp->wp_bm_speed = dp->speed | (dp->has_cache<<4); 
	else
		mdp->wp_bm_speed = dp->has_cache<<4;
	mdp->dscptr_len = DSCPTR_LEN;
	dsp = (struct blk_dscptr *)((unchar *)mdp +MODEHEAD_LEN);
	if(dp->subtype == ARCHIVE){
		if ((dp->outstanding->b_cmd >>8) & QIC120_XDT){
			dsp->density = 0x0F;
			dp->density = 0x0F;
		}
		else{
			dsp->density = 0;
			dp->density = 0;
		}
	}
	else  /* nine track tape */
		dsp->density = dp->density;

	dsp->numblk_msb = dsp->numblk = dsp->numblk_lsb = 
	dsp->blk_len_msb = dsp->blk_len_lsb = dsp->pad=0;
	if(dp->subtype == ARCHIVE)
		dsp->blk_len = 2;		
	else
		dsp->blk_len = 0;
#endif /* EXABYTE */
}
