/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) stp_open.c: version 4.1 created on 5/2/90 at 19:38:48	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)stp_open.c	4.1	5/2/90 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/debug.h"
#include "sys/file.h"
#include "sys/errno.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/elog.h"

#include "sys/user.h"
#include "sys/buf.h"

#include "stp_cdb.h"
#include "scsi_cmdbx.h"

#ifdef EXABYTE
#include "xbyte_cdb.h"
#include "xbyte.h"
#else
#include "stp.h"
#endif /* EXABYTE */

#include "scsi_error.h"
#include "hlvl_macro.h"
#include "scsi_log.h"
#include "stioctl.h"



struct DEVICE_TABLE TAPE_TAB[MAXNODRVS];
static tape_init  = 0;	/* tape initialize flag */

extern buf_t *geteblk();
extern CMD_BOX *scsi_get_cmd();
extern struct iotime *get_iotime();

static tape_init_table()
{
	int i;
	struct	DEVICE_TABLE	*dp;
	bzero(TAPE_TAB, sizeof(struct DEVICE_TABLE)* MAXNODRVS);
	for ( i = 0, dp = TAPE_TAB; i < MAXNODRVS; i++, dp++) {
		dp->b_dev = i; 
		dp->sar = get_iotime(i);
	}
	tape_init = 1; /* turn on flag */
}



/*
 * TAPEOPEN()
 *
 * Parameters:
 *
 *  open the archive drive
 *
 *	Minor Device number
 *	 bit 7 to bit 4 : unit ID.
 *	 bit 3 to bit 2 : Reserve for future used 
 *	 bit 1 	 	: Format Bit ( Only for 2150S )
 *	             0	: Default 
 *		     1  : When tape media is DC600XTD and write with 
 *			  QIC-120 format. 
 *	 bit 0		: Rewind on Open
 *
 *
 *	Flag	(FWRITE, etc from file.h)
 *
 * No Return Values
 *
 * Algorithm:
 *
 *	- Mark device in use.
 *
 *
 *	- Check for errors.
 *
 *	- Send out format command if necessary.
 *
 * Notes:
 *
 *	Only one process at a time is allowed to access the drive.
 *
 *	Archive Drive automatically rewinds on open.
 *
 *	Errors are marked in u.u_error.
 */

/* device config table */

TAPE_OPEN(dev, flag)
dev_t		dev;
unsigned	flag;
{

	unchar	 unit_id;
	uint	s, status;
	struct DEVICE_TABLE *dp;

	unit_id = UNIT(dev);
	log(LOG_TAPE|LOG_OPEN, unit_id, NULL, RBEGIN);

	s = splhlv();
	if(tape_init == 0)
		tape_init_table();

	dp = GETDP(unit_id);

	if ( dp->b_flags & B_BSY ) {
		u.u_error = EBUSY;
		log(LOG_TAPE|LOG_OPEN,dp->b_dev,NULL,RERROR);
		splx(s);
		return;
	}
	dp->b_flags |= B_BSY;

	splx(s);

	if (!(dp->b_flags & B_ALLOC))
		if (!tape_resrc_alloc(dp)) {
			set_open_err(dp, EBUSY);
			return;
		}

	if ((status = open_tape_drv(dp, dev, flag)) != 0) {
		tape_resrc_dealloc(dp);
		set_open_err(dp,status);
		return;
	}
	u.u_error = 0;	/* return the buffer */
	log(LOG_TAPE|LOG_OPEN,unit_id,NULL,REND);
	return;

} /* end of TAPEOPEN */

static  open_tape_drv(dp, dev, flag)
struct DEVICE_TABLE *dp;
dev_t dev;
unsigned	flag;
{
	int	ready;

	if(!(dp->b_flags & B_ONCE)){
		if(!init_tape_drive(dp,dp->b_dev))
			return(ENXIO);
	}

	if (dp->type != SA_DEV) {
		TAPE_DISPLAY_ERR( dp->subtype, dp->b_dev, "device is not a tape");
		return(ENXIO);
	}
	if (dp->sar == NULL)
		dp->sar = get_iotime(dp->b_dev);

	/* check if tape just been changed */	
	dp->b_flags |= B_NO_PRINT; /* to tell intr routine: do not print error
				      message if following command get unit 
				      attention error */
	ready = TAPE_COMMAND(dp->b_dev, CDB_TEST_UNIT_READY, 0, 0);
	dp->b_flags &= ~B_NO_PRINT;

	if (!ready  && dp->status != SCSIERR_ATN)
		return(ENXIO);

	/* prevent media from being removed */
#ifndef TP9TRK
	if(!TAPE_COMMAND(dp->b_dev, CAT2(PREVENT,CDB_MEDIUM_REMOVAL), 0, 
	   CMD_RELEASE_ATTN))
		return(ENXIO);
#endif /* TP9TRK */

	if (!ready  ||  dp->subtype == 0 || (dp->b_flags & B_SETTP) ) {
	/* trying to setup density if we get unit attention */
		if(!init_tape_media(dp, dev) ){
#ifndef TP9TRK
			dp->b_flags |= B_NO_PRINT; /* no error report */
			TAPE_COMMAND(dp->b_dev, CAT2(ALLOW,CDB_MEDIUM_REMOVAL),
			 0, 0);
			dp->b_flags &= ~B_NO_PRINT;
#endif /* TP9TRK */
			return(EIO);
		}
		dp->b_flags &= ~B_SETTP;
	}
#ifdef EVERY_CHECK
	if ((dp->b_flags & B_WP) && (flag  &  FWRITE)){
#else
	if ((flag & FWRITE) && write_protect(dp)) {
#endif /* EVERY_CHECK */
		TAPE_DISPLAY_ERR(dp->subtype,dp->b_dev,
				"media is write protect");
#ifndef TP9TRK
		dp->b_flags |= B_NO_PRINT; /* no error report */
		TAPE_COMMAND(dp->b_dev, CAT2(ALLOW,CDB_MEDIUM_REMOVAL), 0, 0);
		dp->b_flags &= ~B_NO_PRINT;
#endif /* TP9TRK */
		return(EACCES);
	}

	if (flag & FAPPEND) {
	/* forward to next file mark */
		if(!TAPE_COMMAND(dp->b_dev, CAT3(S_FMK, 1, CDB_SPACE), 0, 0))
			return(EIO);

#ifdef TP9TRK
		if (!TAPE_COMMAND(dp->b_dev, CAT3(S_FMK, -1, 
						CDB_SPACE), 0,0)) 
			return(EIO);
#endif /* TP9TRK */

	}
	return(0);
} /* end of open_tape_drv */
/*
 * TAPE_CLOSE()
 *
 */

TAPE_CLOSE(dev, flag)
register dev_t	dev;
short		flag;
{

	unchar	unit_id = UNIT(dev);
	struct DEVICE_TABLE *dp;

	dp = GETDP(unit_id);

	LOG_LONG_WORD(LOG_TAPE|LOG_CLOSE, dev, dp, RBEGIN);
	close_tape_drv(dp, dev, flag);
	tape_resrc_dealloc(dp);
	LOG_LONG_WORD(LOG_TAPE|LOG_CLOSE, dev, dp, REND);
}

static close_tape_drv(dp, dev, flag)
struct DEVICE_TABLE *dp;
dev_t dev;
short flag;
{
	unchar	unit_id = UNIT(dev);


	if (flag & FWRITE) {
	/*
	 * If we were writing, write  1 file mark on the tape.
	 */
		TAPE_COMMAND(unit_id, CAT2(1,CDB_WRITE_FILEMARKS), 0, 0);
#ifdef TP9TRK
		TAPE_COMMAND(unit_id, CAT2(1,CDB_WRITE_FILEMARKS),0, 0);
		if (dev & ROC)
			/* unload  tape */
			TAPE_COMMAND(unit_id, CDB_REWIND, 0, 0);
		else
			TAPE_COMMAND(unit_id, CAT3(S_FMK, -1, CDB_SPACE), 0, 0);
#else
		if (dev & ROC) {
			/* unload  tape */
			TAPE_COMMAND(unit_id, CDB_REWIND, 0, 0);
			dp->b_flags |= B_NO_PRINT; /* no error report */
			TAPE_COMMAND(unit_id, CAT2(ALLOW,CDB_MEDIUM_REMOVAL),
			 0, 0);
			dp->b_flags &= ~B_NO_PRINT;
		}
#endif /* TP9TRK */

	}
	else {					/* opened for reading */
		if (dev & ROC) { /* close with rewind */
			/* unload  tape */
			TAPE_COMMAND(unit_id, CDB_REWIND, 0, 0);
#ifndef TP9TRK
			dp->b_flags |= B_NO_PRINT; /* no error report */
			TAPE_COMMAND(unit_id, CAT2(ALLOW,CDB_MEDIUM_REMOVAL),
			 0, 0);
			dp->b_flags &= ~B_NO_PRINT;
#endif /* TP9TRK */
		}
		else {  /* close without rewind */
			/*
			 * if we are not at a file mark, read forward
			 * to the next file mark.
			 */
			if ( (dp->tapemark & TM_DETECTED) == 0 )
			   	TAPE_COMMAND(unit_id, 
					CAT3(S_FMK, 1, CDB_SPACE), 0, 0);
			
		}
	} /* end of if ( FWRITE) */

	/* clear old status info */
	dp->tapemark = 0;
	dp->b_flags &= ~B_BSY;
}

static set_open_err(dp,err_code)
struct DEVICE_TABLE *dp;
char	err_code;
{
	u.u_error = err_code;
	dp->b_flags &= ~B_BSY;
	log(LOG_TAPE|LOG_OPEN,dp->b_dev,NULL,RERROR);
}

static init_tape_drive(dp,unit_id)
struct DEVICE_TABLE *dp;
unchar	unit_id;
{


	dp->b_dev = unit_id;
	/* get device type if this is the first time to do the open */
	if(!TAPE_COMMAND(unit_id, CDB_INQUIRY, INQUIRY_LEN, 0))
		return(0);

	/* setup default value */
	dp->type =(unchar )*dp->own_bp->b_un.b_addr;
	dp->has_cache = DO_CACHE;
#ifdef EXABYTE
	/* parity enable, even byte discon,report busy status */
	dp->mode_flags = XB_PE | XB_EBD | XB_NAL; 
	dp->motion_thres = 240;	/* 240 k */
	dp->recon_thres = 64;	/* 64 k */
	dp->gap_thres = 0 ;	/* sets # pad blocks before stopping */
#else
	dp->density = 0;
#endif /* EXABYTE */
		
	dp->b_flags |= B_ONCE;
	return(1);
} /* init_tape_drive */

static init_tape_media(dp,dev,flag)
struct DEVICE_TABLE *dp;
dev_t		dev;
unsigned	flag;
{
#ifdef EXABYTE
	XBYTE_MODE_DATA *mp;
	BLK_LIMIT *limit_data;
		
	if (!TAPE_COMMAND(dp->b_dev, CAT2(LD,CDB_LOAD), 0, CMD_RELEASE_ATTN))
		return(0);

	if(dp->subtype == 0){ /* set sub device type */
		if((dp->subtype = media_type(dp)) != XABYTE){
			dp->subtype = 0;
			return(0);
		}
		/* get block limit data for nine track tape */
		if (!TAPE_COMMAND(dp->b_dev,CDB_READ_BLKLI,6, 0))
			return(0);

		limit_data = (BLK_LIMIT *)dp->own_bp->b_un.b_addr;

		dp->maxblklen = CAT3(limit_data->max_msb,
		 		limit_data->max , limit_data->max_lsb); 
		dp->minblklen = CAT2(limit_data->min_msb << 8, 
					limit_data->min_lsb);
	}
	if(!TAPE_COMMAND(dp->b_dev,CDB_MODE_SELECT, XB_MODE_DATA_LEN, 0 ))
			return(0);
	/* verify tape media */
	if(!TAPE_COMMAND(dp->b_dev, CDB_MODE_SENSE, XB_MODE_DATA_LEN, 0) ) 	
		return(0);
	mp =  (XBYTE_MODE_DATA *)dp->own_bp->b_un.b_addr;

	if (mp->mh.wp_bm_speed & WP)
		dp->b_flags |= B_WP;
	else
		dp->b_flags &= ~B_WP;
	return(1);
#else 
	struct mode_head *mh;
	struct blk_dscptr *blkdcptr;
	BLK_LIMIT *limit_data;
	unchar	dev_flag;

	if (!TAPE_COMMAND(dp->b_dev, CAT2(LD,CDB_LOAD), 0, CMD_RELEASE_ATTN))
		return(0);

	if (dp->subtype == 0){ /* set sub device type */
		if (!(dp->subtype = media_type(dp))){
			TAPE_DISPLAY_ERR (dp->subtype,dp->b_dev,
				"media is not right type");
			dp->subtype = 0;
			return(0);
		}
#ifdef TP9TRK
		if (!TAPE_COMMAND(dp->b_dev,CDB_READ_BLKLI,6, 0))
			return(0);
		limit_data = (BLK_LIMIT *)dp->own_bp->b_un.b_addr;

		dp->maxblklen = CAT3(limit_data->max_msb,
				limit_data->max , limit_data->max_lsb); 
		dp->minblklen = CAT2(limit_data->min_msb << 8, 
				limit_data->min_lsb);
#endif /* TP9TRK */
	}
#ifdef TP9TRK
	 if(dp->density == 0){
		dp->density = DENS_1600;
		dp->speed = LOW_SPEED; /* 50 ips */
	}
	if (!TAPE_COMMAND(dp->b_dev, CDB_MODE_SELECT, 
			TAPE_SENSE_DATA_LEN, 0) ) {
		if (dp->b_flags & B_DENSITY) {  /* wrong density, set default */
			dp->density = DENS_1600;
			dp->b_flags &= ~B_DENSITY;
			TAPE_DISPLAY_ERR (dp->subtype,dp->b_dev,
			 	"Invalid density, set to default density");
		}
		return(0);
	}
#else
	if (!TAPE_COMMAND(dp->b_dev, CAT2((dev & QIC120_XDT), CDB_MODE_SELECT), 
		TAPE_SENSE_DATA_LEN, 0 ))
		return(0);
#endif /* TP9TRK */
	/* verify tape media */
	if (!TAPE_COMMAND(dp->b_dev, CDB_MODE_SENSE, TAPE_SENSE_DATA_LEN,
		 0)) 	
		return(0);
	mh =  (struct mode_head *)dp->own_bp->b_un.b_addr;
	blkdcptr = (struct blk_dscptr *)((uint)mh + MODEHEAD_LEN);

	if (mh->wp_bm_speed & WP)
		dp->b_flags |= B_WP;
	else
		dp->b_flags &= ~B_WP;	

	/* setup block size */
	dp->blk_size = CAT3(blkdcptr->blk_len_msb,blkdcptr->blk_len,
			blkdcptr->blk_len_lsb);	

	if(((dp->blk_size != 0) && (dp->subtype == TRACK9)) ||
	   ((dp->blk_size == 0) && (dp->subtype == ARCHIVE))){
		TAPE_DISPLAY_ERR(dp->subtype, dp->b_dev,
				"device's block size is wrong");
		return(0);	
	}
	return(1);
#endif /* EXABYTE */

} /* end of init_tape_media */

/* to determine drive type (nine track or cartridge) by density code */
static media_type(dp)
struct DEVICE_TABLE *dp;
{
	struct mode_head *mh;
#ifdef EXABYTE
	if(!TAPE_COMMAND(dp->b_dev, CDB_MODE_SENSE, XB_MODE_DATA_LEN, 0) ) 
		return(0);
		/* check write protect */
	mh =  (struct mode_head *)dp->own_bp->b_un.b_addr;

	if(mh->med_type & EXABYTEMASK)
		return(XABYTE);
	else
		return(ARCHIVE);
		
#else
	struct blk_dscptr *blkcptr; 
	uint	type;

	if (!TAPE_COMMAND(dp->b_dev, CDB_MODE_SENSE, TAPE_SENSE_DATA_LEN, 0)) 
		return(0);
		/* check write protect */
	mh =  (struct mode_head *)dp->own_bp->b_un.b_addr;
	blkcptr = (struct blk_dscptr *)((uint)mh + MODEHEAD_LEN);

#ifdef TP9TRK
	type = TRACK9 ;
	return(type) ;
#else /* TP9TRK */

/******
	switch(blkcptr->density){
		case NRZI:
		case PE:
		case GCR:
		case DDPE:
		case DAT:
			type = TRACK9;
			break;
		default:
			type = ARCHIVE;
			break;
	}
 ****************/

	type = ARCHIVE ;
	return(type);
#endif /* TP9TRK */
#endif /* EXABYTE */
} /* end of media_type */

static tape_resrc_alloc(dp) 
struct DEVICE_TABLE *dp;
{
	ASSERT(!(dp->b_flags & B_ALLOC));
	ASSERT(dp->cm == NULL);
	ASSERT(dp->cm_bkup == NULL);
	ASSERT(dp->own_bp == NULL);
	if ((dp->cm = scsi_get_cmd(dp->b_dev)) == NULL)
		return(0);
	if ((dp->cm_bkup = scsi_get_cmd(dp->b_dev)) == NULL) {
		scsi_put_cmd(dp->cm);
		dp->cm = NULL;
		return(0);
	}
	dp->own_bp = geteblk();
	dp->own_bp->b_proc = 0;
	dp->own_bp->b_dev = dp->b_dev << 4;
	dp->b_flags |= B_ALLOC;
	dp->tapemark = 0 ;
	return(1);
}

static tape_resrc_dealloc(dp) 
struct DEVICE_TABLE *dp;
{
	ASSERT(dp->b_flags & B_ALLOC);
	ASSERT(dp->cm);
	ASSERT(dp->cm_bkup);
	ASSERT(dp->own_bp);
	scsi_put_cmd(dp->cm);
	scsi_put_cmd(dp->cm_bkup);
	brelse(dp->own_bp);
	dp->cm = dp->cm_bkup = (CMD_BOX *)NULL;
	dp->own_bp = (struct buf *)NULL;
	dp->b_flags &= ~B_ALLOC;
}
static
write_protect(dp)
struct DEVICE_TABLE *dp;
{
	
#ifdef EXABYTE
	XBYTE_MODE_DATA *mp;
	TAPE_COMMAND(dp->b_dev, CDB_MODE_SENSE, XB_MODE_DATA_LEN, 0);
	mp =  (XBYTE_MODE_DATA *)dp->own_bp->b_un.b_addr;
	return (mp->mh.wp_bm_speed & WP);
#else
	struct mode_head *mh;
	TAPE_COMMAND(dp->b_dev, CDB_MODE_SENSE, TAPE_SENSE_DATA_LEN, 0); 	
	mh =  (struct mode_head *)dp->own_bp->b_un.b_addr;
	return (mh->wp_bm_speed & WP);
#endif /* EXABYTE */
}
