/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) stp_ioctl.c: version 4.1 created on 5/2/90 at 19:38:45	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)stp_ioctl.c	4.1	5/2/90 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/debug.h"
#include "sys/file.h"
#include "sys/errno.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/ioctl.h"

#include "sys/user.h"
#include "sys/buf.h"

#include "hlvl_macro.h"
#include "scsi_cmdbx.h"
#include "stp_cdb.h"

#ifdef EXABYTE
#include "xbyte.h"
#include "xbyte_cdb.h"
#include "xbyte_ioc.h"
#else

#include "stp.h"
#endif /* EXABYTE */
#include "stioctl.h"
#include "scsi_log.h"


extern struct DEVICE_TABLE TAPE_TAB[];

static	int
suword(addr, value)
caddr_t	addr;
uint	value;
{
	return(copyout(&value, addr, sizeof(value)));
}

/*
 * sxbioctl()
 *
 *		ioctl interface for archive drive
 *
 * Parameters:
 *
 *	Minor dev num.
 *
 *	Command:
 *
 *		PERGET or PERSET
 *
 *	Argument:
 *
 *		Pointer to an integer containing one of the following values:
 *
 *		REWIND, TAPESTAT, PERGET, PERSET,
 *		LASTSTAT, TENSION, ERASE
 *
 *	Mode:
 *
 *		Mode that the device is opened with. (see file.h)
 */

unchar	*tapeaddr;

TAPE_IOCTL(dev,cmd,arg,mode)
{

	int type;
	struct	DEVICE_TABLE *dp = GETDP(UNIT(dev));	
	uint	scsi_cmd = CCS_NO_CMD;
	
	ASSERT(dp->type == SA_DEV);
	if( copyin(arg, &type, sizeof(type)) != -1){
		log(LOG_TAPE|LOG_IOCTL,type>>8,type,RBEGIN);

		switch (cmd) {
		case PERGET:
			tapegetcmd(dp,type,arg,mode,&scsi_cmd);
			break;

		case PERSET:
			tapesetcmd(dev, dp,type,arg,mode,&scsi_cmd);
			break;

		default:
			u.u_error = EINVAL;
			break;
		}
	}
	else
		u.u_error = EFAULT;

	if(u.u_error == 0 && scsi_cmd != CCS_NO_CMD){
		if ( !TAPE_COMMAND(dp->b_dev, scsi_cmd, 0, 0))
			u.u_error = EIO;
	}
	log(LOG_TAPE|LOG_IOCTL,type>>8,type,REND);
}

/* SCSI mode_sense      0,	1,	2,	3,	4,	5,	6    */
/* density code		defaule 800	1600	6250	???	???	3200 */
static
char density_conv[] = { 1, 	4,	 1, 	2,	6,	7,	3    };

static tapegetcmd(dp,type,arg,mode,scsi_cmd)
struct DEVICE_TABLE *dp;
ushort	type;
uint	*scsi_cmd;
{
	switch ( type ) {

	case  TAPESTAT:
	{
		register EX_SENSE_DATA *sd;

		TAPE_COMMAND(dp->b_dev, CDB_REQUEST_SENSE, SENSE_DATA_SIZE, 0);
		sd = (EX_SENSE_DATA *)dp->own_bp->b_un.b_addr;
		if((sd->sense_key  & SENSE_KEY) ==  SNSKEY_NOT_READY)
			type = TP_NRDY;
		else
		if(sd->sense_key & EOMD)
			type = TP_EOM;
		else 
			type = 0;

		if ( copyout(&type, arg, sizeof(type)) == -1 )
			u.u_error = EFAULT;
		break;
	}

	case  LASTSTAT:
		type = dp->status;

		if ( copyout(&type, arg, sizeof(type)) == -1 )
				u.u_error = EFAULT;
		break;


	case T_GET_CACHE:	/* returns cache bit: 0=no,1=yes*/

		if (suword(arg, dp->has_cache) < 0)
			u.u_error = EFAULT;
		break;

#ifdef EXABYTE

	case T_GET_TYPE:	/* returns drive type: nine track */
		if (suword(arg, TRACK9) == -1 )
			u.u_error = EFAULT;
		break;
	case T_GET_DENSITY:	/* returns density code */
	case T_GET_SPEED:	/* returns speed: 0=low,1=hi	*/
		u.u_error = EFAULT;
		break;

	case XB_GET_MODE:
		if (suword(arg, dp->mode_flags) < 0)
			u.u_error = EFAULT;
		break;

	case XB_GET_MOTION:
		if (suword(arg, dp->motion_thres) < 0)
			u.u_error = EFAULT;
		break;

	case XB_GET_RECONN:
		if (suword(arg, dp->recon_thres) < 0)
			u.u_error = EFAULT;
		break;
	
	case XB_GET_POSITION:
	{
		register EX_SENSE_DATA *sd;
		uint cur_pos ;

		TAPE_COMMAND(dp->b_dev, CDB_REQUEST_SENSE, SENSE_DATA_SIZE, 0);
		sd = (EX_SENSE_DATA *)dp->own_bp->b_un.b_addr;

		cur_pos = CAT3 (sd->remain_msb, sd->remain_mid, 
						sd->remain_lsb) ;
		if ( copyout(&cur_pos, arg, sizeof(cur_pos)) == -1 )
			u.u_error = EFAULT;
		break ;
	}

	case  TAPE_TYPE:
	default:

		if ( (suword(arg, TRACK9)) < 0)
			u.u_error = EFAULT;
		break;

#else
	case T_GET_TYPE:	/* returns drive type: nine track */

		if (suword(arg, dp->subtype) == -1 )
			u.u_error = EFAULT;
		break;

	case T_GET_DENSITY:	/* returns density code */
		if (dp->subtype != TRACK9)
			u.u_error = EFAULT;
		else
			if ((dp->density < 0) || (dp->density > DENS_3200))
				u.u_error = EFAULT;
			else
				if (suword(arg, density_conv[dp->density]) < 0)
					u.u_error = EFAULT;
		break;

	case T_GET_SPEED:	/* returns speed: 0=low,1=hi	*/
		if (dp->subtype != TRACK9)
			u.u_error = EFAULT;
		else
			if (suword(arg, (dp->speed == HI_SPEED)) < 0)
				u.u_error = EFAULT;
		break;

	case  TAPE_TYPE:
	default:

		if ( (suword(arg, dp->subtype)) < 0)
			u.u_error = EFAULT;
		break;
#endif /* EXABYTE */

	}
}

static tapesetcmd(dev, dp,type,arg,mode,scsi_cmd)
struct DEVICE_TABLE *dp;
ushort	type;
uint  *scsi_cmd;
{

		switch ( type ) {

		case  REWIND:
			*scsi_cmd = CDB_REWIND ;
			break;

		case  TENSION:
			if ( !TAPE_COMMAND(dp->b_dev, CDB_REWIND, 0, 0))
				u.u_error = EIO;
			else
				*scsi_cmd = CAT2((LD|RETEN),CDB_LOAD);
			break;
			
		case  ERASE:
			if ( ! (mode & FWRITE) )
				u.u_error = EINVAL;
			else
				*scsi_cmd = CDB_ERASE;
			break;				
		case  REOF:
			*scsi_cmd = CAT3(S_FMK , 1, CDB_SPACE);
			break;

		case  WEOF:
			if ( ! (mode & FWRITE) )
				u.u_error = EFAULT;
			else
				*scsi_cmd = CAT2(1, CDB_WRITE_FILEMARKS);
			break;
		default:
			tapeparamet(dev, dp,type);
			break;
		}
}


static tapeparamet(dev, dp,type)
struct DEVICE_TABLE *dp;
ushort	type;
{
		if (!(dev & ROC)) {
		/* settape has to be happened for rewind device */
			TAPE_DISPLAY_ERR( dp->subtype, dp->b_dev, "Device has to be a rewind device");
			u.u_error = EFAULT;
			return;
		}
		dp->b_flags |= B_SETTP; 	/* turn on settape flag */

		switch ( type ) {

		case T_HAS_CACHE:
			dp->has_cache = DO_CACHE;
			break;

		case T_NO_CACHE:
			dp->has_cache = NO_CACHE;
			break;
#ifdef EXABYTE
		case XB_NO_BUSY_EN:
			dp->mode_flags |= XB_NBE;	/* no busy enable */
			break;

		case XB_SET_BUSY_REP:
			dp->mode_flags &= ~XB_NBE;
			break;

		case XB_SET_EUR:
			dp->mode_flags |= XB_CT; /* set European tape */
			break;

		case XB_SET_DOM:	
			dp->mode_flags &= ~XB_CT; /* set domestic tape */
			break;

		case XB_NO_AUTO_LD:
			dp->mode_flags |= XB_NAL; /* set no auto loading */
			break;

		case XB_AUTO_LD:
			dp->mode_flags &= ~XB_NAL; /* set auto loading */
			break;
			
		case T_DEFT_DENSITY:
		case T_6250_DENSITY:
		case T_3200_DENSITY:
		case T_1600_DENSITY:
		case T_800_DENSITY:
		case T_HIGH_SPEED:
		case T_LOW_SPEED:
#else

		case T_DEFT_DENSITY:
			if(dp->subtype != TRACK9)
				u.u_error = EFAULT;
			else	
				dp->density = DENS_DEFAULT;
			break;

		case T_6250_DENSITY:
			if(dp->subtype != TRACK9) {
				u.u_error = EFAULT;
				break;
			}	
			dp->density = DENS_6250;
			dp->b_flags |= B_DENSITY; /* set density change flag */
			break;

		case T_1600_DENSITY:
			if(dp->subtype != TRACK9) {
				u.u_error = EFAULT;
				break;
			}
			dp->density = DENS_1600;
			dp->b_flags |= B_DENSITY; /* set density change flag */
			break;

		case T_800_DENSITY:
			if(dp->subtype != TRACK9) {
				u.u_error = EFAULT;
				break;
			}
			dp->density = DENS_800;
			dp->b_flags |= B_DENSITY; /* set density change flag */
			break;

		case T_3200_DENSITY:
			if(dp->subtype != TRACK9) {
				u.u_error = EFAULT;
				break;
			}
			dp->density = DENS_3200;
			dp->b_flags |= B_DENSITY; /* set density change flag */
			break;

		case T_HIGH_SPEED:
			if(dp->subtype != TRACK9)
				u.u_error = EFAULT;
			else
				dp->speed = HI_SPEED;
			break;
		
		case T_LOW_SPEED:
			if(dp->subtype != TRACK9) {
				u.u_error = EFAULT;
				break;
			}
			dp->speed = LOW_SPEED;
		        break;	
#endif /* EXABYTE */
		default:
			u.u_error = EFAULT;
		        break;	
	}
	if (u.u_error == EFAULT)
		dp->b_flags &= ~B_SETTP;
}

