/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) stp_intr.c: version 25.1 created on 11/27/91 at 14:46:06	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)stp_intr.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/debug.h"
#include "sys/file.h"
#include "sys/errno.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/elog.h"

#include "sys/buf.h"

#include "hlvl_macro.h"
#include "scsi_error.h"
#include "scsi_cmdbx.h"
#ifdef	EXABYTE
#include "xbyte.h"
#else
#include "stp.h"
#endif 	/* EXABYTE */
#include "stp_cdb.h"
#include "scsi_log.h"
#include "stioctl.h"


extern struct DEVICE_TABLE TAPE_TAB[];
extern char *scsi_err_msg();
extern char *scsi_sns_msg();

#define TBLKSHIFT	9

static
void tape_retry(cm)
CMD_BOX *cm;
{
	cm->retry_cnt--;
	cm->err_code = 0; /* clear error */
	scsi_send_cmd(cm); /* send command box to low level driver */
}
/*
 * TAPE_INTR() -- interrupt service routine
 */
void 
TAPE_INTR(cm)
register CMD_BOX *cm;
{
	struct buf *bp = (struct buf *)cm->tag;
	struct DEVICE_TABLE *dp;

	LOG_LONG_WORD(LOG_TAPE|LOG_INT, 0, cm, RBEGIN);
	
	dp = GETDP(cm->unit_id);

	ASSERT(bp == dp->outstanding);

	dp->status = cm->err_code;

	if(cm->err_code == SCSIERR_BUSY && cm->retry_cnt != 0) {
		timeout(tape_retry,cm,BUSY_TIME_SLICE); /* wait for a sec 
                          			          and try again */
		return;
	}
		
	if(cm->err_code )
		tape_err_handler(dp,cm);

	if(dp->status != 0){
		if (dp->tapemark & TM_EOM)
			bp->b_error = ENOSPC;
		else
			bp->b_error = EIO;	
		bp->b_flags |= B_ERROR;
		bp->b_resid = bp->b_bcount;
	}
	else{
		bp->b_resid  = cm->dma_resid;
		bp->b_flags &= ~B_ERROR;
		bp->b_error = 0;
		if (dp->tapemark & TM_DETECTED) {
			if (bp->b_resid == bp->b_bcount)
				dp->tapemark |= TM_REPORTED ;
		}
	}

	if (dp->own_bp != bp) {
		int act_byte;

		act_byte = bp->b_bcount - bp->b_resid;
		if (act_byte & (BLOCKSIZE - 1))
			dp->sar->io_bcnt++;	
		dp->sar->io_bcnt += (act_byte >> TBLKSHIFT);
		dp->sar->io_act += cm->act;
		dp->sar->io_resp += (get_time_stamp() - bp->b_start);
	}

	dp->outstanding = 0;  
	iodone(bp);
	TAPE_START(dp);	
	LOG_LONG_WORD(LOG_TAPE|LOG_INT,0, bp, REND);
} /* end of sxbintr */


static tape_err_handler(dp,cm)
register CMD_BOX *cm;
struct DEVICE_TABLE *dp;
{
	struct buf *bp = (struct buf *)cm->tag;
	EX_SENSE_DATA *sns = (EX_SENSE_DATA *)cm->error;	
	char *err_msg = 0;
	unchar	sense_key;

	if ((dp->status = cm->err_code) != SCSIERR_SENSE){
		if (!((dp->status == SCSIERR_ATN) && (dp->b_flags & B_NO_PRINT)))
			TAPE_DISPLAY_ERR(dp->subtype, cm->unit_id, 
				scsi_err_msg(dp->status));
		return;
	}
		
	if (!(sense_key = (sns->sense_key &  SENSE_KEY))) {
		tape_mark_handler(dp,cm);
		return;
	}
	/* check sense_recovered_error */
	/* hp returns recovered error code; kennedy doesn't */
	if (sense_key == SNSKEY_RECOVERED_ERR) {
		dp->status = 0 ;
		return ;
	}

#ifdef EXABYTE
	if (sense_key == SNSKEY_BLANK_CHECK){
#else
	if((sense_key == SNSKEY_BLANK_CHECK) && (dp->subtype == ARCHIVE)){
#endif /* EXABYTE */
		dp->status = 0;
		dp->tapemark |= TM_DETECTED ;
		return;
	}
/* wendy: if this is a nine track, this is an error to have blank_check
 * 	  i am now somewhere down the tape from the tapemark
 *	  do rewind ????
 *        or i can rewind back to the tapemark and make it act like the others
 *	  whereas, with the other two, the position of the head is still at
 *        the end of the filemark
 */


	if ((sense_key == SNSKEY_UNIT_ATTN) && (cm->cmd_dsc_blk[0] == CDB_ERASE)) {
		dp->status = 0;
		return;
	}
	/* print error message */
	if (!(sense_key == SNSKEY_UNIT_ATTN && dp->b_flags & B_NO_PRINT)) {
		err_msg = scsi_sns_msg(sense_key);
		ASSERT(err_msg);
		TAPE_DISPLAY_ERR(dp->subtype, cm->unit_id, err_msg);
		if(sns->err_class & INFO_VALID){
		 	printf("	residual length = %d\n",
			CAT4(sns->info_msb,sns->info_2,
			 sns->info_1, sns->info_lsb));
		}
	}
	if ( dp->status  && sense_key == SNSKEY_UNIT_ATTN )
		dp->status = SCSIERR_ATN;
} /* end of tape_err_handler */

static
tape_mark_handler(dp,cm)
register CMD_BOX *cm;
struct DEVICE_TABLE *dp;

{

	register unchar	cmd = cm->cmd_dsc_blk[0];
	EX_SENSE_DATA *sns = (EX_SENSE_DATA *)cm->error;

	/* if it just get warning message */
	if(sns->sense_key & FMD)
	/* if it is file mark detected warning */
		dp->tapemark |= TM_DETECTED ;
	if(sns->sense_key & EOMD)
		dp->tapemark |= TM_EOM;
		
	switch ( cmd ){
	/* on  following conditions, the error condition are not 
			suppose to set */

	case CDB_READ:
                if ((sns->sense_key & FMD) || (sns->sense_key & EOMD ))
			dp->status = 0;
		break;
			
	case CDB_WRITE:
		if (sns->sense_key & EOMD)
			dp->status = 0;
		break;

	case CDB_WRITE_FILEMARKS:
		if (( sns->sense_key& FMD) || (sns->sense_key & EOMD))
			dp->status =0;
		break;

	case CDB_SPACE:
		if(sns->sense_key & FMD) 
			dp->status = 0;
		break;

	case CDB_ERASE:
		if(sns->sense_key & EOMD)
			dp->status = 0;
		break;

	} /* end of switch of command */
	if (dp->status != 0) {
		if (dp->tapemark & TM_DETECTED)
			TAPE_DISPLAY_ERR(dp->subtype, cm->unit_id, 
				" file mark detected");
		if (dp->tapemark & TM_EOM)
			TAPE_DISPLAY_ERR(dp->subtype, cm->unit_id, 
				" End of tape detected");
		if(sns->sense_key & ILI)
			TAPE_DISPLAY_ERR(dp->subtype, cm->unit_id, 
				" illegal length detected");
	}
} /* end of tape_mark_handler */



TAPE_DISPLAY_ERR(type, unit_id, err_msg)
unchar	type;
unchar  unit_id;
char	*err_msg;
{
#ifdef	EXABYTE
	printf("%s on channel id %d unit id %d : %s\n", "Exabyte tape", 
		CHANID(unit_id), BUSID(unit_id), err_msg);
#else
	char *hdr;
	switch(type) {
		case ARCHIVE:
			hdr = "Cartridge tape error";
			break;
		case TRACK9:
			hdr = "9 track tape error";
			break;
		default:
			hdr = "Tape error";
	}
		
	printf("%s on channel id %d unit id %d : %s\n", hdr, CHANID(unit_id), 
		BUSID(unit_id), err_msg);
#endif	/* EXABYTE */
}
	
	
