/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) space.c: version 25.1 created on 11/27/91 at 14:45:22	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)space.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#define IOPM_OS

#include "sys/types.h"
#include "callo.h"
#include "sys/fs/s5param.h"
#include "sys/map.h"
#include "sys/iopmstat.h"
#include "stream.h"
#include "iopmconf.h"
#include "buf.h"
#include "tcb.h"
#include "devsw.h"
#include "dma.h"

struct iopminfo  iopminfo;

uint          numtcb = NUM_START_TCB;
uint          numtcb_struct = NUMTCB_STRUCT;
struct tcb    tcbpool[NUMTCB_STRUCT];

uint          ncallout = NCALLOUT;
struct icallo callout[NCALLOUT];

uint          nbuffermap = NBUFFERMAP;
struct map    buffermap[NBUFFERMAP];

uint          maxsysmem = MAXSYSMEM;

char strlofrac = STRLOFRAC;		/* low priority cutoff percentage */
char strmedfrac = STRMEDFRAC;		/* medium priority cutoff percentage */

struct fmodsw fmodsw[64];
int	fmodcnt;

/* for BUFs static configureation */
#if NUMBUF
uint    numbuf = NUMBUF;
char    bufers[NUMBUF + 1][SBUFSIZE];
caddr_t bufferp = (caddr_t)bufers;
#else
uint    numbuf = 0;
caddr_t bufferp = 0;
#endif

#if NUMBP
uint    numbp = NUMBP;
i_buf_t bppool[NUMBP];
i_buf_t *bppoolp = bppool;
#else
uint    numbp = 0;
i_buf_t *bppoolp = 0;
#endif

/* for STREAMs static configuration */
#if NQUEUE
uint nq = NQUEUE;
iqueue_t queue[NQUEUE];
#else
uint nq = 0;
iqueue_t  queue[1];
#endif

#if N4096 | N2048 | N1024 | N512 | N256 | N128 | N64 | N16 | N4
int  nb[] = { N4096, N2048, N1024, N512, N256, N128, N64, N16, N4 };

char strbase[N4096 * 4096 + N2048 * 2048 + N1024 * 1024 + N512 * 512 +
            N256 * 256 + N128 * 128 + N64 * 64 + N16 * 16 + N4 * 4];
char *strbasep = strbase;

#define DBLKS  (N4096 + N2048 + N1024 + N512 + N256 + N128 + N64 + N16 + N4)
#define MBLKS  ((DBLKS * 5) / 4)

int nmblock = MBLKS;

mblk_t mblock[MBLKS];
mblk_t  *mblockp = mblock;

dblk_t dblock[DBLKS];
dblk_t  *dblockp = dblock;
#else
int nb[] = {0,0,0,0,0,0,0,0,0};
char *strbasep = 0;
int nmblock = 0;
mblk_t *mblockp = 0;
dblk_t *dblockp = 0;
#endif

#if NSTREVENT
int              nstrevent = NSTREVENT;	/* max number of stream event cells */
struct strevent  strevent[NSTREVENT];	/* table of stream event cells */
struct strevent  *streventp = strevent;
#else
int              nstrevent;
struct strevent  *streventp;
#endif

user_config()
{
	extern void	testo(), testc(), tests(), testi();
	extern void	sdkopen(), sdkclose(), sdkstrategy(), sdkprint(),
			sdkioctl();
	extern void	stpopen(), stpclose(), stpstrategy(), stpioctl();
	extern void	sxbopen(), sxbclose(), sxbstrategy(), sxbioctl();
	extern void	pt_open(), pt_close(), pt_strategy(), pt_ioctl();
	extern void	sar_open(), sar_close(), sar_strategy(), sar_ioctl();
	extern void	cdr_open(), cdr_close(), cdr_strategy(), cdr_ioctl();
	extern void	hpopen(), hpclose(), hpstrategy(), hpioctl();
	extern void	optopen(), optclose(), optstrategy(), optioctl();
	extern void	scsi_init();
	extern void	dev_srv_intr();
	extern void	nulldev();
	extern uint	devcnt;

	bdevsw[0].d_open = sdkopen;
	bdevsw[0].d_close = sdkclose;
	bdevsw[0].d_strategy = sdkstrategy;
	bdevsw[0].d_print = sdkprint;
	cdevsw[0].d_ioctl = sdkioctl;
	bdevsw[0].dma = SGDMA;  /* allow driver to go thru CSS bus */

	bdevsw[1].d_open = stpopen;
	bdevsw[1].d_close = stpclose;
	bdevsw[1].d_strategy = stpstrategy;
	bdevsw[1].d_print = nulldev;
	cdevsw[1].d_ioctl = stpioctl;
	bdevsw[1].dma = SGDMA;  /* allow driver to go thru CSS bus */

	bdevsw[2].d_open = sxbopen;
	bdevsw[2].d_close = sxbclose;
	bdevsw[2].d_strategy = sxbstrategy;
	bdevsw[2].d_print = nulldev;
	cdevsw[2].d_ioctl = sxbioctl;
	bdevsw[2].dma = SGDMA;  /* allow driver to go thru CSS bus */

	bdevsw[3].d_open = pt_open;
	bdevsw[3].d_close = pt_close;
	bdevsw[3].d_strategy = pt_strategy;
	bdevsw[3].d_print = nulldev;
	cdevsw[3].d_ioctl = pt_ioctl;
	bdevsw[3].dma = SGDMA;  /* allow driver to go thru CSS bus */

	bdevsw[4].d_open = cdr_open;
	bdevsw[4].d_close = cdr_close;
	bdevsw[4].d_strategy = cdr_strategy;
	bdevsw[4].d_print = nulldev;
	cdevsw[4].d_ioctl = cdr_ioctl;
	bdevsw[4].dma = SGDMA;  /* allow driver to go thru CSS bus */

	bdevsw[5].d_open = sar_open;
	bdevsw[5].d_close = sar_close;
	bdevsw[5].d_strategy = sar_strategy;
	cdevsw[5].d_ioctl = sar_ioctl;
	bdevsw[5].d_print = nulldev;
	bdevsw[5].dma = LOCALDMA;  /* allow driver to go thru CSS bus */

	bdevsw[6].d_open = hpopen;
	bdevsw[6].d_close = hpclose;
	bdevsw[6].d_strategy = hpstrategy;
	cdevsw[6].d_ioctl = hpioctl;
	bdevsw[6].d_print = nulldev;
	bdevsw[6].dma = SGDMA;  /* allow driver to go thru CSS bus */

	bdevsw[7].d_open = optopen;
	bdevsw[7].d_close = optclose;
	bdevsw[7].d_strategy = optstrategy;
	bdevsw[7].d_print = nulldev;
	cdevsw[7].d_ioctl = optioctl;
	bdevsw[7].dma = SGDMA;  /* allow driver to go thru CSS bus */

	devcnt = 8;
	scsi_init();
}

