/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sar.c: version 25.1 created on 11/27/91 at 14:45:18	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sar.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <sys/param.h>
#include <sys/types.h>
#include <sys/debug.h>
#include <sys/buf.h>
#include <sys/errno.h>
#include <sys/elog.h>
#include <sys/user.h>

#define	MAX_SCSI	16

sar_open()
{
}

sar_close()
{
}

sar_ioctl()
{
	u.u_error = EINVAL;
}

sar_strategy(bp)
register struct buf	*bp;
{
	uint	count, unit;
	char	*src, *dst;
	struct iotime	*get_iotime();

	count = bp->b_bcount;
	bp->b_resid = 0;
	dst = bp->b_un.b_addr;

	if (count % sizeof(struct iotime)) {
		bp->b_error = EINVAL;
		bp->b_flags |= B_ERROR;
		iodone(bp);
		return;
	}

	if (count >= MAX_SCSI * sizeof(struct iotime))
		bp->b_resid += bp->b_bcount - MAX_SCSI *
		  sizeof(struct iotime);
	unit = 0;
	while (count) {
		src = (char *) get_iotime(unit++);
		bcopy(src, dst, sizeof(struct iotime));
		count -= sizeof(struct iotime);
		dst += sizeof(struct iotime);
	}
	iodone(bp);
}
