/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) pt.c: version 25.1 created on 11/27/91 at 14:45:14	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)pt.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/param.h"
#include "sys/debug.h"
#include "sys/file.h"
#include "sys/errno.h"
#include "sys/sysmacros.h"
#include "sys/user.h"
#include "sys/buf.h"

#include "scsi_error.h"
#include "scsi_cmdbx.h"
#include "passthru.h"



extern CMD_BOX *scsi_get_cmd();

static CMD_BOX	*pt_box[16];
static uint	pt_state[16];
#define	STATE_INIT	0
#define	STATE_GOT_CMD	1
#define	STATE_DID_CMD	2

static void
pt_iodone(box)
CMD_BOX	*box;
{
	register buf_t	*bp = (buf_t *) box->tag;

	ASSERT(box == pt_box[( box->unit_id & 0xF)] );
	bp->b_resid = box->dma_resid;
	pt_state[(box->unit_id & 0xF)] = STATE_DID_CMD;
	iodone(box->tag);
}

static void
pt_wakeup(box)
CMD_BOX *box;
{
	ASSERT(box == pt_box[(box->unit_id & 0xF)] );
	pt_state[(box->unit_id & 0xF)] = STATE_DID_CMD;
	wakeup(box);
}

/* device config table */
pt_open(minor_dev, flag)
dev_t		minor_dev;
unsigned	flag;
{
	if (pt_box[minor_dev]) {
		u.u_error = EBUSY;
		return;
	}
	pt_box[minor_dev] = scsi_get_cmd(minor_dev);
	if (!pt_box[minor_dev]) {
		u.u_error = EINVAL;
		return;
	}
	pt_box[minor_dev]->unit_id = minor_dev;
	pt_box[minor_dev]->service = NULL;
	pt_state[minor_dev] = STATE_INIT;
}

pt_close(minor_dev, flag)
register dev_t	minor_dev;
short		flag;
{
	scsi_put_cmd(pt_box[minor_dev]);
	pt_box[minor_dev] = NULL;
}

pt_strategy(bp)
register struct buf	*bp;
{
dev_t minor_dev;
	minor_dev=minor(bp->b_dev);
	if (pt_state[minor_dev] != STATE_GOT_CMD) {
		bp->b_error = EINVAL;
		bp->b_flags |= B_ERROR;
		iodone(bp);
		return;
	}
	pt_box[minor_dev]->tag = (uint) bp;
	pt_box[minor_dev]->dma_buffer = (unchar *) bp->b_un.b_addr;
	pt_box[minor_dev]->dma_proc = bp->b_proc;
	pt_box[minor_dev]->dma_buf_len = bp->b_bcount;
	if (bp->b_flags & B_READ)
		pt_box[minor_dev]->dma_flags = DMA_READ;
	else
		pt_box[minor_dev]->dma_flags = 0;
	pt_box[minor_dev]->service = pt_iodone;
	scsi_send_cmd(pt_box[minor_dev]);
}

pt_ioctl(minor_dev, cmd, arg)
register dev_t	minor_dev;
uint		cmd;
uint		arg;
{
	CMD_BOX	user_box;
	SCSI_CMD  user_command;
  	SCSI_RESULT user_result;
	uint	index;
	uint	x;

	switch (cmd) {
	case PT_SET_CMD:
		if (copyin(arg, &user_command, sizeof(SCSI_CMD)) < 0) {
			u.u_error = EFAULT;
			return;
		}
		pt_box[minor_dev]->cmd_type = CMD_RELEASE_ATTN;

		pt_box[minor_dev]->cmd_dsc_len = user_command.cmd_dsc_len;
		for (index = 0; index < pt_box[minor_dev]->cmd_dsc_len; index++)
			pt_box[minor_dev]->cmd_dsc_blk[index] =
			  user_command.cmd_dsc_blk[index];
/*MBJM -- timer = mil_seconds / ???? */
		pt_box[minor_dev]->timer = user_command.mil_sec;
		pt_state[minor_dev] = STATE_GOT_CMD;
		break;
	case PT_EXECUTE:
		if ( pt_state[minor_dev] != STATE_GOT_CMD ) {
			u.u_error = EINVAL;
			return;
		}
		pt_box[minor_dev]->service = pt_wakeup;
		pt_box[minor_dev]->dma_buf_len = 0;
		pt_box[minor_dev]->dma_proc = NULL;
		pt_box[minor_dev]->dma_buffer = NULL;
		scsi_send_cmd(pt_box[minor_dev]);
		x = splserv();
		while (pt_state[minor_dev] != STATE_DID_CMD)
			sleep(pt_box[minor_dev]);
		splx(x);
		break; 
	case PT_GET_RESULTS:
		if ( pt_state[minor_dev] != STATE_DID_CMD ) {
			u.u_error = EINVAL;
			return;
		}
 		user_result.act_time = pt_box[minor_dev]->act;
 		user_result.disc_count = pt_box[minor_dev]->disc_count;
 		user_result.err_code = pt_box[minor_dev]->err_code;
 		user_result.err_len = pt_box[minor_dev]->err_len;
		for (index = 0; index < user_result.err_len; index++)
		  	user_result.error[index] = pt_box[minor_dev]->error[index];
		if (copyout(&user_result, arg, sizeof(SCSI_RESULT)) < 0)
			u.u_error = EFAULT;
		pt_state[minor_dev] = STATE_INIT;
		break;
	default:
		u.u_error = EINVAL;
		break;
	}
}
