/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) opt_strat.c: version 25.1 created on 11/27/91 at 14:45:06	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)opt_strat.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* opt_strat.c -- optical driver strategy  	*/

#include "sys/types.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/errno.h"
#include "sys/elog.h"
#include "sys/file.h"
#include "sys/debug.h"

#include "sys/buf.h"

#include "scsi_log.h"
#include "hlvl_macro.h"
#include "opt_cdb.h"
#include "sys/ioctl.h"
#include "scsi_cmdbx.h"
#include "opt.h"


extern buf_t *o_ownbuf[];
extern struct local_buffer dbf;
extern void opt_intr();
extern struct optiobuf opttbl[];
extern get_time_stamp();
extern void	swap_buff();


#define ONEK_TO_DRV_BLK(dp, onek_blkno) \
			((BSIZE > (dp)->cfg.blk_len) ? \
			(onek_blkno) * (dp)->cfg.blk_ratio : \
			(onek_blkno) / (dp)->cfg.blk_ratio)

/*
optcommand -- This routine used for internal issueing a disk operation 
	      request. It setup local buf header and then call strategy
	      routine.
input: 
      unit_id -- scsi device target ID.(1-7 or 8-15).
      cmd     -- First bytes : scsi command code.
	         Rest of three bytes :	parameters go with command.	
      buf_len -- number of bytes to transfer. if it is 0 , then use default
		 value.
output:
	successful -- 1.
	otherwise -- 0.
*/
	
optcommand(unit_id,cmd,buf_len)
unchar	unit_id;
uint cmd;
uint buf_len;
{
	register buf_t *bp = o_ownbuf[unit_id];
	uint	x;
	unchar scsi_cmd;
	
	/*log(LOG_WRM|LOG_XCMD, unit_id, cmd>>24, RBEGIN);*/
	/*log(LOG_PR, buf_len>>16, buf_len>>8, buf_len);*/
	/* setup buf header structure */
	bp->b_error = 0;
	bp->b_cmd = cmd;
	bp->b_bcount = buf_len;
	bp->b_resid = 0;
	scsi_cmd = bp->b_cmd;
	if ((scsi_cmd == CDB_READ) || (scsi_cmd == CDB_WRITE))
		bp->b_sblock = (struct buf *)GET_PRA(cmd);  /* get block number */

	/* do the oper	*/
	optstrategy(bp);
	iowait(bp);
	bp->b_flags &= ~B_DONE;

	if (bp->b_flags & B_ERROR) {
		/*log(LOG_WRM|LOG_XCMD, unit_id, cmd, RERROR);*/
		/*log(LOG_PR, buf_len>>16, buf_len>>8, buf_len);*/
		return(0);
	}
	else {
		/*log(LOG_WRM|LOG_XCMD, unit_id, cmd, REND);*/
		/*log(LOG_PR, buf_len>>16, buf_len>>8, buf_len);*/
		return(1);
	}
	
} /* end of optcommand */

optstrategy(bp)
register struct	buf	*bp;	/* request buffer pointer */
{
	unchar	unit_id = UNIT(bp->b_dev);	/* get unit id */
	register struct optiobuf *dp = GETDP(unit_id); /* get device table */
	uint	noblk = dp->cfg.lst_blkno + 1;
	uint	drv_blkno =  ONEK_TO_DRV_BLK(dp, (uint)bp->b_blkno); /* drive block */
	uint	iplsave;
	int	lblk; /* last block */
	
	/*LOG_LONG_WORD(LOG_WRM|LOG_STRA, 0, bp, RBEGIN);*/

	if (bp != o_ownbuf[unit_id]) {
		/* command is issued by kernel */
		ASSERT(dp->open_cnt);
		if (dp->b_flags & B_NEWMDM) {
			DISPLAY_DRV_ID(unit_id);
			printf("%s\n", "Medium has been changed.");
			opterror(bp, EINVAL);
			return;
		}

		if (bp->b_bcount & (dp->cfg.blk_len - 1)) { /* check len */
			DISPLAY_DRV_ID(unit_id);
			printf("%s - %u\n", " illegal data length", bp->b_bcount);
			opterror(bp, EINVAL);
			/*LOG_LONG_WORD(LOG_WRM|LOG_STRA, ENXIO, bp, RERROR);*/
			return;
		}

		/* if the requested data block does not fall within range of medium */
		if (drv_blkno >= noblk) {
			if ((drv_blkno == noblk) && (bp->b_flags & B_READ)) {
				bp->b_resid = bp->b_bcount;
				/*LOG_LONG_WORD(LOG_DSK|LOG_STRA, 0, bp, REND);*/
				/*LOG_LONG_WORD(LOG_PR, 0, bp->b_resid, 0);*/
				iodone(bp);
			}
			else {
				opterror(bp, ENXIO);
				/*LOG_LONG_WORD(LOG_WRM|LOG_STRA, ENXIO, bp, RERROR);*/
			}
			return;
		}
		if ((lblk = drv_blkno + (bp->b_bcount / dp->cfg.blk_len) - 1) >= noblk) 
			bp->b_resid = dp->cfg.blk_len * (lblk - noblk + 1);
		else
			bp->b_resid = 0;

		ASSERT(drv_blkno + (bp->b_bcount-bp->b_resid)/dp->cfg.blk_len <= noblk);

		bp->b_sblock = (struct buf *)drv_blkno;
		/* update statistic information */
		bp->b_start = get_time_stamp(); /* get starting time */
	}
	iplsave = splhlv();
	dp->sar->io_cnt++;
	dp->qcnt++; /* inc current i/o request */

	optsort(dp, bp);
	optstart(dp);
	/* EXIT CRITICAL REGION */
	splx(iplsave);
	/*LOG_LONG_WORD(LOG_WRM|LOG_STRA, 0, bp, REND);*/
		
} /* end of optstrategy */

#ifdef ATT
optsort(dp, bp)
register struct optiobuf *dp;
register struct buf	*bp;
{
	/* link buffer header to drive worklist */
	if (dp->b_actf == NULL) {
		dp->b_actf = bp;
		dp->b_actl = bp;
		dp->b_acts = bp;
		bp->av_forw = NULL;
	} else {
 		register struct buf *ap, *cp;

 		if ((dp->sar->io_cnt&(SSTEP-1)) == 0)
 			dp->b_acts = dp->b_actl;
 		for (ap = (struct buf *)dp->b_acts; cp = ap->av_forw; ap = cp) {
 			register int s1, s2;
 			if ((s1 = ap->b_sblock- bp->b_sblock)<0)
 				s1 = -s1;
 			if ((s2 = ap->b_sblock - cp->b_sblock)<0)
 				s2 = -s2;
 			if (s1 < s2)
 				break;
 		}
 		ap->av_forw =  bp;
 		if ((bp->av_forw = cp) == NULL)
 			dp->b_actl = bp;
	}
} /* end of sorting */

/* optstart -- get a request */
optstart(dp)
struct optiobuf	*dp;
{
	struct buf *bp;
	
	/*LOG_LONG_WORD(LOG_WRM|LOG_START, 0, dp, RBEGIN);*/
	if (dp->b_flags & B_RESET)
		return;
	if ((dp->b_actf) && (dp->b_outcnt < BOTH_IN_USE)) {
	/* dequeue i/o request */
		bp = dp->b_actf;
		if (dp->b_outcnt == 0)  {
		/* no command outstanding, dequeue it! */
			if ((dp->b_actf = bp->av_forw) == NULL) {
				dp->b_actl = NULL;
				dp->b_acts = NULL;		
			}
			if(bp == dp->b_acts)
				dp->b_acts = dp->b_actf;
			dp->qcnt--;
			ASSERT(dp->qcnt != -1);
		}
		optxstart(dp, bp);
	}
	/*log(LOG_WRM|LOG_START, 0, dp, REND);*/

} /* end of optstart */
#endif /* ATT */


#ifdef C_SCAN
optsort(dp, bp)
register struct optiobuf *dp;
register struct buf	*bp;
{
	register buf_t	*ap, *cp;
	int first_q;


	if ( ! dp->b_actf ) {
		dp->b_actf = dp->b_actl = dp->b_acts = bp;
		dp->b_acte = bp;
		bp->av_forw = 0;
		return;
	}

	/* sort groups of SSTEP - 1 */
 	if ((dp->sar->io_cnt&(SSTEP-1)) == 0) {
		dp->b_acts =  dp->b_acte = dp->b_actl;
	}
	if ( bp->b_sblock < dp->b_acts->b_sblock) {
		first_q = 0;
		for (ap = dp->b_acte; cp = ap->av_forw; ap = cp)
			if (bp->b_sblock < cp->b_sblock)
				break;
	}
	else {
		first_q = 1;
		for (ap = dp->b_acts; cp = ap->av_forw; ap = cp) {
			if ( ap == dp->b_acte)
				break;
			if (bp->b_sblock < cp->b_sblock)
				break;
		}
	}
	ap->av_forw =  bp;

	if ((bp->av_forw = cp) == NULL)
		dp->b_actl = bp;
	if (first_q == 1 && ap == dp->b_acte)
		dp->b_acte = bp;
} /* end of sorting */

/* optstart -- get a request */
optstart(dp)
struct optiobuf	*dp;
{
	struct buf *bp;
	
	/*LOG_LONG_WORD(LOG_WRM|LOG_START, 0, dp, RBEGIN);*/
	if (dp->b_flags & B_RESET)
		return;
	if((dp->b_actf)&&(dp->b_outcnt < BOTH_IN_USE)){
	/* dequeue i/o request */
		bp = dp->b_actf;
		if (dp->b_outcnt == 0)  {
		/* no command outstanding, dequeue it! */
			if ((dp->b_actf = bp->av_forw) == NULL) {
				dp->b_actl = NULL;
				dp->b_acts = NULL;		
				dp->b_acte = NULL;
			}
			if (bp == dp->b_acts)
				dp->b_acts = dp->b_actf;
			if (bp == dp->b_acte)
				dp->b_acte == dp->b_actf;
			dp->qcnt--;
			ASSERT(dp->qcnt != -1);
		}
		optxstart(dp, bp);
	}
	/*log(LOG_WRM|LOG_START, 0, dp, REND);*/

} /* end of optstart */
#endif /* C_SCAN */


/* optxstart -- format request to scsi Command Descriptor Block */
optxstart(dp, bp)
struct optiobuf	*dp;
register struct buf *bp;
{
	register CMD_BOX *cm;	
	unchar	unit_id,index;

	/* get command mailbox	*/
	/*LOG_LONG_WORD(LOG_WRM|LOG_XSTART, 0, bp, RBEGIN);*/
	unit_id = UNIT(bp->b_dev);
	index = dp->b_outcnt & CMB0_IN_USE;
	cm = dp->cm[index];
	ASSERT(cm);
	dp->b_outcnt |= (index+1);

	bzero (cm, sizeof (CMD_BOX));

	/* format command descriptor block and command mailbox	*/
	cm->dma_flags = 0; /* clear flag */
	
	/* setup general information in command mail box */
	cm->service = opt_intr; /* setup server routine */
	cm->tag = (uint )bp;		   /* setup tag */
	cm->unit_id = UNIT(bp->b_dev);
	cm->cmd_type = 0;	/* set to regular command */
	cm->retry_cnt = 5;

	if (bp == o_ownbuf[unit_id])
		optlocalio(dp, cm, bp);
	else
		optfastio(dp, cm, bp);

	/* setup dma information */
	if ((cm->dma_buf_len = bp->b_bcount - bp->b_resid) != 0) {
		cm->dma_buffer = (unchar *)bp->b_un.b_addr;
		cm->dma_proc = bp->b_proc;
		/* swap bytes for write if necessary */
		if ((dp->b_flags & B_SWAP) && !(bp->b_flags & B_READ))
			swap_buff(cm->dma_buffer, cm->dma_buf_len, cm->dma_proc);
	}
   scsi_send_cmd(cm);
	/*LOG_LONG_WORD(LOG_WRM|LOG_XSTART, 0, bp, REND);*/
	
} /* end of optxstart */

opterror(bp, err)
struct buf *bp;
unchar err;
{
	bp->b_flags |= B_ERROR;
	bp->b_error = err;
	iodone(bp);
}

optfastio(dp, cm, bp)
struct optiobuf	*dp;
register CMD_BOX *cm;
register struct buf *bp;
{

	register struct g1_cdb	*cdb = (struct g1_cdb *)(cm->cmd_dsc_blk);
	uint	blk_cnt, drv_blkno;

	cm->cmd_dsc_len = G1SIZE;
    	if(!(bp->b_flags & B_READ))
		cdb->opcode = CDB_WRITE_EXTENDED;
	else {
		cdb->opcode = CDB_READ_EXTENDED;
		cm->dma_flags |= DMA_READ;
	}
	cdb->ctl = 0;
	ITOC4(cdb->lbadr_msb, cdb->lbadr_2, cdb->lbadr_1, cdb->lbadr_lsb, (uint)bp->b_sblock);
	blk_cnt = (bp->b_bcount - bp->b_resid)/dp->cfg.blk_len;
	ASSERT(blk_cnt);
#ifdef DEE
	if(!(cm->dma_flags & DMA_READ ) { /* write test */
		if(bp->b_tablep == 0 && cm->unit_id == 8){
			int i;
			unchar *datap = (unchar *)bp->b_un.b_addr;

			for(i = 0; i<200; i++){
				if(*datap++ != 0)
					break;
			}
			ASSERT(i < 200);
		}
	}
#endif
	ITOC2(cdb->xferlen_msb, cdb->xferlen_lsb, blk_cnt);

	cm->cmd_dsc_len = G1SIZE;
	cm->timer = BASIC_TIMER+(RWUNIT_TIMER*blk_cnt);
}

optlocalio(dp, cm, bp)
struct optiobuf	*dp;
register CMD_BOX *cm;
register struct buf *bp;
{
	register unchar	opcode = bp->b_cmd;

	switch (opcode & GRPMASK) {
		case GRP0:
			grp0_cdb(dp, cm, bp);
			break;
		case GRP1:
			grp1_cdb(dp, cm, bp);
			break;
		case GRP5:
			grp5_cdb(dp, cm, bp);
			break;
		default:
			panic("So far, the group number %d is not supported\n",
				((opcode & GRPMASK) >> 5));
	}
} /* end of optlocalio */
			
/*
	the rest of 3 routines - grp0_cdb, grp1_cdb and grp5_cdb - setting
	up command descriptor block, value of timer for each command,
	size of cdb, dma direction if necessary.
*/
#define CP_LIST	0x08

static
grp0_cdb(dp, cm, bp)
struct optiobuf	*dp;
register CMD_BOX *cm;
register struct buf *bp;
{
	register struct g0_cdb *cdb = (struct g0_cdb *)cm->cmd_dsc_blk;
 	uint	pars = GET_PRA(bp->b_cmd);
	uint	blk_cnt, drv_blkno;

	cdb->ctl = 0;
	cm->cmd_dsc_len = G0SIZE;

	switch(cdb->opcode = bp->b_cmd){
		case CDB_READ:
			cm->dma_flags |= DMA_READ;	
		case CDB_WRITE:
			/* setup block number and xfer count */
			
			ITOC3(cdb->lbaddr_msb, cdb->lbaddr, cdb->lbaddr_lsb, (uint)bp->b_sblock);
			cdb->lbaddr_msb &= 0x1F;
			cdb->xfer_len = (bp->b_bcount - bp->b_resid) /
						dp->cfg.blk_len;
			cm->timer = BASIC_TIMER + (RWUNIT_TIMER * cdb->xfer_len);
			break;

		case CDB_MODE_SENSE:
			cm->dma_flags |= DMA_READ;
			cdb->page_flags = pars;
			cdb->alloc_len = bp->b_bcount;
			cm->timer = MODE_TIMER;
			break;

		case CDB_MODE_SELECT:
			cdb->lun_flags = pars;
			cdb->alloc_len = bp->b_bcount;
			cm->timer = MODE_TIMER;
			break;

		case CDB_REQUEST_SENSE:
			cm->dma_flags |= DMA_READ;
			cm->timer = SENSE_TIMER;
			cdb->alloc_len = bp->b_bcount;
			break;

		case CDB_INQUIRY:
			cm->dma_flags |= DMA_READ;
			cm->timer = INQUIRY_TIMER;
			cdb->alloc_len = bp->b_bcount;
			cm->timer = BASIC_TIMER;
			break;

		case CDB_START_STOP:
			cdb->start_flags = pars;
			cm->timer = START_TIMER;	
			break;

		case CDB_MEDIUM_REMOVAL:
			cdb->prvnt = pars;
			cm->timer = START_TIMER;	
			break;

		case CDB_TEST_UNIT_READY:
		case CDB_REZERO:
			cm->timer = BASIC_TIMER;

			break;
#if 0 /* declan - comment out for now, untested */
		case CDB_FORMAT_UNIT:
			cdb->lun_flags = pars;
			cdb->alloc_len = bp->b_bcount;
			cm->timer = SONY_FORMAT_TIMER;	
			break;
#endif /* untested */
		default:
			ASSERT(0);
	}
}

static
grp1_cdb(dp, cm, bp)
struct optiobuf	*dp;
register CMD_BOX *cm;
register struct buf *bp;
{
	register struct g1_cdb *cdb = (struct g1_cdb *)cm->cmd_dsc_blk;
 	uint	pars = GET_PRA(bp->b_cmd);
	uint	blk_cnt, drv_blkno;
	
	cdb->ctl = 0;
	cm->cmd_dsc_len = G1SIZE;

	switch(cdb->opcode = bp->b_cmd){
		case CDB_READ_EXTENDED:
			cm->dma_flags |= DMA_READ;
			/* FALL THRU	*/
		case CDB_WRITE_EXTENDED:
			/* caculate drive block no */
			ITOC4(cdb->lbadr_msb, cdb->lbadr_2, cdb->lbadr_1, cdb->lbadr_lsb, (uint)bp->b_sblock);

			blk_cnt = (bp->b_bcount - bp->b_resid)/dp->cfg.blk_len;

			ITOC2(cdb->xferlen_msb, cdb->xferlen_lsb, blk_cnt);

			cm->timer = RWUNIT_TIMER*blk_cnt;
			break;

		case CDB_READ_CAPACITY:
			/* setup logical block number */
			ITOC4(cdb->calba_msb, cdb->calba_2, cdb->calba_1, cdb->calba_lsb, pars);
			
			if(pars)
				cdb->ca_pmi = PMI; /* set partial indicator */
			cm->timer = RDCP_TIMER;
			cm->dma_flags |= DMA_READ;
			break;

		default:
			panic("opt_strat: Unknown cdb command :%x\n",
				cdb->opcode);
	}
}

static
grp5_cdb(dp,cm,bp)
struct optiobuf	*dp;
register CMD_BOX *cm;
register struct buf *bp;
{
	register struct g5_cdb *cdb = (struct g5_cdb *)cm->cmd_dsc_blk;
 	uint	pars = GET_PRA(bp->b_cmd);
	
	cdb->ctl = 0;
	cm->cmd_dsc_len = G5SIZE;

	switch(cdb->opcode = bp->b_cmd){
		
		default:
			ASSERT(0);	
	}
}
