/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) opt_open.c: version 25.1 created on 11/27/91 at 14:45:01	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)opt_open.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* opt_open.c -- optical driver open/close routines */

#include "sys/types.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/debug.h"
#include "sys/errno.h"
#include "sys/elog.h"
#include "sys/file.h"
#include "sys/open.h"

#include "sys/user.h"
#include "sys/buf.h"

#include "scsi_log.h"
#include "hlvl_macro.h"
#include "opt_cdb.h"
#include "sys/ioctl.h"
#include "scsi_cmdbx.h"
#include "opt.h"


/* global data area	*/
struct buf	*o_ownbuf[MAXNODRVS];
struct optiobuf	opttbl[MAXNODRVS];
extern struct buf	*geteblk();
extern CMD_BOX	*scsi_get_cmd();
extern struct iotime	*get_iotime();
extern void	opt_reset_done();

void
opt_lock_buf(unit_id)
unchar unit_id;
{
	register buf_t *bp = o_ownbuf[unit_id];

	ASSERT(bp);
	while (bp->b_flags & B_BUSY) {
		bp->b_flags |= B_WANTED;
		sleep(bp, PRIBIO);
	}
	ASSERT((bp->b_flags & B_BUSY) == 0);
	bp->b_flags |= B_BUSY;
}

void
opt_rel_buf(unit_id)
unchar unit_id;
{
	register buf_t *bp = o_ownbuf[unit_id];

	ASSERT(bp->b_flags & B_BUSY);
	bp->b_flags &= ~B_BUSY;
	if(bp->b_flags & B_WANTED) {
		bp->b_flags &= ~B_WANTED;
		wakeup(bp);
	}
}
	
/* device lock  routine	*/
void
optslopen(dp)
struct optiobuf	*dp;
{
	uint	x;
	x = splhlv();	/* raise the interrupt mask level */

	dp->wait++;
	while(dp->b_flags & B_OPENING) /* wait for device available */
   		sleep(dp, PZERO);
	dp->b_flags |= B_OPENING; 
	dp->wait--;
	splx(x);
}

/* unlock device */
void
optwkup(dp)
struct optiobuf	*dp;
{
	uint	x;

	x = splhlv();	/* raise the interrupt mask level */
	dp->b_flags &= ~B_OPENING;
	wakeup(dp);
	splx(x);
}

static	void
optinit()
{
	uint i;

	/*log(LOG_OPT|LOG_INIT, 0, 0, RBEGIN);*/
	/* initialize global table */
	bzero(opttbl, sizeof(struct optiobuf) * MAXNODRVS);
	for ( i = 0; i < MAXNODRVS; i++)
		opttbl[i].unit_id = i;

	/*log(LOG_OPT|LOG_INIT, 0, 0, REND);*/

}

static
opt_alloc(dp)
register struct optiobuf *dp;
{
	register buf_t *bp;

	/* get drive's own buf header */
	bp = o_ownbuf[dp->unit_id] = geteblk();
	bp->b_dev = dp->unit_id << 4;
	bp->b_proc = 0;

	/* clear flags */
	opt_rel_buf(dp->unit_id);

	/* get command mailboxes */
	if (!(dp->cm[0] = scsi_get_cmd(dp->unit_id)))
		return 0;
	if (!(dp->cm[1] = scsi_get_cmd(dp->unit_id))) {
		if (scsi_put_cmd(dp->cm[0]) == 0)
			ASSERT(0);
		return 0;
	}
	return 1;
}

static opt_dealloc(dp)
register struct optiobuf *dp;
{
	register buf_t *bp = o_ownbuf[dp->unit_id];

	ASSERT(bp);
	brelse(bp);
	o_ownbuf[dp->unit_id] = NULL;
	/* release command mailboxes */
	if(scsi_put_cmd(dp->cm[0])== 0)
		ASSERT(0);
	if(scsi_put_cmd(dp->cm[1]) == 0)
		ASSERT(0);
	dp->cm[0] = dp->cm[1] = NULL;
	dp->b_flags &= ~B_ALLOC;
}

optopen(dev, flag, type)
register ushort dev;
uint flag, type;
{
	static uint	opt_initialized = 0;
	unchar unit_id = UNIT(dev);
	struct optiobuf *dp;
	uint x, error;

	/* check if the first open for the driver */
	/*log(LOG_OPT|LOG_OPEN, unit_id, flag, RBEGIN);*/
	if (!opt_initialized) {
		x = splhlv();	/* disable software interrupt */
		optinit(); 	/* initialize driver's table */
		opt_initialized = 1; /* never again! */
		splx(x);	 
	}

	dp = GETDP(unit_id);	/* get device table	*/

	optslopen(dp);	/* lock device */
	/* check if eject on close */
	if (dev & OPT_EOC)
		dp->b_flags |= B_EOC;
	

	if (!(dp->b_flags & B_ALLOC)) {
		if (!opt_alloc(dp)) {
			/* note this assumes that the command mailboxes couldn't
			 * be allocated because they have been taken by another driver
			 * using the device. From this is it deduced that the wrong type
			 * of drive is being opened. It is possible that the other
			 * driver has been allocated the boxes and is in the process of
			 * discovering that it is addressing the wrong device type. In
			 * that case this open will fail incorrectly. */
			u.u_error = ENXIO;
			optwkup(dp);
			return;	 
		}
		dp->b_flags |= B_ALLOC;
	}
	
#if 0 /* declan - untested */
	/* if drive is being formatted, then busy */
	if (dp->b_flags & B_FMT) {
		u.u_error = EBUSY;
		opt_dealloc(dp);
		optwkup(dp);
		return;	 
	}
#endif /* untested */
	opt_lock_buf(unit_id);
	if ((u.u_error = opt_disk_open(dp, unit_id)) != 0) {
		opt_rel_buf(unit_id);
		opt_dealloc(dp);
		optwkup(dp);
		return;	 
	}
	opt_rel_buf(unit_id); /* unlock buf header */


	if ((u.u_error = opt_set_optype(dp, flag, type)) != 0) {
		if ((dp->open_cnt == 0) && (dp->b_flags & B_RMB)) {
			opt_lock_buf(unit_id);
			opt_unlock_drv(dp);
			opt_rel_buf(unit_id);
			opt_dealloc(dp);
		}
	}
		
	optwkup(dp);	/* release device */

	/*log(LOG_OPT|LOG_OPEN, unit_id, u.u_error, REND);*/
} /* end of optopen */

static
opt_disk_open(dp, unit_id)
struct optiobuf *dp;
unchar unit_id;
{
	if (!(dp->b_flags & B_ONCE)) {
		dp->unit_id = unit_id;
		if (!opt_device_init(dp))
			return(ENXIO);	 
	}
	if ((dp->b_flags & B_NEWMDM) || (dp->open_cnt == 0)) {
		if (!opt_media_init(dp))
			return(EIO);	 
	}
	return(0);
}

optclose(dev,flag, type)
register ushort dev;
uint flag, type;
{
	uint	unit_id = UNIT(dev);
	struct optiobuf *dp = GETDP(unit_id);
	
	/*log(LOG_OPT|LOG_CLOSE, unit_id, flag, RBEGIN);*/

	optslopen(dp);

	switch (type) {
	case OTYP_BLK:
		ASSERT(dp->ot_flg & OFLG_BLK);
		dp->ot_flg &= ~OFLG_BLK;
		break;
	case OTYP_CHR:
		ASSERT(dp->ot_flg & OFLG_CHR);
		dp->ot_flg &= ~OFLG_CHR;
		break;
	default:
		ASSERT(0);
	}
	ASSERT(dp->open_cnt > 0);
	if (--dp->open_cnt == 0) {
		ASSERT(dp->ot_flg == 0);
		while(dp->qcnt || dp->b_outcnt)
			delay(2);
		opt_unlock_drv(dp);

		if (dp->b_flags & B_ALLOC )
			opt_dealloc(dp);
	}
	optwkup(dp);
	/*log(LOG_OPT|LOG_CLOSE, unit_id, flag, REND);*/
}

static opt_device_init(dp)
struct optiobuf *dp;
{
	register unchar unit_id = dp->unit_id;
	register buf_t *bp = o_ownbuf[unit_id];
	OPTCFG	*wmcfg = &dp->cfg;
	struct	inquiry_data *inqp;

	dp->sar = get_iotime(unit_id);
	if (!optcommand(unit_id, CDB_INQUIRY, sizeof(struct inquiry_data))) {
		dp->sar = NULL;
		return(0);	 
	}
	inqp = (struct inquiry_data *)bp->b_un.b_addr;
	/* check device type */
	if (optcmp(inqp->vdr_id, "MAXTOR", 6))
		dp->b_flags |= B_MAXTOR;

	if (optcmp(inqp->vdr_id, "SONY", 4)) {
		if (optcmp(inqp->prod_id, "SMO-C511", 8) ||
			optcmp(inqp->prod_id, "SMO-C501", 8)) {
			dp->b_flags |= B_SONY_MF; /* multifunctional drive */
			if (inqp->dev_type == DA_DEV)
				dp->b_flags |= B_ERS; /* erasable medium */
			}
	}

	if (inqp->dev_type != WO_DEV && !(dp->b_flags & B_SONY_MF)) {
		DISPLAY_DRV_ID(unit_id);
		printf("%s\n", "device type error"); /* display error message */
		dp->sar = NULL;
		return(0);	 
	}

	if (inqp->dev_qual & QUAL_RMB) {
		dp->b_flags |= B_RMB;	/* removable media drive (should all be!) */	
		opt_spin_drv(dp);
	}

	if (!set_opt_err_recover_page(dp))
		return(0);

	dp->b_flags |= B_NEWMDM;
	dp->b_flags |= B_ONCE;
	return(1);
} /*  end of opt_device_init */

static opt_media_init(dp)
struct optiobuf *dp;
{
	unchar pg_flag;
	unchar unit_id = dp->unit_id;
	register buf_t *bp = o_ownbuf[unit_id];
	struct	inquiry_data *inqp;

	if (!opt_spin_drv(dp))
		return(0);
	/* check if drive is ready */
	if (!optcommand(unit_id, CDB_TEST_UNIT_READY, 0))
		return(0);
	if (!(dp->b_flags & B_NEWMDM))
		return(1);	/* already initialized */

	if (dp->b_flags & B_SONY_MF) {
		/* find out media type - non-SCSI mode of reporting! */
		if (!optcommand(unit_id, CDB_INQUIRY, sizeof(struct inquiry_data)))
			return(0);	 
		inqp = (struct inquiry_data *)bp->b_un.b_addr;
		if (inqp->dev_type == DA_DEV)
			dp->b_flags |= B_ERS; /* erasable medium */
		else	dp->b_flags &= ~B_ERS;
	}
		
	if (dp->pg1_len != 0) {
		pg_flag = M_PF;
		bcopy(dp->pg1, bp->b_un.b_addr, dp->pg1_len);
		if (!optcommand(unit_id, CAT2(pg_flag, CDB_MODE_SELECT), 
			dp->pg1_len))
			return(0);
	}
	
	dp->b_flags &= ~B_NEWMDM;
	dp->b_flags &= ~B_SWAP;
	
	if (!check_write_protect(dp) )
		return(0);
	
	/* setup device configuration table */
	if (!initoptdrv(dp))
		return(0);

	return(1);
} /*  end of opt_media_init */

static
check_write_protect(dp)
struct optiobuf *dp;
{
	struct mode_head *sd;
	
	if (!optcommand(dp->unit_id,CAT2((PAGE01 | CURRENT), CDB_MODE_SENSE),
		MODEHEAD_LEN))
		return(0);

	sd = (struct mode_head *)o_ownbuf[dp->unit_id]->b_un.b_addr;

	if ( sd->wp_bm_speed & WP)
		dp->b_flags |= B_WP;
	else
		dp->b_flags &= ~B_WP;
	return(1);
}
	
static
opt_spin_drv(dp)
struct optiobuf *dp;
{
	unchar unit_id = dp->unit_id;
	if (dp->b_flags & B_LOCKED)
		return(1);
	if (!(dp->b_flags & B_RMB)) {
		/* to eliminate UNIT ATTENTION condition */
		if(!optcommand(unit_id, CDB_REQUEST_SENSE, SENSE_DATA_SIZE))
			return(0);	 
		else
			return(1);
	}
	/* spin up drive */
	dp->b_flags |= B_NEW_MED_OK;
	if (!optcommand(unit_id, CAT2(SPIN_UP, CDB_START_STOP), 0)) {
		if (!(dp->b_flags & B_NEWMDM)) {
			dp->b_flags &= ~B_NEW_MED_OK;
			opt_unlock_drv(dp);
			return(0);
		}
	}
	dp->b_flags &= ~B_NEW_MED_OK;
#if 0
	dp->b_flags &= ~B_NEWMDM;
#endif

	/* to eliminate UNIT ATTENTION condition */
	if(!optcommand(unit_id, CDB_REQUEST_SENSE, SENSE_DATA_SIZE))
		return(0);	 
	if (!optcommand(unit_id, CAT2(PREVENT, CDB_MEDIUM_REMOVAL), 0)) {
		if (!(dp->b_flags & B_NEWMDM)) {
			/* clear flags associated with this medium */
			dp->b_flags &= ~B_ERS;
			opt_unlock_drv(dp);
			return(0);
		}
		else { /* resend command */
			dp->b_flags &= ~B_NEWMDM;
			if (!optcommand(unit_id, 
				CAT2(PREVENT, CDB_MEDIUM_REMOVAL) , 0)) {
				opt_unlock_drv(dp);
				return(0);
			}
		}
	}
#if 0
	dp->b_flags &= ~B_NEWMDM;
#endif
	dp->b_flags |= B_LOCKED;
	return(1);
}

static opt_unlock_drv(dp)
struct optiobuf *dp;
{
	unchar unit_id = dp->unit_id;

	if (dp->b_flags & B_RMB) {
		/* unlock media */
		optcommand(unit_id, CAT2(ALLOW, CDB_MEDIUM_REMOVAL), 0);
		if (dp->b_flags & B_EOC) {
			optcommand(unit_id,
				CAT2(SPIN_DOWN | LOAD_EJECT, CDB_START_STOP), 0);
			dp->b_flags &= ~B_EOC;
		}
	}
	dp->b_flags &= ~B_LOCKED;
}

optcmp(s,d,l)
register unchar	*s,*d;
{
	register uint	i;

	for (i = 0; i < l; i++) {
		if (*s++ != *d++) 
			return(0);
	}
	return(1);
}

/* initoptdrv -- initialize scsi disk table.
	setup configuration table.
*/
initoptdrv(dp)
struct optiobuf	*dp;
{
	struct opt_block_0 *s0;
	struct capacity *ca;

	/* get block size and total number of blocks */

       	if(!optcommand(dp->unit_id,CAT2( 0, CDB_READ_CAPACITY), BSIZE))
		return(0);

	ca = (struct capacity *)o_ownbuf[dp->unit_id]->b_un.b_addr;

	dp->cfg.blk_len = CAT4(ca->bl_msb, ca->bl_2, ca->bl_1, ca->bl_lsb);
	dp->cfg.lst_blkno = CAT4(ca->lba_msb, ca->lba_2, ca->lba_1, ca->lba_lsb);
	dp->cfg.blk_ratio = (BSIZE > dp->cfg.blk_len) ? BSIZE / dp->cfg.blk_len :
				dp->cfg.blk_len / BSIZE;

	return(1);
}

static	
opt_set_optype (dp, flag, type)
struct optiobuf *dp;
int flag, type;
{
	if ((dp->b_flags & B_WP) && (flag & FWRITE)) {
		DISPLAY_DRV_ID(dp->unit_id);
		printf("%s\n", "Medium is write protected!");
		return(EACCES);
	}

	switch (type) {
	case OTYP_BLK:
			opt_opflg_set(dp, OFLG_BLK);
			break;
	case OTYP_CHR:
			opt_opflg_set(dp, OFLG_CHR);
			break;
	defualt :
			return(EINVAL);
	}

	return(0);
}

static
opt_opflg_set(dp, flag)
struct 	optiobuf	*dp;
int	flag;
{
	if (!(dp->ot_flg & flag)) {
		dp->ot_flg |= flag;
		dp->open_cnt++;
	}
}

#define	MAXMS_P1 PGHD_LEN + DSCPTR_LEN + MODEHEAD_LEN + sizeof (struct page_01)

set_opt_err_recover_page(dp)
struct optiobuf *dp;
{
	int page_len,  byte_remain;
	unchar	cbuf[MAXMS_P1];
	unchar	dbuf[MAXMS_P1];
	struct mode_head  *cptr, *dptr;
	register  struct blk_dscptr *cbdp, *dbdp;
	register  struct page_hd	*cph, *dph;
	register  struct page_01	*cp1p, *dp1p;
	struct	g0_cdb *cdb;
	register  unchar *x,*y; 

	if (dp->b_flags & B_MAXTOR)
		return(1);
	if (!optcommand(dp->unit_id, CAT2((PAGE01|CHANGE), CDB_MODE_SENSE),
		MAXMS_P1))
		return(0);
	bcopy(o_ownbuf[dp->unit_id]->b_un.b_addr, cbuf, MAXMS_P1);

	cptr = (struct mode_head *)cbuf;
	cbdp = (struct blk_dscptr *)((uint)cptr + MODEHEAD_LEN);
	cph = (struct page_hd *)((uint)cbdp + cptr->dscptr_len);
	cp1p = (struct page_01 *)((uint)cph + PGHD_LEN);
	if (cptr->sd_len <= (MODEHEAD_LEN + cptr->dscptr_len + PGHD_LEN - 1)) {
		dp->pg1_len = 0;
		return(1);
	}
	/* read default value */

	if (!optcommand(dp->unit_id, CAT2((PAGE01 | DEFAULT), CDB_MODE_SENSE),
		MAXMS_P1))
		return(0);
	bcopy(o_ownbuf[dp->unit_id]->b_un.b_addr, dbuf, MAXMS_P1);
	dptr = (struct mode_head *)dbuf;

	dbdp = (struct blk_dscptr *)((uint)dptr + MODEHEAD_LEN);
	dph = (struct page_hd *)((uint)dbdp + dptr->dscptr_len);
	dp1p = (struct page_01 *)((uint)dph + PGHD_LEN);

	page_len = dph->len;
	byte_remain = page_len;	
	dp1p->err_flags = cp1p->err_flags & (AWRE | ARRE | EEC);
	if (--byte_remain == 0)
		goto setpg1;

	dp1p->retry_cnt = (10 & cp1p->retry_cnt);

	if (--byte_remain == 0)
		goto setpg1;
		

	 /* use drive default value or don't changed */	
	 for (x = (unchar *)&dp1p->correction, y = (unchar *)&cp1p->correction; 
			byte_remain != 0; byte_remain--, x++, y++)
		*x &= *y;
setpg1:
	dptr->sd_len = 0;	
	dptr->dscptr_len = 0;

	dph->code = PAGE01;

	bcopy(dptr, dp->pg1, MODEHEAD_LEN);
	bcopy(dph, (uint)(dp->pg1)+4, page_len + PGHD_LEN);
	dp->pg1_len = page_len + PGHD_LEN + MODEHEAD_LEN;

	/* config mode select command box */
	bzero(&dp->ms_cm, sizeof(CMD_BOX));
	dp->ms_cm.cmd_dsc_len = sizeof(struct g0_cdb);
	cdb = (struct g0_cdb *)dp->ms_cm.cmd_dsc_blk;
	cdb->opcode = CDB_MODE_SELECT;
	cdb->lun_flags = M_PF;
	cdb->alloc_len = dp->pg1_len;
	dp->ms_cm.unit_id = dp->unit_id;
	dp->ms_cm.timer = MODE_TIMER;
	dp->ms_cm.dma_proc = 0;
	dp->ms_cm.cmd_type = CMD_RELEASE_ATTN;
	dp->ms_cm.dma_buffer = dp->pg1;
	dp->ms_cm.dma_buf_len = dp->pg1_len;
	dp->ms_cm.dma_flags = 0;	/* dma write */
	dp->ms_cm.tag = 0;
	dp->ms_cm.service = opt_reset_done;
	dp->ms_cm.retry_cnt = 0;
	return(1);
}
