/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) opt_ioctl.c: version 25.1 created on 11/27/91 at 14:44:57	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)opt_ioctl.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* opt_ioctl -- ioclt routines for optical driver */

#include "sys/types.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/errno.h"
#include "sys/elog.h"
#include "sys/file.h"
#include "sys/debug.h"

#include "sys/user.h"
#include "sys/buf.h"

#include "scsi_log.h"
#include "hlvl_macro.h"
#include "opt_cdb.h"
#include "sys/ioctl.h"
#include "scsi_cmdbx.h"
#include "opt.h"

extern struct buf *o_ownbuf[];
extern struct optiobuf opttbl[];


/* optioctl --  includes following spacial functions:

   GET_DISK_SIZE 	get the size of media

   input:
	dev		minor device number
	cmd		ioctl function code
	arg		pointer to parameters listing
	mode		Mode that device is open with(e.q FWRITE, FREAD etc.,).
*/
	
unchar altbuf[BSIZE];

optioctl(dev, cmd, arg, mode)
ushort	dev;
uint	cmd;
unchar	*arg;
uint	mode;
{
	unchar	unit_id = UNIT(dev);
	struct optiobuf	*dp = GETDP(unit_id);
	int	x;

	/*log(LOG_OPT|LOG_IOCTL, unit_id, cmd, RBEGIN);*/
	/*LOG_LONG_WORD(LOG_PR, 0, arg, 0);*/

	u.u_error = 0; 	/* clear error flag	*/
	switch(cmd) {
		case W_GET_DISK_SIZE: {  /* number of blocks for logic device */
			uint	size = dp->cfg.lst_blkno + 1;
			copyout(&size, arg, sizeof(size));
			break;
		}
		case W_GET_BLK_SIZE:  /* size of blocks for logic device */
			copyout(&dp->cfg.blk_len, arg, sizeof(dp->cfg.blk_len));
			break;

		/* the eject bit is initially set on open based on the lsb
		 * of the device minor number.
		 * The last ioctl sent decides the issue.
		 */
		case W_EJECTONCLOSE:	/* eject medium on last close */
			dp->b_flags |= B_EOC;
			break;
		case W_NOEJECTONCLOSE:	/* don't eject medium on last close */
			dp->b_flags &= ~B_EOC;
			break;
		/* byte swapping (01 00 03 02 05 04 etc.) is required because the
		 * driver used by one of the the ports of the Imix application 
		 * writes screwy. It is up to the application to decide that swapping
		 * is necessary. Swapping is done on all reads on this medium from then
		 * on.
		 */
		case W_BYTESWAPON:	/* turn on byte swapping */
			dp->b_flags |= B_SWAP;
			break;
		case W_BYTESWAPOFF:	/* turn on byte swapping */
			dp->b_flags &= ~B_SWAP;
			break;
#if 0 /* fix declan comment out for now, since haven't tested */
		case W_SONY_FORMAT: /* format a sony drive */
			if (!(dp->b_flags & B_SONY_MF)) /* sony drive ? */
				u.u_error = EINVAL;
			else
				if (!opt_fmt_lock(dp))
					u.u_error = EBUSY;
			else {
				if (!opt_sony_format(dp, unit_id))
					u.u_error = EIO;
				opt_fmt_unlock(dp);
			}
			break;
#endif /* untested */ 
		default: 
			u.u_error = EINVAL;
			break;
	}
	/*log(LOG_OPT|LOG_IOCTL, unit_id, cmd, REND);*/
	/*LOG_LONG_WORD(LOG_PR, u.u_error, arg, 0);*/
} /* end of optioctl */

/*
 * Try to lock drive for formatting. Only perform format if this is the
 * only open on the drive.
 */
opt_fmt_lock(dp)
struct optiobuf	*dp;
{
	optslopen(dp); /* get exclusive access to drive info */
	if (dp->open_cnt != 1) {
		optwkup(dp);
		return 0;
	}
	dp->b_flags |= B_FMT;
	optwkup(dp); /* release dp */
	return 1;
}

/*
 * Unlock drive from formatting.
 */
opt_fmt_unlock(dp)
struct optiobuf	*dp;
{
	optslopen(dp); /* get exclusive access to drive info */
	ASSERT(dp->open_cnt == 1);
	dp->b_flags &= ~B_FMT;
	optwkup(dp); /* release dp */
}

/* mode select pages for Sony Optical */
static uchar MSelSony[] = {
	/* parameter list header */
	0x00, 0x00, 0x00, 0x00, 
	/*  page 1:  enable auto-realloc, retry count */
	0x01, 0x06, 0x80, 0x02, 0x00, 0x00, 0x00, 0x00,
	/*  page 2:  buffer ratios */ 
	0x02, 0x0a, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	/* page 20: mode 3, type 1, 1 user band, 1024 spare */ 
	0x20, 0x0a, 0x03, 0x01, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x00
};

static unchar	fmt_data[] = { 0, 0, 0, 0 };

opt_sony_format(dp, unit_id)
struct optiobuf	*dp;
unchar	unit_id;
{
	register	buf_t *bp = o_ownbuf[unit_id];

	/* at this stage have exclusive access to drive */
	ASSERT(bp);
	ASSERT(!bp->b_flags & B_BUSY);
	opt_lock_buf(unit_id);

	/* perform mode select */
	bcopy(MSelSony, bp->b_un.b_addr, sizeof(MSelSony));
	if (!optcommand(unit_id, CAT2(M_PF, CDB_MODE_SELECT), sizeof(MSelSony))) {
		opt_rel_buf(unit_id);
		return 0;
	}

	/* format unit */
	bcopy(fmt_data, bp->b_un.b_addr, sizeof(fmt_data));
	if (!optcommand(unit_id, CAT2(FORMAT_DATA | 0x5, CDB_FORMAT_UNIT), sizeof(fmt_data))) {
		opt_rel_buf(unit_id);
		return 0;
	}
	opt_rel_buf(unit_id);
	return 1;
}
