/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) scsi_ltime.c: version 2.1 created on 4/17/90 at 14:02:47	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)scsi_ltime.c	2.1	4/17/90 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* cmd_timeout - timeout for command excution	*/

#include 	"sys/types.h"
#include 	"sys/param.h"
#include 	"sys/debug.h"
#include	"sys/cmn_err.h"

#include 	"scsi_log.h"
#include	"scsi_error.h"
#include	"scsi_cmdbx.h"

#include	"scsi_ncr.h"
#include	"scsi_db.h"

#include	"llvl_msgs.h"
#include	"llvl_queue.h"
#include	"llvl_drv.h"
#include	"llvl_macro.h"


extern void xfer_info_timeout();
extern SCSI_DB_REGS *dual_r;
extern SCSI_CTB	chan[NOCHANNELS];	/* channel table */
void
cmd_timeout(dcb)
DCTB	*dcb;
{
	SCSI_CTB	*scb;
	int s = spldb();
	
	scb = dcb->sc;	/* get channel control block	*/

	LOG_LONG_WORD( LOG_TMO|LOG_DCB, 0, dcb, RBEGIN );
	
	if (dcb == scb->cur_dev) /* ignore this timeout */
		return;
#ifdef TIME_DEBUG
	check_timeout(dcb);
#endif /* TIME_DEBUG */
cmn_err(CE_WARN,"Command timeout on cm = %x\n",dcb->cur_cmd);
	if(scb->flags & SF_BUS_BUSY){
		if(scb->cur_dev != dcb){
			dcb->flags |= DF_ABORT;
			dcb->cur_cmd->err_code = SCSIERR_CMDTIMEOUT;
			complete_cmd(scb,dcb);
	  		scsi_enque(&scb->abort_q, dcb); /* waiting abort */
		}
	}
	else { /* bus is idle */
		scb->flags |= SF_BUS_BUSY;
		dcb->cur_cmd->err_code = SCSIERR_CMDTIMEOUT;
		ESPWREG(bus_id) = (dcb->cur_cmd->unit_id & 0x07);
		complete_cmd(scb,dcb);
		scb->cur_dev = dcb;
		scb->msgout[0] = MSG_IDFY | DISC_RECONN;
		scb->msgout_len = 1;
		dcb->flags |= DF_ABORT;
		/* stuffing message in fifo */
		fill_fifo(scb,scb->msgout, scb->msgout_len, FF_NC);
		scb->phase = DISC_PHASE;		/* clear phase */
		scb->timer = (SELECT_TIMEOUT/HZ) + 1;
		espcmd(scb,ESP_SELATNSTP);
	}

	LOG_LONG_WORD(LOG_TMO | LOG_DCB, 0, dcb, REND);
	splx(s);
}

/* bus_reset_done --- routine was called after 4 seconds since SCSI bus 
   		      had been reset.
*/
bus_reset_done(scb)
SCSI_CTB	*scb;
{
 	int s = spldb(); 	/* raise interrupt level to prevent other
				   request comming */
	scb->flags &= ~SF_BLOCK;
	start_connect(scb);
	
	splx(s);
}
/* bus timeout */
void
xfer_info_timeout(scb)
SCSI_CTB	*scb;
{

	LOG_LONG_WORD( LOG_TMO | LOG_XFR, 0, scb, RBEGIN);

	if (bad_fuse(scb)) {
		cmn_err(CE_NOTE, "Bad fuse in channel %d\n", scb->chan_id);
		scb->cm->err_code = SCSIERR_PARITY;
		set_scsi_err(scb, SCSIERR_PARITY);
		return;
	}	
	if ((scb->espcmd == ESP_SELATNSTP) && !(scb->flags & SF_CONN)) {
		chan_connect_fail(scb);
		return;
	}
cmn_err(CE_WARN, "bus timeout on espcmd %x in channel %d bus id %d\n",
	 scb->espcmd, scb->chan_id, scb->cur_dev->bus_id);
	if (scb->cur_dev->flags & DF_ABORT) {
		scsi_bus_reset(scb); /* reset scsi bus */	
		scb->flags |= SF_BLOCK; /* set channel in block state */
		timeout(bus_reset_done, scb, 4*HZ+1); /* wait for device reset done */
		return;
	}
		

	if(!(scb->flags & SF_WAIT_DISC)){
	/* abort this command and send error back to high level driver */
		ASSERT(scb->cm);
		if(dma_parity_err(scb)){
			scb->cm->err_code = SCSIERR_PARITY;
			bcr_reset(scb);	
		} else 
			scb->cm->err_code = SCSIERR_BUSTIMEOUT;
		complete_cmd(scb, scb->cur_dev);
		
		/* clear current command status in this scsi channel */
		scb->cur_dev = NULL;
	}
	scsi_bus_reset(scb); /* reset scsi bus */	
	scb->flags |= SF_BLOCK; /* set channel in block state */
	timeout(bus_reset_done, scb, 4*HZ+1); /* wait for device reset done */

	
	LOG_LONG_WORD( LOG_TMO | LOG_XFR, 0, scb, REND);

} /* end of xfer_info_timeout */

	

/* time delay function -- n * 20 ms */
scsi_delay(n)
{
	register uint i;
	i = get_lbolt() + n;
	while(get_lbolt() <= n );
}

#ifdef 	TIME_DEBUG
static	unchar time_log = 0;
s_timeout(func, dcb, timer)
void (*func)();
DCTB	*dcb;
int	timer;
{
	ASSERT((dcb->flags & DF_STAMPED) == 0);
	ASSERT(dcb->time_stamp == 0);
	dcb->time_stamp = get_lbolt();
	dcb->flags |= DF_STAMPED;
	time_log++;
	log(LOG_TMO | LOG_STO, time_log, 0, 0);
	dcb->timer_id = timeout(func, dcb, timer);
}

s_untimeout(dcb)
DCTB	*dcb;
{
	uint	pc = *(((uint *)&dcb)-1);
	log(LOG_TMO | LOG_UST, time_log, 0, 0);
	ASSERT(dcb->flags & DF_STAMPED);
	dcb->flags &= ~DF_STAMPED;
	dcb->time_stamp = 0;
	dcb->pc = pc;
	untimeout(dcb->timer_id);
}
	

check_timeout(dcb)
DCTB	*dcb;
{
	uint time_stamp = get_lbolt();

	ASSERT(dcb->flags & DF_STAMPED);
	ASSERT(dcb->time_stamp);
	ASSERT(dcb->cur_cmd);
	ASSERT(dcb->cur_cmd->cmd_flags & CB_DISC);
	ASSERT((time_stamp - dcb->time_stamp + 1) >= dcb->cur_cmd->timer);
	dcb->flags &= ~DF_STAMPED;
	dcb->time_stamp = 0;
}
#endif /* TIME_DEBUG */

/* temp fix for RO-5030E	*/
abort_done(dcb)
DCTB	*dcb;
{
	SCSI_CTB	*scb;
	int s;

	s=spldb();
	dcb->flags &= ~DF_ABORT;
	scb = dcb->sc;
	if (!(scb->flags & SF_BUS_BUSY))
		start_connect(scb);
	splx(s);
}

bad_fuse(scb)
SCSI_CTB	*scb;
{
	uint	x;
	x = dual_r->un.r.bsr;
	if (scb->chan_id == 0)
		return((x & BSR_FUSEA) == 0);
	else
		return((x & BSR_FUSEB) == 0);
}

one_sec_timer()
{
	static int i = 0;
	int 	s = spldb();

	if (chan[i].timer != 0) {
		if (--chan[i].timer == 0)
			xfer_info_timeout(&chan[i]);
	}
	i ^= 1;
	if (chan[i].timer != 0) {
		if (--chan[i].timer == 0)
			xfer_info_timeout(&chan[i]);
	}
	timeout(one_sec_timer, NULL, HZ);
	splx(s);
}
