/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) scsi_lsend.c: version 2.1 created on 4/17/90 at 14:02:42	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)scsi_lsend.c	2.1	4/17/90 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* scsi_lsend.c -- send scsi command lower driver */
#include 	"sys/types.h"
#include 	"sys/param.h"
#include	"sys/debug.h"

#include 	"scsi_log.h"
#include	"cdb.h"
#include	"scsi_error.h"
#include	"scsi_cmdbx.h"

#include	"scsi_db.h"
#include	"scsi_ncr.h"

#include	"llvl_msgs.h"
#include	"llvl_queue.h"
#include	"llvl_drv.h"
#include	"llvl_macro.h"

extern uint	scsi_init_flag;
extern SCSI_CTB chan[];
extern DCTB	scsidev[];
extern void 	cmd_timeout();
extern void 	xfer_info_timeout();

DCTB *get_cur_device();

ch_send_cmd(cm)
CMD_BOX	*cm;
{
	SCSI_CTB *scb;
        DCTB	 *dcb; 
	uint	s;

	LOG_LONG_WORD(LOG_DRV|LOG_SSEND, cm->unit_id, cm, RBEGIN);
	s=spldb();

	cm->err_code = 0;
	cm->err_len = 0;
	cm->disc_count = 0;
	cm->act = 0;
	/* get scsi control block */
	if (IS_INITIATOR_ID(cm->unit_id)) {
		log(LOG_DRV|LOG_SSEND,cm->unit_id,NULL,RERROR);
		cm->err_code = SCSIERR_UNIT_ID;
		scsi_cmd_done(cm);
	} 
	else {
		/* get SCSI control table */
		scb = GETSCSI(cm->unit_id);

		/* get device control block */	
		dcb = GETDCB(cm->unit_id);

		scsi_enque(&scb->ready_q,cm);
		dcb->cur_cmd = cm;
		cm->cmd_flags = CB_READY;
 		/* start to issue command  if scsi bus is free */
 		if((!scb->cm) && (!(scb->flags & (SF_WAIT_DISC | SF_BLOCK |
			SF_BUS_BUSY ))))
			start_connect(scb);
	}
	splx(s);
	LOG_LONG_WORD(LOG_DRV|LOG_SSEND, cm->unit_id, cm, REND);
	
} /* end of scsi_send_cmd */

unchar identify(scb,bus_id)
SCSI_CTB *scb;
unchar bus_id;
{
	scb->active |= bus_id; 
	if(scb->active & (~bus_id)) /* if any other device active */
		return(MSG_IDFY | DISC_RECONN); 
	else {
		if(scb->cm->timer > MIN_RECON_TIMER)
			return(MSG_IDFY | DISC_RECONN); 
		else
			return(MSG_IDFY);
	}
}
#ifdef DMA_DEBUG
extern unchar **mem_ptr;
extern unchar *mem_table[];
extern int cnt_0_happen;
extern int table_index;
extern int disc_info[20];
extern int *disc_ptr;
int log_flg = 0;
#endif /* DMA_DEBUG */

start_connect(scb)
SCSI_CTB *scb;
{
	CMD_BOX *cm;
	DCTB	*dcb;
	unchar	id_bit;

	LOG_LONG_WORD(LOG_DRV|LOG_SEND, 0, scb, RBEGIN);
	if ((dcb = get_cur_device(scb)) == NULL)  /* no dcb available */
		return;
	cm = dcb->cur_cmd;
	scb->cm = dcb->cur_cmd;
	scb->cur_dev = dcb;

	cm->cmd_flags &= CB_MASK;    /* mask out command state bits */
	cm->cmd_flags |= CB_RUNNING; /* set to running state */
		
	scb->flags |= SF_BUS_BUSY; /* set bus busy */
	/* start the timer */
#ifdef TIME_DEBUG
	scb->cur_dev->timer_id = s_timeout(cmd_timeout,scb->cur_dev,cm->timer);
#else
	scb->cur_dev->timer_id = timeout(cmd_timeout,scb->cur_dev,cm->timer);
#endif /* TIME_DEBUG */
	id_bit = ENCODE_BUS_ID(cm->unit_id);
	/* set device id	*/
	ESPWREG(bus_id) = GET_BUS_ID(cm->unit_id);
	scb->phase = DISC_PHASE;		/* clear phase */

	if (dcb->flags & DF_INIT_STATE) {
		/* setup async mode */
		ESPWREG(sync_offset) = 0;
		ESPWREG(sync) = 0;
		/* setup message byte */
		scb->msgout[0] = identify(scb,id_bit);
		scb->msgout_len = 1;
		/* stuffing message in fifo */
		fill_fifo(scb,scb->msgout,scb->msgout_len,FF_NC);
		espcmd(scb,ESP_SELATNSTP);
		scb->timer = COMMAND_TIMEOUT; /* start timer */
		dcb->flags &= ~DF_INIT_STATE;
	}
	else{
		if(dcb->status & DS_NO_OPTMSG) {  
		/* if it doesn't support optional message */
			/* send command only */
			/* setup async mode */
			ESPWREG(sync_offset) = 0;
			ESPWREG(sync) = 0;
			fill_fifo(scb,scb->cm->cmd_dsc_blk,
			  scb->cm->cmd_dsc_len,FF_NC);
			espcmd(scb,ESP_SEL);
			scb->timer = ((min(cm->timer, MIN_RECON_TIMER)/HZ) + 1);
		} 
		else { /* the target supports optional message */
			/* first setup sync/async mode */ 	
			ESPWREG(sync_offset) = scb->cur_dev->window;
			ESPWREG(sync) = scb->cur_dev->xferp;
			/* setup message byte */
			scb->msgout[0] = identify(scb,id_bit);
			scb->msgout_len = 1;
			
			/* stuffing message in fifo */
			fill_fifo(scb,scb->msgout,scb->msgout_len,FF_NC);
			/* load command descriptor block to fifo */
			fill_fifo(scb,scb->cm->cmd_dsc_blk,
			  		scb->cm->cmd_dsc_len,FF_NC);
			espcmd(scb,ESP_SELATN);
			if (scb->msgout[0] &  DISC_RECONN)
				scb->timer = COMMAND_TIMEOUT;
			else
				scb->timer = ((min(cm->timer, MIN_RECON_TIMER)/HZ) + 1);
		}
	}
	/* setup dcb for dma transfer */
	
	cm->act = get_time_stamp();
	if(cm->dma_buf_len > 0){
		dcb->cur_resid = cm->dma_buf_len;
		cm->dma_resid = cm->dma_buf_len;
#ifdef DMA_DEBUG
		if ((scb->chan_id == 1) &&(cm->dma_buf_len >= 128*1024))
		{
			log_flg = 1;
			table_index = 0;
	        	cnt_0_happen = 0;
			mem_ptr = &mem_table[table_index*128];
			disc_ptr = &disc_info[0];
			*disc_ptr = 0;
		}
		else
			log_flg = 0;
#endif /* DMA_DEBUG */
		scb->cur_ptable = scb->ptable_1;
		scb->dma_count = setup_dataptr(scb->cur_ptable,cm,
			dcb->cur_resid,FULL_TABLE);
	}
	else  {
		dcb->cur_resid = 0;
		scb->dma_count = 0;
	}
	LOG_LONG_WORD(LOG_DRV|LOG_SEND, 0, scb, REND);
} /* end of start_connect */


ch_set_dev_init(unit_id)
uint	unit_id;
{
	DCTB *dcb = GETDCB(unit_id); /* get device control block */
	
	dcb->flags |= DF_INIT_STATE;
} 
/* 
get_cur_device -- get a device control block which is in ready state 
		and also has a command box waiting in the ready queue. 
*/
static DCTB *
get_cur_device(scb)
SCSI_CTB *scb;
{
	CMD_BOX	*cm;
	DCTB	*dcb;
	Q_HDR	tmp_q;
			
	tmp_q.head = tmp_q.tail = NULL;	/* initialize tmp queue */

	while(cm = (CMD_BOX *)scsi_deque(&scb->ready_q)) {

		dcb = GETDCB(cm->unit_id); /* get device control block */

		if (dcb->flags & DF_ABORT) {
	 	/* if device is waiting to send abort message, put 
			into tmp queue */
			scsi_enque(&tmp_q,cm);
			continue;
		}
		break;
	} /* end of while loop */

	/* merge tmp queue back to ready queue */
	merge_queue(&scb->ready_q, &tmp_q);
	if (cm == NULL)
		return(NULL);		/* can not find a dcb */
	return(dcb);
}

