/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) scsi_lintr.c: version 25.1 created on 11/27/91 at 14:43:46	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)scsi_lintr.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* scsi_lintr -- scsi lower level interrupt routine */


#include 	"sys/types.h"
#include 	"sys/param.h"
#include 	"sys/debug.h"
	
#include 	"scsi_log.h"
#include	"scsi_error.h"
#include	"scsi_cmdbx.h"

#include	"scsi_ncr.h"
#include	"scsi_db.h"

#include	"llvl_msgs.h"
#include	"llvl_queue.h"
#include	"llvl_drv.h"
#include	"llvl_macro.h"

extern	SCSI_DB_REGS *dual_r;
extern SCSI_CTB chan[];
extern	Q_HDR	relq;

typedef void (*PFI)();

void false_intr();
extern void scsi_intr();
void bscsi_intr();
void comb_intr();
void dmabus_err();
void bdmabus_err();
void scsi_dma_intr();

PFI intr_tbl[] ={
		bscsi_intr,	/* scsi interrupt on both channel */ 
		scsi_intr,	/* scsi interrupt on channel a */
		scsi_intr,	/* scsi interrupt on channel b */
		false_intr,	/* false interrupt */
		comb_intr,	/* scsi int on ch a & b,bus error on ch b */
		comb_intr,	/* scsi int on ch a, bus error on ch b */
		scsi_dma_intr,	/* scsi int on ch b, bus error on ch b */
		dmabus_err,	/* bus error on channel b */
		comb_intr,	/* scsi int on ch a & b, bus error on ch a */
		scsi_dma_intr,	/* scsi int and bus error on channel a */
		comb_intr,      /* scsi int on channel b bus error on ch a */
		dmabus_err,	/* bus error on channel a */
		comb_intr,	/* scsi int on a & b, bus error on a & b */
		comb_intr,	/* scsi int on ch a, bus error on a & b */
		comb_intr,	/* scsi int on ch b, bus error on a & b */
		bdmabus_err	/* bus errors on both channels */
};
uint	para[] = {
		0,
		(uint)&chan[0],
		(uint)&chan[1],
		0xFFFFFFFF,    /* false interrupt */
		4,
		5,	
		(uint)&chan[1],
		(uint)&chan[1],
		8,
		(uint)&chan[0],
		10,
		(uint)&chan[0],
		12,
		13,
		14,
		15
};

/*
void 
scsi_intr(scb)
SCSI_CTB *scb;
{
	LOG_LONG_WORD(LOG_DB|LOG_S, 0, scb, RBEGIN);
	scsi_fsm(scb);
	LOG_LONG_WORD(LOG_DB|LOG_S, 0, scb, REND);
}  */


void
bscsi_intr()
{
	static x=0;
	scsi_intr(&chan[x]);
	x ^= 1;
	scsi_intr(&chan[x]);		
}
void
dmabus_err(scb)
SCSI_CTB *scb;
{
	uint	page_addr;
	uint	low_addr,i;
	extern unchar **dma_ptable;

	LOG_LONG_WORD(LOG_DB|LOG_D, 0, scb, RBEGIN);
	low_addr = *scb->ch_r.pcr_r;
	page_addr = (uint)dma_ptable | low_addr;
        printf("scsi_drv: the dma bus error on memory page address %x",page_addr);
	bcr_uncmd(scb,BCR_ENDMA);	/* disable dma */
#ifdef WIREWRAP
	bcr_cmd(scb,BCR_RESET); 	/* reset device board to clear bus error
					 status */
	scsi_delay(RESET_BD_DELAY);    /* wait for a while to reset RESET bit */
	bcr_uncmd(scb,BCR_RESET);
#else
	bcr_reset(scb);			/* reset device board and unreset */
#endif
	scb->cm->err_code = SCSIERR_DMABUS;
	scsi_bus_reset(scb); /* reset scsi bus and report error */
	LOG_LONG_WORD(LOG_DB|LOG_D, 0, scb, REND);
}

void
bdmabus_err()
{
	static int x=0;
	dmabus_err(&chan[x]);
	x ^= 1;
	dmabus_err(&chan[x]);	
}
void
false_intr()
{
	printf("false interrupt\n");
}
/* bus error and scsi interrupt happened on same channel at same time */
void
scsi_dma_intr(scb) 
SCSI_CTB *scb;
{
	dmabus_err(scb);
}

void
comb_intr(n)
unchar n;
{
	switch(n){
	case 4:
		scsi_intr(&chan[0]);
		scsi_dma_intr(&chan[1]);
		break;
	case 5:
		scsi_intr(&chan[0]);
		dmabus_err(&chan[1]);
		break;
	case 8:
		scsi_intr(&chan[1]);
		scsi_dma_intr(&chan[0]);
		break;
	case 10:
		scsi_intr(&chan[1]);
		dmabus_err(&chan[0]);
		break;
	case 12:
		scsi_dma_intr(&chan[0]);
		scsi_dma_intr(&chan[1]);
		break;
	case 13:
		scsi_dma_intr(&chan[0]);
		dmabus_err(&chan[1]);
		break;
	case 14:
		scsi_dma_intr(&chan[1]);
		dmabus_err(&chan[0]);
		break;
	default:
		panic("comb_intr: interrupt number was wrong %x\n",n);
	}
}
