/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) scsi_linit.c: version 25.1 created on 11/27/91 at 14:43:41	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)scsi_linit.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* scsi_init.c -- initialization of device board and scsi chip */

/* This entry may be exist on scsi command interface	*/
#include 	"sys/types.h"
#include 	"sys/param.h"
#include 	"sys/debug.h"

#include 	"scsi_log.h"
#include	"scsi_error.h"
#include	"scsi_cmdbx.h"

#include	"scsi_ncr.h"
#include	"scsi_db.h"

#include	"llvl_queue.h"
#include	"llvl_drv.h"
#include	"llvl_msgs.h"
#include	"llvl_macro.h"

#define	DUMMY_LOC	0xF8080000
/* global variables for page table */

unchar	*dma_table[(DMA_PAGE/4)*2];	/* page table */
/* page table pointer */
unchar **dma_ptable;

/* global variables for  control table */
SCSI_DB_REGS	*dual_r;	  		/* device board register */
SCSI_CTB	chan[NOCHANNELS];	/* channel table */
DCTB		scsidev[MAXDEVS];	/* scsi device control table */
uint		scsi_init_flag = 0;	/* initialize flag	*/
Q_HDR		relq;
extern  void scsi_db_intr();
extern  void one_sec_timer();
scsi_init()
{
	uint i, time;
	unchar **pt;

	cache_disable();
	log(LOG_DI|LOG_SC,0,0,RBEGIN);

	scsi_init_ctl_table();
        bzero(scsidev,(sizeof(DCTB)*MAXDEVS));
	bzero(chan,(sizeof(SCSI_CTB)*NOCHANNELS));
	init_iotime_table();
	init_dev_que();
	/* setup dma table	*/
	dma_ptable = (unchar **) ((uint)(dma_table + DMA_PAGE/4) & 0xFFFFFC00);
	for(pt = dma_ptable,i = 0; i < (DMA_PAGE/4); i++, pt++)
		*pt = (unchar *)vtop(DUMMY_LOC, NULL); 
	dual_r = (SCSI_DB_REGS *)DB_CONTROL;	/* setup register base */
	dual_r->un.w.pcrh = (uint)vtop(dma_ptable, NULL); /* setup dma pagetable address */
	set_lo_db_vector(scsi_db_intr);
	set_hi_db_vector(scsi_db_intr);
	scsi_init_flag = 1;
	/* setup channel id */
	for(i=0; i<NOCHANNELS; i++){
		chan[i].chan_id = i;
#ifdef INITIATOR_ID
		chan[i].init_id = INITIATOR_ID;
		if(chan[i].init_id > 7)
		 	panic("The INITIATOR_ID was setup ridiculous value in makefile. Please modify INITIATOR_ID and recompile llvl/scsi_linit.c\n");
#else
		chan[i].init_id = DEFAULT_ID;
#endif
		chan[i].flags = SF_CHAN_UNINIT;
		chan_init(&chan[i]);
	}
	scsi_delay(BUS_RESET_DELAY);
	timeout(one_sec_timer, NULL, HZ); 	/* start one second timer */
	log(LOG_DI|LOG_SC,0,0,REND);
}
/* initialize channel	*/
chan_init(scb)
SCSI_CTB *scb;
{
	int  s=spldb();	

	log(LOG_DI|LOG_CH,scb->flags>>8,scb->flags,RBEGIN);

	if(scb->chan_id  == 0){
		/* setup register address */
		scb->ch_r.sr = (SCSI_R *)SCSI_CHIPA;
		scb->ch_r.bcr_w =&dual_r->un.w.bcr[0];
		scb->ch_r.pcr_w=&dual_r->un.w.wg[0].pcr;
		scb->ch_r.pcr_r=&dual_r->un.r.rg[0].pcr;
		scb->ch_r.mmr_r=&dual_r->un.r.rg[0].mmr;

		/* initialize page table pointer */
		scb->ptable_1 = dma_ptable;
		scb->ptable_2 = dma_ptable+(MAXXFERCNT/DMA_PAGE);
		init_dcb_table(scb);
	}
	else {
	/* setup register address */
		scb->ch_r.sr = (SCSI_R *)SCSI_CHIPB;
		scb->ch_r.bcr_w =&dual_r->un.w.bcr[1];
		scb->ch_r.pcr_w=&dual_r->un.w.wg[1].pcr;
		scb->ch_r.pcr_r=&dual_r->un.r.rg[1].pcr;
		scb->ch_r.mmr_r=&dual_r->un.r.rg[1].mmr;
		/* initialize page table pointer */
		scb->ptable_1=dma_ptable+((MAXXFERCNT*2)/DMA_PAGE);
		scb->ptable_2 = scb->ptable_1+(MAXXFERCNT/DMA_PAGE);
		init_dcb_table(scb);
	}
#ifdef DIFF_FIRST
	init_dsdb_chan(scb, BCR_DIFF, NO_DELAY);	
#else
	init_dsdb_chan(scb, BCR_SINGLE, NO_DELAY);	
#endif /* DIFF_FIRST */                 		 
	scb->flags |= SF_CHAN_INITED;
	scb->timer = 0;
	splx(s);
}	/* end of channel init */


init_dsdb_chan(scb, mode, delay_flag)
SCSI_CTB	*scb;
uint	mode;
uint 	delay_flag;
{
	clear_pwron_reset(scb);
	bcr_cmd(scb, BCR_BURST);
	if (mode == BCR_DIFF) {
		bcr_cmd(scb,BCR_DIFF);
		scb->flags |= SF_DIFF;	/* flag to differential */
	}
	else {
		bcr_uncmd(scb, BCR_DIFF);
		scb->flags &= ~SF_DIFF; /* flag to sigle ended */
	}
	ncr_chip_config(scb);
	espcmd(scb,ESP_RESET_BUS);
	if (delay_flag == DELAY)
		scsi_delay(BUS_RESET_DELAY); 	/* delay 4s */
}
ncr_chip_config(scb)
SCSI_CTB *scb;
{
	unchar cf;

	espcmd(scb,ESP_RESET_CHIP);
	scsi_delay(RESET_CHIP_DELAY);
	espcmd(scb,ESP_NOP);
	ESPWREG(config) = (CF_PARITY|CF_SCSI_RID|scb->init_id);
			
	if((cf = ESPRREG(config)) != (CF_PARITY|CF_SCSI_RID|scb->init_id))
	  panic("config not success at address %x\n",&ESPWREG(config));
	ESPWREG(ccf) = CCF;
	ESPWREG(timeout) = SEL_TIMEOUT;
}

config_sync(scb)
SCSI_CTB *scb;
{
	if((scb->msgin[4] != 0)&&(scb->msgin_len == 5)){
		/* save sync parameters */
		scb->cur_dev->status |= DS_SYNC;
		scb->cur_dev->xferp = ((uint)scb->msgin[3]*4)/SCSI_CLK_RATE;
		ASSERT(scb->cur_dev->xferp >= 5);
		scb->cur_dev->window =(uint)scb->msgin[4];
		/* initiate sync transfer */
		ESPWREG(sync_offset) = (uint)scb->msgin[4];
		ESPWREG(sync) = ((uint)scb->msgin[3]*4)/NCR_TCP; /* number of ticks */
	}
	else { /* async transfer */
		ESPWREG(sync_offset) = 0;
		ESPWREG(sync) = 0; 
	}
} /* end fo config_sync */

scsi_bus_reset(scb)
SCSI_CTB *scb;
{
	uint i;
        DCTB *dcb;
        CMD_BOX *cm;

	log(LOG_DI|LOG_RST,scb->chan_id,0,RBEGIN);

	espcmd(scb,ESP_RESET_BUS);
	espcmd(scb,ESP_RESET_CHIP);
	scsi_delay(RESET_CHIP_DELAY);
	ncr_chip_config(scb);	
	bcr_uncmd(scb,BCR_ENDMA); /* disable dma */
	/* check each drives to see if it is running */
	for(i = 0;i<MAXDEVS;i++){
		if(scsidev[i].sc == scb) {
			dcb = &scsidev[i];
			/* indecate device was reset */
			if((cm = dcb->cur_cmd) == NULL)
				continue;
			switch(cm->cmd_flags & 0xFF){
			  case CB_READY:
				break;

			  case CB_DISC:
				cm->err_code =SCSIERR_BUSRESET;
			  /* FALL THRU */
			  case CB_ABORT:	
				complete_cmd(scb,dcb);
				break;
			  default:
				panic("scsi_bus_reset: cmd box flags is wrong %x",cm->cmd_flags);
		      }
		}
	}
	scb->abort_q.head = scb->abort_q.tail = NULL;
	
	scb->flags &= SF_RESET_MASK;	/* set to reset state */ 

	log(LOG_DI|LOG_RST,scb->chan_id,0,REND);
} /* end of scsi_bus_reset */

static
init_dcb_table(scb)
SCSI_CTB *scb;
{
	int i, unit_id; 
	for (i = 0; i < 8; i++) {
		unit_id = scb->chan_id << 3 | i;
		scsidev[unit_id].sc = scb;
		scsidev[unit_id].bus_id = i;
	}
}		
