/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) scsi_lfsm.c: version 2.1 created on 4/17/90 at 14:02:19	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)scsi_lfsm.c	2.1	4/17/90 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* scsi_lfsm.c -- first level finite state machine */


#include 	"sys/types.h"
#include 	"sys/param.h"
#include 	"sys/debug.h"

#include 	"scsi_log.h"
#include	"scsi_cmdbx.h"
#include	"scsi_error.h"

#include	"scsi_ncr.h"
#include	"scsi_db.h"
#include	"llvl_msgs.h"
#include	"llvl_queue.h"
#include	"llvl_drv.h"
#include	"llvl_macro.h"

#define	ABORT_PROCESSING_TIME	(HZ/4 + 1)	/* 250 msecs */
extern void 	cmd_timeout();
extern void 	xfer_info_timeout();
extern void 	bus_reset_done();
extern void	abort_done();

scsi_intr(scb)
SCSI_CTB *scb;
{

	/* read registers  */
	scb->status = ESPRREG(status);
	scb->step = (ESPRREG(seq_stp) & 0x07);
	scb->int_status = ESPRREG(int_status);

	log(LOG_FSM|LOG_SF,scb->status,scb->int_status,RBEGIN);

	/* stop channel timer */
	scb->timer = 0;
	scb->int_status &= ~INT_SCSI_RESET; /* ingore scsi bus reset int */

	if((scb->int_status & INT_RESELECTED) &&  
	  (scb->int_status & INT_ILLEGAL_CMD))
	   	scb->int_status &= ~INT_ILLEGAL_CMD; /* ignore illegal command
							interrupt if reselected
							happened */
	if(scb->flags & SF_IGNR_ILLCMD){
		scb->flags &= ~SF_IGNR_ILLCMD;
		scb->int_status &= ~INT_ILLEGAL_CMD; /* ignore illegal command
						        interrupt */
	}
	if(scb->int_status != 0)	/* if something need to serve */
		scsi_service(scb);
	log(LOG_FSM|LOG_SF,scb->status,scb->int_status,REND);
} /* end of scsi_fsm */
	
scsi_service(scb)
SCSI_CTB *scb;
{
	/* check error first */
	if(scb->status & ST_GROSS_ERR)
			scsi_gross_err(scb);
	else 
	if (scb->int_status & INT_DISCONNECT)
		disconnect(scb);
	else
	if(scb->int_status & INT_ILLEGAL_CMD)
		illegal_cmd(scb);
	else
	if(scb->flags & SF_WAIT_DISC) { /* if we expect bus free but not */
		if ((scb->status & ST_XFER_MASK) == ST_MSGOUT) {
			xfer_info(scb);
			return;
		}
		scsi_bus_reset(scb); /* reset scsi bus */	
		scb->flags |= SF_BLOCK; /* set channel in block state */
		timeout(bus_reset_done, scb, 4*HZ+1); /* wait for device reset done */
	}
	else 
	if(scb->int_status & INT_RESELECTED)
		reselection(scb);
	else 
	switch(scb->espcmd & ESP_MODE_ZONE){
		case ESP_DISC_MODE:
			disc_fsm(scb);
			break;
		case ESP_INIT_MODE:
			initr_fsm(scb);
			break;
		default:
			panic("illegal command mode: %x",
				scb->espcmd & ESP_MODE_ZONE);
	}

} /* end of scsi_service */

/* disc_fsm -- finite state machine for disconnected mode */

disc_fsm(scb)
SCSI_CTB *scb;
{
	log(LOG_FSM|LOG_DF,scb->espcmd,scb->step,RBEGIN);

	switch(scb->espcmd & ESP_CMD_ZONE){
		case ESP_SEL:
			sel_fsm(scb);
			break;
		case ESP_SELATN:
			selatn_fsm(scb);
			break;
		case ESP_SELATNSTP:
			selatnstp_fsm(scb);
			break;
		case ESP_DISSEL:
			panic("disable select is never issued");
			break;
		default:
			panic("illegal esp command interrupt: %x",scb->espcmd);
	}
	log(LOG_FSM|LOG_DF,scb->espcmd,scb->step,REND);
} /* end of disc_fsm */	
/* State machine for Select w/o ATN */
sel_fsm(scb)
SCSI_CTB *scb;
{
	
	DCTB	*dcb;

	switch( (scb->step<<8) |scb->int_status){

		case STEP_0:
		      ASSERT(0);	/* never happened */

		case STEP_2:
	/* arbitration and select completed. Not command phase */
#ifdef EXPERIMENT
		     err_to_reset_bus(scb, SCSIERR_PHASE);
#endif /* EXPERIMENT */
		     xfer_info(scb);
		     break;

		case STEP_3:
	/* arbitrate and select completed. Command phase; all command bytes
	   not transferred because of Phase change.	*/

	/*	     espcmd(scb,ESP_FLSH_FIFO); */

	        case STEP_4:
	/* Arbitrate,Select,and Command Phase completed */
		     /* set async transfered */
		     xfer_info(scb); /* transfer information */
		     break; 
	
		 default:
		     err_to_reset_bus(scb, SCSIERR_ILLSEQ);
		     break;
	}
} /* end of sel_fsm */

/* selatn_fsm -- sel with atn state machine */
selatn_fsm(scb)
SCSI_CTB *scb;
{
	
	switch( (scb->step<<8) |scb->int_status){

		case STEP_0:
		      ASSERT(0);

	 	case STEP_05:
	/* arbitration and select completed. Not message out phase; ATN on */
 	/* doesn't support message other than COMMAND COMPLETE */
/*
		      scb->cur_dev->status |= DS_NO_OPTMSG;
*/
		      xfer_info(scb);
		      break;

		case STEP_2:
	/* arbitration and select completed. Not command phase */
#ifdef EXPERIMENT
		      err_to_reset_bus(scb, SCSIERR_PHASE);
#endif /* EXPERIMENT */
		      xfer_info(scb);
		      break;

		case STEP_3:
	/* aribtrate and select completed. Command phase; all command bytes
	   not transferred because of Phase change.	*/
#ifdef SCSI_FIX
/* TWU FIX DOn't know how to get this phase */
		     espcmd(scb,ESP_FLSH_FIFO);
#endif

	        case STEP_4:
		     xfer_info(scb); /* call the transfer state machine */
		     break; 
	
		 default:
		     err_to_reset_bus(scb, SCSIERR_ILLSEQ);
		     break;
	}
} /* end of selatn_fsm */

/* selatnstp_fsm -- select with atn and stop */
selatnstp_fsm(scb)
SCSI_CTB *scb;
{
	/* turn off first selection flags */
	switch( (scb->step<<8) |scb->int_status){

		case STEP_0:
	/* arbitration complete;select timeout. Disconnected */
		      ASSERT(0);
		      break;

	 	case STEP_05:
	/* arbitration and select completed. Not message out phase; ATN on */
 	/* doesn't support message other than COMMAND COMPLETE */
			if(!(scb->flags & SF_CONN))
			     scb->flags |= SF_CONN;
			if (!(scb->cur_dev->flags & DF_ABORT)) {
/*
		      		scb->cur_dev->status |= DS_NO_OPTMSG;
*/
				/* it does not support sync mode */
				config_sync(scb);
		      		xfer_info(scb);
				/* send NOP message if drive change to message
					out phase later on */
				scb->msgout_len = 1;
				scb->msgout[0] = MSG_NOP;
			} 
			else { /* device does not allow initiator to send abort
				message. The only way to stop device doing 
				previous operation is reset bus! pain! */
				scsi_bus_reset(scb);
				scb->flags |= SF_BLOCK;
				timeout(bus_reset_done, scb, 4*HZ+1);
				scb->cur_dev->flags &= ~DF_ABORT;
			}
				
		      	break;

		case STEP_1:
			if(!(scb->flags & SF_CONN))
			     scb->flags |= SF_CONN;
	/* Sent one message byte, ATN on */
        /* trying to send extended sync message */
		     if(scb->cur_dev->flags & DF_ABORT){
			char phase;
			if((phase = scb->status & ST_XFER_MASK) != ST_MSGOUT) {
				scsi_bus_reset(scb);
				scb->flags |= SF_BLOCK;
				timeout(bus_reset_done, scb, 4*HZ+1);
				scb->cur_dev->flags &= ~DF_ABORT;
				return;
			}
			else {
				scb->msgout_len = 1;
				scb->msgout[0] = MSG_ABRT;
				scb->flags |= SF_WAIT_DISC; /* expected bus free */
/* TWU	temp fix for RO-5030E */
				timeout(abort_done,scb->cur_dev, ABORT_PROCESSING_TIME);
				scb->cur_dev = 0;
		     	} 
		     }
		     else {
			char phase;
			if((phase = scb->status & ST_XFER_MASK) != ST_MSGOUT) {
				if (phase == ST_COMMAND) {
					scb->msgout_len = 0;
					config_sync(scb);
					xfer_info(scb);
				}
				else
		     			err_to_reset_bus(scb, SCSIERR_PHASE);
				return;
			}	
		     	scb->msgout_len = 5;
		     	scb->msgout[0] = MSG_EXTN;
		     	scb->msgout[1] = 0x03; /* extended message length */
		     	scb->msgout[2] = MSG_SYNC; /* message code */
		     	scb->msgout[3] = XFER_PERIOD;  	  /* xfer period */
		     	scb->msgout[4] = XFER_OFFSET;	  /* REQ/ACK offset */
		     }
		     xfer_info(scb);
		     break;
		 default:
		     err_to_reset_bus(scb, SCSIERR_ILLSEQ);
		     break;
	}
} /* end of selatnstp_fsm */

/* initr_fsm -- initiator finite state machine */
initr_fsm(scb)
SCSI_CTB *scb;
{
	log(LOG_FSM|LOG_ITF,scb->espcmd,0,RBEGIN);
	switch(scb->espcmd & ESP_CMD_ZONE){
		case ESP_XFER_INFO:
			xfer_info_fsm(scb);
			break;
		case ESP_MSG_ACPT:
			xfer_info(scb);
			break;
		case ESP_CMD_CMP:
		{
			unchar message;
			if (scb->status & ST_PARITY_ERR)  {
				set_msg(scb, MSG_PERR);
				espcmd(scb,ESP_FLSH_FIFO);
				espcmd(scb,ESP_MSG_ACPT);
				xfer_info(scb);
				return;
			}
			if(scb->int_status & INT_FUNC_COMP){
			/* read status byte and last message byte */
				scb->sbyte = ESPRREG(fifo);
				check_status(scb);
				message = ESPRREG(fifo);
				espcmd(scb,ESP_MSG_ACPT);
				complete_cmd(scb, scb->cur_dev);
			}
			else 
				xfer_info(scb);
			break;
		}		
		default:
			panic("illegal interrupt");
	}
	log(LOG_FSM|LOG_ITF,scb->espcmd,0,REND);
}
xfer_info_fsm(scb)
SCSI_CTB *scb;
{
	uint dump_cnt;
	uint ph;

	log(LOG_FSM|LOG_IF,scb->phase,0,RBEGIN);
		
	switch(scb->phase) {	/* check last data transfer phase */
	
		case ST_MSGIN:
			 message_in(scb);
			 break;
		case ST_MSGOUT:
			if ((scb->msgout_len == 5) && 
				(scb->status & ST_XFER_MASK) != ST_MSGIN){
#ifdef ANSI_SPAC
				scb->msgout_len = 0;
		     		err_to_reset_bus(scb, SCSIERR_PHASE);
				return;
#else /* to make it get around SONY cdrom problem */
				scb->msgin_len = 0;
				config_sync(scb);	
				scb->msgout_len = 0;
#endif
			} 
			else
				scb->msgout_len = ESPRREG(fifo_flag);
				
			xfer_info(scb);
			break;
		case ST_COMMAND:
			xfer_info(scb);
			break;
		case ST_STATUS:
			if (scb->status & ST_PARITY_ERR)  {
				set_msg(scb, MSG_ERRD);
				espcmd(scb,ESP_FLSH_FIFO);
				espcmd(scb,ESP_MSG_ACPT);
			}
			else
				scb->sbyte = ESPRREG(fifo);
			xfer_info(scb);
			break;

		case ST_DATAIN:
			if (scb->status & ST_PARITY_ERR)
				set_msg(scb, MSG_ERRD);
		case ST_DATAOUT:

			ASSERT((scb->int_status & INT_FUNC_COMP) == 0);
			
			if((scb->phase == ( scb->status & ST_XFER_MASK)) && 
				 (scb->status & ST_XFER_CNT_0)) {
				if (dma_continue(scb))
					break;
				/* double check if scsi bus phase changed */
				scsi_delay(HZ+1);
				ph = ESPRREG(status);
				if(scb->phase == ( ph & ST_XFER_MASK)) {
					err_to_reset_bus(scb, SCSIERR_DMACNT);
					break;
				}
			}
			dma_stop(scb);
			/* start timer for rest of things to do until disconnect */
			scb->timer = BASIC_TIMEOUT/HZ + 1;
			break;
		default:
			ASSERT(0);
	}
	log(LOG_FSM|LOG_IF,scb->phase,0,REND);

} 	/* end of scsi_xfer_fsm */

scsi_gross_err(scb)
SCSI_CTB *scb;
{
	if(scb->int_status & INT_DISCONNECT)
		disconnect(scb);
	espcmd(scb,ESP_RESET_CHIP);
       	ncr_chip_config(scb); 
}

#ifdef DMA_DEBUG
int cnt_0_happen;
int disc_info[20];
int *disc_ptr;
extern log_flg;
#endif /* DMA_DEBUG */
dma_continue(scb)
SCSI_CTB *scb;
{

	scb->cur_dev->cur_resid -= scb->dma_count;
#ifdef DMA_DEBUG
	if (log_flg) {
		cnt_0_happen++;
		*disc_ptr += scb->dma_count;
	}
#endif /* DMA_DEBUG */
	if(*scb->cur_ptable != (unchar *)(&scb->nice_buf))
	/* continue to transfer next dma table of data  */
		if (!xfer_next_table(scb))
			return(0);
		else
			return(1);
	else { 
		if(scb->phase == ST_DATAIN){
			bcr_uncmd(scb,BCR_ENDMA);
			dump_dmafifo(scb);
		    	bcopy(&scb->nice_buf,scb->save_dmap, scb->dma_count);
		}
	  	*scb->cur_ptable = scb->save_dmap+ scb->dma_count;
		scb->dma_count = scb->save_dmac;
	  	xfer_info(scb);	
		return(1);
	}
}

dma_stop(scb)
SCSI_CTB *scb;
{
	int	remain;
	unchar lo_cnt,hi_cnt,fifo_cnt;

	bcr_uncmd(scb,BCR_ENDMA); /* disable dma */
	/*	dump fifo to memory if it is read */
	if(scb->phase == ST_DATAIN)
		dump_dmafifo(scb);
	/* if phase changed and transfer count is 0 */
	if(((scb->status & ST_XFER_MASK) != scb->phase) && 
		 (scb->status & ST_XFER_CNT_0))	{
		if(scb->phase == ST_DATAOUT){
			/* make sure if there are some bytes in fifo */
			fifo_cnt = ESPRREG(fifo_flag);
			scb->dma_count -= (fifo_cnt&0x01F); 
		}
		scb->cur_dev->cur_resid -= scb->dma_count;
		if(!(scb->cm->cmd_flags & CB_SENSE))
			scb->cm->dma_resid = scb->cur_dev->cur_resid;
#ifdef DMA_DEBUG
		if (log_flg == 1) {
			*disc_ptr++ += scb->dma_count;
			*disc_ptr = 0;
		}
#endif /* DMA_DEBUG */
	}
	else {
		/* Data transfer phase is changed early */
		hi_cnt = ESPRREG(xfercnt_hi);
		lo_cnt = ESPRREG(xfercnt_lo);
		remain = (hi_cnt <<8) | lo_cnt;
		if((remain == 0)&&(!(scb->status&ST_XFER_CNT_0)))
			remain = 0x10000;
		if(scb->phase == ST_DATAOUT){
			fifo_cnt = ESPRREG(fifo_flag);
			remain += (fifo_cnt&0x01F); 
		}
		scb->cur_dev->cur_resid -= (scb->dma_count -remain);
#ifdef DMA_DEBUG
		if (log_flg) {
			*disc_ptr++ += (scb->dma_count - remain);
			*disc_ptr = 0;
		}
#endif /* DMA_DEBUG */
					
		scb->cm->dma_resid = scb->cur_dev->cur_resid;
		scb->cm->err_len = 0;
		log(LOG_FSM|LOG_CNT,hi_cnt,lo_cnt,0);
		log(LOG_PR,scb->cur_dev->cur_resid>>16,
		 	scb->cur_dev->cur_resid>>8, scb->cur_dev->cur_resid);
	}

	ASSERT(scb->int_status & INT_BUS_SERV);
	xfer_info(scb);
} 

err_to_reset_bus(scb, error)
SCSI_CTB *scb;
uint	error;
{
	set_scsi_err(scb, error);
	scsi_bus_reset(scb); /* reset scsi bus */	
	scb->cur_dev = NULL;
	scb->flags |= SF_BLOCK; /* set channel in block state */
	timeout(bus_reset_done, scb, 4*HZ+1); /* wait for device reset done */
}



set_scsi_err(scb,err_code)
SCSI_CTB *scb;
uint	err_code;
{
	scb->cm->err_code = err_code;
	complete_cmd(scb,scb->cur_dev);
}

complete_cmd(scb,dcb)
SCSI_CTB *scb;
DCTB *dcb;
{
	CMD_BOX *cm = dcb->cur_cmd;
	if (scb->cur_dev == dcb)
#ifdef TIME_DEBUG
		s_untimeout(dcb); /* stop function timer */
#else
		untimeout(dcb->timer_id); /* stop function timer */
#endif /* TIME_DEBUG */
	cm->act = get_time_stamp() - cm->act;
	cm->cmd_flags = CB_COMP;
	dcb->cur_cmd = NULL;
	if (scb->cur_dev == dcb)
		scb->cm = NULL;
	scsi_cmd_done(cm);
}
		  
