/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) scsi_lemsg.c: version 2.1 created on 4/17/90 at 14:02:10	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)scsi_lemsg.c	2.1	4/17/90 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* scsi_lemsg.c  */
#include "sys/types.h"
#include "sys/debug.h"

#define	MAX_SCSIERR_NUM	0x4F
#define MAX_SENSE_NUM	0xF
#define	NULL		0

char *sense_key_msg[] = {	 /* shared with the nine track driver */
/* 0 */ 	"no sense",
/* 1 */		"recovered error",
/* 2 */ 	"drive is not ready",
/* 3 */		"unrecoverable data error",
/* 4 */		"hardware error",
/* 5 */		"illegal request",
/* 6 */		"unit attention ", 
/* 7 */		"write protected or disqualified media",
/* 8 */		"blank check - A no-data condition was encountered",
/* 9 */		"unknown sense key - 9",
/* A */ 	"unknown sense key - a",
/* B */		"aborted command",
/* C */		"unknown sense key - c",
/* D */		"volume overflow",
/* E */		"unknown sense key - e",
/* F */ 	"unknown sense key - f"
};


char  *scsi_report_err[] = {
/* 0 */		"No error",
/* 1 */		"Invalid parameter in command mailbox",
/* 2 */		"Invalid unit id",
/* 3 */		"Device has been reset or media has been changed",
/* 4 */		"The length of CDB is 0 ",
/* 5 */		"The transfer data direction is inconsistent ",
/* 6 */		" ",
/* 7 */		" ",
/* 8 */		" ",
/* 9 */		" ",
/* a */		" ",
/* b */		" ",
/* c */		" ",
/* d */		" ",
/* e */		" ",
/* f */		" ",
/* 10 */	"SCSI bus accessing timeout",
/* 11 */	"Illegal select sequence number",
/* 12 */	"Illegal phase changed",
/* 13 */	"Parity error",
/* 14 */	"SCSI bus reset",
/* 15 */	"Unexpected disconnect",
/* 16 */	"Device is not on line",
/* 17 */	"Command excution timeout",
/* 18 */	" ",
/* 19 */	" ",
/* 1a */	" ",
/* 1b */	" ",
/* 1c */	" ",
/* 1d */	" ",
/* 1e */	" ",
/* 1f */	" ",
/* 20 */	"Unexpected message received",
/* 21 */	"Message was rejected by target",
/* 22 */	"Device fatal error",
/* 23 */	"Device error, request sense data is available in error buffer",
/* 24 */	"Device busy",
/* 25 */	" ",
/* 26 */	" ",
/* 27 */	" ",
/* 28 */	" ",
/* 29 */	" ",
/* 2a */	" ",
/* 2b */	" ",
/* 2c */	" ",
/* 2d */	" ",
/* 2e */	" ",
/* 2f */	" ",
/* 30 */	"DMA bus error",
/* 31 */	"DMA count error",
/* 32 */	" ",
/* 33 */	" ",
/* 34 */	" ",
/* 35 */	" ",
/* 36 */	" ",
/* 37 */	" ",
/* 38 */	" ",
/* 39 */	" ",
/* 3a */	" ",
/* 3b */	" ",
/* 3c */	" ",
/* 3d */	" ",
/* 3e */	" ",
/* 3f */	" ",
/* 40 */	"unexpected interrupt status ",
/* 41 */	"illegal ncr command ",
/* 42 */	" ",
/* 44 */	" ",
/* 44 */	" ",
/* 45 */	" ",
/* 46 */	" ",
/* 47 */	" ",
/* 48 */	" ",
/* 49 */	" ",
/* 4a */	" ",
/* 4b */	" ",
/* 4c */	" ",
/* 4d */	" ",
/* 4e */	" ",
/* 4f */	" "
};

/* the entry only contains  " " means reserved entry for future used */

/*
  scsi_err_msg -- return the error message pointer 
		This routine is called by high level drivers to get
		error message. the error message corresponds to the error code 
		which was set by low level driver.

   input:
	err_code: error code.
	
   output:
	a message pointer, if error code is a valid error code.
	otherwise, return 0.
*/
char *
scsi_err_msg(err_code)
ushort err_code;
{
	char *err_msg;
	if (err_code > MAX_SCSIERR_NUM )
		return(NULL);

	err_msg = scsi_report_err[err_code];
	if (*err_msg == ' ') {
		ASSERT(0);
		return (NULL);
	}
	else
		return(err_msg);
}

char *
scsi_sns_msg(sense_key)
unchar sense_key;
{
	if (sense_key > MAX_SENSE_NUM) {
		ASSERT(0);
		return(NULL);
	}
	else
		return (sense_key_msg[sense_key]);
}
