/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) scsi_ldrv.c: version 2.1 created on 4/17/90 at 14:02:05	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)scsi_ldrv.c	2.1	4/17/90 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include 	"sys/types.h"
#include 	"sys/param.h"
#include 	"sys/debug.h"
#include	"sys/cmn_err.h"
#include 	"scsi_log.h"
#include	"scsi_ncr.h"
#include	"scsi_db.h"
#include	"scsi_cmdbx.h"
#include	"scsi_error.h"
#include	"llvl_queue.h"
#include	"llvl_drv.h"
#include	"cdb.h"
#include	"llvl_msgs.h"
#include	"llvl_macro.h"


extern DCTB scsidev[];
extern void 	bus_reset_done();
extern Q_HDR relq;

/* get device control block */

espcmd(scb,command)
SCSI_CTB   *scb;
unchar	command;
{
	LOG_LONG_WORD((LOG_DRV|LOG_ESP),command,scb,RFINE);

	scb->espcmd = command;
#ifdef DEBUG_TIMEOUT
	{
	static int count = 0;
	if((command & 0x7F) == ESP_XFER_INFO){
		if(++count == 1000){
			count = 0;
			printf("bus timeout ....");
			return;
		}	
	}
	}
#endif
	ESPWREG(cmd) = command;
} 

	
fill_fifo(scb, buffer, len, flag)
register SCSI_CTB *scb;
register unchar	*buffer;
register short	len;
unchar flag;
{
	if(flag == FF_C)
		espcmd(scb, ESP_FLSH_FIFO);
	while(len--)
		ESPWREG(fifo) = *buffer++;
}

reject_msg(scb)
SCSI_CTB	*scb;
{
	/* clear msgin buffer */
	scb->msgin_len = 0;
	scb->msgin[0] = 0xFF;
	espcmd(scb, ESP_SET_ATN);
	/* send message reject */
	scb->msgout_len = 1;
	scb->msgout[0] = MSG_RJCT;
}
	



#ifdef DMA_DEBUG
int table_index;
extern char *mem_table[];
extern char **mem_ptr;
extern int log_flg;
#endif /* DMA_DEBUG */

reselection(scb)
SCSI_CTB *scb;
{
	extern SCSI_DB_REGS	*dual_r;	/* device board register */
	unchar unit_id,intstatus,my_id;
	uint   mask_bit;	

	/* if channel was trying to initiate bus 	*/
	log(LOG_DRV|LOG_RES, scb->chan_id, 0, RBEGIN);
	if(scb->cur_dev){
	/* then back off ! */
		/* canncel timer first */
		if(scb->cm){ /* has command pending */
#ifdef TIME_DEBUG
			s_untimeout(scb->cur_dev); /* stop function timer */
#else
			untimeout(scb->cur_dev->timer_id); /* stop function timer */
#endif /* TIME_DEBUG */
			scb->cm->cmd_flags &= CB_MASK;
			scb->cm->cmd_flags |= CB_READY;
			scsi_pushq(&scb->ready_q, scb->cm); /* back off */
			scb->cm=0;	/* clear pointer */
		}
		else { /* cur device is trying to send abort msg */

			ASSERT(scb->cur_dev->flags & DF_ABORT);
			scsi_pushq(&scb->abort_q,scb->cur_dev);	
		}
		scb->cur_dev = 0;
		scb->flags |= SF_IGNR_ILLCMD; /* prevent illegal command 
						interrupt */
		 
	}
	/* get two messages from fifo */
	scb->msgin_len = 0;
	scb->msgin[0] = ESPRREG(fifo);
	scb->msgin_len++;
	if(scb->int_status & INT_FUNC_COMP){
		scb->msgin[1] = ESPRREG(fifo);
		scb->msgin_len++;
	}
	espcmd(scb, ESP_FLSH_FIFO); /* clear fifo */
	/* convert unit id */
	unit_id = 0;
	my_id = ((unchar)1 <<scb->init_id);
	scb->msgin[0] &= ~my_id;		/* turn off my id */
	while((scb->msgin[0]&0x01)==NULL){
		unit_id++;
		scb->msgin[0] >>= 1; /* shift right one bit at a time */
	}
	unit_id |= (scb->chan_id << 3);
	scb->cur_dev = GETDCB(unit_id);
	scb->cm = scb->cur_dev->cur_cmd;
	if (scb->cm == NULL) { 	/* ignore reselect if no one is waiting */
		/* print warning mesage */
		cmn_err(CE_WARN, " channel id %d bus is %d doing an unnecessary reselect", scb->chan_id, unit_id & 0x07);
		scb->cur_dev = NULL;
		/* reset bus */
		scsi_bus_reset(scb); /* reset scsi bus */	
		scb->flags |= SF_BLOCK; /* set channel in block state */
		timeout(bus_reset_done, scb, 4*HZ+1); /* wait for device reset done */
		return;	
	}

	/* setup sync/async mode */
	ESPWREG(sync_offset) = scb->cur_dev->window;
	ESPWREG(sync) = scb->cur_dev->xferp;

	if(scb->msgin[1] & MSG_IDFY){
		/* target ask for resel */
		scb->cm->cmd_flags &= ~CB_DISC;
		scb->cm->cmd_flags |= CB_RUNNING;
		if(scb->cm->dma_buf_len > 0 ) {
			scb->cur_ptable = scb->ptable_1;
			/* restore pointer */
			scb->cur_dev->cur_resid = scb->cur_dev->save_resid;
#ifdef DMA_DEBUG
			if (log_flg == 1) {
				table_index++;
				mem_ptr = &mem_table[table_index*128];
			}
#endif /* DMA_DEBUG */
			if(scb->cur_dev->cur_resid > 0)
				scb->dma_count = setup_dataptr(scb->cur_ptable,
				   	scb->cm, scb->cur_dev->cur_resid, 
					FULL_TABLE);
		}
		scb->flags |= SF_BUS_BUSY;
		scb->phase = ST_MSGIN;
		espcmd(scb, ESP_MSG_ACPT);
		scb->timer = 2;
	} 
	else 
		xfer_info(scb);
	scb->msgin_len = 0;
	log(LOG_DRV|LOG_RES, scb->chan_id, 0, REND);
} /* reselection end */	

disconnect(scb)
SCSI_CTB *scb;
{
	log(LOG_DRV|LOG_DIS, scb->chan_id, 0, RBEGIN);

	if(scb->flags & SF_WAIT_DISC) 
		scb->flags &= ~SF_WAIT_DISC;
        else  /* unexpected disconnect */
		unexpect_disc(scb);

	scb->cur_dev =  NULL;

	if((scb->cur_dev = (DCTB *)scsi_deque(&scb->abort_q)) != NULL){
		ESPWREG(bus_id) = (scb->cur_dev->bus_id & 0x07);
		scb->msgout[0] = MSG_IDFY;
		/* stuffing message in fifo */
		fill_fifo(scb,scb->msgout, scb->msgout_len, FF_NC);
		scb->phase = 0xFF;
		espcmd(scb,ESP_SELATNSTP);
	} 
	else {
		scb->flags &=  ~SF_BUS_BUSY;
		espcmd(scb,ESP_FLSH_FIFO); /* flush fifo before enable resel */
		espcmd(scb,ESP_ENSEL); /* enable sel */
		start_connect(scb);
	}
	log(LOG_DRV|LOG_DIS, scb->chan_id, 0, REND);
}

unexpect_disc(scb)
SCSI_CTB *scb;
{
	ASSERT(scb->cm);
	if ((scb->espcmd & ESP_MODE_ZONE) == ESP_DISC_MODE) {
		select_fail(scb);
		return;
	}
	if ( scb->msgout_len == 1 && scb->msgout[0] == MSG_NOP) {
	/* we got reject message last time and it may go to bus free
	   phase, retry command  */
		scb->msgout_len = 0; /* clear message byte */
#ifdef TIME_DEBUG
		s_untimeout(scb->cur_dev); /* stop function timer */
#else
		untimeout(scb->cur_dev->timer_id); /* stop function timer */
#endif /* TIME_DEBUG */
		scsi_pushq(&scb->ready_q,scb->cm);
	}
	else
		set_scsi_err(scb, SCSIERR_DISC);
}

select_fail(scb)
SCSI_CTB *scb;
{
      	if (scb->espcmd != ESP_SELATNSTP) {
		set_scsi_err(scb, SCSIERR_NODEV);
		return;
	}
      	if(!(scb->flags & SF_CONN))
		chan_connect_fail(scb);
      	else
		no_device(scb);
}

chan_connect_fail(scb)
SCSI_CTB *scb;
{
#ifdef DIFF_FIRST
	if((scb->flags & SF_DIFF)){
		init_dsdb_chan(scb, BCR_SINGLE, DELAY);
#else
	if(!(scb->flags & SF_DIFF)){
		init_dsdb_chan(scb, BCR_DIFF, DELAY);
#endif /* DIFF_DEBUG */
#ifdef TIME_DEBUG
		s_untimeout(scb->cur_dev); /* stop function timer */
#else
		untimeout(scb->cur_dev->timer_id); /* stop function timer */
#endif /* TIME_DEBUG */
		scsi_pushq(&scb->ready_q,scb->cm);
		scb->cm = NULL;
	} 
	else {
		init_dsdb_chan(scb, BCR_DIFF, NO_DELAY);
		set_scsi_err(scb,SCSIERR_NODEV);
	}
}

no_device(scb)
SCSI_CTB *scb;
{
	if(!(scb->cur_dev->flags & DF_ABORT))
      		set_scsi_err(scb,SCSIERR_NODEV);
	else
		scb->cur_dev->flags &= ~DF_ABORT;
}

/* message_in -- process the msg data */
message_in(scb)
SCSI_CTB *scb;
{
	uint	dump_count;
	uint	remain;
	unchar	message;

	if (scb->status & ST_PARITY_ERR) {
		espcmd(scb,ESP_MSG_ACPT);
		espcmd(scb,ESP_FLSH_FIFO);
		set_msg(scb, MSG_PERR);
		scb->timer = 2;
	}
		
	message = ESPRREG(fifo);
	log(LOG_DRV|LOG_MGI, message, scb->msgin_len, RBEGIN);
	if(scb->msgin_len != 0){
 		if((scb->msgin_len == 2) && (message != MSG_SYNC)){
			reject_msg(scb);
			scb->msgin_len = 0;
		}
		else{
			scb->msgin[scb->msgin_len] = message;
			if(++scb->msgin_len == 5){
				config_sync(scb);
				scb->msgin_len = 0;
			}
		}
	}
	else
		switch(message){

		case MSG_COMP:
			scsi_cmd_done(scb->cm);
			break;
		case MSG_EXTN:
			if(scb->msgin_len == 0){
				scb->msgin[0] = message; /* save message */
				scb->msgin_len = 1;
				break;
			} 
			if((scb->msgin[0] != MSG_EXTN) ||
			   (scb->msgin_len != 1))
				reject_msg(scb);
			else{
			    scb->msgin[1] = MSG_SYNC;
			    scb->msgin_len = 2;	
			}
			break;
		case MSG_SAVE:
			scb->cur_dev->save_resid = scb->cur_dev->cur_resid;
			scb->cm->dma_resid = scb->cur_dev->cur_resid;
			break;
		case MSG_REST:
			scb->cur_ptable = scb->ptable_1;
			scb->cur_dev->cur_resid = scb->cur_dev->save_resid;
			scb->dma_count = setup_dataptr(scb->cur_ptable,scb->cm,
				scb->cur_dev->cur_resid, FULL_TABLE);
			break;
		case MSG_DISC:
			/* prepare target disconnect */
		   	scb->flags |= SF_WAIT_DISC;
			/* save pointer in case drive did not send SAVE message 
			   */
						
			if(scb->cm->dma_buf_len > 0){
				scb->cur_dev->save_resid = 
					scb->cur_dev->cur_resid;
				scb->cm->dma_resid = 
					scb->cur_dev->cur_resid;
			}
		 	scb->cm->cmd_flags &= ~CB_RUNNING;
			scb->cm->cmd_flags |= CB_DISC;
			scb->cm->disc_count++;
			scb->cm = NULL;
			scb->cur_dev = NULL;
		   	break;
		case MSG_RJCT: 
			if((scb->msgout[0] == MSG_EXTN) && 
			   (scb->msgout[2] == MSG_SYNC)){
		/* drive does not support sync transfer */
				scb->msgin[0] = MSG_RJCT;
				scb->msgin_len = 0;
				config_sync(scb);
			/* prepare the next message needed to send */
     				espcmd(scb, ESP_SET_ATN); /* asserted ATN */
				scb->msgout[0] = MSG_NOP;
				scb->msgout_len = 1;
				
			} else
			 if(scb->msgout[0] == MSG_ABRT){
				/* try to reset scsi device */
				scb->msgout[0] = MSG_DRST;	
				scb->msgout_len = 1;
				espcmd(scb,ESP_SET_ATN); /* assert atn */
			} 
			else {
				if (scb->msgout[0] == MSG_ERRD ||
				    scb->msgout[0] == MSG_PERR )
					err_to_reset_bus(scb, SCSIERR_PARITY);
				else
					err_to_reset_bus(scb, SCSIERR_NOCCS);
				return;
			}
			break;
		case MSG_LNKC: 
		case MSG_LNKF: 
			break;
		default:
			if((scb->msgin[0] == MSG_EXTN) && 
			   (scb->msgin[1] == MSG_SYNC) && 
			   (scb->msgin_len >= 2) && (scb->msgin_len <= 4)) {
			/* get extention message for sync */
				scb->msgin[scb->msgin_len] = message;
				scb->msgin_len++;
				if(scb->msgin_len == 5)
					config_sync(scb);
			} 
			else
				reject_msg(scb);
			break;
		}
	espcmd(scb,ESP_MSG_ACPT);
	scb->timer = 2;
	log(LOG_DRV|LOG_MGI, message, scb->msgin_len, REND);
} /* end of message in */

/* xfer_info -- transfer information state machine */

xfer_info(scb)
SCSI_CTB *scb;
{
	unchar *buffer;	/* buffer pointer */
	uint	*count;  /* number of bytes need to transfer */
	uint	flags;	/* dma direction flags */
	unchar  cur_phase,old_phase;
	unchar  fill_flag = 0;
	CMD_BOX	*cm = scb->cm;
/* setup current scsi bus phase */
	log(LOG_DRV|LOG_XIN, scb->phase, 0, RBEGIN);

	if((cur_phase = scb->status & ST_XFER_MASK) != scb->phase){
		espcmd(scb,ESP_NOP|ESP_DMA); /* just in case */
		if((cur_phase == ST_MSGOUT) || (cur_phase == ST_COMMAND))
			fill_flag = 1;
		if((cur_phase == ST_STATUS) || (cur_phase == ST_MSGIN) ||
		   (cur_phase == ST_DATAIN && scb->cur_dev->window == 0))
			espcmd(scb,ESP_FLSH_FIFO);
	}

	old_phase = scb->phase;

	switch(scb->phase = cur_phase){
		case ST_DATAOUT:
		case ST_DATAIN:
			dma_start(scb,old_phase);
			break;

		case ST_MSGIN:
			espcmd(scb,ESP_FLSH_FIFO);
			espcmd(scb,ESP_XFER_INFO);
			scb->timer = 2;
			break;
		case ST_MSGOUT: 
			if(fill_flag == 1){
				if (scb->msgout_len == 0) {
					scb->msgout[0] = MSG_NOP;
					scb->msgout_len = 1;
				}
				fill_fifo(scb,scb->msgout,scb->msgout_len,FF_C);
				log(LOG_DRV|0x0C, scb->msgout[0], 
					scb->msgout[1], scb->msgout_len);
			}
			espcmd(scb, ESP_XFER_INFO);
			scb->timer = 5;
			break;

		case ST_COMMAND:
			
			if(fill_flag == 1){
				fill_fifo(scb,cm->cmd_dsc_blk,
				cm->cmd_dsc_len,FF_C);
			}
				espcmd(scb,ESP_XFER_INFO);
				scb->timer = ((min(scb->cm->timer, 
						MIN_RECON_TIMER) + 1)/HZ + 1);
			break;
		case ST_STATUS:
			espcmd(scb,ESP_CMD_CMP);
			scb->timer = 3;
			break;
	}
	log(LOG_DRV|LOG_XIN, scb->phase, 0, REND);
} /* end of xfer_info */

dma_start(scb,old_phase)
register SCSI_CTB *scb;
unchar	old_phase;

{
	unchar dma_flag,id_bit;
        int	bytes,timer;

	if(scb->phase == ST_DATAIN)
		dma_flag =0;
	else 
		dma_flag = BCR_DMAWRITE;
	/* check dma address in long word boundary */
	if( scb->dma_count )
		dma_xfer(scb,scb->dma_count,dma_flag);
	else {
		if (scb->cur_dev->cur_resid == 0) {/* nothing need transfer */
		     	err_to_reset_bus(scb, SCSIERR_PHASE);
			return;
		}
		log(LOG_DRV|LOG_XTR, bytes, 0, 0);
		if(scb->phase == ST_DATAOUT)
			bcopy(*scb->cur_ptable,&scb->nice_buf, scb->cur_dev->cur_resid);
			/* save first entry for later use */
		scb->save_dmap = *scb->cur_ptable;
		scb->save_dmac = 0;
		scb->dma_count = scb->cur_dev->cur_resid;
		*scb->cur_ptable = (unchar *)(&scb->nice_buf);
		  /* setup dma  */
		dma_xfer(scb, scb->cur_dev->cur_resid, dma_flag);
	}
	timer = ((BASIC_TIMEOUT + 
		(scb->dma_count/BLOCK_SIZE + 1)*BLOCK_TIMEOUT)/HZ)+1;
	if (scb->phase == ST_DATAOUT) {
		id_bit = (1 << (scb->cm->unit_id & 0x07)); 
		/* if no disconnect option, then timer should be
		    added by access time for write operation */
		if ( (scb->cur_dev->status & DS_NO_OPTMSG) ||
			(!(scb->active & (~id_bit)))) 
			timer += 4;	/* add 4 secs */
	}
	scb->timer = timer;
}

check_status(scb)
SCSI_CTB *scb;
{

	log(LOG_DRV|LOG_STS, scb->sbyte, 0, RBEGIN);
	if(scb->sbyte & TRGT_CHECK_CON)
		/* device complain */
		scb->cm->err_code = SCSIERR_SENSE;
	else {
		if(scb->sbyte & TRGT_BUSY) 
			scb->cm->err_code = SCSIERR_BUSY;
	}
	scb->flags |= SF_WAIT_DISC;	/* wait for disconnected */

	log(LOG_DRV|LOG_STS, scb->sbyte, 0, REND);
} /* end of check_status	*/

dma_xfer(scb,n,flag)
SCSI_CTB *scb;
unchar flag;
ushort n;
{
	unchar low_cnt,hi_cnt;
	uint	fifo_cnt;
	
	log(LOG_DMA|0x4, n>>8, n,0);
	LOG_LONG_WORD(LOG_PR, 0, scb->cur_ptable, 0);

	*scb->ch_r.pcr_w = (uint)vtop(scb->cur_ptable, NULL);
	ESPWREG(xfercnt_lo) = n;
	ESPWREG(xfercnt_hi) = (n >> 8); 
#ifdef DMA_DEBUG
	espcmd(scb,ESP_NOP|ESP_DMA);
	low_cnt = ESPRREG(xfercnt_lo);
	hi_cnt = ESPRREG(xfercnt_hi);
	ASSERT((low_cnt == (n&0xFF)) && (hi_cnt == ((n>>8)&0xFF)));	
#endif /* DMA_DEBUG */
	espcmd(scb,ESP_XFER_INFO|ESP_DMA);
	bcr_uncmd(scb,BCR_DMAWRITE); /* turn off write bit */
	bcr_cmd(scb,BCR_ENDMA | flag);
}
/* send particular bcr command */
bcr_cmd(scb,cmd)
SCSI_CTB *scb;
uint	cmd;
{
	if (cmd == 0)
		scb->bcrcmd = 0;
	else
		scb->bcrcmd |= cmd;
#ifdef  WIREWRAP
	*scb->ch_r.bcr_w = scb->bcrcmd;
#else
	if(scb->chan_id == 0)
		*scb->ch_r.bcr_w = scb->bcrcmd << BCR_SHIFT_A;
	else
		*scb->ch_r.bcr_w = scb->bcrcmd << BCR_SHIFT_B;
#endif

}
/* turn off particular bcr command */
bcr_uncmd(scb,cmd)
SCSI_CTB *scb;
uint	cmd;
{
	scb->bcrcmd &= ~cmd;
#ifdef  WIREWRAP
	*scb->ch_r.bcr_w = scb->bcrcmd;
#else
	if(scb->chan_id == 0)
		*scb->ch_r.bcr_w = scb->bcrcmd << BCR_SHIFT_A;
	else
		*scb->ch_r.bcr_w = scb->bcrcmd << BCR_SHIFT_B;
#endif
}

#ifndef	WIREWRAP

/* reset device board */
bcr_reset(scb)
SCSI_CTB *scb;
{
	bcr_uncmd(scb,BCR_UNRESET);	/* reset is active low */
	scsi_delay(RESET_BD_DELAY);     /* delay about 20 ms */
	bcr_cmd(scb,BCR_UNRESET);	/* clear reset status */

}

/* reset scsi chip */
bcr_chip_reset(scb)
SCSI_CTB *scb;
{
	bcr_uncmd(scb,BCR_UNSCSIRES);	/* reset is active low */
	scsi_delay(RESET_CHIP_DELAY);   /* about 20 ms delay */
	bcr_cmd(scb,BCR_UNSCSIRES);	/* clear reset status */
}

/* clear reset state after power on reset */
clear_pwron_reset(scb)
{
	bcr_cmd(scb, 0);
	bcr_cmd(scb, BCR_UNRESET);
	bcr_cmd(scb, BCR_UNSCSIRES);
}

#endif

/* handle the illegal command interrupt */
illegal_cmd(scb)
{
	cmn_err(CE_PANIC, "got illegal command interrupt\n");
}


set_msg(scb, msg)
SCSI_CTB *scb;
unchar	msg;
{
	scb->msgout_len = 1;
	scb->msgout[0] = msg;
	espcmd(scb, ESP_SET_ATN);
}
	
