/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) scsi_ldma.c: version 25.1 created on 11/27/91 at 14:43:25	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)scsi_ldma.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* scsi_ldma.c -- the routines handles all the scsi dma transfer */
#include 	"sys/types.h"
#include 	"sys/param.h"
#include 	"sys/debug.h"
#include	"scsi_cmdbx.h"
#include	"scsi_ncr.h"
#include	"scsi_db.h"
#include	"scsi_error.h"
#include 	"scsi_log.h"
#include	"cdb.h"
#include	"llvl_queue.h"
#include	"llvl_drv.h"
#include	"llvl_msgs.h"
#include	"llvl_macro.h"

extern	SCSI_DB_REGS	*dual_r;	  		/* device board register */
extern	unchar **dma_ptable;
extern CM_CTL cm_ctl_table[];
#ifdef DMA_DEBUG
unchar *mem_table[20*128];
unchar **mem_ptr;
extern log_flg;
#endif /* DMA_DEBUG */

dump_dmafifo(scb)
SCSI_CTB *scb;
{
	unchar unload_done;
	unchar bsr;

	LOG_LONG_WORD(LOG_DMA|LOG_DMP, 0, scb, RBEGIN);
	
	scb->espcmd = 0;	/* means no command issued */
	bcr_cmd(scb,BCR_UNLOAD);
	if(scb->chan_id == 0)
		unload_done = BSR_UNLDA;
	else
		unload_done = BSR_UNLDB;	
	do
		bsr = dual_r->un.r.bsr;
	while(!(bsr&unload_done));
		/* wait for bit to setup */
	bcr_uncmd(scb,BCR_UNLOAD); /* turnoff command */

	LOG_LONG_WORD(LOG_DMA|LOG_DMP, 0, scb, REND);
}
/*
setup_dataptr -- setup dma page table.
input:
	scb->cur_ptable, dcb->resid, dcb->save_ptr.
	table_size -- max number of page table entries need to setup 
output: number of byte will be transfer for next dma activity.
*/
setup_dataptr(ptable,cm,resid,table_size)
register unchar		**ptable;
register CMD_BOX	*cm;
register int		resid;
int			table_size;
{
	register unchar	*buf_ptr;
	register int	tot_cnt, cnt, dma_cnt, entry_cnt;
	int		first_pgcnt; 
	void		*proc;	
	unchar		*phy_addr;

	LOG_LONG_WORD(LOG_DMA|LOG_SDP, 0, resid, RBEGIN);
	
	if (resid == 0)
		return(0);
	/* caculate starting address */
	buf_ptr = cm->dma_buffer + (cm->dma_buf_len - resid );
	proc = cm->dma_proc;

	LOG_LONG_WORD(LOG_DMA|0x03,0,buf_ptr,0);

	if ((uint)buf_ptr & 0x03 && resid < 4) /* can not go to dma */
		return(0);	

	entry_cnt = 0;
	tot_cnt = 0;

	first_pgcnt = DMA_PAGE - ((uint)buf_ptr & 0x3FF);

	while (resid > 0 && entry_cnt < table_size) {
#ifdef DMA_DEBUG
		phy_addr = (unchar *)vtop( buf_ptr, proc); 
		ASSERT( (uint)phy_addr < (uint)cm_ctl_table || (uint)phy_addr > (uint)cm_ctl_table);
		*ptable++ = phy_addr;
		if (log_flg == 1)
			*mem_ptr++ = phy_addr;
#else
		*ptable++ = (unchar *)vtop( buf_ptr, proc);
#endif /* DMA_DEBUG */
		cnt = DMA_PAGE - ((uint)buf_ptr & 0x3FF);
		entry_cnt++;
		buf_ptr += cnt;
		resid -= cnt;
		tot_cnt += cnt;
	}

	if (resid < 0)
		tot_cnt += resid;

	/* the ncr chip only can transfer 64k at a time */

	if(entry_cnt >= HALF_TABLE)
		dma_cnt = first_pgcnt+DMA_PAGE*63;
	else
		dma_cnt = tot_cnt;

	LOG_LONG_WORD(LOG_DMA|LOG_SDP, 0, dma_cnt, REND);
	return(dma_cnt);
} /* end of setup_dataptr */

xfer_next_table(scb)
SCSI_CTB *scb;
{
	unchar **ptable;
	uint	next_mm;
	unchar low_cnt,hi_cnt;
#ifdef DMA_DEBUG
	int x;
#endif /* DMA_DEBUG */

	LOG_LONG_WORD(LOG_DMA|LOG_XNP, 0, scb, RBEGIN);
	/* setup transfer counter */
	
	if (scb->cur_dev->cur_resid == 0)
		return(0);
	/* setup next dma page table */
	if(scb->cur_ptable == scb->ptable_1)
		scb->cur_ptable = scb->ptable_2;
	else
		scb->cur_ptable = scb->ptable_1;

	/* the max transfer count is 64k. */
	scb->dma_count = (scb->cur_dev->cur_resid > MAXXFERCNT) ? 
			MAXXFERCNT : scb->cur_dev->cur_resid;
	/* initiate dma */
	LOG_LONG_WORD(LOG_DMA|5, 0, scb->dma_count, 0);
	LOG_LONG_WORD(LOG_PR, 0, scb->cur_ptable, 0);
	ESPWREG(xfercnt_lo) = scb->dma_count;
	ESPWREG(xfercnt_hi) = scb->dma_count>>8;
	espcmd(scb,ESP_NOP|ESP_DMA);
	low_cnt = ESPRREG(xfercnt_lo);
	hi_cnt = ESPRREG(xfercnt_hi);
	ASSERT((low_cnt == (scb->dma_count&0xFF)) && (hi_cnt == ((scb->dma_count>>8)&0xFF)));	
	espcmd(scb,ESP_XFER_INFO|ESP_DMA);	
	
	/* format next page table if necessary */	
	if((scb->cur_dev->cur_resid - scb->dma_count) == 0)
		return(1);
	if(scb->cur_ptable == scb->ptable_1)
		ptable = scb->ptable_2;
	else
		ptable = scb->ptable_1;
#ifdef DMA_DEBUG
	if (log_flg == 1)
		x = 1;
	else   
		x = 0;
	log_flg = 0;
#endif /* DMA_DEBUG */
	setup_dataptr(ptable, scb->cm, scb->cur_dev->cur_resid - scb->dma_count,
		HALF_TABLE);
#ifdef DMA_DEBUG
	if (x)
		log_flg = 1;
#endif /* DMA_DEBUG */	
	LOG_LONG_WORD(LOG_DMA|LOG_XNP, 0, ptable, REND);
	return(1);
} /* end of xfer_next_page */

dma_parity_err(scb)
SCSI_CTB *scb;
{
	unchar parity_bit;
	unchar bsr;

	if(scb->chan_id == 0)
		parity_bit = BSR_BUSERRA;
	else
		parity_bit = BSR_BUSERRB;	
	bsr = dual_r->un.r.bsr;

	return(bsr&parity_bit);
}
