/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) scsi_lcmd.c: version 25.1 created on 11/27/91 at 14:43:21	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)scsi_lcmd.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* scsi_cmdbx.c -- allocate/deallocate command mailbox */

#include 	"sys/types.h"
#include 	"sys/param.h"
#include	"sys/debug.h"
#include	"scsi_error.h"
#include	"scsi_cmdbx.h"
#include	"llvl_macro.h"
#include 	"scsi_log.h"

/* global variables for command mailbox */

#define NUM_CMD_BOXES  (MAXALLOC * MAXNODRVS)
#define STATIC static

STATIC CM_CTL cm_ctl_table[NUM_CMD_BOXES];
STATIC CMD_BOX cm_pool[NUM_CMD_BOXES];
int cm_count[MAXNODRVS];
int init_cmdbox = 0;

/* scsi_get_cmd -- allocate a free command mailbox 
* 	input :	device unit id
*	output: the command mailbox pointer if not 0.
*		otherwise, no free command mailbox or unit id was wrong.
*/ 	

CMD_BOX *scsi_get_cmd(unit_id)
unchar unit_id;
{
	CM_CTL *ctl;
	int s;
	s = spldb();
	log(LOG_DRV|LOG_GET, 0, 0, RBEGIN);

	/* check unit id is valid */

	if(INVALID_UNIT_ID(unit_id)){

	log(LOG_DRV|LOG_GET, 0, unit_id, RERROR);
		splx(s);
		return(NULL); 
	}

	/* each drive can only has MAXALLOC number of command mailboxes
	   concurently */
	if(cm_count[unit_id] >= MAXALLOC){
	log(LOG_DRV|LOG_GET, 1, cm_count[unit_id], RERROR);
		splx(s);
		return(NULL);
	}
	/* looking for the free command mailboxes */
	;
	for(ctl = &cm_ctl_table[unit_id*MAXALLOC]; ctl < &cm_ctl_table[(unit_id+1)*MAXALLOC]; ctl++){
		if(ctl->flags == CM_FREE){
			ctl->flags = CM_BUSY;
			cm_count[unit_id]++;
			LOG_LONG_WORD(LOG_DRV|LOG_GET,2,ctl->cm,2);
			bzero(ctl->cm, sizeof(CMD_BOX));
			ctl->cm->unit_id = unit_id;

			LOG_LONG_WORD((LOG_DRV|LOG_GET), 0, ctl->cm, REND);
			splx(s);
			return(ctl->cm);
		}
	}
	panic("\nscsi_drv: cannot find free commmand mailbox");
}

/* scsi_put_cmd -- return command mailbox back to pool 
*  	input: command mailbox pointer
*	output: 1: ok.
*		0: command mailbox does not belong to pool or
*		   
*/
scsi_put_cmd(cm)
CMD_BOX *cm;
{
	CM_CTL *ctl;
	int i,s;

	s= spldb();

	ASSERT(init_cmdbox);

	log(LOG_DRV|LOG_PUT,0,0,RBEGIN);

	for(ctl = cm_ctl_table, i = 0; ctl <= &cm_ctl_table[NUM_CMD_BOXES-1];ctl++, i++){
		if(ctl->cm == cm){
			ASSERT(cm_count[i / MAXALLOC]);

			cm_count[i / MAXALLOC]--;

			ASSERT(ctl->flags != CM_FREE);

			ctl->flags = CM_FREE;
			splx(s);
			log(LOG_DRV|LOG_PUT,0,0,REND);
			return(1);
		}
	}
	splx(s);
	log(LOG_DRV|LOG_PUT,0,3,RERROR);
	ASSERT(0);
	return(0);
}

scsi_init_ctl_table()
{
	CM_CTL *ctl;
	CMD_BOX *cm;
	int i;

	for(ctl = cm_ctl_table, cm = cm_pool; 
		ctl <= &cm_ctl_table[NUM_CMD_BOXES-1]; ctl++,cm++){
		ctl->flags = CM_FREE;
		ctl->cm = cm;
	}
	for(i = 0;i <= MAXNODRVS-1;i++)
		cm_count[i] = 0;
	init_cmdbox = 1;
	
}
check_cm_table()
{
	if(init_cmdbox == 0)
		return(1);
	else
		return((uint)cm_ctl_table[0].cm);
}
