/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) dev_que.c: version 25.2 created on 4/14/92 at 20:28:13	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)dev_que.c	25.2	4/14/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* dev_serv.c -- service device command request and return the request when
 *		 it is done.
 *
 * called from higher level:
 *	scsi_send_cmd
 *
 * called from lower level:
 *	scsi_cmd_done
 *
 * called from elsewhere:
 *	init_dev_que
 *	dev_srv_intr
 */

#include	"sys/types.h"
#include	"sys/param.h"
#include	"sys/debug.h"
#include	"sys/sbus_iopm.h"
#include	"scsi_cmdbx.h"
#include	"cdb.h"
#include	"llvl_macro.h"
#include	"llvl_queue.h"
#include	"scsi_error.h"

void	ch_send_cmd();		/* send cmbox to channel */
void	ch_set_dev_init();	/* force channel to initialize device */
ITEM	*scsi_deque();		/* remove cmdbox from queue */
void	scsi_enque();		/* place cmdbox on queue */

struct	dev_que {
	Q_HDR	dev_q;	/* command box queue waiting for device is free */
	uint	flags;	/* current status */
	CMD_BOX	*cur_cm; /* current command box in processing */
	CMD_BOX req_cmd; /* request sense command box */
};

/* flag definitions */
#define	DQ_ATTN		0x01	/* device is in attention state */
#define	DQ_IN_ISSUE	0x02	/* issue_cmd is active for device */

#define MAXNODEVS	16

#define	 REQ_TIMER	(HZ + 1)

/******************* SEND COMMAND BOXES DOWN ONE AT A TIME ***********/

static  struct	dev_que	dev_q_table[MAXNODEVS];
static	Q_HDR 	resp_q;



#define	ID_MASK		0xfffffff0		

static void
issue_cmd(dev)
struct dev_que	*dev;
{
	if (dev->flags & DQ_IN_ISSUE)
		return;
	dev->flags |= DQ_IN_ISSUE;

	while ((dev->cur_cm = (CMD_BOX *)scsi_deque(&dev->dev_q)) != NULL) {

		if (dev->flags & DQ_ATTN)  {
			if (dev->cur_cm->cmd_type != CMD_RELEASE_ATTN) {
				dev->cur_cm->err_code = SCSIERR_ATN;
				scsi_enque(&resp_q, dev->cur_cm);
				request_service();
				continue;
			}
			dev->flags &= ~DQ_ATTN;
		}
		ch_send_cmd(dev->cur_cm);
		break;
	}
	dev->flags &= ~DQ_IN_ISSUE;
}

void
scsi_send_cmd(cm)
CMD_BOX *cm;
{
	int  x;
	uint unit_id = cm->unit_id;

	ASSERT(!INVALID_UNIT_ID(unit_id));
	x = spldb();
	scsi_enque(&dev_q_table[unit_id].dev_q, cm);
	if (dev_q_table[unit_id].cur_cm == NULL)
		issue_cmd(&dev_q_table[unit_id]); /* send command */
	splx(x);
}


/******************* RETURN COMPLETED COMMAND BOXES ***********/

static void
get_request_sense(dev)
struct dev_que	*dev;
{
	dev->req_cmd.dma_buffer = dev->cur_cm->error;
	ch_send_cmd(&dev->req_cmd);
}

static CMD_BOX *
finish_request_sense(dev)
struct dev_que *dev;
{
	CMD_BOX *org_cm = dev->cur_cm;
	CMD_BOX *sense_cm = &dev->req_cmd;

	if (sense_cm->err_code)
		org_cm->err_code = SCSIERR_FATAL;
	else
		org_cm->err_len = sense_cm->dma_buf_len - sense_cm->dma_resid;
	return(org_cm);
}


static uint
dev_attn(cm)
CMD_BOX *cm;
{
	EX_SENSE_DATA *sns_data = (EX_SENSE_DATA *)cm->dma_buffer;

	if ( (cm->cmd_dsc_blk[0] == CDB_REQUEST_SENSE) )
	{
		uchar key;

		if ( (uint)sns_data < IOPM_RAM_START )
		{
			uint savmap = vmap_save();

			sns_data = (EX_SENSE_DATA *)vmap(sns_data,cm->dma_proc);
			key = sns_data->sense_key & SENSE_KEY;
			vmap_restore(savmap);
		}
		else
			key = sns_data->sense_key & SENSE_KEY;

		if ( key == SNSKEY_UNIT_ATTN )
			return(1);
	}
	return(0);
}

void
scsi_cmd_done(cm)
CMD_BOX	*cm;
{
	struct dev_que	*dev = &dev_q_table[cm->unit_id];

	ASSERT(cm == dev->cur_cm || cm == &dev->req_cmd);
	if (dev_attn(cm)) {
		dev->flags |= DQ_ATTN;
		ch_set_dev_init(cm->unit_id); /* set device in init state */
	}
	if (cm == &dev->req_cmd)
		cm = finish_request_sense(dev);
	else if (cm->err_code == SCSIERR_SENSE) {
		get_request_sense(dev);
		return;
	}
	scsi_enque(&resp_q, cm);
	request_service();
	issue_cmd(dev);
}

/* dev_srv_intr -- return command boxes back to device driver.
 * It is designed to be used by request_service routine, 
 */

static void
dev_srv_intr()
{
	CMD_BOX *rel_cm;
	int s = spldb();

	while ((rel_cm = (CMD_BOX *)scsi_deque(&resp_q)) != NULL) {
		splx(s);
		(*rel_cm->service)(rel_cm);
		s = spldb();
	}
	splx(s);
}

/******************* INITIALIZATION ***************************/

static void
init_req_box()
{
	struct	dev_que *dev;
	int 	i;

	for (i = 0, dev = dev_q_table; i != MAXNODEVS; dev++, i++) {
		dev->req_cmd.unit_id = i;
		dev->req_cmd.cmd_dsc_blk[0] = CDB_REQUEST_SENSE;
		dev->req_cmd.cmd_dsc_blk[1] = 0;
		dev->req_cmd.cmd_dsc_blk[2] = 0;
		dev->req_cmd.cmd_dsc_blk[3] = 0;
		dev->req_cmd.cmd_dsc_blk[4] = SENSE_DATA_SIZE;
		dev->req_cmd.cmd_dsc_blk[5] = 0;
		dev->req_cmd.cmd_dsc_len = sizeof (struct g0_cdb);
		dev->req_cmd.dma_buf_len = SENSE_DATA_SIZE;
		dev->req_cmd.dma_proc = NULL;
		dev->req_cmd.timer = REQ_TIMER;
		dev->req_cmd.service = NULL;
	}
}

/*
 * init_dev_que -- initialization for dev_que
 *
 * called from rest of system initialization
 */
init_dev_que()
{
	init_req_box();
	set_serv_handler(dev_srv_intr);
}
