/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sdk_strat.c: version 2.1 created on 4/17/90 at 14:01:02	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sdk_strat.c	2.1	4/17/90 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* sdk_strat.c -- IOPM scsi disk driver of strategy  	*/

#include "sys/types.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/errno.h"
#include "sys/elog.h"
#include "sys/file.h"
#include "sys/debug.h"

#include "sys/buf.h"

#include "scsi_log.h"
#include "hlvl_macro.h"
#include "sdk_cdb.h"
#include "sdkioctl.h"
#include "sdkcfg.h"
#include "scsi_cmdbx.h"
#include "sdk.h"


extern buf_t *ownbuf[];
extern buf_t *sdk_lock_buf();
extern struct local_buffer dbf;
extern void sdk_intr();
extern struct dskiobuf devtbl[];
extern get_time_stamp();



/*
sdkcommand -- This routine used for internal issueing a disk operation 
	      request. It setup local buf header and then call strategy
	      routine.
input: 
      unit_id -- scsi device target ID.(1-7 or 8-15).
      cmd     -- First bytes : scsi command code.
	         Rest of three bytes :	parameters go with command.	
      buf_len -- number of bytes to transfer. if it is 0 , then use default
		 value.
output:
	successful -- 1.
	otherwise -- 0.
*/
	
sdkcommand(unit_id,cmd,buf_len)
unchar	unit_id;
uint cmd;
uint buf_len;
{
	register buf_t *bp = ownbuf[unit_id];
	uint	x;
	unchar scsi_cmd;
	
	log(LOG_DSK|LOG_XCMD, unit_id, cmd>>24, RBEGIN);
	log(LOG_PR, buf_len>>16, buf_len>>8, buf_len);
	/* setup buf header structure */
	bp->b_error = 0;
	bp->b_cmd = cmd;
	bp->b_bcount = buf_len;
	bp->b_resid = 0;
	scsi_cmd = bp->b_cmd;
	if((scsi_cmd == CDB_READ) || (scsi_cmd == CDB_WRITE))
		bp->b_sblock = (struct buf *)GET_PRA(cmd);  /* get block number */

/* do the oper	*/
	sdkstrategy(bp);
	iowait(bp);
	bp->b_flags &= ~B_DONE;

	if(bp->b_flags & B_ERROR){
		log(LOG_DSK|LOG_XCMD, unit_id, cmd, RERROR);
		log(LOG_PR, buf_len>>16, buf_len>>8, buf_len);
		return(0);
	}
	else {
		log(LOG_DSK|LOG_XCMD, unit_id, cmd, REND);
		log(LOG_PR, buf_len>>16, buf_len>>8, buf_len);
		return(1);
	}
	
} /* end of sdkcommand */

sdkstrategy(bp)
register struct	buf	*bp;	/* request buffer pointer */
{
	unchar	unit_id = UNIT(bp->b_dev);	/* get unit id */
	unchar	sl = SLICE(bp->b_dev);		/* get slice number */
	register struct dskiobuf *dp = GETDP(unit_id); /* get device table */
	DCFG	*dcfg;
	register SLSIZE	*lg;	/* logical drive	*/
	uint	iplsave;
	int	lblk;
	
	LOG_LONG_WORD(LOG_DSK|LOG_STRA, 0, bp, RBEGIN);

	dcfg = &dp->cfg;	   /* point to configuration table */
	if(bp != ownbuf[unit_id]){
		/* command is issued by kernel */
		ASSERT(dp->open_cnt);
		if (dp->b_flags & B_NEWMDM) {
			DISPLAY_DRV_ID(unit_id);
			printf("Slice %d,%s\n",sl,"Medium just been changed.");
			sdkerror(bp,EINVAL);
			return;
		}
		lg = &dcfg->logdrv[sl];

		if (bp->b_bcount & (BSIZE - 1)) { /* check length  */
			DISPLAY_DRV_ID(unit_id);
			printf("Slice %d,%s\n",sl," illegal data length");
			sdkerror(bp,EINVAL);
			LOG_LONG_WORD(LOG_DSK|LOG_STRA, ENXIO, bp ,RERROR);
			return;
		}

	/* if the requested data block does not within requested partition */
		if (bp->b_blkno >= lg->noblk){
			if((bp->b_blkno == lg->noblk) && (bp->b_flags&B_READ)) {
			/* this case is here to help read ahead */
				bp->b_resid = bp->b_bcount;
				LOG_LONG_WORD(LOG_DSK|LOG_STRA, 0, bp, REND);
				LOG_LONG_WORD(LOG_PR, 0, bp->b_resid, 0);
				iodone(bp);
			}
			else {
			        sdkerror(bp,ENXIO);
				LOG_LONG_WORD(LOG_DSK|LOG_STRA, ENXIO, bp ,RERROR);
			}
			return;
		}
			

	    	if((lblk = bp->b_blkno + (bp->b_bcount / BSIZE) - 1) >= lg->noblk) 
			bp->b_resid = BSIZE * (lblk - lg->noblk + 1);
		else
			bp->b_resid = 0;
		ASSERT( bp->b_blkno + (bp->b_bcount - bp->b_resid)/BSIZE <= lg->noblk);

		bp->b_sblock = (struct buf *)(lg->offset + bp->b_blkno);
		/* update statistic information */
		bp->b_start = get_time_stamp(); /* get starting time */

	}
	iplsave = splhlv();
	dp->sar->io_cnt++;
	dp->qcnt++; /* inc current i/o request */

	sdksort(dp,bp);
	sdkstart(dp);
	/* EXIT CRITICAL REGION */
	splx(iplsave);
	LOG_LONG_WORD(LOG_DSK|LOG_STRA, 0, bp, REND);
		
} /* end of sdkstrategy */

#ifdef ATT
sdksort(dp,bp)
register struct dskiobuf *dp;
register struct buf	*bp;
{
	/* link buffer header to drive worklist */
	if (dp->b_actf == NULL) {
		dp->b_actf = bp;
		dp->b_actl = bp;
		dp->b_acts = bp;
		bp->av_forw = NULL;
	} else {
 		register struct buf *ap, *cp;

 		if ((dp->sar->io_cnt&(SSTEP-1)) == 0)
 			dp->b_acts = dp->b_actl;
 		for (ap = (struct buf *)dp->b_acts; cp = ap->av_forw; ap = cp) {
 			register int s1, s2;
 			if ((s1 = ap->b_sblock- bp->b_sblock)<0)
 				s1 = -s1;
 			if ((s2 = ap->b_sblock - cp->b_sblock)<0)
 				s2 = -s2;
 			if (s1 < s2)
 				break;
 		}
 		ap->av_forw =  bp;
 		if ((bp->av_forw = cp) == NULL)
 			dp->b_actl = bp;
	}
} /* end of sorting */

/* sdkstart -- get a request */
sdkstart(dp)
struct dskiobuf	*dp;
{
	struct buf *bp;
	
	LOG_LONG_WORD(LOG_DSK|LOG_START, 0, dp, RBEGIN);
	if (dp->b_flags & B_RESET)
		return;
	if((dp->b_actf)&&(dp->b_outcnt < BOTH_IN_USED)){
	/* dequeue i/o request */
		bp = dp->b_actf;
		if (dp->b_outcnt == 0)  {
		/* no command outstanding, dequeue it! */
			if ((dp->b_actf = bp->av_forw) == NULL) {
				dp->b_actl = NULL;
				dp->b_acts = NULL;		
			}
			if(bp == dp->b_acts)
				dp->b_acts = dp->b_actf;
			dp->qcnt--;
			ASSERT(dp->qcnt != -1);
		}
		sdkxstart(dp, bp);
	}
	log(LOG_DSK|LOG_START, 0, dp, REND);

} /* end of sdkstart */
#endif /* ATT */


#ifdef C_SCAN
sdksort(dp,bp)
register struct dskiobuf *dp;
register struct buf	*bp;
{
	register buf_t	*ap, *cp;
	int first_q;


	if ( ! dp->b_actf ) {
		dp->b_actf = dp->b_actl = dp->b_acts = bp;
		dp->b_acte = bp;
		bp->av_forw = 0;
		return;
	}

	/* sort groups of SSTEP - 1 */
 	if ((dp->sar->io_cnt&(SSTEP-1)) == 0) {
		dp->b_acts =  dp->b_acte = dp->b_actl;
	}
	if ( bp->b_sblock < dp->b_acts->b_sblock) {
		first_q = 0;
		for (ap = dp->b_acte; cp = ap->av_forw; ap = cp)
			if (bp->b_sblock < cp->b_sblock)
				break;
	}
	else {
		first_q  = 1;
		for (ap = dp->b_acts; cp = ap->av_forw; ap = cp) {
			if ( ap == dp->b_acte)
				break;
			if (bp->b_sblock < cp->b_sblock)
				break;
		}
	}
	ap->av_forw =  bp;

	if ((bp->av_forw = cp) == NULL)
		dp->b_actl = bp;
	if (first_q == 1 && ap == dp->b_acte)
		dp->b_acte = bp;
} /* end of sorting */

/* sdkstart -- get a request */
sdkstart(dp)
struct dskiobuf	*dp;
{
	struct buf *bp;
	
	LOG_LONG_WORD(LOG_DSK|LOG_START, 0, dp, RBEGIN);
	if (dp->b_flags & B_RESET)
		return;
	if((dp->b_actf)&&(dp->b_outcnt < BOTH_IN_USED)){
	/* dequeue i/o request */
		bp = dp->b_actf;
		if (dp->b_outcnt == 0)  {
		/* no command outstanding, dequeue it! */
			if ((dp->b_actf = bp->av_forw) == NULL) {
				dp->b_actl = NULL;
				dp->b_acts = NULL;		
				dp->b_acte = NULL;
			}
			if (bp == dp->b_acts)
				dp->b_acts = dp->b_actf;
			if (bp == dp->b_acte)
				dp->b_acte == dp->b_actf;
			dp->qcnt--;
			ASSERT(dp->qcnt != -1);
		}
		sdkxstart(dp, bp);
	}
	log(LOG_DSK|LOG_START, 0, dp, REND);

} /* end of sdkstart */
#endif /* C_SCAN */


/* sdkxstart -- format request to scsi Command Descriptor Block */
sdkxstart(dp, bp)
struct dskiobuf	*dp;
register struct buf *bp;
{
	register CMD_BOX *cm;	
	unchar	unit_id,index;

	/* get command mailbox	*/
	LOG_LONG_WORD(LOG_DSK|LOG_XSTART, 0, bp, RBEGIN);
	unit_id = UNIT(bp->b_dev);
	index = dp->b_outcnt & CMB0_IN_USED;
	cm = dp->cm[index];
	ASSERT(cm);
	dp->b_outcnt |= (index+1);

	bzero (cm, sizeof (CMD_BOX));

	/* format command descriptor block and command mailbox	*/
	cm->dma_flags = 0; /* clear flag */
	
	/* setup general information in command mail box */
	cm->service = sdk_intr; /* setup server routine */
	cm->tag = (uint )bp;		   /* setup tag */
	cm->unit_id = UNIT(bp->b_dev);
	cm->cmd_type = 0;	/* set to regular command */
	cm->retry_cnt = 5;

	if(bp == ownbuf[unit_id])
		sdklocalio(dp, cm, bp);
	else
	        sdkfastio(dp, cm, bp);

	/* setup dma information */
	if((cm->dma_buf_len = bp->b_bcount - bp->b_resid) != 0){
		cm->dma_buffer = (unchar *)bp->b_un.b_addr;
		cm->dma_proc = bp->b_proc;
		
	}
        scsi_send_cmd(cm);
	LOG_LONG_WORD(LOG_DSK|LOG_XSTART, 0, bp, REND);
	
} /* end of sdkxstart */

sdkerror(bp,err)
struct buf *bp;
unchar err;
{
	bp->b_flags |= B_ERROR;
	bp->b_error = err;
	iodone(bp);
}

sdkfastio( dp, cm, bp)
struct dskiobuf	*dp;
register CMD_BOX *cm;
register struct buf *bp;
{

	register struct g1_cdb	*cdb = (struct g1_cdb *)(cm->cmd_dsc_blk);
	uint	blk_cnt, drv_blkno;

	cm->cmd_dsc_len = G1SIZE;
    	if(!(bp->b_flags & B_READ))
		cdb->opcode = CDB_WRITE_EXTENDED;
	else {
		cdb->opcode = CDB_READ_EXTENDED;
		cm->dma_flags |= DMA_READ;
	}
	cdb->ctl = 0;
	drv_blkno = (uint)bp->b_sblock * dp->cfg.blk_ratio; /* caculate drive block no */
	ASSERT(drv_blkno);
	ITOC4(cdb->lbadr_msb, cdb->lbadr_2, cdb->lbadr_1, cdb->lbadr_lsb, drv_blkno);
	blk_cnt = (bp->b_bcount - bp->b_resid)/dp->cfg.blk_len;
	ASSERT(blk_cnt);
#ifdef DEE
	if(!(cm->dma_flags & DMA_READ ) { /write test */
		if(bp->b_tablep == 0 && cm->unit_id == 8){
			int i;
			unchar *datap = (unchar *)bp->b_un.b_addr;

			for(i = 0; i<200; i++){
				if(*datap++ != 0)
					break;
			}
			ASSERT(i < 200);
		}
	}
#endif
	ITOC2(cdb->xferlen_msb, cdb->xferlen_lsb, blk_cnt);

	cm->cmd_dsc_len = G1SIZE;
	cm->timer = BASIC_TIMER+(RWUNIT_TIMER*blk_cnt);
}

sdklocalio(dp, cm, bp)
struct dskiobuf	*dp;
register CMD_BOX *cm;
register struct buf *bp;
{
	register unchar	opcode = bp->b_cmd;

	switch (opcode & GRPMASK){
		case GRP0:
			grp0_cdb(dp, cm, bp);
			break;
		case GRP1:
			grp1_cdb(dp, cm, bp);
			break;
		case GRP5:
			grp5_cdb(dp, cm, bp);
			break;
		default:
			panic("So far, the group number %d is not supported\n",
				((opcode & GRPMASK) >> 5));
	}
} /* end of sdklocalio */
			
/*
	the rest of 3 rotines - grp0_cdb, grp1_cdb and grp5_cdb - setting
	up command descriptor block, value of timer for each command,
	size of cdb, dma direction if necessary.
*/
#define CP_LIST	0x08

STATIC grp0_cdb(dp, cm, bp)
struct dskiobuf	*dp;
register CMD_BOX *cm;
register struct buf *bp;
{
	register struct g0_cdb *cdb = (struct g0_cdb *)cm->cmd_dsc_blk;
 	uint	pars = GET_PRA(bp->b_cmd);
	uint	blk_cnt, drv_blkno;

	cdb->ctl = 0;
	cm->cmd_dsc_len = G0SIZE;

	switch(cdb->opcode = bp->b_cmd){
		case CDB_READ:
			cm->dma_flags |= DMA_READ;	
		case CDB_WRITE:
			/* setup block number and xfer count */
			drv_blkno = (int)bp->b_sblock * dp->cfg.blk_ratio; /* caculate drive block no */
			
			ITOC3(cdb->lbaddr_msb, cdb->lbaddr, cdb->lbaddr_lsb, drv_blkno);
			cdb->lbaddr_msb &= 0x1F;
			cdb->xfer_len = (bp->b_bcount - bp->b_resid ) /
						dp->cfg.blk_len;
			cm->timer = BASIC_TIMER + (RWUNIT_TIMER * cdb->xfer_len);
			break;

		case CDB_MODE_SENSE:
			cm->dma_flags |= DMA_READ;
			if (dp->b_flags & B_ODD)
				cdb->lun_flags = 0x10;
			cdb->page_flags = pars;
			cdb->alloc_len = bp->b_bcount;
			cm->timer = MODE_TIMER;
			break;

		case CDB_MODE_SELECT:
			cdb->lun_flags = pars;
			cdb->alloc_len = bp->b_bcount;
			cm->timer = MODE_TIMER;
			break;

		case CDB_REQUEST_SENSE:
			cm->dma_flags |= DMA_READ;
			cm->timer = SENSE_TIMER;
			cdb->alloc_len = bp->b_bcount;
			break;

		case CDB_INQUIRY:
			cm->dma_flags |= DMA_READ;
			cm->timer = INQUIRY_TIMER;
			cdb->alloc_len = bp->b_bcount;
			cm->timer = BASIC_TIMER;
			break;

		case CDB_START_STOP:
			cdb->start_flags = pars;
			cm->timer = START_TIMER;	
			break;

		case CDB_MEDIUM_REMOVAL:
			cdb->prvnt = pars;
			cm->timer = START_TIMER;	
			break;

		case CDB_TEST_UNIT_READY:
		case CDB_REZERO:
			cm->timer = BASIC_TIMER;

			break;
		default:
			ASSERT(0);
	}
}

STATIC grp1_cdb(dp, cm, bp)
struct dskiobuf	*dp;
register CMD_BOX *cm;
register struct buf *bp;
{
	register struct g1_cdb *cdb = (struct g1_cdb *)cm->cmd_dsc_blk;
 	uint	pars = GET_PRA(bp->b_cmd);
	uint	blk_cnt, drv_blkno;
	
	cdb->ctl = 0;
	cm->cmd_dsc_len = G1SIZE;

	switch(cdb->opcode = bp->b_cmd){
		case CDB_READ_EXTENDED:
			cm->dma_flags |= DMA_READ;
			/* FALL THRU	*/
		case CDB_WRITE_EXTENDED:
			drv_blkno = (uint)bp->b_sblock * dp->cfg.blk_ratio; /* caculate drive block no */
			ITOC4(cdb->lbadr_msb, cdb->lbadr_2, cdb->lbadr_1, cdb->lbadr_lsb, drv_blkno);

			blk_cnt = (bp->b_bcount - bp->b_resid)/dp->cfg.blk_len;

			ITOC2(cdb->xferlen_msb, cdb->xferlen_lsb, blk_cnt);

			cm->timer = RWUNIT_TIMER*blk_cnt;
			break;

		case CDB_READ_CAPACITY:
			/* setup logical block number */
			ITOC4(cdb->calba_msb, cdb->calba_2, cdb->calba_1, cdb->calba_lsb, pars);
			
			if(pars)
				cdb->ca_pmi = PMI; /* set partial indicator */
			cm->timer = RDCP_TIMER;
			cm->dma_flags |= DMA_READ;
			break;

		default:
			panic("sdk_strat: Unknown cdb command :%x\n",
				cdb->opcode);
	}
}

STATIC grp5_cdb(dp,cm,bp)
struct dskiobuf	*dp;
register CMD_BOX *cm;
register struct buf *bp;
{
	register struct g5_cdb *cdb = (struct g5_cdb *)cm->cmd_dsc_blk;
 	uint	pars = GET_PRA(bp->b_cmd);
	
	cdb->ctl = 0;
	cm->cmd_dsc_len = G5SIZE;

	switch(cdb->opcode = bp->b_cmd){
		
		default:
			ASSERT(0);	
	}
	
}

sdkprint(dev, str)
uint dev;
char *str;
{
	cmn_err(CE_NOTE, "%s on SCSI disk drive (id %d), logical disk %d\n",
			str, UNIT(dev), SLICE(dev));
}
