/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sdk_open.c: version 25.1 created on 11/27/91 at 14:42:35	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sdk_open.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* sdk_open.c -- IOPM scsi driver open/close routines */

#include "sys/types.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/debug.h"
#include "sys/errno.h"
#include "sys/elog.h"
#include "sys/file.h"
#include "sys/open.h"

#include "sys/user.h"
#include "sys/buf.h"

#include "scsi_log.h"
#include "hlvl_macro.h"
#include "sdk_cdb.h"
#include "sdkioctl.h"
#include "sdkcfg.h"
#include "scsi_cmdbx.h"
#include "sdk.h"
#include "sdk_disk.h"

#include "disksect.h"	/* scsi edt sector 0 header file */

/* global data area	*/
struct buf *ownbuf[MAXNODRVS];
struct dskiobuf devtbl[MAXNODRVS];
uint	initialized = 0;		/* flag to indicate first time
					   to go through */
extern struct buf *geteblk();
extern CMD_BOX *scsi_get_cmd();
extern struct iotime	*get_iotime();
extern void reset_done();

buf_t *
sdk_lock_buf(unit_id)
unchar unit_id;
{
	register buf_t *bp = ownbuf[unit_id];

	ASSERT(bp);
	while(bp->b_flags & B_BUSY){
		bp->b_flags |= B_WANTED;
		sleep(bp,PRIBIO);
	}
	ASSERT((bp->b_flags & B_BUSY) == 0);
	bp->b_flags |= B_BUSY;
}

sdk_rel_buf(unit_id)
unchar unit_id;
{
	register buf_t *bp = ownbuf[unit_id];

	ASSERT(bp->b_flags & B_BUSY);
	bp->b_flags &= ~B_BUSY;
	if(bp->b_flags & B_WANTED){
		bp->b_flags &= ~B_WANTED;
		wakeup(bp);
	}
}
	
/* device lock  routine	*/
static sdkslopen(dp)
struct dskiobuf	*dp;
{
	uint	x;
	x=splhlv();	/* higher the interrupt mask level */

	dp->wait++;
	while(dp->b_flags & B_OPENIN) /* wait for device available */
   		sleep(dp,PZERO);
	dp->b_flags |= B_OPENIN; 
	dp->wait--;
	splx(x);
}

/* unlock device */
static sdkwkup(dp)
struct dskiobuf	*dp;
{
	uint	x;

	x=splhlv();	/* higher the interrupt mask level */
	dp->b_flags &= ~B_OPENIN;
	wakeup(dp);
	splx(x);
}

sdkinit()
{
	int i;
	log(LOG_DSK|LOG_INIT, 0, 0, RBEGIN);
	/* initialize global table */
	bzero(devtbl,sizeof(struct dskiobuf)*MAXNODRVS);
	for ( i = 0; i < MAXNODRVS; i++)
		devtbl[i].b_dev = i;

	log(LOG_DSK|LOG_INIT, 0, 0, REND);

}	/* end of sdkinit */




sdkopen(dev, flag, type)
register ushort dev;
uint flag, type;
{
	unchar unit_id = UNIT(dev);
	unchar slice = SLICE(dev);
	struct dskiobuf *dp;
	uint x, error;

	/* check if the first open for the driver */
	log(LOG_DSK|LOG_OPEN, unit_id, flag, RBEGIN);
	if(!initialized){
		x = splhlv();	/* disable software interrupt */
		sdkinit(); 	/* initialize driver's table */
		initialized = 1; /* mark driver has been initialized */
		splx(x);	 
	}

	dp = GETDP(unit_id);	/* get device table	*/

	sdkslopen(dp);	/* lock device */

	if (!(dp->b_flags & B_ALLOC)) {
		if (!sdk_alloc(dp)) {
			/* note this assumes that the command mailboxes couldn't
			 * be allocated because they have been taken by another driver
			 * using the device. From this is it deduced that the wrong type
			 * of drive is being opened. It is possible for that the other
			 * driver has been allocated the boxes and is in the process of
			 * discovering that it is addressing the wrong device type. In
			 * that case this open will fail incorrectly. */
			u.u_error = ENXIO;
			sdkwkup(dp);
			return;	 
		}
		dp->b_flags |= B_ALLOC;
	}
	
	sdk_lock_buf(unit_id);
	if ( (u.u_error = disk_open(dp, unit_id)) != 0) {
		sdk_rel_buf(unit_id);
		sdk_dealloc(dp);
		sdkwkup(dp);
		return;	 
	}
	sdk_rel_buf(unit_id); /* unlock buf header */


	if ((u.u_error = sdk_set_optype(dp, slice, flag, type)) != 0) {
		if ((dp->open_cnt == 0) && (dp->b_flags & B_RMB)) {
			sdk_lock_buf(unit_id);
			sdk_unlock_drv(dp);
			sdk_rel_buf(unit_id);
			sdk_dealloc(dp);
		}
	}
		
	sdkwkup(dp);	/* release device */

	log(LOG_DSK|LOG_OPEN, unit_id, u.u_error, REND);
} /* end of sdkopen */

static
disk_open (dp, unit_id)
struct dskiobuf *dp;
unchar unit_id;
{
	if (!(dp->b_flags & B_ONCE)) {
		dp->b_dev = unit_id;
		if ( !sdk_device_init(dp))
			return(ENXIO);	 
	}
	if ((dp->b_flags & B_NEWMDM) || (dp->open_cnt == 0)) {
		dp->b_flags &= ~B_NEWMDM;
		if (!sdk_media_init(dp))
			return(EIO);	 
	}

	if (!sdk_spin_drv(dp))
		return(EIO);	 
	return(0);
}

sdkclose(dev,flag, type)
register ushort dev;
uint flag, type;
{
	uint	unit_id = UNIT(dev);
	uint	sl = SLICE(dev);
	struct dskiobuf *dp = GETDP(unit_id);
	
	log(LOG_DSK|LOG_CLOSE, unit_id, flag, RBEGIN);

	sdkslopen(dp);

	switch (type) {
	case OTYP_BLK:
		ASSERT(dp->ot_flg[sl] & OFLG_BLK);
		dp->ot_flg[sl] &= ~OFLG_BLK;
		break;
	case OTYP_MNT:
		ASSERT(dp->ot_flg[sl] & OFLG_MNT);
		dp->ot_flg[sl] &= ~OFLG_MNT;
		break;
	case OTYP_CHR:
		ASSERT(dp->ot_flg[sl] & OFLG_CHR);
		dp->ot_flg[sl] &= ~OFLG_CHR;
		break;
	case OTYP_SWP:
		ASSERT(dp->ot_flg[sl] & OFLG_SWP);
		dp->ot_flg[sl] &= ~OFLG_SWP;
		break;
	case OTYP_MIR:
		ASSERT(dp->ot_flg[sl] & OFLG_MIR);
		dp->ot_flg[sl] &= ~OFLG_MIR;
		break;
	case OTYP_LYR:
		break;
	default:
		ASSERT(0);
	}
	ASSERT(dp->open_cnt > 0);
	if (--dp->open_cnt == 0) {
		for (sl = 0; sl != MAX_UNIX_SLICES; sl++)
			ASSERT(dp->ot_flg[sl] == 0);
		while(dp->qcnt || dp->b_outcnt)
			delay(2);
		sdk_unlock_drv(dp);

		if (dp->b_flags & B_ALLOC )
			sdk_dealloc(dp);
	}
	sdkwkup(dp);
	log(LOG_DSK|LOG_CLOSE, unit_id, flag, REND);
}

sdk_alloc(dp)
register struct dskiobuf *dp;

{
	/* get drive's own buf header */
	ownbuf[dp->b_dev] = geteblk();
	ownbuf[dp->b_dev]->b_dev = dp->b_dev << 4;
	ownbuf[dp->b_dev]->b_proc = 0;

	/* clear flags */
	sdk_rel_buf(dp->b_dev);

	/* get command mailboxes */
	if (!(dp->cm[0] = scsi_get_cmd(dp->b_dev)))
		return 0;
	if (!(dp->cm[1] = scsi_get_cmd(dp->b_dev))) {
		if (scsi_put_cmd(dp->cm[0]) == 0)
			ASSERT(0);
		return 0;
	}
	return 1;
}

static sdk_dealloc(dp)
register struct dskiobuf *dp;

{
	ASSERT(ownbuf[dp->b_dev]);
	brelse(ownbuf[dp->b_dev]);
	ownbuf[dp->b_dev] = NULL;
	/* get command mailboxes */
	if(scsi_put_cmd(dp->cm[0])== 0)
		ASSERT(0);
	if(scsi_put_cmd(dp->cm[1]) == 0)
		ASSERT(0);
	dp->cm[0] = dp->cm[1] = NULL;
	dp->b_flags &= ~B_ALLOC;
}
static sdk_device_init(dp)
struct dskiobuf *dp;
{
	register unchar unit_id = dp->b_dev;
	DCFG	*dcfg = &dp->cfg;
	struct	inquiry_data *inqp;


	dp->sar = get_iotime(unit_id);
	if(!sdkcommand(unit_id, CDB_INQUIRY, sizeof(struct inquiry_data))){
		dp->sar = NULL;
		return(0);	 
	}
	inqp = (struct inquiry_data *)ownbuf[unit_id]->b_un.b_addr;
	/* check device type */
	if((dcfg->dev_type = inqp->dev_type) != DA_DEV){
			DISPLAY_DRV_ID(unit_id);
			printf("%s\n", "device type error"); /* display error message */
			dp->sar = NULL;
			return(0);	 
	}

	if (inqp->dev_qual & QUAL_RMB)
		dp->b_flags |= B_RMB;	/* setup removalbe media drive */	

	if( sdkcmp(inqp->vdr_id,"IBM",3) )
		dp->b_flags |= B_IBM;

	if ( sdkcmp(inqp->vdr_id, "Ten X", 5))
		dp->b_flags |= B_TNX;

	if ( sdkcmp(inqp->prod_id, "RO-5030E", 8))
		dp->b_flags |= B_ODD;

	if ( sdkcmp(inqp->prod_id, "SPECIAL", 7))
		dp->b_flags |= B_ODD;


	if (dp->b_flags & B_RMB)
		sdk_spin_drv(dp);

	if(!set_err_recover_page(dp))
		return(0);

	dp->b_flags |= B_NEWMDM;
	dp->b_flags |= B_ONCE;
	return(1);
} /*  end of sdk_device_init */

static sdk_media_init(dp)
struct dskiobuf *dp;
{
	unchar pg_flag;
	unchar unit_id = dp->b_dev;


	if (!sdk_spin_drv(dp))
		return(0);
	/* check if drive is ready */
	if(!sdkcommand(unit_id, CDB_TEST_UNIT_READY, 0)) {
		if (!(dp->b_flags & B_NEWMDM))
			return(0);
	}

	if (dp->pg1_len != 0) {
		if (dp->b_flags & B_ODD)
			pg_flag = M_PF;
		else
			pg_flag  = (M_PF | PG_SP);
		bcopy(dp->pg1, ownbuf[unit_id]->b_un.b_addr, dp->pg1_len);
		if(!sdkcommand(unit_id, CAT2(pg_flag,CDB_MODE_SELECT), 
			dp->pg1_len))
			return(0);
	}
	
	dp->b_flags &= ~B_NEWMDM;
	
	if (!check_write_protect(dp) )
		return(0);
	
	/* setup device configuration table */
	if( !initdrv(dp) )
		return(0);

	return(1);
} /*  end of sdk_media_init */

static
check_write_protect(dp)
struct dskiobuf *dp;
{
	struct mode_head *sd;
	
	if (!sdkcommand(dp->b_dev,CAT2( (PAGE01 | CURRENT), CDB_MODE_SENSE),
		MODEHEAD_LEN))
		return(0);

	sd = (struct mode_head *)ownbuf[dp->b_dev]->b_un.b_addr;

	if ( sd->wp_bm_speed & WP)
		dp->b_flags |= B_WP;
	else
		dp->b_flags &= ~B_WP;
	return(1);
}
	
static sdk_spin_drv(dp)
struct dskiobuf *dp;
{
	unchar unit_id = dp->b_dev;
	if (dp->b_flags & B_LOCKED)
		return(1);
	if (!(dp->b_flags & B_RMB)) {
		/* to eliminate UNIT ATTENTION condition */
		if(!sdkcommand(unit_id, CDB_REQUEST_SENSE, SENSE_DATA_SIZE))
			return(0);	 
		else
			return(1);
	}
	/* spin up drive */
	dp->b_flags |= B_NO_ERR_NEWMDIA;
	if (!sdkcommand(unit_id, CAT2(SPIN_UP, CDB_START_STOP), 0)) {
		if (!(dp->b_flags & B_NEWMDM)) {
			dp->b_flags &= ~B_NO_ERR_NEWMDIA;
			sdk_unlock_drv(dp);
			return(0);
		}
	}
	dp->b_flags &= ~B_NO_ERR_NEWMDIA;
	dp->b_flags &= ~B_NEWMDM;

	/* to eliminate UNIT ATTENTION condition */
	if(!sdkcommand(unit_id, CDB_REQUEST_SENSE, SENSE_DATA_SIZE))
		return(0);	 
	if (!sdkcommand(unit_id, CAT2( PREVENT, CDB_MEDIUM_REMOVAL), 0)) {
		if (!(dp->b_flags & B_NEWMDM)) {
			sdk_unlock_drv(dp);
			return(0);
		}
		else { /* resend command again */
			dp->b_flags &= ~B_NEWMDM;
			if (!sdkcommand(unit_id, 
				CAT2(PREVENT, CDB_MEDIUM_REMOVAL) , 0)) {
				sdk_unlock_drv(dp);
				return(0);
			}
		}
	}
	dp->b_flags &= ~B_NEWMDM;
	dp->b_flags |= B_LOCKED;
	return(1);
}

static sdk_unlock_drv(dp)
struct dskiobuf *dp;
{
	unchar unit_id = dp->b_dev;
	if (dp->b_flags & B_RMB)
		/* unlock media */
		sdkcommand(unit_id, CAT2(ALLOW,CDB_MEDIUM_REMOVAL) , 0);
	dp->b_flags &= ~B_LOCKED;
}
is_scsi_edt(s0)
struct edt_sector0 *s0;
{
	if ( (*((int *)&s0->id[0]) != (int)'INIT') ||
		(s0->pd_ldmaxnum > LOGDR) ||
		(s0->pd_ldnum > LOGDR) ) 
		return(0);
	else
		return(1);
}

sdkcmp(s,d,l)
unchar	*s,*d;
{
	int i;
	for(i = 0;i<l;i++){
		if(*s++ != *d++) 
			return(0);
	}
	return(1);
}

/* initdrv -- initialize scsi disk table.
	setup configuration table.
	initialize slice table.
*/
initdrv(dp)
struct dskiobuf	*dp;
{
	struct sdk_block_0 *s0;
	struct capacity *ca;

	/* get block size and total number of blocks */

       	if(!sdkcommand(dp->b_dev,CAT2( 0, CDB_READ_CAPACITY), BSIZE))
		return(0);

	ca = (struct capacity *)ownbuf[dp->b_dev]->b_un.b_addr;

	dp->cfg.blk_len = CAT4(ca->bl_msb, ca->bl_2, ca->bl_1, ca->bl_lsb);
	dp->cfg.lst_blkno = CAT4(ca->lba_msb, ca->lba_2, ca->lba_1, ca->lba_lsb);

	dp->cfg.blk_ratio = BSIZE/dp->cfg.blk_len; 

	/* read config block */
       	if(!sdkcommand(dp->b_dev,CAT2( CONFIG_BLOCK, CDB_READ) , BSIZE)) {
			DISPLAY_DRV_ID(dp->b_dev);
			printf("%s\n", "device is not formatted"); /* display error message */
			return(0);
	}
	/* check if disk has been formated ? */	
	s0 = (struct sdk_block_0 *)ownbuf[dp->b_dev]->b_un.b_addr;

	if(is_scsi_edt(s0)){
		set_edt_disk_table(s0,dp);
		dp->b_flags |= B_EDT;
	}
	else {
		if(is_iopm_disk(s0))
			if(is_old_disk(s0)){
				if(!set_old_disk_table(s0,dp))
					return(0);
				dp->b_flags |= B_OLD;
			}
			else
				set_new_disk_table(s0,dp);
		else {
			DISPLAY_DRV_ID(dp->b_dev);
			printf("%s\n", "device is not formatted"); /* display error message */
			return(0);
		}
	}
	return(1);
}

is_iopm_disk(s0)
struct sdk_block_0	*s0;
{
	return(sdkcmp(s0->misc.disk_info.vol_id,"IOPMSCSI",8));
}

is_old_disk(s0)
struct sdk_block_0	*s0;
{
	return(s0->misc.disk_info.date < VERSION_DATE );
}

set_edt_disk_table(s0,dp)
struct edt_sector0 *s0;
struct dskiobuf *dp;
{
	int i;
	register SLSIZE *ld;

	dp->cfg.heads = s0->headcyl;
	dp->cfg.cylns = s0->cyldisk;
	dp->cfg.bps = s0->bytesec;


	for(i = 0, ld = dp->cfg.logdrv; i < MAXSLICE; i++, ld++){
		ld->type = LD_UNIX_SLICE;
		ld->offset = s0->logdrive[i].ld_strt;
		ld->noblk = s0->logdrive[i].ld_size;
	}
		
	for(i = 0, ld = dp->cfg.logdrv; i < MAXSLICE; i++,ld++) {
		if( ld->noblk != 0) {
			ld->spt = sdk_get_spt(dp, ld->offset);
		}
		else 
			ld->spt = 0;
	}
	return(1);
}

set_old_disk_table(s0,dp)
SECTOR0 *s0;
struct dskiobuf	*dp;
{
	int i;
	

	for(i = 0;i <MAXSLICE;i++){
		if(s0->sltable[i].noblk == 0)
			continue;
		dp->cfg.logdrv[i].type = LD_UNIX_SLICE;
		dp->cfg.logdrv[i].offset = s0->sltable[i].offset + s0->phyblkno;
		dp->cfg.logdrv[i].noblk = s0->sltable[i].noblk;
	}
	if(!set_device_table(dp))
		return(0);
	for(i = 0; i < MAXSLICE; i++) {
		if( dp->cfg.logdrv[i].noblk != 0) {
			dp->cfg.logdrv[i].spt = sdk_get_spt(dp, 
					dp->cfg.logdrv[i].offset);
		}
		else 
			dp->cfg.logdrv[i].spt = 0;
	}
	return(1);
	
}

set_new_disk_table(s0,dp)
struct sdk_block_0 *s0;
struct dskiobuf	*dp;
{
	int i;

	dp->cfg.heads = s0->misc.disk_info.heads;
	dp->cfg.cylns = s0->misc.disk_info.cylns;
	dp->cfg.bps = s0->misc.disk_info.bps;

	for(i = 0; i < 16; i++){
		dp->cfg.logdrv[i].type = s0->slice_table[i].ldrv.ld_type;
		dp->cfg.logdrv[i].spt = s0->slice_table[i].ldrv.ld_spt;
		dp->cfg.logdrv[i].offset = s0->slice_table[i].ldrv.ld_strt;
		dp->cfg.logdrv[i].noblk = s0->slice_table[i].ldrv.ld_size;
	}

}


static	
sdk_set_optype (dp, sl, flag, type)
struct dskiobuf *dp;
int sl, flag, type;
{
	if ((dp->b_flags & B_WP) && (flag & FWRITE)) {
		DISPLAY_DRV_ID(dp->b_dev);
		printf("%s\n","Device is write protect!");
		return(EACCES);
	}

	if ((flag & FWRITE) && (dp->ot_flg[sl] & OFLG_MIR))
		return (EBUSY);

	switch (type) {
	case OTYP_BLK:
		if ((flag & FWRITE) && (dp->ot_flg[sl] & OFLG_SWP))
			return(EBUSY);
		else 
			sdk_opflg_set(dp, sl, OFLG_BLK);
		break;
	case OTYP_MNT:
		if (dp->ot_flg[sl] & (OFLG_BLK | OFLG_CHR | OFLG_SWP | OFLG_MNT
			))
			return(EBUSY);
		else
			sdk_opflg_set(dp, sl, OFLG_MNT);
		break;
	case OTYP_CHR:
		if ((flag & FWRITE) && (dp->ot_flg[sl] & (OFLG_SWP | OFLG_MNT)
			))
			return(EBUSY);
		else
			sdk_opflg_set(dp, sl, OFLG_CHR);
		break;
	case OTYP_SWP:
		if (dp->ot_flg[sl] & (OFLG_BLK | OFLG_CHR | OFLG_SWP | 
			OFLG_MNT))
			return(EBUSY);
		else
			sdk_opflg_set(dp, sl, OFLG_SWP);
		break;

	case OTYP_MIR:
		if (dp->ot_flg[sl] & (OFLG_BLK | OFLG_CHR | OFLG_MNT |
			OFLG_SWP | OFLG_MIR))
			 return(EBUSY);
		else
			sdk_opflg_set(dp, sl, OFLG_MIR);
		break;

	case OTYP_LYR:
		dp->open_cnt++;
		break;
	}
	return (0);
}

	
static
sdk_opflg_set(dp, sl, flag)
struct 	dskiobuf	*dp;
int	sl, flag;
{
	if (!(dp->ot_flg[sl] & flag)) {
		dp->ot_flg[sl] |= flag;
		dp->open_cnt++;
	}
}
		
/* set_device_table -- setup disk drive configuration table. */

set_device_table(dp)
struct dskiobuf   *dp;	
{
	
	/* get local buffer */
	LOG_LONG_WORD(LOG_DSK|LOG_SETMD, 0, dp, RBEGIN);

	if((is_IBM_disk(dp)) || (dp->b_flags & B_ODD)){
		if( !set_IBM_table(dp))
			return(0);
	}
	else {
		if( !set_normal_table(dp))
			return(0);
	}

	LOG_LONG_WORD(LOG_DSK|LOG_SETMD, 0, dp, REND);
	return(1);
}

static set_normal_table(dp)
struct dskiobuf   *dp;	
{
	register DCFG	*dcfg = &dp->cfg;

	struct	mode_head *sd; /* send data ptr */
	struct  blk_dscptr *bdcp;	/* block descriptor	*/
 	register struct	page_hd	*ph;	/* page header ptr	*/
	register struct	page_03	*p3;	/* page 03 ptr	*/
	register struct	page_04	*p4;	/* page 04 ptr	*/		
	unchar *desp;
	register int 	len_cnt;

	if(!sdkcommand(dp->b_dev,CAT2((PAGEALL | CURRENT) ,CDB_MODE_SENSE) ,
		200))
  		return(0);

	sd = (struct mode_head *)ownbuf[dp->b_dev]->b_un.b_addr;
	len_cnt = sd->sd_len+1;	 	/* init length count */
	dcfg->wp = sd->wp_bm_speed;		/* get write protection bit */	
	len_cnt -= MODEHEAD_LEN;

	ASSERT(sd->dscptr_len > 0);

	bdcp = (struct 	blk_dscptr *)(sd+1);
	dcfg->blk_len = 0;
	dcfg->blk_len = CAT3(bdcp->blk_len_msb, bdcp->blk_len, bdcp->blk_len_lsb);
	dcfg->blk_ratio = BSIZE/dcfg->blk_len; /* system block size :
						 drive block size */
	len_cnt -= sd->dscptr_len;	

	ph = (struct page_hd *)((uint)bdcp+sd->dscptr_len);
	while(len_cnt > 0){ 
		switch(ph->code & 0x3F){
		case PAGE03:
			p3 = (struct page_03 *)((uint)ph+PGHD_LEN);
			dcfg->bps = CAT2(p3->bps_msb, p3->bps_lsb);
			break;
		case PAGE04:
			p4 = (struct page_04 *)((uint)ph+PGHD_LEN);
			dcfg->cylns = CAT3(p4->cylns_msb, p4->cylns, p4->cylns_lsb);
			dcfg->heads = p4->heads;
			break;
		default:
			break;	/* skip this page */
		}
		/* bump to next page	*/
		len_cnt -=PGHD_LEN;
		len_cnt -=ph->len;
		ph = (struct page_hd *)((uint)ph+PGHD_LEN+ph->len);
	}
	return(1);

} /* end of set_normal_table  */

static set_IBM_table(dp)
struct dskiobuf *dp;
{
	struct capacity	*ca;
	register DCFG	*dcfg = &dp->cfg;

	if(!sdkcommand(dp->b_dev, CDB_READ_CAPACITY, CA_DATA_SIZE))
		return(0);
	ca = (struct capacity *)ownbuf[dp->b_dev]->b_un.b_addr;
	dcfg->blk_len = 0;
	dcfg->blk_len = CAT4(ca->bl_msb, ca->bl_2, ca->bl_1, ca->bl_lsb);

	dcfg->blk_ratio = BSIZE/dcfg->blk_len; /* system block size :
						  drive block size */
	if (dp->b_flags & B_ODD) {
		dcfg->bps = 0x400;
		dcfg->cylns = 18553;
		dcfg->heads = 1;
	}
	else {
		dcfg->bps = IBM_BPS;
		dcfg->cylns = IBM_CYLNS;
		dcfg->heads = IBM_HEADS;
	}
	return(1);
}
#define	MAXMS_P1 PGHD_LEN + DSCPTR_LEN + MODEHEAD_LEN + sizeof (struct page_01)

set_err_recover_page(dp)
struct dskiobuf *dp;
{
	int page_len,  byte_remain;
	unchar	cbuf[MAXMS_P1];
	unchar	dbuf[MAXMS_P1];
	struct mode_head  *cptr, *dptr;
	register  struct blk_dscptr *cbdp, *dbdp;
	register  struct page_hd   *cph, *dph;
	register  struct page_01  *cp1p, *dp1p;
	struct	g0_cdb *cdb;
	register  unchar *x,*y; 


	if (!sdkcommand(dp->b_dev,CAT2((PAGE01|CHANGE),CDB_MODE_SENSE),
		MAXMS_P1))
		return(0);
	bcopy(ownbuf[dp->b_dev]->b_un.b_addr, cbuf, MAXMS_P1);

	cptr = (struct mode_head *)cbuf;
	cbdp =(struct blk_dscptr *)((uint)cptr+MODEHEAD_LEN);
	cph = (struct page_hd *)((uint)cbdp+cptr->dscptr_len);
	cp1p = (struct page_01 *)((uint)cph+PGHD_LEN);
	if (cptr->sd_len <= (MODEHEAD_LEN+cptr->dscptr_len + PGHD_LEN -1)){
		dp->pg1_len = 0;
		return(1);
	}
	/* read default value */

	if (!sdkcommand(dp->b_dev,CAT2( (PAGE01 | CURRENT), CDB_MODE_SENSE),
		MAXMS_P1))
		return(0);
	bcopy(ownbuf[dp->b_dev]->b_un.b_addr, dbuf, MAXMS_P1);
	dptr = (struct mode_head *)dbuf;

	dbdp =(struct blk_dscptr *)((uint)dptr+MODEHEAD_LEN);
	dph = (struct page_hd *)((uint)dbdp+dptr->dscptr_len);
	dp1p = (struct page_01 *)((uint)dph+PGHD_LEN);

	page_len = dph->len;
	byte_remain = page_len;	
	if (dp->b_flags & B_ODD)
		dp1p->err_flags = (AWRE | ARRE | EEC);
	else
		dp1p->err_flags = cp1p->err_flags & (AWRE | EEC); /* set default value */
	if (--byte_remain == 0)
		goto setpg1;

	dp1p->retry_cnt = (10 & cp1p->retry_cnt);

	if (--byte_remain == 0)
		goto setpg1;
		

	 /* use drive default value or don't changed */	
/* REE - this screws up severely
	 for (x = (unchar *)&dp1p->correction, y = (unchar *)&cp1p->correction; 
			byte_remain != 0; byte_remain--, x++, y++)
		*x &= *y;
END REE */
	if (dp->b_flags & B_ODD) {
		dp1p->rsv2 = 0;
		dp1p->rsv3 = dp1p->rsv4 = 0xFF;
	}
setpg1:
	dptr->sd_len = 0;	
	dptr->dscptr_len = 0;

	dph->code = PAGE01;

/* REE */
	dptr->wp_bm_speed=0x0;

	bcopy(dptr, dp->pg1, MODEHEAD_LEN);
	bcopy(dph, (uint)(dp->pg1)+4, page_len + PGHD_LEN);
	dp->pg1_len = page_len + PGHD_LEN + MODEHEAD_LEN;

	/* config mode select command box */
	bzero(&dp->ms_cm, sizeof (CMD_BOX));
	dp->ms_cm.cmd_dsc_len = sizeof (struct g0_cdb);
	cdb =(struct g0_cdb *)dp->ms_cm.cmd_dsc_blk;
	cdb->opcode = CDB_MODE_SELECT;
	cdb->lun_flags = M_PF;
	cdb->alloc_len = dp->pg1_len;
	dp->ms_cm.unit_id = dp->b_dev;
	dp->ms_cm.timer = MODE_TIMER;
	dp->ms_cm.dma_proc = 0;
	dp->ms_cm.cmd_type = CMD_RELEASE_ATTN;
	dp->ms_cm.dma_buffer = dp->pg1;
	dp->ms_cm.dma_buf_len = dp->pg1_len;
	dp->ms_cm.dma_flags = 0;	/* dma write */
	dp->ms_cm.tag = 0;
	dp->ms_cm.service = reset_done;
	dp->ms_cm.retry_cnt = 0;
	return(1);
}
