/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sdk_ioctl.c: version 25.1 created on 11/27/91 at 14:42:31	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sdk_ioctl.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* sdk_ioctl -- IOPM scsi driver to handle ioctl */

#include "sys/types.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/errno.h"
#include "sys/elog.h"
#include "sys/file.h"
#include "sys/debug.h"

#include "sys/user.h"
#include "sys/buf.h"
#include "sys/ioctl.h"

#include "scsi_log.h"
#include "hlvl_macro.h"
#include "sdk_cdb.h"
#include "sdkioctl.h"
#include "sdkcfg.h"
#include "scsi_cmdbx.h"
#include "sdk.h"
#include "sdk_disk.h"

extern struct buf *ownbuf[];
extern struct dskiobuf devtbl[];


/* sdkioctl --  includes following spacial functions:

   SDK_GETSLICE  	get slice table
   GET_DISK_SIZE 	get the size of certain slice
   GET_CYLINDER_SIZE 	get the number of blocks per cylinder
   GET_INTERLACE 	get driver suggest interlace number 
   GET_TRACK_SIZE 	get number of blocks per track 
   GET_LOG_TYPE		FIX, new ioctl code used for mkfs
   GET_DEV_TYPE 	
   SDK_READ_VTOC	read configuration block (1024 bytes)
   GET_OPEN_TYPES	get open type flags

   input:
	dev		minor device number
	cmd		ioctl function code
	arg		pointer to parameters listing
	mode		Mode that device is open with(e.q FWRITE,FREAD etc.,).
*/
	
unchar altbuf[BSIZE];

sdkioctl(dev,cmd,arg,mode)
ushort	dev;
uint	cmd;
unchar	*arg;
uint	mode;

{
	unchar	unit_id = UNIT(dev);
	unchar	sno = SLICE(dev);
	struct dskiobuf	*dp = GETDP(unit_id);
	DCFG	*dcfg = &dp->cfg;
	int	x;

	log(LOG_DSK|LOG_IOCTL, unit_id, cmd, RBEGIN);
	LOG_LONG_WORD(LOG_PR, 0, arg, 0);

	u.u_error = 0; 	/* clear error flag	*/
	switch(cmd){
		case SDK_GETSLICE:
			/* copy slice table to user area */
			sdk_lock_buf(unit_id);
			if (!sdk_get_slice(dp,arg))
				u.u_error = EIO;
			sdk_rel_buf(unit_id);
			break;

		case GET_DISK_SIZE:  /* number of blocks for logic device */
			
			u.u_rval1 = dcfg->logdrv[sno].noblk;
			break;

		case GET_CYLINDER_SIZE:  /* number of blocks per cylinder */
			u.u_rval1 = (dcfg->logdrv[sno].spt * dcfg->heads) /
				    (BSIZE / dcfg->bps); 
			break;

		case GET_INTERLACE: 
			u.u_rval1 = 1;
			break;

		case GET_TRACK_SIZE:  /* number of blocks per track */
			u.u_rval1 = dcfg->logdrv[sno].spt /
				    (BSIZE / dcfg->bps); 
			break;

		case GET_DEV_TYPE:
			u.u_rval1 = SCSI_TYPE;
			break;
			
		case GET_LOG_TYPE:

			u.u_rval1 = dcfg->logdrv[sno].type;
			return (u.u_rval1);
			break;
			
		case SDK_READ_VTOC:
			sdk_lock_buf(unit_id);
       			if(!sdkcommand(unit_id,CAT2( CONFIG_BLOCK, CDB_READ) , 
				BSIZE)) {
				DISPLAY_DRV_ID(unit_id);
				printf("%s\n", "device is not formatted");
				u.u_error = EIO;
				sdk_rel_buf(unit_id);
				return;
			}
			copyout(ownbuf[unit_id]->b_un.b_addr, arg, BSIZE);
			sdk_rel_buf(unit_id);
			break;

		case GET_OPEN_TYPES:
			u.u_rval1 = dp->ot_flg[sno];
			break;

/* TWU internal testing use for getting disk queue elements */
		case GET_QUEUE:
		    {
			int s, cnt;
			char *addr;
			buf_t *ap;
			int	null = 0;

			s = splhlv();
			cnt = min(dp->qcnt, 10);
			for (addr = (char *)arg, ap = dp->b_actf; cnt; 
				ap = ap->av_forw,cnt--) {
			   copyout(&ap->b_sblock,  addr, 4);
			   addr += 4;
			}
			copyout(&null, addr, 4);
			splx(s);
			break;
		     }
			
		default: 
			u.u_error = EINVAL;
			break;
	}
	log(LOG_DSK|LOG_IOCTL, unit_id, cmd, REND);
	LOG_LONG_WORD(LOG_PR, u.u_error, arg, 0);
} /* end of sdkioctl */

/* get next cylinder starting block number */

STATIC uint
sdk_nice_blkno(dp, blkno)
struct dskiobuf *dp;
uint	blkno;
{
	uint nice_blkno;

	if((nice_blkno = cyln_last_block(dp, blkno)) == 0)
		return (0);
	else
		return (nice_blkno++);
}

/* get last block number on same cylndr */
STATIC 
cyln_last_block(dp, blkno)
struct dskiobuf *dp;
uint	blkno;
{
	uint last_cyln_blk;
	struct capacity *ca;

	blkno *= dp->cfg.blk_ratio;
	if(!sdkcommand(dp->b_dev, ((blkno << 8) | CDB_READ_CAPACITY), CA_DATA_SIZE))
		return(0);

	ca = (struct capacity *)ownbuf[dp->b_dev]->b_un.b_addr;
	last_cyln_blk = CAT4(ca->lba_msb, ca->lba_2, ca->lba_1, ca->lba_lsb);
	return(last_cyln_blk/dp->cfg.blk_ratio);
}

sdk_get_spt(dp, blkno)
struct dskiobuf *dp;
int	blkno;
{
	int  tot_blks, cur_cyln_lastblk, cur_cyln_first_blk,
		prev_cyln_lastblk, prev_blkno;
	
	if((cur_cyln_lastblk = cyln_last_block(dp,blkno)) == 0)
		return(0);

	prev_blkno = blkno;

	/* trying to get previous cylnder's last block */
	do {
		if((prev_blkno -= 100) <= 0)
			prev_blkno = 1;	
		if ((prev_cyln_lastblk = cyln_last_block(dp, prev_blkno)) == 0)
			return(0);
	} while ( prev_blkno != 1 && prev_cyln_lastblk == cur_cyln_lastblk);

	/* At this point, we found the different cylnder last blocks */
	/* and we are trying to get exact previous cylinder's last block */

	while (prev_cyln_lastblk != cur_cyln_lastblk) {
		prev_blkno = prev_cyln_lastblk + 1;
		if((prev_cyln_lastblk = cyln_last_block(dp, prev_blkno)) == 0)
			return(0);
	}	

	if(prev_blkno == 1)
		cur_cyln_first_blk = 0;
	else 
		cur_cyln_first_blk = prev_blkno;
	/* caculate total number of blocks in this cylinder */
	tot_blks = cur_cyln_lastblk - cur_cyln_first_blk + 1;
	return((tot_blks / dp->cfg.heads) * (dp->cfg.blk_len / dp->cfg.bps) );
}

STATIC
sdk_get_slice(dp,arg)
struct dskiobuf	*dp;
unchar	*arg;
{
	SLSIZE	*sl = (SLSIZE *)altbuf;
	struct sdk_block_0 *s0;
	int i;


	if (dp->b_flags & B_EDT || dp->b_flags & B_OLD){
		copyout(dp->cfg.logdrv,arg,sizeof(SLSIZE)*MAX_UNIX_SLICES);
		return(1);
	}
	if(!sdkcommand(dp->b_dev, CAT2(CONFIG_BLOCK ,CDB_READ), BSIZE))
		return(0);
	s0 = (struct sdk_block_0 *)ownbuf[dp->b_dev]->b_un.b_addr;

	for ( i = 0; i < MAX_IOPM_SLICES ; i++, sl++) {
		sl->type = s0->slice_table[i].ldrv.ld_type;
		sl->spt	= s0->slice_table[i].ldrv.ld_spt;
		sl->offset = s0->slice_table[i].ldrv.ld_strt;
		sl->noblk = s0->slice_table[i].ldrv.ld_size;
	}

	copyout(altbuf, arg, sizeof(SLSIZE)*MAX_IOPM_SLICES);
	return(1);
} /* end of sdk_get_slice */
	
