/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sdk_intr.c: version 25.1 created on 11/27/91 at 14:42:27	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sdk_intr.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* scsi_intr.c -- iopm's disk driver interrupt service routine */

#include "sys/types.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/errno.h"
#include "sys/elog.h"
#include "sys/file.h"
#include "sys/debug.h"

#include "sys/buf.h"

#include "scsi_log.h"
#include "scsi_error.h"
#include "hlvl_macro.h"
#include "sdk_cdb.h"
#include "sdkioctl.h"
#include "sdkcfg.h"
#include "scsi_cmdbx.h"
#include "sdk.h"

extern struct dskiobuf devtbl[];
extern struct buf *ownbuf[];
extern get_time_stamp();
extern scsi_send_cmd();

char *get_add_sense_msg();


/* sdk_intr -- disk interrupt service routine	*/
void
sdk_intr(cm)
CMD_BOX	*cm;
{
	struct buf *bp;
	struct dskiobuf	*dp;
	unchar	unit_id;
	uint	retry = 0;
	
	LOG_LONG_WORD(LOG_DSK|LOG_INT, 0, cm, RBEGIN);

	bp = (struct buf *)cm->tag;
	unit_id =UNIT(bp->b_dev);
	dp = GETDP(unit_id);

	/* set statistic information	*/
	bp->b_flags &= ~B_ERROR;

	if(cm->err_code)
		retry = sdk_errsetup(dp, bp, cm);	

	if (!retry) {
		bp->b_resid += cm->dma_resid;
		if ( bp != ownbuf[dp->b_dev]) {
			dp->sar->io_resp += (get_time_stamp() - bp->b_start);
			dp->sar->io_act += cm->act;
			dp->sar->io_bcnt += 
				((bp->b_bcount - bp->b_resid)>>BLK_SHIFT);
		}
		/* delete bp from sorting queue if it necessary */
		sdkdeque(dp);
		iodone(bp);
		if ( cm == dp->cm[0])
			dp->b_outcnt &= ~CMB0_IN_USED; /* turn off used bit */
		else
			dp->b_outcnt &= ~CMB1_IN_USED;	
		sdkstart(dp);	/* go get next command to excute	*/
	}
	LOG_LONG_WORD(LOG_DSK|LOG_INT, 0, bp, REND);
} /* sdk_intr */

/* sdk_errsetup -- setup real error code and display error message */
sdk_errsetup(dp, bp,cm)
struct dskiobuf	*dp;
struct buf *bp;
CMD_BOX *cm;
{
	int  revalue, retry;
	
	/* check if error come from drive itself */
	LOG_LONG_WORD(LOG_DSK|LOG_HERR, 0, bp, RBEGIN);
	LOG_LONG_WORD(LOG_PR, 0, cm, 0);

	if ( cm->err_code == SCSIERR_SENSE) {
		if((retry = set_sense_error(dp, cm)) == 1) {
			bp->b_flags &= ~B_ERROR;
			revalue = 1;
		}
		else {
			if (cm->error[2] != SNSKEY_NO_SENSE) {
				bp->b_flags |= B_ERROR;
				bp->b_error = EIO;
			}
			revalue = 0;
		}
	}
	else {
		if((retry = set_scsi_err(dp, cm)) == 1) {
			bp->b_flags &= ~B_ERROR;
			revalue = 1;
		}	
		else {
			bp->b_flags |= B_ERROR;
			bp->b_error = EIO;
			revalue = 0;
		}

	}
	LOG_LONG_WORD(LOG_DSK|LOG_ERR,revalue, bp, REND);
	LOG_LONG_WORD(LOG_PR, 0, cm, 0);
	return(revalue);
}

STATIC
set_sense_error(dp, cm)
struct dskiobuf	*dp;
CMD_BOX *cm;
{
	EX_SENSE_DATA *sd;
	unchar	sense_key;

	sd = (EX_SENSE_DATA *)cm->error;
	
	if ((sd ->err_class & ERR_CLASS_MASK) != ANSI_CLASS ) {
		DISPLAY_DRV_ID(cm->unit_id);
		printf( " vendor unique error\n");
	}
	else {
		if ((sense_key = sd->sense_key & SENSE_KEY) == SNSKEY_UNIT_ATTN)
		{
			if (sd->err_code  == ASNS_MDMCHNG ) {
				dp->b_flags |= B_NEWMDM;
				if (dp->b_flags & B_NO_ERR_NEWMDIA)
					return(0);
			}
			else {
				if (dp->pg1_len != 0)
					set_page_01(dp, cm);
				else {
					cm->cmd_type = CMD_RELEASE_ATTN;
					sdk_retry_cmd(cm);
				}
				return(1);
			}
		}
		if (sense_key == SNSKEY_BLANK_CHECK) {
			zero_out(dp,cm);
			if (cm->dma_resid == 0) {
				sd->sense_key = SNSKEY_NO_SENSE;
				return(0);
			}
			else {
				read_remain(dp, cm);
				return(1);
			}
		}
		if (sense_key == SNSKEY_RECOVERED_ERR && cm->dma_resid == 0) {
				sd->sense_key = SNSKEY_NO_SENSE;
				return(0);
		}
		DISPLAY_DRV_ID(cm->unit_id);
		printf("%s", scsi_sns_msg(sense_key)); /* display error message */
		printf(".\n");
		display_sense_detail(sd);
	}
	return(0);
}

STATIC
set_scsi_err(dp, cm)
struct dskiobuf	*dp;
CMD_BOX *cm;
{

 	if (!sdk_err_retry(cm)) {
		DISPLAY_DRV_ID(cm->unit_id);
		printf("%s", scsi_err_msg(cm->err_code)); /* display error message */
		printf(".\n");
		return(0);
	}
	else 	
		return(1);
}
	
static
display_sense_detail(sense_data)
EX_SENSE_DATA *sense_data;
{
	int xlen;

	printf("request sense data:\n");
	printf("\tsense key: %x\n",sense_data->sense_key);
	if (sense_data->err_class & INFO_VALID) {
		printf("\tinformation bytes:");
		printf("%x\n",CAT4(sense_data->info_msb, sense_data->info_2,
				sense_data->info_1, sense_data->info_lsb));
	}
	if ((xlen = sense_data->xsense_len) == 0)
		return;
	xlen -= 4;
	if (xlen <= 0)
		return;
	printf("\terror code: %x", sense_data->err_code);
	printf(" (%s)\n",get_add_sense_msg(sense_data->err_code));
	if (--xlen <= 0) 	/* skip reserved byte */
		return;
	if (--xlen <= 0) 	/* point to FRU code */
		return;
	printf("\tFRU field: %x\n",sense_data->frucode);
	if (--xlen <= 0)	/* point to flag	*/
		return;
	if (sense_data->flags & FPV) {
		printf("\tfield pointer:");
		printf("byte %x ", 
			CAT2(sense_data->field_hi, sense_data->field_lo));
		if (sense_data->flags & CDBIT)
			printf("in CDB field\n");
		else
			printf("in data field\n");
		if (sense_data->flags & BPV)
			printf ("\tbit pointer: %x\n", 
					(sense_data->flags & BIT_POINTER_MASK));
	}
}


STATIC sdk_retry_cmd(cm)
CMD_BOX	*cm;
{
	cm->cmd_flags = 0;
	bzero(cm->error, SENSE_DATA_SIZE); /* clear error buffer */
	scsi_send_cmd(cm);
}

STATIC
sdk_err_retry(cm)
CMD_BOX	*cm;
{
	struct dskiobuf	*dp;

	dp = GETDP(cm->unit_id);

	if(cm->err_code == 0)
		return(1);
	
	switch(cm->err_code){
	   case SCSIERR_ATN:
		if (dp->b_flags & B_NEWMDM) /* no retry when media changed */
			return(0);
		cm->cmd_type = CMD_RELEASE_ATTN;
		if (dp->b_flags & B_RESET) {
			dp->reset_q->next = cm;
			cm->next = NULL;
		} else 
			sdk_retry_cmd(cm);
		return(1);
		break;
	   case SCSIERR_BUSTIMEOUT:
	   case	SCSIERR_CMDTIMEOUT:
	   case SCSIERR_BUSRESET:
	   case SCSIERR_PARITY:
	   case SCSIERR_DISC:
		if ( cm->retry_cnt-- == 0) 
			return(0);
		else{
			sdk_retry_cmd(cm);
			return(1);
		}
		break;
	   default:
		return(0);
	}
}

static char *additional_sense[] = {
/* 0x00 */	"No Additional Sense Information",
/* 0x01 */	"No Index/Sector signal",
/* 0x02 */	"No Seek Complete",
/* 0x03 */	"Write Fault",
/* 0x04 */	"Drive Not Ready",
/* 0x05 */	"Drive Not Selected",
/* 0x06 */	"No Track Zero found",
/* 0x07 */	"Multiple Drives Selected",
/* 0x08 */	"Logical Unit Communication Failure",
/* 0x09 */	"Track Following error",
/* 0x0A */	"Reserved additional sense code",
/* 0x0B */	"Reserved additional sense code",
/* 0x0C */	"Reserved additional sense code",
/* 0x0D */	"Reserved additional sense code",
/* 0x0E */	"Reserved additional sense code",
/* 0x0F */	"Reserved additional sense code",
/* 0x10 */	"ID CRC or ECC error",
/* 0x11 */	"Unrecovered Read error of data blocks",
/* 0x12 */	"No Address Mark found in ID field",
/* 0x13 */	"No Address Mark found in Data field",
/* 0x14 */	"No record found",
/* 0x15 */	"Seek Positioning error",
/* 0x16 */	"Data Synchronization Mark error",
/* 0x17 */	"Recovered Read data with target's Read retries(not with ECC)",
/* 0x18 */	"Recovered Read data with target's ECC correction(not with retries",
/* 0x19 */	"Defect List error",
/* 0x1A */	"Parameter Overrun",
/* 0x1B */	"Synchronous Transfer error",
/* 0x1C */	"Primary Defect List not found",
/* 0x1D */	"Compare error",
/* 0x1E */	"Recovered ID with target's ECC correction",
/* 0x1F */	"Reserved additional sense code",
/* 0x20 */	"Invalid Command Operation Code",
/* 0x21 */	"Illegal Logical Block Address",
/* 0x22 */	"Illegal function for device type",
/* 0x23 */	"Reserved additional sense code",
/* 0x24 */	"Illegal field in CDB",
/* 0x25 */	"Invalid LUN",
/* 0x26 */	"Invalid field in Parameter List",
/* 0x27 */	"Write Protected",
/* 0x28 */	"Medium  Changed",
/* 0x29 */	"Power On or Reset or Bus Device Reset occured",
/* 0x2A */      "Mode Select Parameters changed",
/* 0x2B */	"Reserved additional sense code",
/* 0x2C */	"Reserved additional sense code",
/* 0x2D */	"Reserved additional sense code",
/* 0x2E */	"Reserved additional sense code",
/* 0x2F */	"Reserved additional sense code",
/* 0x30 */	"Incompatible Cartridge",
/* 0x31 */	"Medium Format corrupted",
/* 0x32 */	"No Defect Spare Location Available",
/* 0x33 */	"Reserved additional sense code",
/* 0x34 */	"Reserved additional sense code",
/* 0x35 */	"Reserved additional sense code",
/* 0x36 */	"Reserved additional sense code",
/* 0x37 */	"Reserved additional sense code",
/* 0x38 */	"Reserved additional sense code",
/* 0x39 */	"Reserved additional sense code",
/* 0x3A */	"Reserved additional sense code",
/* 0x3B */	"Reserved additional sense code",
/* 0x3C */	"Reserved additional sense code",
/* 0x3D */	"Reserved additional sense code",
/* 0x3E */	"Reserved additional sense code",
/* 0x3F */	"Reserved additional sense code",
/* 0x40 */	"RAM failure",
/* 0x41 */	"Data Path diagnostic failure",
/* 0x42 */	"Power On Diagnostic Failure",
/* 0x43 */	"Message Reject Error",
/* 0x44 */	"Internal Controller Error",
/* 0x45 */	"Select/Reselect failed",
/* 0x46 */	"Unsuccessful Soft Reset",
/* 0x47 */	"SCSI Interface Parity Error",
/* 0x48 */	"Initiator Detected Error",
/* 0x49 */	"Inappropriate/Illegal Message"
};

#define MIN_RESERVED	0x4A
#define	MAX_RESERVED	0x7F
#define MIN_VDR_UNIQ	0x80
#define MAX_VDR_UNIQ	0xFF
static char *
get_add_sense_msg(err_code)
unchar err_code;
{
	if ((err_code >= MIN_RESERVED ) && (err_code < MAX_RESERVED))
		return("Reserved additional sense code");
	if ((err_code >= MIN_VDR_UNIQ) && (err_code <= MAX_VDR_UNIQ))
		return("Vendor Unique");
	return(additional_sense[err_code]);
}
zero_out(dp, cm)
struct dskiobuf	*dp;
CMD_BOX	*cm;
{
	int  data_xfered, zero_len;
	unchar *vaddr, *blnk_addr;
	uint	x;
	
	data_xfered = cm->dma_buf_len - cm->dma_resid;
	blnk_addr = (unchar *)((uint)cm->dma_buffer + (uint)data_xfered);
	ASSERT(cm->dma_resid >= dp->cfg.blk_len);
	zero_len = dp->cfg.blk_len;
	x = vmap_save();
	while(zero_len--) {
		vaddr = (unchar *)vmap(blnk_addr,cm->dma_proc);
		*vaddr = 0;
		blnk_addr++;
	}
	vmap_restore(x);
	cm->dma_resid -=  dp->cfg.blk_len;
}

read_remain(dp, cm)
struct dskiobuf	*dp;
CMD_BOX	*cm;
{
	int xfer_noblks = cm->dma_resid /dp->cfg.blk_len; 
	uint blk_addr;
	struct g0_cdb *cdb0; 
	struct g1_cdb *cdb1;

	cdb0 = (struct g0_cdb *)cm->cmd_dsc_blk;
	ASSERT(cdb0->opcode == CDB_READ || cdb0->opcode == CDB_READ_EXTENDED);
	if (cdb0->opcode == CDB_READ) {
		blk_addr = CAT3(cdb0->lbaddr_msb, 
				cdb0->lbaddr, cdb0->lbaddr_lsb);
		blk_addr += (cdb0->xfer_len - xfer_noblks);
		ITOC3(cdb0->lbaddr_msb, cdb0->lbaddr, cdb0->lbaddr_lsb, 
				blk_addr);
		cdb0->xfer_len = xfer_noblks;
	}
	else {
		cdb1 = (struct g1_cdb *)cm->cmd_dsc_blk;
		blk_addr = CAT4(cdb1->lbadr_msb, 
				cdb1->lbadr_2, cdb1->lbadr_1, cdb1->lbadr_lsb);
		blk_addr += (cdb0->xfer_len - xfer_noblks);
		ITOC4(cdb1->lbadr_msb, cdb1->lbadr_2, cdb1->lbadr_1, 
			cdb1->lbadr_lsb, blk_addr);
		ITOC2(cdb1->xferlen_msb, cdb1->xferlen_lsb, xfer_noblks);
	}
	cm->dma_buffer += (cm->dma_buf_len - cm->dma_resid);
	cm->dma_buf_len = cm->dma_resid;
	cm->dma_resid = 0;
	scsi_send_cmd(cm);
}

set_page_01(dp,cm)
struct dskiobuf *dp;
CMD_BOX  *cm;
{
	dp->b_flags |= B_RESET;
	ASSERT(dp->reset_q == NULL);
	dp->reset_q = cm;	
	if ( dp->b_flags & B_TNX)
		timeout(scsi_send_cmd, &dp->ms_cm, 10*HZ);
	else
		scsi_send_cmd(&dp->ms_cm);
}

reset_done(cm)
CMD_BOX  *cm;
{
	struct dskiobuf	*dp;
	CMD_BOX	*next_cm, *wait_cm;
	buf_t	*bp;

	dp = GETDP(cm->unit_id);
	if (cm->err_code != 0) {
		DISPLAY_DRV_ID(cm->unit_id);
		printf("error happen in reset sequence\n");
		for (wait_cm = dp->reset_q; wait_cm != NULL;) {
			bp = (buf_t *)wait_cm->tag;
			bp->b_error = EIO;
			bp->b_flags |= B_ERROR; 
			bp->b_resid = 0;
			sdkdeque(dp);
			iodone(bp);
			if ( wait_cm == dp->cm[0])
				dp->b_outcnt &= ~CMB0_IN_USED;
			else
				dp->b_outcnt &= ~CMB1_IN_USED;	
			wait_cm = wait_cm->next;
		}
		dp->reset_q = NULL;
		dp->b_flags &= ~B_RESET;
		sdkstart(dp);
		return;
	}	
	else {
		next_cm = dp->reset_q->next;
		dp->reset_q->next = NULL;
		scsi_send_cmd(dp->reset_q);
		dp->reset_q = NULL;
		dp->b_flags &= ~B_RESET;
		if (next_cm)
			scsi_send_cmd(next_cm);	
		else 
			sdkstart(dp);
	}
}

static 
sdkdeque(dp)
struct dskiobuf	*dp;
{
	buf_t	*bp;

	if ((bp = dp->b_actf) == NULL)
		return;
	if ((dp->b_actf = bp->av_forw) == NULL) {
		dp->b_acts = NULL;
		dp->b_actl = NULL;
#ifdef C_SCAN
		dp->b_acte = NULL;
#endif /* C_SCAN */
	} else {
		if (dp->b_acts == bp)
			dp->b_acts = dp->b_actf;
#ifdef C_SCAN
		if (dp->b_acte == bp)
			dp->b_acte = dp->b_actf;
#endif /* C_SCAN */
	}
	dp->qcnt--;
	ASSERT(dp->qcnt != -1);
}
