/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) scsi_log.c: version 2.1 created on 4/17/90 at 14:00:22	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)scsi_log.c	2.1	4/17/90 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ifdef SCSI_LOG
#include "sys/types.h"

#define DSK		0	/* disk driver */
#define TPE		0	/* tape driver	*/
#define SDV		1	/* scsi driver	*/
#define HIN		0	/* high interrupt routine */
#define LIN		1	/* low interrupt routine	*/
#define TMO		1	/* timeout routine	*/
#define DMA		0	/* dma routines	*/
#define FSM		1	/* scsi finite state machine */
#define INI		1	/* scsi initiate */
#define IOP		1       /* iop/os */
#define XTP		0	/* xbyte tape */
#define PAR		0	/* parameters	*/
#define TMR		1	/* timer	*/

#define NUL		0	/* NOT used */

#define LOG_BUFFER_SIZE	1024*64

/* the next three variables are tight togather, don't change order or
insert anything between them */
uint log_b_boundary;
unchar log_table[LOG_BUFFER_SIZE];
uint log_e_boundary;

unchar *log_ptr,*log_end ;
int log_init = 0;
unchar log_index[] = {DSK,DSK,DSK,DSK,DSK,DSK,DSK,DSK,DSK,DSK,DSK,DSK,DSK,DSK,DSK,DSK,
		      TPE,TPE,TPE,TPE,TPE,TPE,TPE,TPE,TPE,TPE,TPE,TPE,TPE,TPE,TPE,TPE,
		      SDV,SDV,SDV,SDV,SDV,SDV,SDV,SDV,SDV,SDV,SDV,SDV,SDV,SDV,SDV,SDV,
		      HIN,HIN,HIN,HIN,HIN,HIN,HIN,HIN,HIN,HIN,HIN,HIN,HIN,HIN,HIN,HIN,
		      LIN,LIN,LIN,LIN,LIN,LIN,LIN,LIN,LIN,LIN,LIN,LIN,LIN,LIN,LIN,LIN,
		      TMO,TMO,TMO,TMO,TMO,TMO,TMO,TMO,TMO,TMO,TMO,TMO,TMO,TMO,TMO,TMO,
		      DMA,DMA,DMA,DMA,DMA,DMA,DMA,DMA,DMA,DMA,DMA,DMA,DMA,DMA,DMA,DMA,
		      FSM,FSM,FSM,FSM,FSM,FSM,FSM,FSM,FSM,FSM,FSM,FSM,FSM,FSM,FSM,FSM,
		      INI,INI,INI,INI,INI,INI,INI,INI,INI,INI,INI,INI,INI,INI,INI,INI,
		      IOP,IOP,IOP,IOP,IOP,IOP,IOP,IOP,IOP,IOP,IOP,IOP,IOP,IOP,IOP,IOP,
		      XTP,XTP,XTP,XTP,XTP,XTP,XTP,XTP,XTP,XTP,XTP,XTP,XTP,XTP,XTP,XTP,
		      TMR,TMR,TMR,TMR,TMR,TMR,TMR,TMR,TMR,TMR,TMR,TMR,TMR,TMR,TMR,TMR,
		      NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,
		      PAR,1,PAR,PAR,PAR,PAR,PAR,PAR,PAR,PAR,PAR,PAR,PAR,PAR,PAR,PAR,
		      NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,
		      NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL,NUL
};
log(a,b,c,d)
unchar a,b,c,d;
{
	int s;
	s = spldb();
	if(log_init == 0){
		log_ptr = log_table;
		log_end = &log_table[LOG_BUFFER_SIZE];
		log_init = 1;
		log_b_boundary = log_e_boundary = 0xFFFFFFFF;
	}
	if(log_index[a] == 0){
		splx(s);
	        return;
	}
	*log_ptr++ = a;
	*log_ptr++ = b;
	*log_ptr++ = c;
	*log_ptr++ = d;
	if(log_ptr >= log_end)
		log_ptr = log_table;
	splx(s);
}
#define LOG_TIMER_SIZE 1024*16

uint log0_b_boundary;
unchar log_0_table[LOG_TIMER_SIZE];
uint log0_e_boundary;

unchar *log_0_ptr,*log_0_end ;
int log_0_init = 0;

log_0(a,b,c,d)
unchar a,b,c,d;
{
	int s;
	s = spldb();
	if(log_0_init == 0){
		log_0_ptr = log_0_table;
		log_0_end = &log_0_table[LOG_TIMER_SIZE];
		log_0_init = 1;
		log0_b_boundary = log0_e_boundary = 0xFFFFFFFF;
	}
	*log_0_ptr++ = a;
	*log_0_ptr++ = b;
	*log_0_ptr++ = c;
	*log_0_ptr++ = d;
	if(log_0_ptr >= log_0_end)
		log_0_ptr = log_0_table;
	splx(s);
}

uint log1_b_boundary;
unchar log_1_table[LOG_TIMER_SIZE];
uint log1_e_boundary;

unchar *log_1_ptr,*log_1_end ;
int log_1_init = 0;

log_1(a,b,c,d)
unchar a,b,c,d;
{
	int s;
	s = spldb();
	if(log_1_init == 0){
		log_1_ptr = log_1_table;
		log_1_end = &log_1_table[LOG_TIMER_SIZE];
		log_1_init = 1;
		log1_b_boundary = log1_e_boundary = 0xFFFFFFFF;
	}
	*log_1_ptr++ = a;
	*log_1_ptr++ = b;
	*log_1_ptr++ = c;
	*log_1_ptr++ = d;
	if(log_1_ptr >= log_1_end)
		log_1_ptr = log_1_table;
	splx(s);
}
#endif /* SCSI_LOG */
