/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) cdr_intr.c: version 25.1 created on 11/27/91 at 14:41:48	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)cdr_intr.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/buf.h"
#include "sys/errno.h"
#include "sys/user.h"
#include "sys/debug.h"
#include "cdr_ds.h"
#include "cdr_err.h"
#include "cdb.h"
#include "scsi_cmdbx.h"
#include "scsi_error.h"
#include "../head/hlvl_macro.h"

extern void scsi_send_cmd();

extern struct buf *drv_buf[] ;
extern struct statetbl cdr_state[] ;
extern void disp_sense_error() ;
extern void disp_scsi_error() ;
extern void cdr_send_cmd() ;
extern struct buf * cdr_pop_head() ;
extern char * scsi_sns_msg() ;
extern char * scsi_err_msg() ;
extern void cdr_cmbox_clean() ;
extern void cdr_clean_up() ;
extern void cdr_pr_xsense() ;
extern void cdr_clean_q() ;
extern void cdr_reset() ;
extern void reset_cleanup() ;
extern void cmbox_err_cleanup() ;
extern void build_a_reset() ;

static unchar cdr_dma_buffer[1024] ;

/* 
 * cdrintr ()
 *		
 * input :	
 *	cmbox from llvl scsi driver
 *
 * output : none
 * 
 * side effects:
 */
cdr_intr (cmbox)
register CMD_BOX *cmbox;
{
	struct buf *bp ;
	STTBL *stp ;
	unchar unit_id ;

	unit_id = cmbox->unit_id ;
	stp = (STTBL *)GETSTBL(unit_id) ;
	bp =  stp->cd_head ;
	ASSERT (bp) ;
	ASSERT (stp->cd_cmbox == cmbox) ;

	if (cmbox->err_code != SCSIERR_NOERR) {
		if (cdr_error (cmbox, stp))
			return ;	/* cdr_error is doing retry */
		if (!(stp->cd_flags & CD_IGNORE_ERR)) {
			bp->b_flags |= B_ERROR ;
			bp->b_error = EIO ;
		}
	}

	/* check dma_resid for error */
	bp->b_resid += cmbox->dma_resid ;
	cdr_clean_up (stp, cmbox) ;
	ASSERT (stp->cd_busy == NOTBUSY) ;
	bp = cdr_pop_head (unit_id) ;
	iodone (bp) ;
	if (stp->cd_flags & CD_MEDIA_CH) {
		cdr_clean_q (stp) ;
	}
	else
		cdr_send_cmd (unit_id) ;

}

void
cdr_clean_up (stp, cmbox)
STTBL *stp ;
CMD_BOX *cmbox ;
{
	(void)bzero ((char *)cmbox, sizeof (* cmbox)) ;
	stp->cd_busy = NOTBUSY ;	/* scsi cmd_box not busy */
	stp->cd_retry_cnt = MAXRETRY ;
	stp->cd_flags &= ~CD_IGNORE_ERR ;
	return ;
}

void
cdr_clean_q (stp)
STTBL *stp ;
{
	struct buf *bp ;
	int oldpri ;
	unchar unit_id = stp->cd_dev ;

	while ((bp = cdr_pop_head (unit_id)) != NULL) {
		if (bp != drv_buf[unit_id]) {
			iodone (bp) ;
		}
	}

	ASSERT (stp->cd_head == NULL) ;
	ASSERT (stp->cd_tail == NULL) ;

}

int
cdr_error(cmbox, stp)
CMD_BOX *cmbox;
STTBL *stp ;
{
	EX_SENSE_DATA *sensedat ;
	int retry = 0 ;

	sensedat = (EX_SENSE_DATA *)cmbox->error ;
	switch (cmbox->err_code) {
		case SCSIERR_BUSTIMEOUT:
		case SCSIERR_BUSRESET:
		case SCSIERR_CMDTIMEOUT:
		case SCSIERR_NODEV:
		case SCSIERR_PARITY:
			retry = 1;
			break ;
		case SCSIERR_ATN:
			cmbox->cmd_type = CMD_RELEASE_ATTN ;
			retry = 1;
			break ;
		case SCSIERR_BUSY:
			if (--stp->cd_retry_cnt > 0) {
				timeout(scsi_send_cmd, cmbox, 5 * HZ) ;
				return 1;
			}
			break ;
		case SCSIERR_SENSE:
			/* if scsierr_attn do and media removal
			 * 	clean and close
			 * if scsierr_attn and reset
			 * 	try to retry else display
		 	 * else  display sense error data for user
		 	 *  bail out 
			 */

			if ((sensedat->sense_key & SENSE_KEY) == SNSKEY_UNIT_ATTN ) {
				if (sensedat->err_code == EXSNS_MEDIA_CH) {
					if (stp->cd_flags & CD_OPEN) {
						stp->cd_flags |= CD_MEDIA_CH ;
					}
					else {
					/* ignore media change error if
					   driver not yet open		*/
						stp->cd_flags |= CD_IGNORE_ERR ;
						return 0 ;
					}
				}
				else if (--stp->cd_retry_cnt > 0) {
					/*  bus reset */
					/* reset drive to state in stp */
					stp->cd_rst_retry = MAXRETRY ;
					build_a_reset (cmbox, stp) ;
					timeout (scsi_send_cmd, cmbox,
						2 * HZ) ;
					return 1 ;
				}
			}
			break ;
		/* fatal errors, i.e. no retry */
		default:
			break ;
	}

	if (retry && --stp->cd_retry_cnt > 0) {
	/* when get cmd timeout, llvl driver does not get bus free
         * from cdrom; therefore, llvl driver does a bus reset and
	 * thinks the cdrom is not on line.  using timeout to try
	 * and give cdrom time to reset.  possible error by cdrom
  	 * device that it does not free bus during reset
	 */
		timeout(scsi_send_cmd, cmbox, 5 * HZ) ;
		/* scsi_send_cmd(cmbox); */
		return 1 ;
	}
	/* have an error; have retried up to MAXRETRY with no success
	 * am bailing out
	 */

	if (cmbox->err_code == SCSIERR_SENSE)
		disp_sense_error (cmbox) ;
	else
		disp_scsi_error (cmbox) ;
	return 0;
}

void
disp_sense_error (cmbox)
register CMD_BOX *cmbox ;
{
	EX_SENSE_DATA *sensedat ;

	sensedat = (EX_SENSE_DATA *)cmbox->error ;

	DIS_CD_ID (cmbox->unit_id) ;
	printf ("%s.\n", scsi_sns_msg (sensedat->sense_key & 0x0F )) ;

	if (sensedat->err_class & INFO_VALID)
		printf ("at logical block address %x(h),",
			CAT4 (sensedat->info_msb, sensedat->info_2,
			sensedat->info_1, sensedat->info_lsb)) ;

	if (sensedat->flags & FPV) {
		printf (",at byte %x", CAT2 (sensedat->field_hi,
			sensedat->field_lo)) ;

		if (sensedat->flags & BPV)
			printf (", on bit %x",
				sensedat->flags & BIT_POINTER_MASK) ;

		if (sensedat->flags & CDBIT)
			printf (" of CDB") ;
		else
			printf (" of data") ;
	}

	if (sensedat->xsense_len) {
		cdr_pr_xsense (sensedat->err_code) ;
	}
}

void
disp_scsi_error (cmbox)
register CMD_BOX *cmbox ;
{
	DIS_CD_ID (cmbox->unit_id) ;
	printf ("%s.\n", scsi_err_msg (cmbox->err_code)) ;
}

static void
build_a_reset (cmbox, stp)
CMD_BOX *cmbox;
STTBL *stp ;
{
	struct g0_cdb *cdb = (struct g0_cdb *)cmbox->cmd_dsc_blk ;

	struct mode_head *md_head = (struct mode_head *)cdr_dma_buffer ;
	struct blk_dscptr *blk_dsc = (struct blk_dscptr *)((uint)md_head + MODEHEAD_LEN) ;

	md_head->dscptr_len = 8 ;
	blk_dsc->blk_len = 4 ; /* sets block size to 1024 */

	cmbox->cmd_type = CMD_REGULAR ;
	cmbox->cmd_dsc_len = G0SIZE ;

	/* cmbox->cmd_dsc_blk  */
	bzero (cdb, G0SIZE) ;
	cdb->ctl = 0 ;
	cdb->opcode = CDB_MODE_SELECT ;
	cdb->alloc_len = MODEHEAD_LEN + DSCPTR_LEN ;

	cmbox->service = cdr_reset ;
	cmbox->tag = (uint)stp ;
	cmbox->timer = DEF_TIMER ;
	cmbox->cmd_type = CMD_RELEASE_ATTN ;

	cmbox->dma_buffer = (unchar *)cdr_dma_buffer ;
	
	cmbox->dma_proc = 0 ;
	cmbox->dma_buf_len = MODEHEAD_LEN + DSCPTR_LEN ;
	cmbox->dma_flags =  0 ;
}

/* 
 * cdr_reset
 *	called by llvl driver on return from reset command
 *	bus reset returns cdrom to default condition
 * 
 * input: scsi command box
 *
 * output : none
 */
void
cdr_reset (cmbox)
CMD_BOX *cmbox;
{
	STTBL *stp ;

	stp = (STTBL *)GETSTBL(cmbox->unit_id) ;
	ASSERT (stp->cd_busy  == BUSY) ;

	if (cmbox->err_code == SCSIERR_NOERR)
	{
		reset_cleanup(cmbox, stp) ;
		cdr_send_cmd (stp->cd_dev) ;
	}
	else if (--stp->cd_rst_retry > 0) {
		timeout (scsi_send_cmd, cmbox, 2 * HZ) ;
	} else { /* bail out  */
		stp->cd_flags |= CD_RESET_ERROR;
		cdr_clean_q (stp) ;

		if (cmbox->err_code == SCSIERR_SENSE)
			disp_sense_error (cmbox) ;
		else
			disp_scsi_error (cmbox) ;

		reset_cleanup(cmbox, stp) ;
	}
}

static void
reset_cleanup(cmbox, stp) 
CMD_BOX *cmbox;
STTBL *stp ;
{
	(void)bzero ((char *)cmbox, sizeof (* cmbox)) ;
	stp->cd_busy = NOTBUSY ;	/* scsi cmd_box not busy */
}
